/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gzcb.dc.service;

import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.receipt.banks.gzcb.dc.service.api.ReceiptInfo;
import kd.ebg.receipt.banks.gzcb.dc.service.api.Srv024_ReceiptInfoQuery;
import kd.ebg.receipt.banks.gzcb.dc.service.api.Srv025_ReceiptPdfQuery;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u8bf7\u6c42\u4fe1\u606f\uff1a\n accNo = " + accNo + " and transDate = " + transDate + "\n");
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"GZCB_DC", (String)accNo, (String)transDateStr);
        BankAcnt acnt = new BankAcnt();
        logger.info("\u5373\u5c06\u67e5\u8be2>>>>>>>>" + accNo + "  " + EBContext.getContext().getCustomID());
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        logger.info("\u67e5\u8be2\u7ed3\u679c>>>>>>>>" + mainAcnt.getAccNo() + "  " + mainAcnt.getCurrency());
        String currency = mainAcnt.getCurrency();
        String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
        logger.info("\u8f6c\u6362\u7ed3\u679c>>>>>>>>" + mainAcnt.getAccNo() + "  " + bankCurrency);
        acnt.setAccNo(accNo);
        acnt.setCurrency(bankCurrency);
        BankReceiptRequest bankReceiptRequest = this.buildRequest(acnt, transDate, null);
        BankReceiptResponseEB srv024Resp = new Srv024_ReceiptInfoQuery().doBiz(bankReceiptRequest);
        List receiptInfos = (List)srv024Resp.getData();
        for (ReceiptInfo receiptInfo : receiptInfos) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
            paramMap.put("ReceiptInfo", receiptInfo);
            BankReceiptRequest srv025Req = this.buildRequest(acnt, transDate, paramMap);
            BankReceiptResponseEB srv025Resp = new Srv025_ReceiptPdfQuery().doBiz(srv025Req);
            String base64Str = (String)srv025Resp.getData();
            String fileName = receiptInfo.getReceiptNo() + ".pdf";
            FileCommonUtils.base64ToFile((String)base64Str, (String)(bakFilePath + File.separator + fileName));
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileLink(fileName);
            downloadListDetail.setFileName(fileName);
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public BankReceiptRequest buildRequest(BankAcnt acnt, LocalDate localDate, Map<String, Object> paramMap) {
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(acnt.getAccNo()).build();
        BankHeader header = new BankHeader();
        header.setAcnt(acnt);
        request.setHeader(header);
        request.setTransDate(localDate);
        request.setParamsMap(paramMap);
        return request;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BankReceiptFetchListAndDownloadTheList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-bosh-dc", (Object[])new Object[0]);
    }
}

