/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ghb.dc.service.receipt.api;

import java.time.LocalDate;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.adbc.dc.service.receipt.api.DownloadReceiptFileImpl;
import kd.ebg.receipt.banks.ghb.dc.service.receipt.api.ReponsePars;
import kd.ebg.receipt.banks.ghb.dc.service.receipt.api.RequestPack;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class ReceiptFileDownloadImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DownloadReceiptFileImpl.class);

    public String pack(BankReceiptRequest request) {
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate(), (String)"yyyyMMdd");
        String accNo = request.getAccNo();
        Map paramMap = request.getParamsMap();
        String TRNDT = (String)paramMap.get("TRNDT");
        String HOSTSEQNO = (String)paramMap.get("HOSTSEQNO");
        String OPPOACCTNO = (String)paramMap.get("OPPOACCTNO");
        String bankLoginId = EBContext.getContext().getBankLoginID();
        String requestStr = RequestPack.receiptDownload(TRNDT, HOSTSEQNO, accNo, OPPOACCTNO, bankLoginId);
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return requestStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        EBContext.getContext().setRemoveWriteResponseLog(false);
        if (responseStr.length() < 500) {
            logger.info("\u54cd\u5e94\u62a5\u6587\uff1a\n" + responseStr);
        }
        String CONTENT = ReponsePars.receiptParser(responseStr);
        return BankReceiptResponseEB.success((Object)CONTENT);
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "ZTSA63Q24";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u534e\u5174\u94f6\u884c\u76f4\u8054\u7248-\u7535\u5b50\u56de\u5355\u67e5\u8be2\u8bf7\u6c42\uff08ZTSA63Q24\uff09", (String)"ReceiptFileDownloadImpl_0", (String)"ebg-receipt-banks-ghb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/ghbankgayway4ent/rest/gayway");
        factory.setHttpHeader("content-type", "application/xml; charset=UTF-8");
        super.configFactory(factory);
    }
}

