/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.MappingValueType;
import kd.fi.v2.fah.dao.sys.BaseDaoImpl;
import kd.fi.v2.fah.models.flex.FlexFieldCfg;
import kd.fi.v2.fah.models.flex.FlexFieldGrpCfg;
import kd.fi.v2.fah.models.mapping.IMappingStructureMeta;
import kd.fi.v2.fah.models.mapping.impl.MappingStructureMeta;
import kd.fi.v2.fah.models.valueset.IValueSetMeta;
import kd.fi.v2.fah.sqlbuilder.IAddSqlColumn;
import kd.fi.v2.fah.sqlbuilder.IInsertSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.impl.FlexMappingTabInsertSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.impl.FlexTableInsertSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.impl.MulValueInsertSqlBuilder;

public class BaseFlexFieldDao
extends BaseDaoImpl {
    private static final String Default_OrderBy_SeqNo = "fseq";

    public static long getTableMaxSerialNo(String table, String columnName, QFilter filter) {
        if (null == filter) {
            return 0L;
        }
        StringBuilder sb = new StringBuilder("select max(");
        sb.append(columnName).append(") as ").append(columnName).append(" from ").append(table).append(" where ").append(filter.getProperty()).append(filter.getCP()).append(filter.getValue());
        try (DataSet rows = DB.queryDataSet((String)BaseFlexFieldDao.class.getName(), (DBRoute)FAHCommonConstant.AI, (String)sb.toString());){
            if (rows.hasNext()) {
                long l = rows.next().getLong(columnName);
                return l;
            }
        }
        return 0L;
    }

    public static Map<Long, Integer> getTableMaxSerialNoMap(String table, String columnName, String groupBy, Long flexTypeId, Object[] numberOrgIds) {
        LinkedHashMap<Long, Integer> map = new LinkedHashMap<Long, Integer>();
        StringBuilder sb = new StringBuilder("select ");
        sb.append(groupBy).append(", max(").append(columnName).append(") as ").append(columnName);
        sb.append(" from ").append(table);
        SqlBuilder where = new SqlBuilder();
        where.append(sb.toString(), new Object[0]);
        where.append(" where fmaptypeid = ?", new Object[]{flexTypeId});
        where.appendIn(" and fownorgid", numberOrgIds);
        where.append(" group by ", new Object[0]).append(groupBy, new Object[0]);
        try (DataSet rows = DB.queryDataSet((String)BaseFlexFieldDao.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)where);){
            while (rows.hasNext()) {
                Row row = rows.next();
                map.put(row.getLong(groupBy), row.getInteger(columnName));
            }
        }
        return map;
    }

    private static void loadFlexFieldCfg(Long primaryId, String orderBy, Consumer<FlexFieldCfg> consumer) {
        if (primaryId == null) {
            return;
        }
        if (primaryId != 0L) {
            String sql = "select fid,fentryid,fseq,fattnum,fattname,fattdatatype,fdescription,fownernum,ffieldusagetype,frefentity,freftypeid,freffieldnum,fdescription,fflexfieldnum from t_fah_flex_struc where fid = ?";
            try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.BaseFlexFieldDao", (DBRoute)FAHCommonConstant.AI, (String)sql, (Object[])new Object[]{primaryId}).orderBy(new String[]{orderBy});){
                for (Row row : queryDataSet) {
                    FlexFieldCfg fcg = new FlexFieldCfg(row.getLong("fentryid"), row.getString("fattnum"), row.getString("fattname"), row.getInteger(Default_OrderBy_SeqNo).intValue(), row.getString("fdescription"), row.getString("fflexfieldnum"));
                    fcg.setDataType(DataValueTypeEnum.getEnum((String)row.getString("fattdatatype")));
                    fcg.setFieldUsageType(row.getInteger("ffieldusagetype").intValue());
                    fcg.setRefBaseProp(row.getString("frefentity"));
                    fcg.setRefTypeId(row.getLong("freftypeid"));
                    fcg.setRefFieldNum(row.getString("freffieldnum"));
                    consumer.accept(fcg);
                }
            }
        }
    }

    public static FlexFieldGrpCfg loadFlexFieldGrpCfg(QFilter filter, String fiextype) {
        FlexFieldGrpCfg flexFieldGrpCfg = new FlexFieldGrpCfg();
        QFilter fieldQueryFilter = filter;
        String tableName = "fah_valueset_type".equals(fiextype) ? "fah_flex_struc_type" : "fah_valmap_struc";
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)tableName, (String)"number,name,description,id,enable", (QFilter[])fieldQueryFilter.toArray());
        if (queryOne == null) {
            return flexFieldGrpCfg;
        }
        long id = queryOne.getLong("id");
        flexFieldGrpCfg.setId(Long.valueOf(id));
        flexFieldGrpCfg.setName(queryOne.getString("name"));
        flexFieldGrpCfg.setNumber(queryOne.getString("number"));
        flexFieldGrpCfg.setDescription(queryOne.getString("description"));
        flexFieldGrpCfg.setEnabled(queryOne.getBoolean("enable"));
        BaseFlexFieldDao.loadFlexFieldCfg(id, Default_OrderBy_SeqNo, field -> flexFieldGrpCfg.cache(field));
        flexFieldGrpCfg.flush();
        return flexFieldGrpCfg;
    }

    public static IMappingStructureMeta loadFlexFieldGrpCfgByMappingType(QFilter filter) {
        FlexFieldGrpCfg flexFieldGrpCfg_in = new FlexFieldGrpCfg();
        FlexFieldGrpCfg flexFieldGrpCfg_out = new FlexFieldGrpCfg();
        MappingStructureMeta result = new MappingStructureMeta();
        QFilter fieldQueryFilter = filter;
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"fah_valmap_struc", (String)"number,name,description,id,enable", (QFilter[])fieldQueryFilter.toArray());
        if (queryOne == null) {
            return result;
        }
        long id = queryOne.getLong("id");
        flexFieldGrpCfg_in.setId(Long.valueOf(id));
        flexFieldGrpCfg_in.setName(queryOne.getString("name"));
        flexFieldGrpCfg_in.setNumber(queryOne.getString("number"));
        flexFieldGrpCfg_in.setDescription(queryOne.getString("description"));
        flexFieldGrpCfg_in.setEnabled(queryOne.getBoolean("enable"));
        BaseFlexFieldDao.loadFlexFieldCfg(id, Default_OrderBy_SeqNo, field -> {
            if (MappingValueType.INPUT.getCode() == field.getFieldUsageType()) {
                flexFieldGrpCfg_in.cache(field);
            } else {
                flexFieldGrpCfg_out.cache(field);
            }
        });
        flexFieldGrpCfg_in.flush();
        flexFieldGrpCfg_out.flush();
        result.setInputParamMeta(flexFieldGrpCfg_in);
        result.setOutputParamMeta(flexFieldGrpCfg_out);
        return result;
    }

    public static IValueSetMeta loadValueSetMeta(QFilter filter) {
        return null;
    }

    public static int[] doInsert(IInsertSqlBuilder srcSqlBuilder) {
        if (srcSqlBuilder == null) {
            return new int[0];
        }
        srcSqlBuilder.completeAndPack();
        List params = srcSqlBuilder.getSqlParams();
        if (params == null || params.isEmpty()) {
            return new int[0];
        }
        return DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)srcSqlBuilder.buildSqlStatement(new Object[0]).toString(), (List)params);
    }

    public static int[] doFlexValueSetInsert(FlexTableInsertSqlBuilder srcSqlBuilder, QFilter filter) {
        if (srcSqlBuilder == null) {
            return new int[0];
        }
        if (srcSqlBuilder.isNeedGetLastMaxSeqNo()) {
            Collection columns = srcSqlBuilder.getColumnNameByUsageType(IAddSqlColumn.ColumnUsageType.Sequence, false);
            long maxSeqNo = BaseFlexFieldDao.getTableMaxSerialNo(srcSqlBuilder.getSqlTableName(), (String)columns.iterator().next(), filter);
            srcSqlBuilder.setStartSeqNo(maxSeqNo + 1L);
        }
        return DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)srcSqlBuilder.buildSqlStatement(new Object[0]).toString(), (List)srcSqlBuilder.getSqlParams());
    }

    public static int[] doMulValueInsert(MulValueInsertSqlBuilder srcSqlBuilder) {
        if (srcSqlBuilder == null) {
            return new int[0];
        }
        return DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)srcSqlBuilder.buildSqlStatement(new Object[0]).toString(), (List)srcSqlBuilder.getSqlParams());
    }

    public static int doFlexMappingInsert(FlexMappingTabInsertSqlBuilder srcSqlBuilder) {
        IInsertSqlBuilder[] builders = srcSqlBuilder.getSqlBuilder();
        if (builders == null || builders.length == 0) {
            return -1;
        }
        if (srcSqlBuilder.getSrcSqlBuilder().isNeedGetLastMaxSeqNo()) {
            long maxSeqNo = BaseFlexFieldDao.getTableMaxSerialNo(srcSqlBuilder.getSrcSqlBuilder().getSqlTableName(), Default_OrderBy_SeqNo, null);
            srcSqlBuilder.getSrcSqlBuilder().setStartSeqNo(maxSeqNo == 0L ? 0L : maxSeqNo + 1L);
        }
        for (IInsertSqlBuilder sqlBuilder : builders) {
            BaseFlexFieldDao.doInsert(sqlBuilder);
        }
        return 0;
    }
}

