/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.models.event.eventrule.BizDimGrpItemDTO;
import kd.fi.v2.fah.models.event.eventrule.BizDimGrpTypeCfgDTO;
import kd.fi.v2.fah.models.event.eventrule.BizDimTypeCustomCfgDTO;
import kd.fi.v2.fah.models.event.eventrule.EvtLineDimGrpGetValueCfgCollection;

public class BizDimGrpDao {
    public EvtLineDimGrpGetValueCfgCollection getEvtLineDimGrpCfgCollection(Long evtLineFId) {
        EvtLineDimGrpGetValueCfgCollection dimGetValueCfgDTOS = new EvtLineDimGrpGetValueCfgCollection();
        try (DataSet dataSet = BizDimGrpDao.getDimGrpEntryInfo(evtLineFId);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                dimGetValueCfgDTOS.setEvtLineRuleId(row.getLong("fentryid"));
            }
        }
        return dimGetValueCfgDTOS;
    }

    public static DataSet getDimGrpEntryInfo(Long evtLineRuleId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select a.fid,a.fentryid,a.fseq,a.fenable,a.fevtlinetypeid,a.fDimGrpTypeId,b.fdetailid,b.fdiminnerid,b.fsyspresetcfgid,b.fcustomcfgid", new Object[0]);
        sql.append("from t_fah_evtline_gen_rule a join t_fah_evtline_dimgrp_cfg b on a.fentryid = b.fentryid and a.fentryid = ?", new Object[]{evtLineRuleId});
        return DB.queryDataSet((String)BizDimGrpDao.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }

    public BizDimGrpTypeCfgDTO getBizDimGrpTypeCfgDTO(Long bizDimGrpId) {
        DynamicObject bizDimGrp = this.queryBizDimGrp(bizDimGrpId);
        if (bizDimGrp == null) {
            return null;
        }
        BizDimGrpTypeCfgDTO dimGrpTypeCfgDTO = new BizDimGrpTypeCfgDTO(Long.valueOf(bizDimGrp.getLong("id")), bizDimGrp.getString("number"), bizDimGrp.getString("name"));
        dimGrpTypeCfgDTO.setMasterId(Long.valueOf(bizDimGrp.getLong("masterid")));
        dimGrpTypeCfgDTO.setSysReserved(bizDimGrp.getBoolean("issysreserved"));
        dimGrpTypeCfgDTO.setEnable(Boolean.valueOf(bizDimGrp.getBoolean("enable")));
        DynamicObjectCollection objectCollection = this.queryBizDimGrpEn(bizDimGrpId);
        LinkedHashMap<Long, BizDimTypeCustomCfgDTO> map = new LinkedHashMap<Long, BizDimTypeCustomCfgDTO>();
        for (DynamicObject dynamicObject : objectCollection) {
            long custGrpID = dynamicObject.getLong("fCustGrpID");
            int seq = dynamicObject.getInt("fSeq") - 1;
            DataValueTypeEnum dataType = DataValueTypeEnum.getEnumByAsstActType((String)dynamicObject.getString("fBizDimTypeId.datatype"));
            boolean isMeasure = "2".equals(dynamicObject.getString("fBizDimTypeId.asstacttype"));
            BizDimGrpItemDTO dimItemDTO = new BizDimGrpItemDTO(Long.valueOf(dynamicObject.getLong("fBizDimTypeId.id")), dynamicObject.getString("fBizDimTypeId.number"), dynamicObject.getString("fBizDimTypeId.name"), dataType, isMeasure);
            dimItemDTO.setIndex(dynamicObject.getInt("fBizDimTypeId.index"));
            dimItemDTO.setSeq(seq);
            dimItemDTO.setAlias("f" + seq);
            dimItemDTO.setDimInnerId(Long.valueOf(dynamicObject.getLong("fDimInnerId")));
            if (DataValueTypeEnum.BaseProp == dataType) {
                dimItemDTO.setRefEntityNum((Object)dynamicObject.getString("fBizDimTypeId.valuesource"));
            } else if (DataValueTypeEnum.AssistProp == dataType) {
                dimItemDTO.setRefEntityNum((Object)dynamicObject.getString("fBizDimTypeId.assistanttype"));
            }
            dimGrpTypeCfgDTO.add((Object)dimItemDTO);
            BizDimTypeCustomCfgDTO customCfgDTO = map.computeIfAbsent(custGrpID, k -> new BizDimTypeCustomCfgDTO());
            customCfgDTO.setId(Long.valueOf(custGrpID));
            customCfgDTO.setDimEnabledValue(seq, dynamicObject.getBoolean("fIsEnabled"));
            customCfgDTO.setDimRequiredValue(seq, dynamicObject.getBoolean("fIsRequired"));
        }
        if (!map.isEmpty()) {
            LinkedHashMap<Long, Set> orgMap = new LinkedHashMap<Long, Set>();
            orgMap.computeIfAbsent(0L, k -> new HashSet()).add(0L);
            DynamicObjectCollection collection = this.queryBizDimGrpOrg(new LinkedList<Long>(map.keySet()));
            for (DynamicObject dynamicObject : collection) {
                orgMap.computeIfAbsent(dynamicObject.getLong("maptype"), k -> new HashSet()).add(dynamicObject.getLong("ownorg.id"));
            }
            for (BizDimTypeCustomCfgDTO customCfgDTO : map.values()) {
                customCfgDTO.setMatchOrgIds((Set)orgMap.get(customCfgDTO.getId()));
            }
        }
        dimGrpTypeCfgDTO.setCustomCfgDTOS(new ArrayList(map.values()));
        dimGrpTypeCfgDTO.buildCustOrgLookupIdx();
        return dimGrpTypeCfgDTO;
    }

    public DynamicObject queryBizDimGrp(Long fid) {
        return QueryServiceHelper.queryOne((String)"fah_biz_dim_combine", (String)"id,number,name,enable,masterid,issysreserved", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)fid)});
    }

    public DynamicObjectCollection queryBizDimGrpEn(Long fid) {
        return QueryServiceHelper.query((String)"fah_biz_dimgrp_en", (String)"fid,fSeq,fBizDimTypeId.id,fBizDimTypeId.number,fBizDimTypeId.name,fBizDimTypeId.asstacttype,fBizDimTypeId.datatype,fBizDimTypeId.valuesource,fBizDimTypeId.assistanttype,fBizDimTypeId.index,fbizdimtypenum,fIsEnabled,fIsRequired,fCustGrpID,fDimInnerId,fissysreserved", (QFilter[])new QFilter[]{new QFilter("fid", "=", (Object)fid)}, (String)"fseq");
    }

    public DynamicObjectCollection queryBizDimGrpOrg(List<Long> groupIds) {
        return QueryServiceHelper.query((String)"fah_valmap_type_org", (String)"maptype,ownorg.id", (QFilter[])new QFilter[]{new QFilter("maptype", "in", groupIds), new QFilter("targetbaseprop", "=", (Object)"fah_biz_dim_combine")});
    }
}

