/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ai.Currency;
import kd.fi.ai.enums.BosOrgBizTypeEnum;
import kd.fi.v2.fah.dto.VoucherTypeCacheKey;
import kd.fi.v2.fah.models.xla.XLAAccount;
import kd.fi.v2.fah.models.xla.XLACashFlowItem;

public class FahCheckXLADataDao {
    public static void loadAccountByOrgId(Set<Long> acctountIds, Long orgId, Long acctTableId, Map<Long, Long> accountDataMap) {
        if (acctountIds.isEmpty() || orgId == 0L || acctTableId == 0L) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", acctountIds), new QFilter("accounttable", "=", (Object)acctTableId), (QFilter)ThreadCache.get((Object)("kd.fi.v2.fah.dao.FahCheckXLADataDao.loadAccountByOrgIdbd_accountview" + orgId), () -> BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId))};
        String selector = "id,number";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_accountview", (String)selector, (QFilter[])filters);
        for (DynamicObject account : query) {
            Long accountId = account.getLong("id");
            accountDataMap.put(accountId, accountId);
        }
    }

    public static void queryAccountInfo(Set<Long> query_accountIds, Map<Long, XLAAccount> idAndAccountMap) {
        DynamicObject[] query;
        if (query_accountIds.isEmpty()) {
            return;
        }
        String selector = "id,number,checkitementry.id,checkitementry.asstactitem,accounttype.accounttype,isleaf,checkitementry.isrequire,enable";
        for (DynamicObject account : query = BusinessDataServiceHelper.load((String)"bd_accountview", (String)selector, (QFilter[])new QFilter("id", "in", query_accountIds).toArray())) {
            XLAAccount xlaAccount = new XLAAccount();
            Long accountId = account.getLong("id");
            xlaAccount.setId(accountId);
            xlaAccount.setProfitAndLoss(account.get("accounttype.accounttype").equals("4"));
            xlaAccount.setEnable(Boolean.valueOf(account.getBoolean("enable")));
            xlaAccount.setIsleaf(Boolean.valueOf(account.getBoolean("isleaf")));
            idAndAccountMap.put(accountId, xlaAccount);
            DynamicObjectCollection checkitementry = account.getDynamicObjectCollection("checkitementry");
            for (DynamicObject assitem : checkitementry) {
                DynamicObject asstactitem = (DynamicObject)assitem.get("asstactitem");
                boolean isrequire = assitem.getBoolean("isrequire");
                if (asstactitem == null) continue;
                String flexField = asstactitem.getString("flexfield");
                xlaAccount.addAssgrpFlexNumber(flexField);
                if (!isrequire) continue;
                xlaAccount.addMustNumber(flexField);
            }
        }
    }

    public static void queryMainItemInfo(Set<Long> query_mainItemIds, Map<Long, XLACashFlowItem> idAndMainItemMap) {
        DynamicObject[] query;
        if (query_mainItemIds.isEmpty()) {
            return;
        }
        String selector = "id,direction,assistentry.id,assistentry.asstypeid,isdealactivity,isscheduleitem,assistentry.isrequire";
        for (DynamicObject cashflowItem : query = BusinessDataServiceHelper.load((String)"gl_cashflowitem", (String)selector, (QFilter[])new QFilter("id", "in", query_mainItemIds).toArray())) {
            XLACashFlowItem xlaCashFlow = new XLACashFlowItem();
            long cfId = cashflowItem.getLong("id");
            xlaCashFlow.setId(Long.valueOf(cfId));
            xlaCashFlow.setDirection(cashflowItem.getString("direction"));
            xlaCashFlow.setIsdealactivity(cashflowItem.getBoolean("isdealactivity"));
            xlaCashFlow.setSupItem(cashflowItem.getBoolean("isscheduleitem"));
            idAndMainItemMap.put(cfId, xlaCashFlow);
            DynamicObjectCollection checkitementry = cashflowItem.getDynamicObjectCollection("assistentry");
            for (DynamicObject assitem : checkitementry) {
                DynamicObject asstactitem = (DynamicObject)assitem.get("asstypeid");
                boolean isrequire = assitem.getBoolean("isrequire");
                if (asstactitem == null) continue;
                String flexField = asstactitem.getString("flexfield");
                xlaCashFlow.addAssgrpFlexNumber(flexField);
                if (!isrequire) continue;
                xlaCashFlow.getMustNumber().add(flexField);
            }
        }
    }

    public static void loadItemByOrgId(Set<Long> itemIds, Long orgId, Map<Long, Long> itemDataMap) {
        if (itemIds.isEmpty() || orgId == 0L) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", itemIds), (QFilter)ThreadCache.get((Object)("kd.fi.v2.fah.dao.FahCheckXLADataDao.loadItemByOrgIdgl_cashflowitem" + orgId), () -> BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId))};
        String selector = "id,number";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"gl_cashflowitem", (String)selector, (QFilter[])filters);
        for (DynamicObject item : query) {
            Long itemId = item.getLong("id");
            itemDataMap.put(itemId, itemId);
        }
    }

    public static Boolean checkVoucherTypeByOrgId(Long voucherTypeId, Long orgId) {
        if (voucherTypeId == 0L || orgId == 0L) {
            return false;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)voucherTypeId), (QFilter)ThreadCache.get((Object)("kd.fi.v2.fah.dao.FahCheckXLADataDao.checkVoucherTypeByOrgIdgl_vouchertype" + orgId), () -> BaseDataServiceHelper.getBaseDataFilter((String)"gl_vouchertype", (Long)orgId))};
        return QueryServiceHelper.exists((String)"gl_vouchertype", (QFilter[])filters);
    }

    public static boolean checkAcctPurpDataFromThreadCache(long accountPurposeId) {
        Map acctPurpDataExistsInCache = (Map)ThreadCache.get((Object)"FahCheckXLADataDao.checkAcctPurpDataFromThreadCache", HashMap::new);
        return acctPurpDataExistsInCache.computeIfAbsent(accountPurposeId, FahCheckXLADataDao::checkAcctPurpData);
    }

    public static boolean checkAcctPurpData(long accountPurposeId) {
        return QueryServiceHelper.exists((String)"fah_evt_accountpurpose", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)accountPurposeId), new QFilter("enable", "=", (Object)true)});
    }

    public static boolean checkOrgDataFromThreadCache(Long orgId) {
        HashMap orgDataCache = (HashMap)ThreadCache.get((Object)"FahCheckXLADataDao.checkOrgDataFromThreadCache", HashMap::new);
        return orgDataCache.computeIfAbsent(orgId, FahCheckXLADataDao::checkIsAccountingOrg);
    }

    public static boolean checkIsAccountingOrg(Long orgId) {
        return QueryServiceHelper.exists((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId), new QFilter("enable", "=", (Object)true), new QFilter(BosOrgBizTypeEnum.ACCOUNTING.getPropertyName(), "=", (Object)true)});
    }

    public static boolean checkVoucherTypeFromThreadCache(Long voucherTypeId, Long orgId) {
        HashMap vchTypeCache = (HashMap)ThreadCache.get((Object)"FahCheckXLADataDao.checkOrgDataFromThreadCache", HashMap::new);
        return vchTypeCache.computeIfAbsent(new VoucherTypeCacheKey(voucherTypeId, orgId), key -> FahCheckXLADataDao.checkVoucherTypeByOrgId(voucherTypeId, orgId));
    }

    public static boolean checkCurrency(Long currId) {
        return QueryServiceHelper.exists((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currId), new QFilter("enable", "=", (Object)true)});
    }

    public static boolean checkCurrencyFromThreadCache(Long currId) {
        HashMap currCache = (HashMap)ThreadCache.get((Object)"FahCheckXLADataDao.checkCurrencyFromThreadCache", HashMap::new);
        return currCache.computeIfAbsent(currId, FahCheckXLADataDao::checkCurrency);
    }

    public static Currency getCurrency(Long currencyId) {
        Currency currency = new Currency();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FahCheckXLADataDao.getCurrency", (String)"bd_currency", (String)"id,amtprecision,priceprecision", (QFilter[])new QFilter("id", "=", (Object)currencyId).toArray(), null, (int)-1);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                currency.setId(row.getLong("id").longValue());
                currency.setAmtprecision(row.getInteger("amtprecision").intValue());
                currency.setPriceprecision(row.getInteger("priceprecision").intValue());
            }
        }
        return currency;
    }

    public static Currency getCurrencyFromThreadCache(Long currencyId) {
        HashMap currencyCache = (HashMap)ThreadCache.get((Object)"FahCheckXLADataDao.getCurrencyFromThreadCache", HashMap::new);
        return currencyCache.computeIfAbsent(currencyId, FahCheckXLADataDao::getCurrency);
    }
}

