/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.dto.upstream.service.QueryUpStreamXlaResult;
import kd.fi.v2.fah.dto.upstream.xla.QueryUpSteamXlaFieldEnum;
import kd.fi.v2.fah.dto.upstream.xla.QueryUpStreamXlaInputParam;

public class FahXLADaoImpl {
    private static final FahXLADaoImpl instance = new FahXLADaoImpl();
    public static final String XLA_Header_Tab_Prefix = "xlaheader";
    public static final String XLA_Line_Tab_Prefix = "xlaline";
    private static final String QueryUpdateStream_XLA_Template = "select %s from t_fah_ae_lines xlaline inner join t_fah_ae_headers xlaheader on xlaheader.fid = xlaline.fid ";

    public static FahXLADaoImpl getInstance() {
        return instance;
    }

    protected String buildSelectedString(QueryUpSteamXlaFieldEnum[] queryFields) {
        if (queryFields == null || queryFields.length == 0) {
            throw new IllegalArgumentException("SQL Query Field Cannot be Null!");
        }
        boolean first = true;
        StringBuilder builder = new StringBuilder();
        for (QueryUpSteamXlaFieldEnum field : queryFields) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            switch (field.getTableName()) {
                case "t_fah_ae_headers": {
                    builder.append(XLA_Header_Tab_Prefix);
                    break;
                }
                case "t_fah_ae_lines": {
                    builder.append(XLA_Line_Tab_Prefix);
                    break;
                }
            }
            builder.append('.').append(field.getDbField());
        }
        return builder.toString();
    }

    public QueryUpStreamXlaResult queryUpStreamXla(QueryUpStreamXlaInputParam inputParam) {
        if (inputParam == null) {
            return null;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        QueryUpSteamXlaFieldEnum[] queryFields = inputParam.getQueryXlaFields();
        String selectFields = this.buildSelectedString(queryFields);
        sqlBuilder.append(String.format(QueryUpdateStream_XLA_Template, selectFields), new Object[0]).append(String.format("where xlaheader.fBookId = %d and xlaheader.fSrc_BillType = '%s' and xlaheader.fAcctRuleId=%d ", inputParam.getAcctBookId(), inputParam.getParentBillType(), inputParam.getAcctRuleId()), new Object[0]).append(String.format("and xlaline.fLineTypeId=%d and xlaline.fSourceEntry='%s' ", inputParam.getEvtLineTypeId(), inputParam.getParentEntryNum()), new Object[0]).appendIn("and xlaline.fSrc_BillentryId ", inputParam.getParentBillEntryIds().toArray()).append("and xlaheader.fstatus = ?", new Object[]{"4"});
        QueryUpStreamXlaResult result = new QueryUpStreamXlaResult(queryFields);
        return (QueryUpStreamXlaResult)DB.query((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder, (ResultSetHandler)result);
    }

    public Map<String, Set<Long>> querySuccessTmpEvtBillTypeAndBillIdsMap(long requestId) {
        HashMap<String, Set<Long>> successTempMap = new HashMap<String, Set<Long>>(8);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fsrc_billtype,a.fsrc_billid from t_fah_ae_headers_tmp a where ", new Object[0]);
        sqlBuilder.append(" NOT EXISTS (select 1 from t_fah_task_fail_bills b where", new Object[0]);
        sqlBuilder.append("b.frequestid =  ? and a.fsrc_billtype = b.fbilltype  and a.fsrc_billid = b.fsrcbillid)", new Object[]{requestId});
        sqlBuilder.append("and a.frequestid = ?", new Object[]{requestId});
        sqlBuilder.append("and a.fstatus = ?", new Object[]{"4"});
        try (DataSet dataSet = DB.queryDataSet((String)"FahXLADaoImpl.querySuccessTmpEvtBillTypeAndBillIdsMap", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String billType = row.getString("fsrc_billtype");
                Long billId = row.getLong("fsrc_billid");
                successTempMap.computeIfAbsent(billType, k -> new HashSet(8)).add(billId);
            }
        }
        return successTempMap;
    }
}

