/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.config.rulechange;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.revisionlog.ChangeRuleType;
import kd.fi.v2.fah.constant.enums.revisionlog.ChangeType;
import kd.fi.v2.fah.models.rulechange.RuleBackupHistoryDTO;
import kd.fi.v2.fah.models.rulechange.RuleChangeHistoryDTO;

public class RuleChangeHisDaoImpl {
    public static void save(RuleChangeHistoryDTO ruleChangeHistoryDTO, RuleBackupHistoryDTO ruleBackupHistoryDTO) {
        DynamicObject ruleChange = BusinessDataServiceHelper.newDynamicObject((String)"fah_rule_change");
        SequenceReader sReader = new SequenceReader(new DBRoute("ai"));
        Long ruleChangeId = ((Long[])sReader.getSequences((Object[])new Long[1], "fah_rule_change", 1))[0];
        ruleChange.set("id", (Object)ruleChangeId);
        ruleChange.set("modifyuser", (Object)ruleChangeHistoryDTO.getModifyUserId());
        ruleChange.set("modifytime", (Object)ruleChangeHistoryDTO.getModifyTime());
        ruleChange.set("changetype", (Object)ruleChangeHistoryDTO.getChangeType().getCode());
        ruleChange.set("seqno", (Object)ruleChangeHistoryDTO.getSeqNo());
        ruleChange.set("srcruletype", (Object)ruleChangeHistoryDTO.getChangeRuleType().getNumber());
        ruleChange.set("srcruleid", (Object)ruleChangeHistoryDTO.getSrcRuleId());
        ruleChange.set("ruledataseqno", (Object)ruleChangeHistoryDTO.getRuleDataSeqNo());
        ruleChange.set("rulebackupseqno", (Object)ruleChangeHistoryDTO.getRuleBackupSeqNo());
        String changeInfo = ruleBackupHistoryDTO.getChangeInfo();
        if (changeInfo.length() > 510) {
            changeInfo = changeInfo.substring(0, 507) + "...";
        }
        Long ruleBackupId = ((Long[])sReader.getSequences((Object[])new Long[1], "fah_rule_backup", 1))[0];
        SqlBuilder insertSql = new SqlBuilder();
        insertSql.append("INSERT INTO t_fah_rule_backup_his(fid, fsrcruletype, fsrcruleid, frulebackupseqno, fchangeinfo, fchangeinfo_tag, frulebackup_tag, fchangehisrecid)", new Object[0]);
        insertSql.append("VALUES(?,?,?,?,?,?,?,?)", new Object[]{ruleBackupId, ruleBackupHistoryDTO.getChangeRuleType().getNumber(), ruleChangeHistoryDTO.getSrcRuleId(), ruleBackupHistoryDTO.getRuleBackupSeqNo(), changeInfo, ruleBackupHistoryDTO.getChangeJson(), ruleBackupHistoryDTO.getChangeBackup(), ruleChangeId});
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)insertSql);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ruleChange});
    }

    public static Map<String, Object> getRuleBackup(Object pk) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fsrcruletype,fsrcruleid,fchangeinfo_tag from t_fah_rule_backup_his where fid = ?", new Object[]{pk});
        try (DataSet rows = DB.queryDataSet((String)"RuleChangeHisDao.getRuleBackup", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            if (rows.hasNext()) {
                Row row = rows.next();
                data.put("srcruletype", row.getString("fsrcruletype"));
                data.put("srcruleid", row.getLong("fsrcruleid"));
                data.put("changeinfo_tag", row.getString("fchangeinfo_tag"));
            }
        }
        return data;
    }

    public static List<RuleChangeHistoryDTO> getRuleLastChange(ChangeRuleType changeRuleType, Long ruleId, int count) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        LinkedList<RuleChangeHistoryDTO> result = new LinkedList<RuleChangeHistoryDTO>();
        sqlBuilder.append("select fid,fSeqNo,fSrcRuleType,fSrcRuleId,fModifyTime,fModifyUserId,fChangeType,fRuleBackupSeqNo,fRuleDataSeqNo from t_fah_rule_change_his where fSrcRuleType = ?", new Object[]{changeRuleType.getNumber()});
        sqlBuilder.append("and fSrcRuleId = ?", new Object[]{ruleId}).append("order by fSeqNo desc ", new Object[0]);
        try (DataSet rows = DB.queryDataSet((String)"RuleChangeHisDao.getRuleLastChange", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder).limit(0, count);){
            while (rows.hasNext()) {
                Row row = rows.next();
                RuleChangeHistoryDTO ruleChangeHistoryDTO = new RuleChangeHistoryDTO(row.getLong("fModifyUserId"), row.getDate("fModifyTime"), ChangeType.getChangeTypeByCode((String)row.getString("fChangeType")), changeRuleType, ruleId);
                ruleChangeHistoryDTO.setId(row.getLong("fid"));
                ruleChangeHistoryDTO.setSeqNo(row.getInteger("fSeqNo").intValue());
                ruleChangeHistoryDTO.setRuleDataSeqNo(row.getInteger("fRuleDataSeqNo").intValue());
                ruleChangeHistoryDTO.setRuleBackupSeqNo(row.getInteger("fRuleBackupSeqNo").intValue());
                result.add(ruleChangeHistoryDTO);
            }
        }
        return result;
    }
}

