/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.engine.event;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.utils.StringUtils;

public class FahEventDaoImpl {
    public static DataSet getEventLineData(Long id, boolean isTemp, boolean isOnlyShowFailData, SqlBuilder querySql, int startIndex, int count) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT eventlinedata.fEntryId fEntryId,eventlinedata.fLineTypeId fLineTypeId,eventlinedata.fAmount fAmount,eventlinedata.fCurrencyId fCurrencyId,eventlinedata.fsrcLineRuleId fsrcLineRuleId,", new Object[0]);
        if (isTemp) {
            sql.append("fLineStatus,fmsg from t_fah_event_line_tmp eventlinedata", new Object[0]);
        } else {
            sql.append(" eventlinedata.fBizLineStatus fBizLineStatus from t_fah_event_line eventlinedata", new Object[0]);
        }
        sql.append(" where eventlinedata.fId = ?", new Object[]{id});
        if (!StringUtils.isEmpty((Object)querySql)) {
            sql.appendSqlBuilder(querySql);
        }
        if (isOnlyShowFailData && isTemp) {
            sql.append(" and eventlinedata.fLineStatus = '3'", new Object[0]);
        }
        return DB.queryDataSet((String)"EventDao.getEventLineData", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql).limit(startIndex, count);
    }

    public static DataSet getErrorEventLineData(Long id, int startIndex, int count) {
        SqlBuilder sql = new SqlBuilder();
        if (FahEventDaoImpl.isExistXlaHeadError(id)) {
            return FahEventDaoImpl.getEventLineData(id, false, false, null, startIndex, count);
        }
        sql.append("SELECT eventlinedata.fEntryId fEntryId,eventlinedata.fLineTypeId fLineTypeId,eventlinedata.fAmount fAmount", new Object[0]);
        sql.append(",eventlinedata.fCurrencyId fCurrencyId,eventlinedata.fsrcLineRuleId fsrcLineRuleId,", new Object[0]);
        sql.append("eventlinedata.fBizLineStatus fBizLineStatus from t_fah_event_line eventlinedata", new Object[0]);
        sql.append("where fEntryId in ( SELECT  eventlinedata.fEntryId fEntryId from t_fah_event_line eventlinedata  ", new Object[0]);
        sql.append("inner join  t_fah_ae_lines_tmp aelines on aelines.fsrc_eventlineid = eventlinedata.fentryid ", new Object[0]);
        sql.append("where eventlinedata.fId =?", new Object[]{id});
        sql.append(" AND  aelines.fiserror ='1')", new Object[0]);
        return DB.queryDataSet((String)"EventDao.getErrorEventLineData", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql).limit(startIndex, count);
    }

    public static boolean isExistXlaHeadError(Long eventHeadId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid from t_fah_ae_headers_tmp where fiserror = '1' and fstatus = '4' and fsrceventid =?", new Object[]{eventHeadId});
        try (DataSet dataSet = DB.queryDataSet((String)"EventDao.isExistXlaHeadError", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            if (dataSet.hasNext()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static int getErrorEventLineDataRowCount(Long id) {
        SqlBuilder sql = new SqlBuilder();
        if (FahEventDaoImpl.isExistXlaHeadError(id)) {
            return FahEventDaoImpl.getDataRowCount(id, false, false, null);
        }
        sql.append("SELECT count(1) datacount from t_fah_event_line eventlinedata", new Object[0]);
        sql.append("inner join  t_fah_ae_lines_tmp aelines on aelines.fsrc_eventlineid = eventlinedata.fentryid ", new Object[0]);
        sql.append("where eventlinedata.fId =?", new Object[]{id});
        sql.append(" AND  aelines.fiserror ='1'", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"EventDao.getErrorEventLineData", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                int n = row.getInteger("datacount");
                return n;
            }
        }
        return 0;
    }

    public static DataSet getXlaData(boolean isTemp, Long eventId, Long id) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT head.facctpurposeid acctpurpose,head.forgid org,head.fbooktypeid booktype,aelines.fdescription edescription\n,aelines.faccountid account,aelines.fassgrpid assgrp,aelines.fori_debit oridebit,aelines.fori_credit oricredit\n,aelines.flocal_debit debitlocal,aelines.flocal_credit creditlocal,aelines.fmaincf_itemid maincf_item,aelines.fmaincf_assgrpid maincf_assgrp\n,aelines.fsupcf_itemid supcf_itemid,aelines.fMeasureUnitId measureunit,aelines.fquantity quantity,aelines.fprice price,aelines.fExpire_Date expiredate\n,aelines.fbusinessnum businessnum,aelines.fCurrencyId currency,aelines.fLocal_ExchangeRate localrate,head.fLoc_CurrencyId localcurrency\n,head.fdescription description,head.fcreatorid creator,head.fattachments attachment,head.fTypeId vouchertype\n", new Object[0]);
        if (isTemp) {
            sql.append(",head.fIsError headiserror,head.fErrorMessage headerrormessage,aelines.fIsError lineiserror,aelines.fErrorMessage lineerrormessage", new Object[0]);
            sql.append(" FROM t_fah_ae_headers_tmp head", new Object[0]);
            sql.append("left JOIN  t_fah_ae_lines_tmp aelines ON head.fid =aelines.fid and aelines.fSrc_EventLineId=?", new Object[]{id});
        } else {
            sql.append(" FROM t_fah_ae_headers head", new Object[0]);
            sql.append("left JOIN  t_fah_ae_lines aelines ON head.fid =aelines.fid and aelines.fSrc_EventLineId=?", new Object[]{id});
        }
        sql.append("left JOIN t_fah_evt_acctgroup acctgroup ON acctgroup.fAcctpurposeId=head.facctpurposeid AND head.fAcctRuleId=acctgroup.fAcctRuleId ", new Object[0]);
        sql.append(" where head.fsrceventid = ?", new Object[]{eventId});
        sql.append(" and head.fstatus = ?", new Object[]{"4"});
        sql.append(" order by acctgroup.fseq asc", new Object[0]);
        return DB.queryDataSet((String)"EventDao.getXlaData", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }

    public static int getDataRowCount(Long id, boolean isTemp, boolean isOnlyShowFailData, SqlBuilder querySql) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("Select COUNT(*) count from ", new Object[0]);
        if (isTemp) {
            sql.append("t_fah_event_line_tmp eventlinedata", new Object[0]);
        } else {
            sql.append("t_fah_event_line eventlinedata", new Object[0]);
        }
        sql.append(" where eventlinedata.fId = ?", new Object[]{id});
        if (isOnlyShowFailData && isTemp) {
            sql.append(" and eventlinedata.fLineStatus = '3'", new Object[0]);
        }
        if (!StringUtils.isEmpty((Object)querySql)) {
            sql.appendSqlBuilder(querySql);
        }
        try (DataSet dataSet = DB.queryDataSet((String)"EventDao.getDataRowCount", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            int n = dataSet.next().getInteger("count");
            return n;
        }
    }

    public static Set<Long> getLogId(Object id) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select flogid from t_fah_reltasklog where fbizid=?", new Object[]{id});
        HashSet<Long> logIdSet = new HashSet<Long>();
        try (DataSet data = DB.queryDataSet((String)"EventDao.getLogId", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            while (data.hasNext()) {
                logIdSet.add(data.next().getLong("flogid"));
            }
        }
        return logIdSet;
    }

    public static DataSet getBizDimension(Object id, boolean isfailure) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT DISTINCT dimgrp_en.fseq,dimgrp_en.fBizDimTypeId fBizDimTypeId,dimgrp_en.fDimInnerId fDimInnerId,asstacttype.fdatatype fdatatype,asstacttype.fvaluesource fvaluesource,asstacttype.fassistanttype fassistanttype FROM t_fah_event_line eventline", new Object[0]);
        if (isfailure) {
            sql.append("INNER JOIN t_fah_dimgrp_values_tmp dimgrpvalues ON dimgrpvalues.fid = eventline.fDimGrpvalId", new Object[0]);
        } else {
            sql.append("INNER JOIN t_fah_dimgrp_values dimgrpvalues ON dimgrpvalues.fid = eventline.fDimGrpvalId", new Object[0]);
        }
        sql.append("INNER JOIN t_fah_dimgrp_type dimgrp ON dimgrp.fId = dimgrpvalues.fDimGrpTypeid", new Object[0]);
        sql.append("INNER JOIN t_fah_dimgrp_type_en dimgrp_en ON dimgrp_en.fid = dimgrp.fId", new Object[0]);
        sql.append("INNER JOIN t_ai_asstacttype asstacttype ON asstacttype.fid = dimgrp_en.fBizDimTypeId", new Object[0]);
        sql.append("WHERE eventline.fentryid=?", new Object[]{id}).append("ORDER BY dimgrp_en.fseq", new Object[0]);
        return DB.queryDataSet((String)"EventDao.getBizDimension", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }

    public static DataSet getBizData(Object id, boolean isfailure, String idValueSql) {
        SqlBuilder sql = new SqlBuilder();
        if (isfailure) {
            sql.append("SELECT dimgrpvalues.fMsg fmsg,", new Object[0]).append(idValueSql, new Object[0]).append("FROM t_fah_event_line eventline", new Object[0]);
        } else {
            sql.append("SELECT ", new Object[0]).append(idValueSql, new Object[0]).append("FROM t_fah_event_line eventline", new Object[0]);
        }
        if (isfailure) {
            sql.append("INNER JOIN t_fah_dimgrp_values_tmp dimgrpvalues ON dimgrpvalues.fid = eventline.fDimGrpvalId", new Object[0]);
        } else {
            sql.append("INNER JOIN t_fah_dimgrp_values dimgrpvalues ON dimgrpvalues.fid = eventline.fDimGrpvalId", new Object[0]);
        }
        sql.append("WHERE eventline.fentryid=?", new Object[]{id});
        return DB.queryDataSet((String)"EventDao.getBizData", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }

    public static DataSet getTxtValue(Set<Long> idSet) {
        SqlBuilder sql = new SqlBuilder();
        sql.appendIn("select fid,fDimValue from t_fah_Reg_DimVal_TXT where fid", idSet.toArray());
        return DB.queryDataSet((String)"EventDao.getTxtValue", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }

    public static DataSet getDtValue(Set<Long> idSet) {
        SqlBuilder sql = new SqlBuilder();
        sql.appendIn("select fid,fDimValue from t_fah_Reg_DimVal_DT where fid", idSet.toArray());
        return DB.queryDataSet((String)"EventDao.getDtValue", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }

    public static DataSet getAmtValue(Set<Long> idSet) {
        SqlBuilder sql = new SqlBuilder();
        sql.appendIn("select fid,fDimValue from t_fah_Reg_DimVal_AMT where fid", idSet.toArray());
        return DB.queryDataSet((String)"EventDao.getAmtValue", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }
}

