/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.FormBuilderConstant;
import kd.fi.v2.fah.dao.config.event.FahDispatchRuleDaoImpl;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.dao.event.FahEventRuleCfgDAO;
import kd.fi.v2.fah.dto.FahRegBillDTO;
import kd.fi.v2.fah.dto.FahRegBillEntryDTO;
import kd.fi.v2.fah.utils.StringUtils;

public class FahRegBillDao {
    private static final String algoKey = "kd.fi.v2.fah.dao.event.RegBillDao";
    private static final String THREAD_CACHE_KEY = "FahRegBillDao.FahRegBillDTOAndFahRegBillEntryDTO";
    private static final String[] selectField = new String[]{"id", "enable", "srcbilltype", "srcapp", "srcbillorgfield", "srcbillstatusfield", "writebackplugin", "keyfieldentry.srcbillstatusval", "keyfieldentry.srcbilldatefieldnum", "keyfieldentry.evtstatusfieldnum"};

    private static Map<String, FahRegBillDTO> getDtoThreadCache() {
        return (Map)ThreadCache.get((Object)THREAD_CACHE_KEY, HashMap::new);
    }

    private static DynamicObjectCollection batchQueryRegBillInfo(QFilter[] filters) {
        return QueryServiceHelper.query((String)"fah_regbill", (String)StringUtils.join((Object[])selectField, (String)","), (QFilter[])filters);
    }

    private static Map<String, FahRegBillDTO> batchDoToDto(DynamicObjectCollection doCollection) {
        HashMap<String, FahRegBillDTO> billToDTO = new HashMap<String, FahRegBillDTO>(doCollection.size());
        for (DynamicObject dto : doCollection) {
            FahRegBillDTO fahRegBillDTO = billToDTO.computeIfAbsent(dto.getString("srcbilltype"), btKey -> {
                FahRegBillDTO newDTO = new FahRegBillDTO();
                newDTO.setId(dto.getLong("id"));
                newDTO.setEnable(dto.getString("enable"));
                newDTO.setSrcBillType(dto.getString("srcbilltype"));
                newDTO.setSrcAppId(dto.getString("srcapp"));
                newDTO.setSrcBillOrgField(dto.getString("srcbillorgfield"));
                newDTO.setSrcBillStatusField(dto.getString("srcbillstatusfield"));
                newDTO.setWriteBackPlugin(dto.getString("writebackplugin"));
                ArrayList<FahRegBillEntryDTO> entry = new ArrayList<FahRegBillEntryDTO>(2);
                newDTO.setEntry(entry);
                return newDTO;
            });
            FahRegBillEntryDTO entryDTO = new FahRegBillEntryDTO(dto.getString("keyfieldentry.srcbillstatusval"), dto.getString("keyfieldentry.srcbilldatefieldnum"), dto.getString("keyfieldentry.evtstatusfieldnum"));
            fahRegBillDTO.addEntryDTO(entryDTO);
        }
        return billToDTO;
    }

    public static List<FahRegBillDTO> batchQueryRegBillByBillType(Collection<String> billTypes) {
        if (billTypes == null || billTypes.isEmpty()) {
            return new ArrayList<FahRegBillDTO>(2);
        }
        Map<String, FahRegBillDTO> regBillDtoCache = FahRegBillDao.getDtoThreadCache();
        ArrayList<FahRegBillDTO> dtoList = new ArrayList<FahRegBillDTO>(billTypes.size());
        ArrayList<String> notInCacheBillTypes = new ArrayList<String>(billTypes.size());
        for (String string : billTypes) {
            FahRegBillDTO fahRegBillDTO = regBillDtoCache.get(string);
            if (fahRegBillDTO == null) {
                notInCacheBillTypes.add(string);
                continue;
            }
            dtoList.add(fahRegBillDTO);
        }
        if (!notInCacheBillTypes.isEmpty()) {
            DynamicObjectCollection dtos = FahRegBillDao.batchQueryRegBillInfo(new QFilter[]{new QFilter("srcbilltype", "in", billTypes)});
            if (dtos == null || dtos.isEmpty()) {
                for (String notInCacheBillType : notInCacheBillTypes) {
                    regBillDtoCache.put(notInCacheBillType, new FahRegBillDTO());
                }
                return dtoList;
            }
            Map<String, FahRegBillDTO> map = FahRegBillDao.batchDoToDto(dtos);
            if (map.isEmpty()) {
                for (String notInCacheBillType : notInCacheBillTypes) {
                    regBillDtoCache.put(notInCacheBillType, new FahRegBillDTO());
                }
                return dtoList;
            }
            for (String notInCacheBillType : notInCacheBillTypes) {
                FahRegBillDTO fahRegBillDTO = map.get(notInCacheBillType);
                if (fahRegBillDTO == null) {
                    regBillDtoCache.put(notInCacheBillType, new FahRegBillDTO());
                    continue;
                }
                dtoList.add(fahRegBillDTO);
                regBillDtoCache.put(notInCacheBillType, fahRegBillDTO);
            }
        }
        return dtoList;
    }

    public static Map<Object, DynamicObject> queryBillInfoByIds(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return new HashMap<Object, DynamicObject>(2);
        }
        QFilter filter = new QFilter("id", "in", ids);
        Map id2Obj = BusinessDataServiceHelper.loadFromCache((String)"fah_regbill", (String)"id,srcbilltype,enable", (QFilter[])filter.toArray());
        return id2Obj;
    }

    public static List<FahRegBillDTO> queryAllEnableInfo() {
        DynamicObjectCollection regBillCol = FahRegBillDao.batchQueryRegBillInfo(new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        Map<String, FahRegBillDTO> billToDtoMap = FahRegBillDao.batchDoToDto(regBillCol);
        if (billToDtoMap.isEmpty()) {
            return new ArrayList<FahRegBillDTO>(2);
        }
        Map<String, FahRegBillDTO> dtoThreadCache = FahRegBillDao.getDtoThreadCache();
        dtoThreadCache.putAll(billToDtoMap);
        return new ArrayList<FahRegBillDTO>(billToDtoMap.values());
    }

    public static Set<String> getRegBillNumbers() {
        HashSet<String> billTypes = new HashSet<String>(16);
        List<FahRegBillDTO> fahRegBillDTOS = FahRegBillDao.queryAllEnableInfo();
        for (FahRegBillDTO dto : fahRegBillDTOS) {
            billTypes.add(dto.getSrcBillType());
        }
        return billTypes;
    }

    public static void getNormalBillTreeNode(Map<String, Map<String, String>> cloudAndAppMap, Map<String, Map<String, String>> bizAppAndEntityMap, Map<String, List<String>> baseDataInfo) {
        QFilter appFilter = new QFilter("srcapp", "<>", (Object)FormBuilderConstant.BIZ_APP_ID);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        try (DataSet objects = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fah_regbill", (String)"srcbilltype.id, srcbilltype.name, srcapp.id, srcapp.name, srcapp.bizcloud.id, srcapp.bizcloud.name", (QFilter[])new QFilter[]{appFilter, enableFilter}, (String)"srcapp.bizcloud.name,srcapp.name,srcbilltype.name");){
            for (Row row : objects) {
                String cloudId = row.getString("srcapp.bizcloud.id");
                if (null == cloudId) continue;
                String appId = row.getString("srcapp.id");
                cloudAndAppMap.computeIfAbsent(cloudId, v -> new LinkedHashMap()).putIfAbsent(appId, row.getString("srcapp.name"));
                bizAppAndEntityMap.computeIfAbsent(appId, v -> new LinkedHashMap()).put(row.getString("srcbilltype.id"), row.getString("srcbilltype.name"));
                baseDataInfo.computeIfAbsent(cloudId, v -> new ArrayList()).add(row.getString("srcbilltype.id"));
                baseDataInfo.computeIfAbsent(appId, v -> new ArrayList()).add(row.getString("srcbilltype.id"));
            }
        }
    }

    private static TreeNode createTreeNode(String parentId, String id, String name, boolean isOpened) {
        TreeNode node = new TreeNode();
        node.setParentid(parentId);
        node.setId(id);
        node.setText(name);
        node.setIsOpened(isOpened);
        return node;
    }

    public static void getEvtBillTreeNode(Map<String, TreeNode> eventGroupMap, Map<String, List<String>> baseDataInfo) {
        QFilter appFilter = new QFilter("srcapp", "=", (Object)FormBuilderConstant.BIZ_APP_ID);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        HashSet<String> regEventClassNumber = new HashSet<String>();
        try (DataSet objects = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fah_regbill", (String)"srcbilltype.id", (QFilter[])new QFilter[]{appFilter, enableFilter}, null);){
            for (Row object : objects) {
                regEventClassNumber.add(object.getString("srcbilltype.id").substring("fah_e_".length()));
            }
        }
        QFilter qfilter = new QFilter("number", "in", regEventClassNumber).and(new QFilter("latestversion", "=", (Object)"1")).and(new QFilter("status", "=", (Object)"C")).and(new QFilter("appversion", "=", (Object)"1"));
        DataSet eventClasses = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fah_ext_datamodel", (String)"number,name,group.id,group.name", (QFilter[])qfilter.toArray(), (String)"group,name");
        Object object = null;
        try {
            for (Row eventClass : eventClasses) {
                String groupId = eventClass.getString("group.id");
                String groupName = eventClass.getString("group.name");
                TreeNode groupNode = eventGroupMap.computeIfAbsent(groupId, v -> FahRegBillDao.createTreeNode(FormBuilderConstant.BIZ_APP_ID, groupId, groupName, false));
                String eventId = DataModelDaoImpl.getTableName((String)eventClass.getString("number"));
                String eventName = eventClass.getString("name");
                TreeNode eventNode = FahRegBillDao.createTreeNode(groupId, eventId, eventName, false);
                eventNode.setLeaf(true);
                groupNode.addChild(eventNode);
                baseDataInfo.computeIfAbsent(groupId, v -> new ArrayList()).add(eventId);
                baseDataInfo.computeIfAbsent(FormBuilderConstant.BIZ_APP_ID, v -> new ArrayList()).add(eventId);
                baseDataInfo.computeIfAbsent(FormBuilderConstant.CLOUD_FI_ID, v -> new ArrayList()).add(eventId);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (eventClasses != null) {
                if (object != null) {
                    try {
                        eventClasses.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    eventClasses.close();
                }
            }
        }
    }

    public static Tuple<String, List<String>> queryAllowBillStatus(String billType) {
        if (billType == null || billType.isEmpty()) {
            return new Tuple((Object)"", new ArrayList(2));
        }
        List<FahRegBillDTO> fahRegBillDTOS = FahRegBillDao.batchQueryRegBillByBillType(Collections.singleton(billType));
        if (fahRegBillDTOS.isEmpty()) {
            return new Tuple((Object)"", new ArrayList(2));
        }
        FahRegBillDTO fahRegBillDTO = fahRegBillDTOS.get(0);
        return new Tuple((Object)fahRegBillDTO.getSrcBillStatusField(), fahRegBillDTO.getEntry().stream().map(FahRegBillEntryDTO::getSrcBillStatusVal).collect(Collectors.toList()));
    }

    public static Map<String, List<String>> getBillType2Status(Collection<String> billTypes) {
        List<FahRegBillDTO> regBillDTOs = FahRegBillDao.batchQueryRegBillByBillType(billTypes);
        Map<String, List<String>> result = regBillDTOs.stream().collect(Collectors.toMap(FahRegBillDTO::getSrcBillType, dto -> dto.getEntry().stream().map(FahRegBillEntryDTO::getSrcBillStatusVal).collect(Collectors.toList())));
        return result;
    }

    public static String querySrcDate(String srcBillType) {
        if (srcBillType == null || srcBillType.isEmpty()) {
            return "";
        }
        List<FahRegBillDTO> fahRegBillDTOS = FahRegBillDao.batchQueryRegBillByBillType(Collections.singleton(srcBillType));
        if (fahRegBillDTOS.isEmpty()) {
            return "";
        }
        return fahRegBillDTOS.get(0).getEntry().get(0).getSrcBillDateFieldNum();
    }

    public static Map<String, String> batchQuerySrcDate(Collection<String> srcBillTypes) {
        if (srcBillTypes == null || srcBillTypes.isEmpty()) {
            return new HashMap<String, String>(2);
        }
        HashMap<String, String> dateMap = new HashMap<String, String>(2);
        List<FahRegBillDTO> fahRegBillDTOS = FahRegBillDao.batchQueryRegBillByBillType(srcBillTypes);
        for (FahRegBillDTO fahRegBillDTO : fahRegBillDTOS) {
            dateMap.put(fahRegBillDTO.getSrcBillType(), fahRegBillDTO.getEntry().get(0).getSrcBillDateFieldNum());
        }
        return dateMap;
    }

    public static String querySrcOrg(String srcBillType) {
        if (srcBillType == null || srcBillType.isEmpty()) {
            return "";
        }
        List<FahRegBillDTO> fahRegBillDTOS = FahRegBillDao.batchQueryRegBillByBillType(Collections.singleton(srcBillType));
        if (fahRegBillDTOS.isEmpty()) {
            return "";
        }
        return fahRegBillDTOS.get(0).getSrcBillOrgField();
    }

    public static Map<String, String> batchQuerySrcOrg(Collection<String> srcBillTypes) {
        if (srcBillTypes == null || srcBillTypes.isEmpty()) {
            return new HashMap<String, String>(2);
        }
        List<FahRegBillDTO> fahRegBillDTOS = FahRegBillDao.batchQueryRegBillByBillType(srcBillTypes);
        HashMap<String, String> orgMap = new HashMap<String, String>(4);
        for (FahRegBillDTO fahRegBillDTO : fahRegBillDTOS) {
            orgMap.put(fahRegBillDTO.getSrcBillType(), fahRegBillDTO.getSrcBillOrgField());
        }
        return orgMap;
    }

    public static Map<String, PairTuple<String, String>> batchQuerySrcOrgAndSrcDate(Collection<String> srcBillTypes) {
        if (srcBillTypes == null || srcBillTypes.isEmpty()) {
            return new HashMap<String, PairTuple<String, String>>(2);
        }
        List<FahRegBillDTO> fahRegBillDTOS = FahRegBillDao.batchQueryRegBillByBillType(srcBillTypes);
        HashMap<String, PairTuple<String, String>> map = new HashMap<String, PairTuple<String, String>>();
        for (FahRegBillDTO fahRegBillDTO : fahRegBillDTOS) {
            List<FahRegBillEntryDTO> entry = fahRegBillDTO.getEntry();
            if (entry == null || entry.isEmpty()) {
                map.put(fahRegBillDTO.getSrcBillType(), (PairTuple<String, String>)new PairTuple((Object)fahRegBillDTO.getSrcBillOrgField(), (Object)""));
                continue;
            }
            map.put(fahRegBillDTO.getSrcBillType(), (PairTuple<String, String>)new PairTuple((Object)fahRegBillDTO.getSrcBillOrgField(), (Object)fahRegBillDTO.getEntry().get(0).getSrcBillDateFieldNum()));
        }
        return map;
    }

    public static Map<String, PairTuple<String, String>> batchQuerySrcDateAndSrcOrg(Collection<String> srcBillTypes) {
        if (srcBillTypes == null || srcBillTypes.isEmpty()) {
            return new HashMap<String, PairTuple<String, String>>(2);
        }
        List<FahRegBillDTO> fahRegBillDTOS = FahRegBillDao.batchQueryRegBillByBillType(srcBillTypes);
        HashMap<String, PairTuple<String, String>> map = new HashMap<String, PairTuple<String, String>>();
        for (FahRegBillDTO fahRegBillDTO : fahRegBillDTOS) {
            List<FahRegBillEntryDTO> entry = fahRegBillDTO.getEntry();
            if (entry == null || entry.isEmpty()) {
                map.put(fahRegBillDTO.getSrcBillType(), (PairTuple<String, String>)new PairTuple((Object)"", (Object)fahRegBillDTO.getSrcBillOrgField()));
                continue;
            }
            map.put(fahRegBillDTO.getSrcBillType(), (PairTuple<String, String>)new PairTuple((Object)fahRegBillDTO.getEntry().get(0).getSrcBillDateFieldNum(), (Object)fahRegBillDTO.getSrcBillOrgField()));
        }
        return map;
    }

    public static void updateEnable(Collection<Long> ids, String enableStatus) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String updateSql = "update t_fah_regbill set fenable=? where fid=? ";
        List params = ids.stream().map(id -> {
            Object[] param = new Object[]{enableStatus, id};
            return param;
        }).collect(Collectors.toList());
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)updateSql, params);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static Set<String> hasGenOrDispatchRule(Collection<String> srcBillTypes) {
        Set hasGenOrDispatch = FahEventRuleCfgDAO.queryExistBySrcBill(srcBillTypes);
        Set<String> hasScheme = FahDispatchRuleDaoImpl.queryExistBySrcBill(srcBillTypes);
        hasGenOrDispatch.addAll(hasScheme);
        return hasGenOrDispatch;
    }

    public static String getDapWBPlugin(String billType) {
        if (billType == null || billType.isEmpty()) {
            return "";
        }
        SqlBuilder qrySql = new SqlBuilder();
        qrySql.append("select fwritebackplugin from t_ai_dapconfig where fbillentity=?", new Object[]{billType});
        return (String)DB.query((DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)qrySql, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getString("fwritebackplugin");
            }
            return "";
        });
    }
}

