/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dim.db.task;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.fi.v2.fah.constant.FAHCommonConstant;

public class DimQueryTask
implements Callable<Set<Long>> {
    int queryDimTypeCnt;
    Integer[] blockIds;
    Map<Integer, Set<Long>> blockIdxFidMap_id;
    Map<Integer, Set<Long>> blockIdxFidMap_txt;
    Map<Integer, Set<Long>> blockIdxFidMap_dt;
    Map<Integer, Set<Long>> blockIdxFidMap_amt;

    public DimQueryTask(int queryDimTypeCnt, Integer[] blockIds, Map<Integer, Set<Long>> blockIdxFidMap_id, Map<Integer, Set<Long>> blockIdxFidMap_txt, Map<Integer, Set<Long>> blockIdxFidMap_dt, Map<Integer, Set<Long>> blockIdxFidMap_amt) {
        this.queryDimTypeCnt = queryDimTypeCnt;
        this.blockIds = blockIds;
        this.blockIdxFidMap_id = blockIdxFidMap_id;
        this.blockIdxFidMap_txt = blockIdxFidMap_txt;
        this.blockIdxFidMap_dt = blockIdxFidMap_dt;
        this.blockIdxFidMap_amt = blockIdxFidMap_amt;
    }

    @Override
    public Set<Long> call() throws Exception {
        return this.doTheQuery();
    }

    private Set<Long> doTheQuery() {
        HashSet<Long> idSet = new HashSet<Long>(16);
        HashSet<Long> txtSet = new HashSet<Long>(16);
        HashSet<Long> dtSet = new HashSet<Long>(16);
        HashSet<Long> amtSet = new HashSet<Long>(16);
        for (Integer blockId : this.blockIds) {
            Set<Long> amts;
            Set<Long> dts;
            Set<Long> txts;
            Set<Long> ids = this.blockIdxFidMap_id.get(blockId);
            if (ids != null) {
                idSet.addAll(ids);
            }
            if ((txts = this.blockIdxFidMap_txt.get(blockId)) != null) {
                txtSet.addAll(txts);
            }
            if ((dts = this.blockIdxFidMap_dt.get(blockId)) != null) {
                dtSet.addAll(dts);
            }
            if ((amts = this.blockIdxFidMap_amt.get(blockId)) == null) continue;
            amtSet.addAll(amts);
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select res.dimgrpid from (", new Object[0]);
        if (!idSet.isEmpty()) {
            sql.appendIn("select idx_id.fsingledimgrpid as dimgrpid from t_fah_blockidx_id idx_id where idx_id.fid ", idSet.toArray());
            sql.append(" and idx_id.frefcnt = ?", new Object[]{1});
            sql.append(" union all ", new Object[0]);
            sql.appendIn("select map1.fdimgrpid as dimgrpid from t_fah_blockidx_id_map map1 where map1.fidxgrpid ", idSet.toArray());
        }
        if (!txtSet.isEmpty()) {
            if (!idSet.isEmpty()) {
                sql.append(" union all ", new Object[0]);
            }
            sql.appendIn("select idx_txt.fsingledimgrpid as dimgrpid from t_fah_blockidx_txt idx_txt where idx_txt.fid ", txtSet.toArray());
            sql.append(" and idx_txt.frefcnt = ?", new Object[]{1});
            sql.append(" union all ", new Object[0]);
            sql.appendIn("select map2.fdimgrpid as dimgrpid from t_fah_blockidx_txt_map map2 where map2.fidxgrpid ", txtSet.toArray());
        }
        if (!dtSet.isEmpty()) {
            if (!idSet.isEmpty() || !txtSet.isEmpty()) {
                sql.append(" union all ", new Object[0]);
            }
            sql.appendIn("select idx_dt.fsingledimgrpid as dimgrpid from t_fah_blockidx_dt idx_dt where idx_dt.fid ", dtSet.toArray());
            sql.append(" and idx_dt.frefcnt = ?", new Object[]{1});
            sql.append(" union all ", new Object[0]);
            sql.appendIn("select map3.fdimgrpid as dimgrpid from t_fah_blockidx_dt_map map3 where map3.fidxgrpid ", dtSet.toArray());
        }
        if (!amtSet.isEmpty()) {
            if (!(idSet.isEmpty() && txtSet.isEmpty() && dtSet.isEmpty())) {
                sql.append(" union all ", new Object[0]);
            }
            sql.appendIn("select idx_amt.fsingledimgrpid as dimgrpid from t_fah_blockidx_amt idx_amt where idx_amt.fid ", amtSet.toArray());
            sql.append(" and idx_amt.frefcnt = ?", new Object[]{1});
            sql.append(" union all ", new Object[0]);
            sql.appendIn("select map4.fdimgrpid as dimgrpid from t_fah_blockidx_amt_map map4 where map4.fidxgrpid ", amtSet.toArray());
        }
        sql.append(") res", new Object[0]);
        sql.append(" group by res.dimgrpid having count(res.dimgrpid) >= ?", new Object[]{this.queryDimTypeCnt});
        DataSet dataSet = DB.queryDataSet((String)"doTheQuery", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
        HashSet<Long> groupIdSet = new HashSet<Long>(16);
        while (dataSet.hasNext()) {
            groupIdSet.add(dataSet.next().getLong("dimgrpid"));
        }
        return groupIdSet;
    }
}

