/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dto.upstream.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.entity.property.EntryProp;
import kd.fi.v2.fah.cache.meta.BosMetaThreadLocalCacheService;
import kd.fi.v2.fah.constant.enums.EvtRelationEnum;
import kd.fi.v2.fah.dto.upstream.botp.BOTPQueryInParam;
import kd.fi.v2.fah.dto.upstream.service.QueryBOTPBillInfo;
import kd.fi.v2.fah.dto.upstream.service.QueryRelatedBillInfo;
import kd.fi.v2.fah.utils.FahEntityMetaHelper;
import kd.fi.v2.fah.utils.StringUtils;

public class QueryUpStreamInParamBuilder {
    private static final BosMetaThreadLocalCacheService metaCacheService = BosMetaThreadLocalCacheService.getInstance();

    public static QueryRelatedBillInfo buildQueryRelatedBillInCommonInfo(long acctBookId, long acctRuleId, long evtLineTypeId, String parentBillType, String parentEntryNum, String parentBillFieldNum, Map<Object, Long> childQueryParam) {
        return new QueryRelatedBillInfo(acctBookId, acctRuleId, evtLineTypeId, null, null, null, parentBillType, parentEntryNum, parentBillFieldNum, childQueryParam);
    }

    public static QueryRelatedBillInfo buildQueryRelatedBillCommonInfo(long acctBookId, long acctRuleId, long evtLineTypeId, String parentBillType, String parentBillFieldNum, Map<Object, Long> childQueryParam) {
        return new QueryRelatedBillInfo(acctBookId, acctRuleId, evtLineTypeId, null, null, null, parentBillType, null, parentBillFieldNum, childQueryParam);
    }

    public static QueryBOTPBillInfo buildQueryBOTPCommonInfo(long acctBookId, long acctRuleId, long evtLineTypeId, String childBillType, String childBillEntryNum, String parentBillType, String parentBillEntryNum, Long[] queryBillIds) {
        return new QueryBOTPBillInfo(acctBookId, acctRuleId, evtLineTypeId, childBillType, childBillEntryNum, null, parentBillType, parentBillEntryNum, null, queryBillIds);
    }

    public static BOTPQueryInParam buildBOTPQueryParam(QueryBOTPBillInfo queryInfo) {
        if (queryInfo.getQueryRelationType() != EvtRelationEnum.BOTP) {
            throw new IllegalArgumentException("Not BOTP Query Info Type:" + queryInfo);
        }
        BOTPQueryInParam result = QueryUpStreamInParamBuilder.buildBOTPQueryParam(queryInfo.getSrcChildBillType(), queryInfo.getTargetParentBillType(), queryInfo.getTargetParentEntryNum(), queryInfo.getChildQueryParams());
        result.setSourceQueryInfo(queryInfo);
        return result;
    }

    private static BOTPQueryInParam _buildBOTPQueryParam(String childEntityType, String lookupTargetBillType, Long[] queryBillIds) {
        if (StringUtils.isEmpty((String)childEntityType)) {
            throw new IllegalArgumentException("Query Source Bill Type is empty!");
        }
        if (StringUtils.isEmpty((String)lookupTargetBillType)) {
            throw new IllegalArgumentException("Lookup Target Bill Type is empty!");
        }
        if (queryBillIds == null || queryBillIds.length == 0) {
            throw new IllegalArgumentException("Query Source Bill Id is empty!");
        }
        BOTPQueryInParam result = new BOTPQueryInParam();
        result.setQueryEntityMetaTableId(metaCacheService.getTableDefineId(childEntityType));
        result.setLookupTargetBillMetaTableId(metaCacheService.getTableDefineId(lookupTargetBillType));
        result.setQueryBillIds(queryBillIds);
        return result;
    }

    public static BOTPQueryInParam buildBOTPQueryParam(String childEntityType, String lookupTargetBillType, List<String> lookupTargetEntryTypes, Long[] queryBillIds) {
        int entityCnt;
        List<Object> entryNames;
        BOTPQueryInParam result = QueryUpStreamInParamBuilder._buildBOTPQueryParam(childEntityType, lookupTargetBillType, queryBillIds);
        if (lookupTargetEntryTypes == null || lookupTargetEntryTypes.isEmpty()) {
            entryNames = new LinkedList();
            entityCnt = FahEntityMetaHelper.findMatchFieldsByType((String)lookupTargetBillType, EntryProp.class, (idx, prop) -> entryNames.add(prop.getName()));
        } else {
            entryNames = lookupTargetEntryTypes;
            entityCnt = lookupTargetEntryTypes.size();
        }
        HashMap<Long, String> lookupTargetEntityTypes = new HashMap<Long, String>(entityCnt);
        result.setLookupTargetEntityTypes(lookupTargetEntityTypes);
        for (String string : entryNames) {
            Long tableId = metaCacheService.getTableDefineId(string);
            if (tableId == null) continue;
            lookupTargetEntityTypes.put(tableId, string);
        }
        return result;
    }

    public static BOTPQueryInParam buildBOTPQueryParam(String childEntityType, String lookupTargetBillType, String leafEntityType, Long[] queryBillIds) {
        if (StringUtils.isEmpty((String)leafEntityType)) {
            return QueryUpStreamInParamBuilder.buildBOTPQueryParam(childEntityType, lookupTargetBillType, Collections.EMPTY_LIST, queryBillIds);
        }
        BOTPQueryInParam result = QueryUpStreamInParamBuilder._buildBOTPQueryParam(childEntityType, lookupTargetBillType, queryBillIds);
        result.setLookupTargetEntityTypes(FahEntityMetaHelper.getAllParentEntityTableIndex((String)lookupTargetBillType, (String)leafEntityType));
        return result;
    }
}

