/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.getvaluehandle;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.v2.fah.constant.enums.ExtractTypeEnum;
import kd.fi.v2.fah.dao.event.FahEventRuleDao;
import kd.fi.v2.fah.getvaluehandle.FieldGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.FormulaGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.IGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.MappingGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.ReferenceGetValueHandle;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSet;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetData;
import kd.fi.v2.fah.models.event.eventrule.EvtReferenceFieldDto;
import kd.fi.v2.fah.models.event.eventrule.FieldAliasInfo;
import kd.fi.v2.fah.models.xla.ReferenceFieldConfig;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.storage.impl.SupplementaryField;

public class AsstGetValueHandle
implements IGetValueHandle {
    private Map<String, IGetValueHandle> asstFieldCompile;

    public AsstGetValueHandle(DynamicExtractFieldValueSetData config) {
        List fieldValueSetList = config.getFieldValueSetList();
        this.asstFieldCompile = new HashMap<String, IGetValueHandle>(fieldValueSetList.size());
        for (DynamicExtractFieldValueSet def : fieldValueSetList) {
            IGetValueHandle gvHandle = null;
            ExtractTypeEnum getValueType = def.getGetValueType();
            switch (getValueType) {
                case CONSTANT_VALUE: 
                case SOURCE_FIELD: {
                    gvHandle = new FieldGetValueHandle(def.getTextValue(), getValueType, def.getActualConstantValue());
                    break;
                }
                case EXPRESSION: {
                    gvHandle = new FormulaGetValueHandle(def.getExpressionValue(), true);
                    break;
                }
                case MAPPING: {
                    gvHandle = new MappingGetValueHandle(def.getMappingType(), def.getMappingGroupId(), def.getDynExtFieldCfg().getNumber(), def.getFieldValueSetEntry(), def.getAsstActId());
                    break;
                }
                case PRESET_FILED: {
                    gvHandle = null;
                    break;
                }
                case REFERENCE_FIELD: {
                    String textValue = def.getTextValue();
                    if (StringUtils.isBlank((CharSequence)textValue)) {
                        gvHandle = new ReferenceGetValueHandle(null);
                        break;
                    }
                    EvtReferenceFieldDto evtReferenceFieldDto = FahEventRuleDao.queryReferenceFieldById(Long.parseLong(textValue));
                    gvHandle = new ReferenceGetValueHandle(new ReferenceFieldConfig(evtReferenceFieldDto.getId(), "", evtReferenceFieldDto.getFieldName(), evtReferenceFieldDto.getCustomValue(), evtReferenceFieldDto.getFieldType(), evtReferenceFieldDto.getValueSource()));
                    break;
                }
                default: {
                    gvHandle = null;
                }
            }
            this.asstFieldCompile.put(def.getAsstActName(), gvHandle);
        }
    }

    @Override
    public Object getValue(Object[] value, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos) {
        HashMap<String, Object> result = new HashMap<String, Object>(this.asstFieldCompile.size());
        for (Map.Entry<String, IGetValueHandle> vh : this.asstFieldCompile.entrySet()) {
            Object obj = vh.getValue().getValue(value, fieldAliasInfos);
            result.put(vh.getKey(), obj);
        }
        return result;
    }

    @Override
    public Map<String, Object> batchGetValue(Collection<Object[]> values, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos) {
        return null;
    }

    @Override
    public boolean isBatchGetValue() {
        return true;
    }

    @Override
    public void preSupData(SupplementaryField sf) {
        for (Map.Entry<String, IGetValueHandle> vh : this.asstFieldCompile.entrySet()) {
            vh.getValue().preSupData(sf);
        }
    }

    @Override
    public Set<String> compileFieldInfo() {
        Collection<IGetValueHandle> values = this.asstFieldCompile.values();
        HashSet<String> result = new HashSet<String>();
        for (IGetValueHandle gvh : values) {
            Set<String> compileFieldInfo = gvh.compileFieldInfo();
            result.addAll(compileFieldInfo);
        }
        return result;
    }
}

