/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.getvaluehandle;

import java.util.List;
import java.util.Map;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.cache.meta.BosMetaThreadLocalCacheService;
import kd.fi.v2.fah.dao.FahXLADaoImpl;
import kd.fi.v2.fah.dao.engine.common.FahQueryUpStreamRecordDaoImpl;
import kd.fi.v2.fah.dto.upstream.botp.BOTPQueryResult;
import kd.fi.v2.fah.dto.upstream.builder.QueryUpStreamInParamBuilder;
import kd.fi.v2.fah.dto.upstream.service.CustomQueryRelatedBillInfo;
import kd.fi.v2.fah.dto.upstream.service.ICustomQueryRelatedBillRecordPlugin;
import kd.fi.v2.fah.dto.upstream.service.QueryBOTPBillInfo;
import kd.fi.v2.fah.dto.upstream.service.QueryRelatedBillInfo;
import kd.fi.v2.fah.dto.upstream.service.QueryUpStreamParentBillRecResult;
import kd.fi.v2.fah.dto.upstream.service.QueryUpStreamXlaInfo;
import kd.fi.v2.fah.dto.upstream.service.QueryUpStreamXlaResult;
import kd.fi.v2.fah.dto.upstream.xla.QueryUpStreamXlaInputParam;
import kd.fi.v2.fah.getvaluehandle.IGetUpStreamBillAndXlaService;
import kd.fi.v2.fah.utils.StringUtils;

public class GetUpStreamBillAndXlaServiceImpl
implements IGetUpStreamBillAndXlaService {
    private static final BosMetaThreadLocalCacheService metaCacheService = BosMetaThreadLocalCacheService.getInstance();
    private static final FahQueryUpStreamRecordDaoImpl upstreamDao = FahQueryUpStreamRecordDaoImpl.getInstance();
    private static final FahXLADaoImpl xlaDao = FahXLADaoImpl.getInstance();
    private static final GetUpStreamBillAndXlaServiceImpl instance = new GetUpStreamBillAndXlaServiceImpl();

    public static GetUpStreamBillAndXlaServiceImpl getInstance() {
        return instance;
    }

    @Override
    public QueryUpStreamXlaResult queryUpStreamXlaResult(QueryUpStreamXlaInfo<?> queryInfo, Object param) {
        QueryUpStreamXlaInputParam xlaInputParam;
        QueryUpStreamXlaResult xlaResult;
        QueryUpStreamParentBillRecResult parentBillRecResult;
        if (queryInfo == null) {
            return null;
        }
        queryInfo.isValid(true);
        switch (queryInfo.getQueryRelationType()) {
            case BOTP: {
                parentBillRecResult = this.queryBOTPParentBillRecords((QueryBOTPBillInfo)queryInfo);
                break;
            }
            case BILL_FIELD: {
                parentBillRecResult = this.queryRelatedBillRecords((QueryRelatedBillInfo)queryInfo);
                break;
            }
            case PLUGIN: {
                parentBillRecResult = this.doCustomQueryRelatedBillRecordPlugin((CustomQueryRelatedBillInfo)queryInfo, String.valueOf(param));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown Query Relation Type: " + this);
            }
        }
        QueryUpStreamXlaResult result = new QueryUpStreamXlaResult();
        result.setFoundMultiResultIds(parentBillRecResult.getFoundMultiResultIds());
        result.setUnmatchedResultIds(parentBillRecResult.getUnmatchedResultIds());
        if (!parentBillRecResult.getMatchedResult().isEmpty() && (xlaResult = xlaDao.queryUpStreamXla(xlaInputParam = new QueryUpStreamXlaInputParam(queryInfo, parentBillRecResult.getMatchedResult().values()))) != null && xlaResult.getMatchResultCnt() > 0) {
            if (xlaResult.getUnmatchedResultIds() != null) {
                result.getUnmatchedResultIds().addAll(xlaResult.getUnmatchedResultIds());
            }
            if (xlaResult.getFoundMultiResultIds() != null) {
                result.getFoundMultiResultIds().addAll(xlaResult.getFoundMultiResultIds());
            }
        }
        return result;
    }

    protected QueryUpStreamParentBillRecResult queryRelatedBillRecords(QueryRelatedBillInfo queryInfo) {
        Object childQueryParam = queryInfo.getChildQueryParams();
        QueryUpStreamParentBillRecResult queryResult = new QueryUpStreamParentBillRecResult(childQueryParam.size());
        upstreamDao.queryRelatedBillRecords(queryInfo.getTargetParentBillType(), queryInfo.getTargetParentEntryNum(), queryInfo.getTargetParentLinkFieldNum(), childQueryParam.keySet().toArray(new Object[0]), arg_0 -> GetUpStreamBillAndXlaServiceImpl.lambda$queryRelatedBillRecords$0((Map)childQueryParam, queryResult, arg_0));
        queryResult.setUnmatchedResultIds(childQueryParam.values());
        return queryResult;
    }

    protected QueryUpStreamParentBillRecResult queryBOTPParentBillRecords(QueryBOTPBillInfo queryInfo) {
        Long[] childQueryParam = queryInfo.getChildQueryParams();
        QueryUpStreamParentBillRecResult queryResult = new QueryUpStreamParentBillRecResult(childQueryParam.length);
        BOTPQueryResult botpResult = upstreamDao.findBotpParentBills(QueryUpStreamInParamBuilder.buildBOTPQueryParam(queryInfo));
        for (Map.Entry<Long, List<PairTuple<Long, BFRowId>>> en : botpResult.getMatchedResult().entrySet()) {
            for (PairTuple<Long, BFRowId> pair : en.getValue()) {
                queryResult.addMatchResult((Long)pair.getKey(), ((BFRowId)pair.getValue()).getEntryId());
            }
        }
        queryResult.setUnmatchedResultIds(botpResult.getUnmatchedResultIds());
        return queryResult;
    }

    protected QueryUpStreamParentBillRecResult doCustomQueryRelatedBillRecordPlugin(CustomQueryRelatedBillInfo queryInfo, String pluginClassPath) {
        if (StringUtils.isEmpty((String)pluginClassPath)) {
            throw new IllegalArgumentException("Plugin Class Path is null! queryInfo=" + queryInfo);
        }
        try {
            ICustomQueryRelatedBillRecordPlugin plugin = (ICustomQueryRelatedBillRecordPlugin)Class.forName(pluginClassPath).newInstance();
            return plugin.doCustomQueryRelatedBillRecord(queryInfo);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static /* synthetic */ Boolean lambda$queryRelatedBillRecords$0(Map childQueryParam, QueryUpStreamParentBillRecResult queryResult, Object[] row) {
        Long srcId = (Long)childQueryParam.remove(row[0]);
        if (srcId != null) {
            queryResult.addMatchResult(srcId, (Long)row[1]);
        }
        return true;
    }
}

