/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.getvaluehandle;

import kd.bos.dataentity.utils.StringUtils;
import kd.fi.v2.fah.constant.enums.ExtractTypeEnum;
import kd.fi.v2.fah.dao.event.FahEventRuleDao;
import kd.fi.v2.fah.getvaluehandle.EntryFieldGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.EntryFormulaGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.FieldGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.FormulaGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.IGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.MappingGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.MultiRuleGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.ReferenceGetValueHandle;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSet;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetData;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetEntry;
import kd.fi.v2.fah.models.event.eventrule.EvtReferenceFieldDto;
import kd.fi.v2.fah.models.xla.ReferenceFieldConfig;
import kd.fi.v2.fah.storage.impl.SupplementaryField;

public class GetValueHandleFactory {
    public static IGetValueHandle getGetValueHandle(DynamicExtractFieldValueSetData config) {
        return GetValueHandleFactory.getSLGetValueHandle(config, null);
    }

    public static IGetValueHandle getSLGetValueHandle(DynamicExtractFieldValueSetData config, SupplementaryField sf) {
        if (config.isMultiBranch()) {
            return new MultiRuleGetValueHandle();
        }
        DynamicExtractFieldValueSet dynamicExtractFieldValueSet = (DynamicExtractFieldValueSet)config.getFieldValueSetList().get(0);
        ExtractTypeEnum getValueType = dynamicExtractFieldValueSet.getGetValueType();
        switch (getValueType) {
            case CONSTANT_VALUE: {
                return new FieldGetValueHandle(config);
            }
            case SOURCE_FIELD: {
                return new FieldGetValueHandle(config);
            }
            case EXPRESSION: {
                return new FormulaGetValueHandle(config);
            }
            case MAPPING: {
                return new MappingGetValueHandle(config, sf);
            }
            case PRESET_FILED: {
                return new FieldGetValueHandle(config);
            }
        }
        return null;
    }

    public static IGetValueHandle getEntryGetValueHandle(DynamicExtractFieldValueSetEntry configEntry) {
        ExtractTypeEnum getValueType = configEntry.getGetValueType();
        switch (getValueType) {
            case CONSTANT_VALUE: {
                return new EntryFieldGetValueHandle(configEntry);
            }
            case SOURCE_FIELD: {
                return new EntryFieldGetValueHandle(configEntry);
            }
            case EXPRESSION: {
                return new EntryFormulaGetValueHandle(configEntry);
            }
            case REFERENCE_FIELD: {
                String textValue = configEntry.getTextValue();
                if (StringUtils.isBlank((CharSequence)textValue)) {
                    return new ReferenceGetValueHandle(null);
                }
                EvtReferenceFieldDto evtReferenceFieldDto = FahEventRuleDao.queryReferenceFieldById(Long.parseLong(textValue));
                return new ReferenceGetValueHandle(new ReferenceFieldConfig(evtReferenceFieldDto.getId(), "", evtReferenceFieldDto.getFieldName(), evtReferenceFieldDto.getCustomValue(), evtReferenceFieldDto.getFieldType(), evtReferenceFieldDto.getValueSource()));
            }
        }
        return null;
    }
}

