/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.migration.datamodels;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.zip.ZipFile;
import kd.bos.zip.model.FileHeader;
import kd.bos.zip.model.ZipParameters;
import kd.fi.ai.util.IOUtils;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.cache.cacheservice.DataModelCfgCacheService;
import kd.fi.v2.fah.cache.cacheservice.FAHDataCacheMgr;
import kd.fi.v2.fah.constant.enums.AppVersionEnum;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.log.ILogHandler;
import kd.fi.v2.fah.log.LogLevelEnum;
import kd.fi.v2.fah.migration.common.IMigrationDataProcessor;
import kd.fi.v2.fah.migration.datamodels.DataModelMigrationLogHandler;
import kd.fi.v2.fah.migration.enums.MigrateDataTypeEnum;
import kd.fi.v2.fah.migration.zip.AbstractZipMigrationHandler;
import kd.fi.v2.fah.models.modeling.impl.DataModelCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCollection;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.task.context.BaseBackgroundTaskContext;
import kd.fi.v2.fah.util.ExtDataModelUtils;
import kd.fi.v2.fah.utils.DataModelUtils;
import kd.fi.v2.fah.utils.FahSerializeHelper;
import kd.fi.v2.fah.validator.processor.IMasterDataBatchValidateProcessor;
import kd.fi.v2.fah.validator.processor.MasterDataBatchValidateProcessor;

public class DataModelZipMigrationHandler
extends AbstractZipMigrationHandler<DataModelCfg>
implements IMigrationDataProcessor<ZipFile, DataModelCfg> {
    private static final Iterator<PairTuple<DataModelCfg, ZipParameters>> emptyIterator = Collections.EMPTY_LIST.iterator();
    protected Set<String> skipPublishModels = new HashSet<String>();

    public DataModelZipMigrationHandler() {
        this.migrateDataCategory = DataModelCfg.class.getSimpleName();
    }

    public void reset() {
        this.skipPublishModels.clear();
    }

    public String getDataVersion() {
        return String.valueOf(AppVersionEnum.getCurrentLastVersion().getCode());
    }

    protected <Long> Iterator<PairTuple<DataModelCfg, ZipParameters>> getMirgationData(final Collection<Long> pks) {
        if (pks == null || pks.isEmpty()) {
            return emptyIterator;
        }
        return new Iterator<PairTuple<DataModelCfg, ZipParameters>>(){
            final Iterator<Long> pkIds;
            final DataModelCfgCacheService cfgCacheService;
            private final ZipParameters zipParameter;
            private final PairTuple<DataModelCfg, ZipParameters> buffer;
            {
                this.pkIds = new ArrayList(pks).iterator();
                this.cfgCacheService = FAHDataCacheMgr.instance.getDataModelCfgCacheService();
                this.zipParameter = new ZipParameters();
                this.buffer = new PairTuple(null, (Object)this.zipParameter);
            }

            @Override
            public boolean hasNext() {
                return this.pkIds.hasNext();
            }

            @Override
            public PairTuple<DataModelCfg, ZipParameters> next() {
                while (this.pkIds.hasNext()) {
                    DataModelCfg dataModelCfg;
                    Object pk = this.pkIds.next();
                    if (pk == null || (dataModelCfg = (DataModelCfg)this.cfgCacheService.loadFromCache(pk, new Object[0])) == null) continue;
                    for (DataModelFieldCollection dataModelFields : (BaseMutableArrayMapStorage)dataModelCfg.getCollections()) {
                        BaseMutableArrayMapStorage fieldCfgs = (BaseMutableArrayMapStorage)dataModelFields.getCollections();
                        if (null == fieldCfgs) continue;
                        for (DataModelFieldCfg fieldCfg : fieldCfgs) {
                            QFilter gFilter;
                            DynamicObject detail;
                            if (fieldCfg.getDataType() != DataValueTypeEnum.AssistProp || null == (detail = QueryServiceHelper.queryOne((String)"bos_assistantdatagroup", (String)"number", (QFilter[])new QFilter[]{gFilter = new QFilter("id", "=", (Object)fieldCfg.getRefAssistProp())}))) continue;
                            fieldCfg.setRefBaseProp(detail.getString("number"));
                        }
                    }
                    this.zipParameter.setFileNameInZip(MigrateDataTypeEnum.Migrate_Data.buildFilePath(dataModelCfg.getNumber()));
                    this.zipParameter.setFileComment(dataModelCfg.getName());
                    this.buffer.setKey((Object)dataModelCfg);
                    return this.buffer;
                }
                return null;
            }
        };
    }

    public Collection<String> initFromMigrationFile(ZipFile srcMigrationFile) {
        return null;
    }

    public DataModelCfg parseFromMigrateFile(Integer dataVersion, FileHeader fileHeader, InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        String fileBuffer = IOUtils.readFully((InputStream)inputStream);
        if (StringUtils.isEmpty((CharSequence)fileBuffer)) {
            return null;
        }
        DataModelCfg result = (DataModelCfg)FahSerializeHelper.getInstance().parse(fileBuffer, DataModelCfg.class);
        if (result != null) {
            result.onAfterLoadMigrationDataModel((Object)dataVersion);
        }
        return result;
    }

    public PairTuple<LogLevelEnum, List<String>> processMigrationData(DataModelCfg srcData, BaseBackgroundTaskContext<Object> taskContext, Object ... params) {
        boolean isPublished;
        DynamicObject model;
        if (srcData == null) {
            return null;
        }
        PairTuple result = new PairTuple((Object)LogLevelEnum.Info, new LinkedList());
        Long orgId = null;
        DataModelMigrationLogHandler logHandler = new DataModelMigrationLogHandler();
        MasterDataBatchValidateProcessor validateProcessor = new MasterDataBatchValidateProcessor(orgId, (ILogHandler)logHandler, false, taskContext);
        DataModelUtils.registerValiateMasterData((DataModelCfg)srcData, (IMasterDataBatchValidateProcessor)validateProcessor);
        DataModelZipMigrationHandler.setRealGroup(srcData);
        validateProcessor.doQueryAndValidate(taskContext);
        ArrayList<String> warnInfoList = new ArrayList<String>();
        for (DataModelFieldCollection dataModelFields : (BaseMutableArrayMapStorage)srcData.getCollections()) {
            BaseMutableArrayMapStorage fieldCfgs = (BaseMutableArrayMapStorage)dataModelFields.getCollections();
            if (null == fieldCfgs) continue;
            for (DataModelFieldCfg fieldCfg : fieldCfgs) {
                String requiredCondition = fieldCfg.getRequiredCondition();
                if (!StringUtils.isNotEmpty((CharSequence)requiredCondition)) continue;
                String fieldName = fieldCfg.getName() + "(" + fieldCfg.getNumber() + ")";
                DataModelFieldCollection parent = fieldCfg.getParent();
                String fieldFullName = DataModelUtils.getFieldFullName((String)fieldName, (DataModelCfg)srcData, (DataModelFieldCollection)parent);
                warnInfoList.add(fieldFullName);
            }
        }
        if (!warnInfoList.isEmpty()) {
            this.skipPublishModels.add(srcData.getNumber());
        }
        if (null != (model = DataModelDaoImpl.queryUnpublishedRecordByNumber((String)srcData.getNumber()))) {
            DataModelDaoImpl.deleteModelAndGroupEntryInfo((Long)model.getLong("id"));
        }
        srcData.setId(null);
        srcData.setMasterId(null);
        DynamicObject latestPublishedModel = DataModelDaoImpl.getLatestPublishedVersion((String)srcData.getNumber());
        boolean bl = isPublished = null != latestPublishedModel;
        if (isPublished) {
            srcData.setMasterId(Long.valueOf(latestPublishedModel.getLong("masterid")));
            long newId = DataModelDaoImpl.saveNewDataModelForImport((DataModelCfg)srcData);
            srcData.setId(Long.valueOf(newId));
        }
        List<String> errorMsgList = ExtDataModelUtils.validateCanSave(srcData);
        Long modelId = null;
        if (errorMsgList.isEmpty()) {
            modelId = DataModelDaoImpl.save((DataModelCfg)srcData);
            boolean checkStatus = true;
            List errorMsg = taskContext.getErrorMsg();
            if (null != errorMsg && !errorMsg.isEmpty()) {
                result.setKey((Object)LogLevelEnum.Warning);
                ((List)result.getValue()).addAll(errorMsg);
                checkStatus = false;
            }
            if (this.skipPublishModels.contains(srcData.getNumber())) {
                String msg = isPublished ? ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u5b58\u5728\u5fc5\u5f55\u6761\u4ef6\uff0c\u8bf7\u70b9\u51fb\u4fee\u6539\u8fdb\u5165\u8349\u7a3f\u9875\u9762\uff0c\u91cd\u65b0\u914d\u7f6e\u5fc5\u5f55\u6761\u4ef6\u540e\u624b\u52a8\u53d1\u5e03\uff0c\u5426\u5219\u53ef\u80fd\u53d1\u751f\u672a\u77e5\u5f02\u5e38\u3002", (String)"DataModelZipMigrationHandler_1", (String)"fi-ai-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u5b58\u5728\u5fc5\u5f55\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u5fc5\u5f55\u6761\u4ef6\u540e\u624b\u52a8\u53d1\u5e03\uff0c\u5426\u5219\u53ef\u80fd\u53d1\u751f\u672a\u77e5\u5f02\u5e38\u3002", (String)"DataModelZipMigrationHandler_0", (String)"fi-ai-business", (Object[])new Object[0]);
                result.setKey((Object)LogLevelEnum.Warning);
                ((List)result.getValue()).add(String.format(msg, StringUtils.join((Object[])warnInfoList.toArray(), (String)", ")));
                checkStatus = false;
            }
            if (checkStatus) {
                Object publishResult;
                DynamicObject newModel = DataModelDaoImpl.loadSingleDataModelById((Long)modelId);
                try {
                    publishResult = DataModelDaoImpl.publish((DynamicObject)newModel);
                }
                catch (Exception e) {
                    publishResult = e.getMessage();
                }
                if (null != publishResult) {
                    result.setKey((Object)LogLevelEnum.Error);
                    if (publishResult instanceof String) {
                        ((List)result.getValue()).add((String)publishResult);
                    } else if (publishResult instanceof Map) {
                        ((List)result.getValue()).add(ExtDataModelUtils.getMsgOfResult((Map)publishResult, srcData.getNumber()));
                    }
                }
            }
        } else {
            result.setKey((Object)LogLevelEnum.Error);
            ((List)result.getValue()).addAll(errorMsgList);
            if (isPublished && null != srcData.getId()) {
                DataModelDaoImpl.deleteModelAndGroupEntryInfo((Long)srcData.getId());
            }
        }
        return result;
    }

    private static void setRealGroup(DataModelCfg srcData) {
        DynamicObject defaultGroup;
        DynamicObject group;
        Long newGroup = null;
        if (null != srcData.getGroupNumber() && null != (group = QueryServiceHelper.queryOne((String)"fah_ext_datamodel_group", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)srcData.getGroupNumber())}))) {
            newGroup = group.getLong("id");
        }
        if (null == newGroup && null != (defaultGroup = QueryServiceHelper.queryOne((String)"fah_ext_datamodel_group", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"DefaultGroup")}))) {
            newGroup = defaultGroup.getLong("id");
        }
        srcData.setGroup(newGroup);
    }

    public Collection<String> completeMigrationProcess(ZipFile srcMigrationFile) {
        return Collections.emptyList();
    }

    protected Class<DataModelCfg> getSerializeClass() {
        return DataModelCfg.class;
    }

    public String getMigrateDataCategory() {
        return this.migrateDataCategory;
    }
}

