/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.bizdims;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.fi.v2.fah.constant.enums.ExtractTypeEnum;
import kd.fi.v2.fah.dao.event.FahEventRuleDao;
import kd.fi.v2.fah.getvaluehandle.ReferenceGetValueHandle;
import kd.fi.v2.fah.models.event.eventrule.BizDimGetValueCfgDTO;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSet;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetData;
import kd.fi.v2.fah.models.event.eventrule.EventRuleLineCfg;
import kd.fi.v2.fah.models.event.eventrule.EvtReferenceFieldDto;
import kd.fi.v2.fah.models.event.eventrule.FieldAliasInfo;
import kd.fi.v2.fah.models.xla.AutoSetValueHandle;
import kd.fi.v2.fah.models.xla.ReferenceFieldConfig;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.util.FahXLARuleModelUtil;
import kd.fi.v2.fah.utils.EventRuleUtils;

public class EventRuleLineCfgGroup {
    private final String entityName;
    private final String entryEntityName;
    private final Map<String, Tuple<String, String>> selectFieldNumMap;
    private final String pkField;
    private final String entryPkField;
    private final String entryPkFieldAlias;
    private String select;
    private String orderBy;
    private BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos;
    private Map<Long, Map<Long, AutoSetValueHandle>> fieldHandle;
    private final Map<Long, EventRuleLineCfg> eventRuleLineCfgMap = new HashMap<Long, EventRuleLineCfg>(8);
    private final Map<Long, Map<Long, String>> bizDataGetValueFieldCfgMap = new HashMap<Long, Map<Long, String>>(8);

    public EventRuleLineCfgGroup(String entityName, String entryEntityName) {
        String entryPkFieldFull;
        this.fieldHandle = new LinkedHashMap<Long, Map<Long, AutoSetValueHandle>>();
        this.entityName = entityName;
        this.entryEntityName = entryEntityName;
        this.selectFieldNumMap = new LinkedHashMap<String, Tuple<String, String>>(16);
        this.fieldAliasInfos = new BaseMutableArrayMapStorage();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        this.pkField = dataEntityType.getPrimaryKey().getName();
        this.selectFieldNumMap.put(this.pkField, (Tuple<String, String>)Tuple.create((Object)this.pkField, (Object)this.pkField));
        if (Objects.equals(entityName, entryEntityName)) {
            this.entryPkField = this.pkField;
            this.entryPkFieldAlias = this.pkField;
            return;
        }
        EntityType entityType = (EntityType)dataEntityType.getAllEntities().get(entryEntityName);
        String entryPkFieldShort = entityType.getPrimaryKey().getName();
        this.entryPkField = entryPkFieldFull = EventRuleUtils.getFieldFullNum((IDataEntityType)entityType, (String)entryPkFieldShort);
        this.entryPkFieldAlias = entryPkFieldFull.replace(".", "_");
        this.selectFieldNumMap.put(this.entryPkField, (Tuple<String, String>)Tuple.create((Object)entryPkFieldFull, (Object)this.entryPkFieldAlias));
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntryEntityName() {
        return this.entryEntityName;
    }

    public EventRuleLineCfg getEventRuleLineCfg(Long genEvtLineRuleId) {
        return this.eventRuleLineCfgMap.get(genEvtLineRuleId);
    }

    public Set<Long> getEventRuleLineCfgIds() {
        return this.eventRuleLineCfgMap.keySet();
    }

    public void addLineCfg(EventRuleLineCfg eventRuleLineCfg) {
        this.eventRuleLineCfgMap.put(eventRuleLineCfg.getId(), eventRuleLineCfg);
        for (BizDimGetValueCfgDTO bizDimGetValueCfgDTO : eventRuleLineCfg.getBizDimGrpGetValueCfgs()) {
            DynamicExtractFieldValueSetData valueSetData = Optional.ofNullable(bizDimGetValueCfgDTO.getCustomCfgGrp()).orElseGet(() -> ((BizDimGetValueCfgDTO)bizDimGetValueCfgDTO).getSysPresetCfgGrp());
            if (null == valueSetData) continue;
            DynamicExtractFieldValueSet fieldValueSet = (DynamicExtractFieldValueSet)valueSetData.getFieldValueSetList().get(0);
            ExtractTypeEnum getValueType = fieldValueSet.getGetValueType();
            String fieldNum = fieldValueSet.getTextValue();
            if (ExtractTypeEnum.REFERENCE_FIELD == getValueType) {
                EvtReferenceFieldDto evtReferenceFieldDto = FahEventRuleDao.queryReferenceFieldById(Long.parseLong(fieldNum));
                ReferenceGetValueHandle valueHandle = new ReferenceGetValueHandle(new ReferenceFieldConfig(evtReferenceFieldDto.getId(), "", evtReferenceFieldDto.getFieldName(), evtReferenceFieldDto.getCustomValue(), evtReferenceFieldDto.getFieldType(), evtReferenceFieldDto.getValueSource()));
                for (String field : valueHandle.compileFieldInfo()) {
                    String fieldFullNum = EventRuleUtils.getFieldFullNumByBillType((String)this.entityName, (String)field);
                    String fieldFullNumAlias = fieldFullNum.replace(".", "_");
                    this.bizDataGetValueFieldCfgMap.computeIfAbsent(eventRuleLineCfg.getId(), k -> new HashMap()).put(bizDimGetValueCfgDTO.getDimInnerId(), fieldFullNumAlias);
                    this.selectFieldNumMap.put(field, (Tuple<String, String>)Tuple.create((Object)fieldFullNum, (Object)fieldFullNumAlias));
                }
                AutoSetValueHandle result = new AutoSetValueHandle(valueHandle, bizDimGetValueCfgDTO.getIndex());
                this.fieldHandle.computeIfAbsent(eventRuleLineCfg.getId(), k -> new HashMap()).put(bizDimGetValueCfgDTO.getDimInnerId(), result);
                continue;
            }
            String fieldFullNum = EventRuleUtils.getFieldFullNumByBillType((String)this.entityName, (String)fieldNum);
            String fieldFullNumAlias = fieldFullNum.replace(".", "_");
            this.bizDataGetValueFieldCfgMap.computeIfAbsent(eventRuleLineCfg.getId(), k -> new HashMap()).put(bizDimGetValueCfgDTO.getDimInnerId(), fieldFullNumAlias);
            this.selectFieldNumMap.put(fieldNum, (Tuple<String, String>)Tuple.create((Object)fieldFullNum, (Object)fieldFullNumAlias));
            this.fieldHandle.computeIfAbsent(eventRuleLineCfg.getId(), k -> new HashMap()).put(bizDimGetValueCfgDTO.getDimInnerId(), FahXLARuleModelUtil.getAutoSetValueHandleByModel(valueSetData, bizDimGetValueCfgDTO.getNumber(), bizDimGetValueCfgDTO.getIndex()));
        }
    }

    public Map<Long, Map<Long, AutoSetValueHandle>> getFieldHandle() {
        return this.fieldHandle;
    }

    public BaseMutableArrayMapStorage<String, FieldAliasInfo> getFieldAliasInfos() {
        return this.fieldAliasInfos;
    }

    public String getSqlPrefix() {
        LinkedList<String> list = new LinkedList<String>();
        for (FieldAliasInfo fieldAliasInfo : this.fieldAliasInfos) {
            list.add(fieldAliasInfo.getQueryFieldNumber() + " " + fieldAliasInfo.getAlias());
        }
        return StringUtils.join((Object[])list.toArray(), (String)",");
    }

    public void setFieldAliasInfoByAuto() {
        int index = 0;
        for (Map.Entry<String, Tuple<String, String>> entry : this.selectFieldNumMap.entrySet()) {
            FieldAliasInfo info = new FieldAliasInfo(entry.getKey(), "f" + index);
            info.setReadPos(index);
            info.setWritePos(index);
            info.setQueryFieldNumber((String)entry.getValue().item1);
            this.fieldAliasInfos.add((Object)info);
            ++index;
        }
    }

    public String getSelect() {
        if (null == this.select) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean isFirst = true;
            for (Tuple<String, String> fieldNumTuple : this.selectFieldNumMap.values()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append((String)fieldNumTuple.item1).append(" ").append((String)fieldNumTuple.item2);
            }
            this.select = stringBuilder.toString();
        }
        return this.select;
    }

    public String getFieldFullNumAlias(Long genEvtLineRuleId, Long dimInnerId) {
        Map<Long, String> dimInnerIdFieldFullNumAliasMap = this.bizDataGetValueFieldCfgMap.get(genEvtLineRuleId);
        if (null == dimInnerIdFieldFullNumAliasMap) {
            return null;
        }
        return dimInnerIdFieldFullNumAliasMap.get(dimInnerId);
    }

    public String getPkField() {
        return this.pkField;
    }

    public String getEntryPkField() {
        return this.entryPkField;
    }

    public String getEntryPkFieldAlias() {
        return this.entryPkFieldAlias;
    }

    public String getOrderBy() {
        if (null == this.orderBy) {
            this.orderBy = Objects.equals(this.pkField, this.entryPkField) ? this.pkField : String.join((CharSequence)",", this.pkField, this.entryPkField);
        }
        return this.orderBy;
    }

    public String toString() {
        return "EventRuleLineCfgGroup{entityName='" + this.entityName + '\'' + ", entryEntityName='" + this.entryEntityName + '\'' + ", selectFieldNumMap=" + this.selectFieldNumMap + ", pkField='" + this.pkField + '\'' + ", entryPkField='" + this.entryPkField + '\'' + ", entryPkFieldAlias='" + this.entryPkFieldAlias + '\'' + ", select='" + this.select + '\'' + ", orderBy='" + this.orderBy + '\'' + ", eventRuleLineCfgMap=" + this.eventRuleLineCfgMap + ", bizDataGetValueFieldCfgMap=" + this.bizDataGetValueFieldCfgMap + '}';
    }
}

