/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.context;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.entity.operate.result.OperationResult;
import kd.fi.v2.fah.constant.enums.event.EventReverseStatusEnum;
import kd.fi.v2.fah.job.IFahJobContext;
import kd.fi.v2.fah.models.context.FahVoucherTrackerContext;
import kd.fi.v2.fah.models.context.ITaskVoucherPushContext;
import kd.fi.v2.fah.models.voucher.FahGLVoucher;
import kd.fi.v2.fah.task.context.BuildVoucherReportInfoContext;

public class GLTaskVoucherPushContext
implements ITaskVoucherPushContext {
    private final List<FahGLVoucher> srcVouchers = new ArrayList<FahGLVoucher>(16);
    private List<Long> nextBatchIds;
    private final List<Long> interFaceTableIds;
    private OperationResult option;
    private final Set<Long> hasSaveVoucherIds = new HashSet<Long>(8);
    private FahVoucherTrackerContext tracker;
    private boolean transactionNeedRollback = false;
    private boolean allTaskStatus = true;
    private BuildVoucherReportInfoContext reportContext;
    private final EventReverseStatusEnum reverseStatusEnum;
    private final int maxSize;
    private int preSaveMaxSize = 100000;
    private List<Long> bufferIds;
    private final IFahJobContext fahJobContext;
    private List<Long> notPushVoucher = new ArrayList<Long>();

    public GLTaskVoucherPushContext(List<Long> interFaceTableIds, EventReverseStatusEnum reverseStatusEnum, int maxSize, IFahJobContext fahJobContext) {
        this.option = new OperationResult();
        this.interFaceTableIds = interFaceTableIds;
        this.reverseStatusEnum = reverseStatusEnum;
        this.maxSize = maxSize;
        this.fahJobContext = fahJobContext;
        this.refreshBufferBatchData(true);
    }

    public void refreshBufferBatchData(Boolean isFirst) {
        if (isFirst.booleanValue()) {
            if (this.interFaceTableIds.size() >= this.maxSize) {
                this.nextBatchIds = new ArrayList<Long>(this.interFaceTableIds.subList(0, this.maxSize));
                this.bufferIds = new ArrayList<Long>(this.interFaceTableIds.subList(this.maxSize, this.interFaceTableIds.size()));
            } else {
                this.nextBatchIds = new ArrayList<Long>(this.interFaceTableIds);
            }
        } else if (this.bufferIds != null && !this.bufferIds.isEmpty()) {
            this.nextBatchIds.addAll(this.bufferIds);
            if (this.nextBatchIds.size() >= this.maxSize) {
                this.bufferIds = new ArrayList<Long>(this.nextBatchIds.subList(this.maxSize, this.nextBatchIds.size()));
                this.nextBatchIds = new ArrayList<Long>(this.nextBatchIds.subList(0, this.maxSize));
            } else {
                this.bufferIds = null;
            }
        }
    }

    @Override
    public List<Long> getInterFaceTableIds() {
        return this.interFaceTableIds;
    }

    @Override
    public List<FahGLVoucher> getCurrBatchSrcVoucher() {
        return this.srcVouchers;
    }

    @Override
    public List<Long> getNextBatchIds() {
        return this.nextBatchIds;
    }

    @Override
    public OperationResult getOpation() {
        return this.option;
    }

    @Override
    public void setOpation(OperationResult opResult) {
        this.option = opResult;
    }

    public Set<Long> getHasSaveVoucherIds() {
        return this.hasSaveVoucherIds;
    }

    public boolean isTransactionNeedRollback() {
        return this.transactionNeedRollback;
    }

    public void setTransactionNeedRollback(boolean transactionNeedRollback) {
        this.transactionNeedRollback = transactionNeedRollback;
    }

    public FahVoucherTrackerContext getTracker() {
        return this.tracker;
    }

    public void setTracker(FahVoucherTrackerContext tracker) {
        this.tracker = tracker;
    }

    public boolean isAllTaskStatus() {
        return this.allTaskStatus;
    }

    public void setAllTaskStatus(boolean allTaskStatus) {
        this.allTaskStatus = allTaskStatus;
    }

    public BuildVoucherReportInfoContext getReportContext() {
        return this.reportContext;
    }

    public void setReportContext(BuildVoucherReportInfoContext reportContext) {
        this.reportContext = reportContext;
    }

    public EventReverseStatusEnum getReverseStatusEnum() {
        return this.reverseStatusEnum;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getPreSaveMaxSize() {
        return this.preSaveMaxSize;
    }

    public void setPreSaveMaxSize(int preSaveMaxSize) {
        this.preSaveMaxSize = preSaveMaxSize;
    }

    @Override
    public IFahJobContext getFahJobContext() {
        return this.fahJobContext;
    }

    public List<Long> getNotPushVoucher() {
        return this.notPushVoucher;
    }

    public void setNotPushVoucher(List<Long> notPushVoucher) {
        this.notPushVoucher = notPushVoucher;
    }
}

