/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.context;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.FahMappingConstant;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.FahDataValsetEntryPropEnum;
import kd.fi.v2.fah.constant.enums.ImportLogStatusEnum;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.dao.BaseFlexFieldDao;
import kd.fi.v2.fah.dao.FahImportLogDao;
import kd.fi.v2.fah.dao.FlexMapValTempDao;
import kd.fi.v2.fah.models.context.BaseFlexTabExcelProcessContext;
import kd.fi.v2.fah.models.flex.FlexFieldGrpCfg;
import kd.fi.v2.fah.models.flex.IFlexFieldMeta;
import kd.fi.v2.fah.sqlbuilder.BaseSqlBuilderFactory;
import kd.fi.v2.fah.sqlbuilder.IFlexFieldLookup;
import kd.fi.v2.fah.sqlbuilder.IInsertSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.ISqlParamBuffer;
import kd.fi.v2.fah.sqlbuilder.impl.FlexTableInsertSqlBuilder;
import kd.fi.v2.fah.util.FahUploadDataValUtil;
import kd.fi.v2.fah.utils.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;

public class SingleValueSetMappingExcelProcContext
extends BaseFlexTabExcelProcessContext<Long, FlexFieldGrpCfg, FlexTableInsertSqlBuilder, Object> {
    public SingleValueSetMappingExcelProcContext(String entityId, Workbook wb, Long batchId, int excelHeaderRowCnt) {
        super(entityId, wb, batchId, excelHeaderRowCnt);
    }

    public SingleValueSetMappingExcelProcContext(String entityId, Workbook wb, Long batchId) {
        super(entityId, wb, batchId);
    }

    protected FlexFieldGrpCfg getFlexFieldGrpCfg(Long flexStrucId, String entityId) {
        if (this.fieldGrpCfg == null) {
            this.fieldGrpCfg = BaseFlexFieldDao.loadFlexFieldGrpCfg(new QFilter("id", "=", (Object)flexStrucId), entityId);
        }
        return this.fieldGrpCfg;
    }

    @Override
    protected IInsertSqlBuilder createBuilder(int sheetIdx) {
        block5: {
            if (this._sqlBuilder != null) break block5;
            FlexTableInsertSqlBuilder sqlBuilder = BaseSqlBuilderFactory.createFlexTableInsertSqlBuilder(this.getTableName(), this.valSetNumber, this.entityId);
            sqlBuilder.setNeedAutoUpdateSeqNo(false);
            sqlBuilder.setNeedGetLastMaxSeqNo(false);
            sqlBuilder.setFlexFieldLookup((IFlexFieldLookup)this.getFlexFieldGrpCfg(this.flexStrucId, this.entityId));
            sqlBuilder.addConstantValueColumn("fbatchid", this.batchId);
            sqlBuilder.addConstantValueColumn("fsrctype", (Object)this.entityId);
            sqlBuilder.addConstantValueColumn("fvaltypeid", (Object)this.flexTypeId);
            sqlBuilder.addConstantValueColumn("fHasMulValue", (Object)0);
            int colIdx = 0;
            sqlBuilder.addPKColumn("fid", new Object[0]);
            sqlBuilder.addFixPosColumn("fexcelrownum", new Object[0]);
            this.flexFields = new LinkedList();
            for (String number : this.entryNumberFields) {
                block7: {
                    block6: {
                        FahDataValsetEntryPropEnum enumNumber = FahDataValsetEntryPropEnum.getEnumByNumber((String)number);
                        if (enumNumber == null) break block6;
                        switch (enumNumber) {
                            case SEGMENT: 
                            case SEGMENTNAME: 
                            case DESCRIPTION: {
                                sqlBuilder.addFixPosColumn(enumNumber.getField(), new Object[0]);
                                break block7;
                            }
                            case EFFICACYDATE: 
                            case EFFECTDATE: {
                                sqlBuilder.addFixPosColumn(enumNumber.getField(), new Object[0]);
                                this.datePos.put(colIdx, number);
                                break block7;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown FahDataValsetEntryPropEnum\uff01");
                            }
                        }
                    }
                    sqlBuilder.addFlexColumn(number, new Object[0]);
                    this.flexFields.add(number);
                }
                ++colIdx;
            }
            this._sqlBuilder = sqlBuilder;
        }
        return this._sqlBuilder;
    }

    @Override
    protected void processExcelData(int sheetIdx) {
        if (sheetIdx > 1) {
            return;
        }
        int writeableColCnt = ((FlexTableInsertSqlBuilder)this._sqlBuilder).getWriteableColumnCnt();
        ISqlParamBuffer sqlParamBuf = ((FlexTableInsertSqlBuilder)this._sqlBuilder).getSqlParamBuffer();
        int length = this.entryNumberFields.length;
        while (this.currentExcelRowIterator.hasNext()) {
            boolean moveToNext = false;
            Row excelRowBuf = this.currentExcelRowIterator.next();
            int colIdx = 0;
            sqlParamBuf.set(colIdx++, (Object)this.currentExcelRowIterator.getCurrentSheetRow());
            int cellIdx = 0;
            for (int i = 0; i < length && colIdx < writeableColCnt; ++colIdx, ++i) {
                String cellValue;
                Cell cell = excelRowBuf.getCell(i);
                String string = cellValue = null == cell ? " " : cell.getStringCellValue();
                if (this.datePos.containsKey(cellIdx)) {
                    if (StringUtils.isEmpty((String)cellValue)) {
                        Date date = ((String)this.datePos.get(cellIdx)).equals("effectdate") ? FahMappingConstant.effectDate : FahMappingConstant.expireDate;
                        sqlParamBuf.set(colIdx, (Object)date);
                    } else {
                        moveToNext = true;
                        sqlParamBuf.set(colIdx, (Object)ObjectConverterFactory.getDate((Object)cellValue));
                    }
                } else {
                    if (StringUtils.isEmpty((String)cellValue)) {
                        cellValue = " ";
                    } else {
                        moveToNext = true;
                    }
                    sqlParamBuf.set(colIdx, (Object)cellValue);
                }
                ++cellIdx;
            }
            if (moveToNext) {
                sqlParamBuf.moveToNextParamRow();
                continue;
            }
            sqlParamBuf.clearDataChangeFlag();
        }
        ((FlexTableInsertSqlBuilder)this._sqlBuilder).completeAndPack();
    }

    @Override
    protected boolean saveData(int sheetIdx) {
        if (sheetIdx > 1) {
            return true;
        }
        BaseFlexFieldDao.doFlexValueSetInsert((FlexTableInsertSqlBuilder)this._sqlBuilder, null);
        return true;
    }

    @Override
    protected boolean finalDataProcess() {
        FlexTableInsertSqlBuilder insertBuilder = BaseSqlBuilderFactory.createFlexTableInsertSqlBuilder("t_fah_flex_valueset", this.valSetNumber, this.entityId);
        this.saveFormalData(insertBuilder);
        return true;
    }

    private void saveFormalData(FlexTableInsertSqlBuilder insertBuilder) {
        List<Object> errorInfos = new LinkedList();
        errorInfos = FlexMapValTempDao.queryNumberAndName((Long)this.batchId);
        if (!errorInfos.isEmpty()) {
            this.saveFahImportLog(ImportLogStatusEnum.FAILED.getCode(), null, errorInfos);
            return;
        }
        errorInfos = FlexMapValTempDao.queryDupValSetsTemp((Long)this.batchId);
        if (!errorInfos.isEmpty()) {
            this.saveFahImportLog(ImportLogStatusEnum.FAILED.getCode(), null, errorInfos);
            return;
        }
        errorInfos = FlexMapValTempDao.queryDateEffectTemp((Long)this.batchId);
        if (!errorInfos.isEmpty()) {
            this.saveFahImportLog(ImportLogStatusEnum.FAILED.getCode(), null, errorInfos);
            return;
        }
        List<Object[]> numbers = FlexMapValTempDao.queryDaplicateValset((Long)this.batchId);
        if (!numbers.isEmpty()) {
            for (Object[] number : numbers) {
                errorInfos.add(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u503c\u7f16\u7801\u201c%2$s\u201d\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SingleValueSetMappingExcelProcContext_0", (String)"fi-ai-business", (Object[])new Object[0]), number[0], number[1]));
            }
            this.saveFahImportLog(ImportLogStatusEnum.FAILED.getCode(), null, errorInfos);
            return;
        }
        HashMap<String, IFlexFieldMeta> flexMap = new HashMap<String, IFlexFieldMeta>();
        insertBuilder.setNeedAutoUpdateSeqNo(true);
        insertBuilder.addConstantValueColumn("fvaluesettypeid", (Object)this.flexTypeId);
        insertBuilder.addConstantValueColumn("fenable", (Object)Character.valueOf('1'));
        insertBuilder.addPKColumn("fid", new Object[0]);
        insertBuilder.addSequenceColumn("fseq", new Object[0]);
        insertBuilder.addFixPosColumn("fnumber", new Object[0]);
        insertBuilder.addFixPosColumn("fname", new Object[0]);
        insertBuilder.addFixPosColumn("fdescription", new Object[0]);
        insertBuilder.addFixPosColumn("feffectdate", new Object[0]);
        insertBuilder.addFixPosColumn("fexpiredate", new Object[0]);
        for (String field : this.flexFields) {
            IFlexFieldMeta tableField = ((FlexTableInsertSqlBuilder)this._sqlBuilder).getFlexFieldLookup().getFlexFieldCfgByFlexFieldNum((Object)field);
            insertBuilder.addFixPosColumn(tableField.getDbFieldNum(), new Object[0]);
            if (DataValueTypeEnum.FahValueSet != tableField.getDataType()) continue;
            flexMap.put(field, tableField);
        }
        Collection sqlColumnNames = ((FlexTableInsertSqlBuilder)this._sqlBuilder).getSqlColumnNames();
        LinkedHashSet colNames = new LinkedHashSet(sqlColumnNames.size());
        colNames.addAll(sqlColumnNames);
        String collectionToString = StringUtils.collectionToString(colNames);
        String sql = "select " + collectionToString + " from " + ((FlexTableInsertSqlBuilder)this._sqlBuilder).getSqlTableName() + " where fbatchid = ?";
        SqlBuilder sb = new SqlBuilder();
        sb.append(sql, new Object[]{this.batchId});
        LinkedHashMap<IFlexFieldMeta, Set<String>> valueMap = new LinkedHashMap<IFlexFieldMeta, Set<String>>();
        DataSet queryDataSet = DB.queryDataSet((String)FahUploadDataValUtil.class.getName(), (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sb);
        Object object = null;
        try {
            for (kd.bos.algo.Row row : queryDataSet) {
                for (IFlexFieldMeta tableField : flexMap.values()) {
                    String dbValue;
                    if (DataValueTypeEnum.FahValueSet != tableField.getDataType() || !StringUtils.isNotEmpty((String)(dbValue = row.getString(tableField.getDbFieldNum())))) continue;
                    Set segments = valueMap.computeIfAbsent(tableField, k -> new HashSet());
                    segments.add(dbValue);
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (queryDataSet != null) {
                if (object != null) {
                    try {
                        queryDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    queryDataSet.close();
                }
            }
        }
        Map<IFlexFieldMeta, Set<String>> notFindNumberMap = FahImportLogDao.findNotValueSet(valueMap);
        if (!notFindNumberMap.isEmpty()) {
            for (Map.Entry entry : notFindNumberMap.entrySet()) {
                String refEntity = ((IFlexFieldMeta)entry.getKey()).getRefEntity();
                for (String code : (Set)entry.getValue()) {
                    errorInfos.add(String.format(ResManager.loadKDString((String)"\u503c\u96c6\u6269\u5c55\u5b57\u6bb5\u4e2d\uff0c\u201c%1$s\u201d\u503c\u96c6\u4e0d\u5b58\u5728\uff08\u6216\u8005\u88ab\u7981\u7528/\u4e0d\u5728\u751f\u6548\u65f6\u95f4\u5185\uff09\u503c\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u503c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SingleValueSetMappingExcelProcContext_1", (String)"fi-ai-business", (Object[])new Object[0]), refEntity, code));
                }
            }
            this.saveFahImportLog(ImportLogStatusEnum.FAILED.getCode(), null, errorInfos);
            return;
        }
        ISqlParamBuffer sqlParamBuf = insertBuilder.getSqlParamBuffer();
        try (DataSet dataSet = DB.queryDataSet((String)FahUploadDataValUtil.class.getName(), (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sb);){
            for (kd.bos.algo.Row row : dataSet) {
                int prop = 0;
                sqlParamBuf.set(prop++, (Object)row.getString("fnumber"));
                sqlParamBuf.set(prop++, (Object)row.getString("fname"));
                sqlParamBuf.set(prop++, (Object)row.getString("fdescription"));
                sqlParamBuf.set(prop++, (Object)row.getDate("feffectdate"));
                sqlParamBuf.set(prop++, (Object)row.getDate("fexpiredate"));
                for (String field : this.flexFields) {
                    IFlexFieldMeta tableField = ((FlexTableInsertSqlBuilder)this._sqlBuilder).getFlexFieldLookup().getFlexFieldCfgByFlexFieldNum((Object)field);
                    String dbFieldNum = tableField.getDbFieldNum().trim();
                    sqlParamBuf.set(prop++, (Object)row.getString(dbFieldNum));
                }
                sqlParamBuf.moveToNextParamRow();
            }
        }
        insertBuilder.completeAndPack();
        QFilter qFilter = new QFilter("fvaluesettypeid", "=", (Object)this.flexTypeId);
        BaseFlexFieldDao.doFlexValueSetInsert(insertBuilder, qFilter);
        this.saveFahImportLog(ImportLogStatusEnum.SUCCEED.getCode(), null, null);
    }
}

