/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.groupmerge;

import java.util.BitSet;
import java.util.Date;
import kd.bos.fs.util.StringUtils;
import kd.fi.v2.fah.constant.enums.event.VchSummaryTypeEnum;
import kd.fi.v2.fah.models.groupmerge.GroupAndMergeRuleModel;
import kd.fi.v2.fah.models.voucher.FahGLVoucher;
import kd.fi.v2.fah.models.voucher.XLAVoucher;

public class FahVoucherGroupKey {
    private Long periodId;
    private Long bookId;
    private Long vchTypeId;
    private Date bookedDate;
    private Date bizDate;
    private Long creatorId;
    private String billno;
    private String extField;
    private String billMergeField;
    private GroupAndMergeRuleModel model;

    public FahVoucherGroupKey(GroupAndMergeRuleModel model, XLAVoucher voucher) {
        this.model = model;
        this.periodId = voucher.getPeriodId();
        this.bookId = voucher.getBookId();
        this.vchTypeId = voucher.getVchTypeId();
        this.bookedDate = voucher.getBookedDate();
        this.bizDate = voucher.getBizDate();
        this.creatorId = voucher.getCreatorId();
        this.billno = voucher.getSourceBillNo();
        this.extField = "";
        this.billMergeField = voucher.getBillMergeField();
    }

    public FahVoucherGroupKey(GroupAndMergeRuleModel model, FahGLVoucher voucher) {
        this.model = model;
        this.periodId = voucher.getPeriodId();
        this.bookId = voucher.getBookId();
        this.vchTypeId = voucher.getVchTypeId();
        this.bookedDate = voucher.getBookedDate();
        this.bizDate = voucher.getBizDate();
        this.creatorId = voucher.getCreatorId();
        this.billno = voucher.getSourcebillno();
        this.extField = "";
        this.billMergeField = voucher.getMergeKey();
    }

    public int hashCode() {
        VchSummaryTypeEnum mergeType = this.model.getMergeType();
        if (VchSummaryTypeEnum.ONE_FOR_ONE == mergeType) {
            return super.hashCode();
        }
        BitSet dimension = this.model.getGroupDimensionAndReCalField();
        int result = 1;
        result = 31 * result + this.periodId.hashCode();
        result = 31 * result + this.bookId.hashCode();
        result = 31 * result + this.vchTypeId.hashCode();
        if (dimension.get(0)) {
            result = 31 * result + this.bookedDate.hashCode();
        }
        if (dimension.get(1)) {
            result = 31 * result + this.bizDate.hashCode();
        }
        if (dimension.get(2)) {
            result = 31 * result + this.creatorId.hashCode();
        }
        if (dimension.get(3)) {
            result = 31 * result + this.billno.hashCode();
        }
        if (StringUtils.isBlank((String)this.extField)) {
            result = 31 * result + this.extField.hashCode();
        }
        if (StringUtils.isBlank((String)this.billMergeField)) {
            result = 31 * result + this.billMergeField.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        VchSummaryTypeEnum mergeType = this.model.getMergeType();
        if (VchSummaryTypeEnum.ONE_FOR_ONE == mergeType) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FahVoucherGroupKey)) {
            return false;
        }
        FahVoucherGroupKey other = (FahVoucherGroupKey)obj;
        BitSet dimension = this.model.getGroupDimensionAndReCalField();
        if (this.periodId == null ? other.getPeriodId() != null : !this.periodId.equals(other.getPeriodId())) {
            return false;
        }
        if (this.bookId == null ? other.getBookId() != null : !this.bookId.equals(other.getBookId())) {
            return false;
        }
        if (this.vchTypeId == null ? other.getVchTypeId() != null : !this.vchTypeId.equals(other.getVchTypeId())) {
            return false;
        }
        if (dimension.get(0) && (this.bookedDate == null ? other.getBookedDate() != null : !this.bookedDate.equals(other.getBookedDate()))) {
            return false;
        }
        if (dimension.get(1) && (this.bizDate == null ? other.getBizDate() != null : !this.bizDate.equals(other.getBizDate()))) {
            return false;
        }
        if (dimension.get(2) && (this.creatorId == null ? other.getCreatorId() != null : !this.creatorId.equals(other.getCreatorId()))) {
            return false;
        }
        if (dimension.get(3) && (this.billno == null ? other.getBillno() != null : !this.billno.equals(other.getBillno()))) {
            return false;
        }
        if (this.extField == null ? other.getExtField() != null : !this.extField.equals(other.getExtField())) {
            return false;
        }
        return !(this.billMergeField == null ? other.getBillMergeField() != null : !this.billMergeField.equals(other.getBillMergeField()));
    }

    public String getExtField() {
        return this.extField;
    }

    public void setExtField(String extField) {
        this.extField = extField;
    }

    public String getBillMergeField() {
        return this.billMergeField;
    }

    public void setBillMergeField(String billMergeField) {
        this.billMergeField = billMergeField;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public Long getBookId() {
        return this.bookId;
    }

    public Long getVchTypeId() {
        return this.vchTypeId;
    }

    public Date getBookedDate() {
        return this.bookedDate;
    }

    public Date getBizDate() {
        return this.bizDate;
    }

    public Long getCreatorId() {
        return this.creatorId;
    }

    public String getBillno() {
        return this.billno;
    }

    public GroupAndMergeRuleModel getModel() {
        return this.model;
    }
}

