/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.groupmerge;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.fi.v2.fah.constant.enums.event.VchValueSetSelectEnum;
import kd.fi.v2.fah.constant.enums.event.VchValueSetTypeEnum;
import kd.fi.v2.fah.dao.FahGenerateXLADataDao;
import kd.fi.v2.fah.models.groupmerge.IRebuildFieldHandle;
import kd.fi.v2.fah.models.groupmerge.ReBuildFieldConfig;
import kd.fi.v2.fah.models.xla.XLAPeriod;

public class RebuildFieldHandle
implements IRebuildFieldHandle {
    private Long creatorId = 0L;
    private int attachment = 0;
    private Set<Long> srcIds = new HashSet<Long>(16);
    private Set<Long> srcEventIds = new HashSet<Long>(16);
    private Date bookedDate;
    private Date bizDate;
    private Date monthFirstDay;
    private Date monthLastDay;
    private ReBuildFieldConfig creatorConfig;
    private ReBuildFieldConfig attachmentConfig;
    private ReBuildFieldConfig bookedDateConfig;
    private ReBuildFieldConfig bizDateConfig;
    private Date bookedDate_ori;
    private Date bizDate_ori;
    private Long creatorId_ori;
    private Boolean isSameBookedDate = true;
    private Boolean isSameBizDate = true;
    private Boolean isSameCreator = true;

    public RebuildFieldHandle(ReBuildFieldConfig[] param) {
        if (param == null) {
            return;
        }
        if (param[0].isEnabled()) {
            this.creatorConfig = param[0];
        }
        if (param[1].isEnabled()) {
            this.attachmentConfig = param[1];
        }
        if (param[2].isEnabled()) {
            this.bookedDateConfig = param[2];
        }
        if (param[3].isEnabled()) {
            this.bizDateConfig = param[3];
        }
    }

    @Override
    public void rebuildCreator(Long newValue, Object ... extparam) {
        if (this.creatorId_ori == null) {
            this.creatorId_ori = newValue;
        } else if (this.isSameCreator.booleanValue()) {
            this.isSameCreator = this.creatorId_ori.equals(newValue);
        }
        if (this.creatorConfig == null) {
            if (this.creatorId == null || this.creatorId == 0L) {
                this.creatorId = newValue;
            }
            return;
        }
        if (this.creatorConfig.getSetType() == VchValueSetTypeEnum.CONSTANT) {
            Object value = this.creatorConfig.getValue();
            if (value != null) {
                this.creatorId = Long.parseLong(value.toString());
            }
            return;
        }
        if (this.creatorConfig.getSetSelectType() == VchValueSetSelectEnum.FIRST && (this.creatorId == null || this.creatorId == 0L)) {
            this.creatorId = newValue;
        }
        if (this.creatorConfig.getSetSelectType() == VchValueSetSelectEnum.LAST) {
            this.creatorId = newValue;
        }
    }

    @Override
    public void rebuildAttment(int newValue, Object ... extparam) {
        if (this.attachmentConfig == null) {
            if (this.attachment == 0) {
                this.attachment = newValue;
            }
            return;
        }
        if (this.attachmentConfig.getSetSelectType() == VchValueSetSelectEnum.TOTAL_ATTACHMENTS) {
            this.attachment += newValue;
        }
        if (this.attachmentConfig.getSetSelectType() == VchValueSetSelectEnum.TOTAL_BILLS) {
            if (extparam[0] != null) {
                this.srcIds.add(Long.parseLong(extparam[0].toString()));
            }
            this.attachment = this.srcIds.size();
        }
        if (this.attachmentConfig.getSetSelectType() == VchValueSetSelectEnum.TOTAL_EVENTS) {
            if (extparam[1] != null) {
                this.srcEventIds.add(Long.parseLong(extparam[1].toString()));
                this.attachment = this.srcEventIds.size();
            } else {
                this.attachment += newValue;
            }
        }
        if (this.attachmentConfig.getSetSelectType() == VchValueSetSelectEnum.FIRST && this.attachment == 0) {
            this.attachment = newValue;
        }
        if (this.attachmentConfig.getSetSelectType() == VchValueSetSelectEnum.LAST) {
            this.attachment = newValue;
        }
    }

    @Override
    public void rebuildBookedDate(Date newValue, Object ... extparam) {
        XLAPeriod period;
        if (this.bookedDate_ori == null) {
            this.bookedDate_ori = newValue;
        } else if (this.isSameBookedDate.booleanValue()) {
            this.isSameBookedDate = this.bookedDate_ori.equals(newValue);
        }
        if (this.bookedDateConfig == null) {
            return;
        }
        if (this.bookedDate == null) {
            this.bookedDate = newValue;
        }
        if (this.bookedDateConfig.getSetSelectType() == VchValueSetSelectEnum.EARLIEST_DATE && this.bookedDate.after(newValue)) {
            this.bookedDate = newValue;
        }
        if (this.bookedDateConfig.getSetSelectType() == VchValueSetSelectEnum.LATEST_DATE && this.bookedDate.before(newValue)) {
            this.bookedDate = newValue;
        }
        if (this.bookedDateConfig.getSetSelectType() == VchValueSetSelectEnum.FIRST_DAY_OF_MONTH) {
            if (this.monthFirstDay == null && extparam[0] != null) {
                period = FahGenerateXLADataDao.getPeriodFromThreadCache(Long.parseLong(extparam[0].toString()));
                this.monthFirstDay = period.getBegindate();
                this.monthLastDay = period.getEnddate();
            }
            this.bookedDate = this.monthFirstDay;
        }
        if (this.bookedDateConfig.getSetSelectType() == VchValueSetSelectEnum.LAST_DAY_OF_MONTH) {
            if (this.monthLastDay == null && extparam[0] != null) {
                period = FahGenerateXLADataDao.getPeriodFromThreadCache(Long.parseLong(extparam[0].toString()));
                this.monthFirstDay = period.getBegindate();
                this.monthLastDay = period.getEnddate();
            }
            this.bookedDate = this.monthLastDay;
        }
        if (this.bookedDateConfig.getSetSelectType() == VchValueSetSelectEnum.FIRST && this.bookedDate == null) {
            this.bookedDate = newValue;
        }
        if (this.bookedDateConfig.getSetSelectType() == VchValueSetSelectEnum.LAST) {
            this.bookedDate = newValue;
        }
    }

    @Override
    public void rebuildBizDate(Date newValue, Object ... extparam) {
        XLAPeriod period;
        if (this.bizDate_ori == null) {
            this.bizDate_ori = newValue;
        } else if (this.isSameBizDate.booleanValue()) {
            this.isSameBizDate = this.bizDate_ori.equals(newValue);
        }
        if (this.bizDateConfig == null) {
            return;
        }
        if (this.bizDate == null) {
            this.bizDate = newValue;
        }
        if (this.bizDateConfig.getSetSelectType() == VchValueSetSelectEnum.EARLIEST_DATE && this.bizDate.after(newValue)) {
            this.bizDate = newValue;
        }
        if (this.bizDateConfig.getSetSelectType() == VchValueSetSelectEnum.LATEST_DATE && this.bizDate.before(newValue)) {
            this.bizDate = newValue;
        }
        if (this.bizDateConfig.getSetSelectType() == VchValueSetSelectEnum.FIRST_DAY_OF_MONTH) {
            if (this.monthFirstDay == null && extparam[0] != null) {
                period = FahGenerateXLADataDao.getPeriodFromThreadCache(Long.parseLong(extparam[0].toString()));
                this.monthFirstDay = period.getBegindate();
                this.monthLastDay = period.getEnddate();
            }
            this.bizDate = this.monthFirstDay;
        }
        if (this.bizDateConfig.getSetSelectType() == VchValueSetSelectEnum.LAST_DAY_OF_MONTH) {
            if (this.monthLastDay == null && extparam[0] != null) {
                period = FahGenerateXLADataDao.getPeriodFromThreadCache(Long.parseLong(extparam[0].toString()));
                this.monthFirstDay = period.getBegindate();
                this.monthLastDay = period.getEnddate();
            }
            this.bizDate = this.monthLastDay;
        }
        if (this.bizDateConfig.getSetSelectType() == VchValueSetSelectEnum.FIRST && this.bookedDate == null) {
            this.bizDate = newValue;
        }
        if (this.bizDateConfig.getSetSelectType() == VchValueSetSelectEnum.LAST) {
            this.bizDate = newValue;
        }
    }

    public Long getCreatorId() {
        if (this.isSameCreator.booleanValue()) {
            return this.creatorId_ori;
        }
        return this.creatorId;
    }

    public int getAttachment() {
        return this.attachment;
    }

    public Date getBookedDate() {
        if (this.isSameBookedDate.booleanValue()) {
            return this.bookedDate_ori;
        }
        return this.bookedDate;
    }

    public Date getBizDate() {
        if (this.isSameBizDate.booleanValue()) {
            return this.bizDate_ori;
        }
        return this.bizDate;
    }

    public Boolean isRebuildCreator() {
        return this.creatorConfig != null;
    }

    public Boolean isRebuildattment() {
        return this.attachmentConfig != null;
    }

    public Boolean isRebuildBookedDate() {
        return this.bookedDateConfig != null;
    }

    public Boolean isRebuildBizDate() {
        return this.bizDateConfig != null;
    }
}

