/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.request;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import kd.fi.v2.fah.models.valueset.base.SimpleBaseValueSet;
import kd.fi.v2.fah.storage.impl.MutableArrayStorage;

public class FahRequestProcessBillDataBatchDTO
extends SimpleBaseValueSet<Object>
implements Serializable {
    public static final int IDX_PK = 0;
    public static final int IDX_RequestId = 1;
    public static final int IDX_SeqNo = 2;
    public static final int IDX_SrcBillType = 3;
    public static final int IDX_ExcuteStartTime = 4;
    public static final int IDX_ExcuteEndTime = 5;
    public static final int IDX_RecCnt = 6;
    public static final int IDX_LockInstanceId = 7;
    public static final int IDX_Status = 8;
    private Collection<Long> srcBillIds;

    public FahRequestProcessBillDataBatchDTO() {
        this._storageData = new MutableArrayStorage(8, Object.class);
    }

    public FahRequestProcessBillDataBatchDTO(long requestId, int batchSeqNo, String srcBillType) {
        this();
        this._storageData.set(1, (Object)requestId);
        this._storageData.set(2, (Object)batchSeqNo);
        this._storageData.set(3, (Object)srcBillType);
    }

    public String toString() {
        return "FahRequestProcessBillDataBatchDTO{_storageData=" + this._storageData + ", srcBillIds=" + this.srcBillIds + '}';
    }

    public Iterator<List<Object[]>> buildBatchEntries(final int batchSize, final Function<Integer, long[]> idProvider) {
        if (this.srcBillIds == null || this.srcBillIds.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new Iterator<List<Object[]>>(){
            final Iterator<Long> srcBillIdIt;
            final long batchId;
            final int _batchSize;
            final Function<Integer, long[]> _idProvider;
            final int totalEntryCnt;
            {
                this.srcBillIdIt = FahRequestProcessBillDataBatchDTO.this.srcBillIds.iterator();
                this.batchId = (Long)FahRequestProcessBillDataBatchDTO.this.__getValueByIndex(0);
                this._batchSize = batchSize;
                this._idProvider = idProvider;
                this.totalEntryCnt = FahRequestProcessBillDataBatchDTO.this.srcBillIds.size();
            }

            @Override
            public boolean hasNext() {
                return this.srcBillIdIt.hasNext();
            }

            @Override
            public List<Object[]> next() {
                if (this.hasNext()) {
                    long[] id_cache = (long[])idProvider.apply(this.totalEntryCnt >= this._batchSize ? this._batchSize : this.totalEntryCnt);
                    int genCnt = 0;
                    ArrayList<Object[]> resultBatch = new ArrayList<Object[]>(id_cache.length);
                    while (genCnt < batchSize && this.srcBillIdIt.hasNext()) {
                        resultBatch.add(new Object[]{id_cache[genCnt++], this.batchId, genCnt, this.srcBillIdIt.next()});
                    }
                    return resultBatch;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
        };
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Long getId() {
        return (Long)this.__getValueByIndex(0);
    }

    public void setId(Long id) {
        this.__setValueByIndex(0, id);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Long getRequestId() {
        return (Long)this.__getValueByIndex(1);
    }

    public void setRequestId(Long requestId) {
        this.__setValueByIndex(1, requestId);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int getSeqNo() {
        return (Integer)this.__getValueByIndex(2);
    }

    public void setSeqNo(int seqNo) {
        this.__setValueByIndex(2, seqNo);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getSrcBillType() {
        return (String)this.__getValueByIndex(3);
    }

    public void setSrcBillType(String srcBillType) {
        this.__setValueByIndex(3, srcBillType);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Date getExcuteStartTime() {
        return (Date)this.__getValueByIndex(4);
    }

    public void setExcuteStartTime(Date excuteStartTime) {
        this.__setValueByIndex(4, excuteStartTime);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Date getExcuteEndTime() {
        return (Date)this.__getValueByIndex(5);
    }

    public void setExcuteEndTime(Date excuteEndTime) {
        this.__setValueByIndex(5, excuteEndTime);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int getRecCnt() {
        return (Integer)this.__getValueByIndex(6);
    }

    public void setRecCnt(int recCnt) {
        this.__setValueByIndex(6, recCnt);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getLockInstanceId() {
        return (String)this.__getValueByIndex(7);
    }

    public void setLockInstanceId(String lockInstanceId) {
        this.__setValueByIndex(7, lockInstanceId);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public char getStatus() {
        return ((Character)this.__getValueByIndex(8)).charValue();
    }

    public void setStatus(char status) {
        this.__setValueByIndex(8, Character.valueOf(status));
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Collection<Long> getSrcBillIds() {
        return this.srcBillIds;
    }

    public void setSrcBillIds(Collection<Long> srcBillIds) {
        this.srcBillIds = srcBillIds;
    }
}

