/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.services;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.ai.enums.PermissonType;
import kd.fi.ai.util.ContextUtil;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.MappingValueType;
import kd.fi.v2.fah.dao.ValueSetDao;
import kd.fi.v2.fah.models.flex.FlexFieldCfg;
import kd.fi.v2.fah.models.flex.FlexFieldGrpCfg;
import kd.fi.v2.fah.models.mapping.MappingDataCollection;
import kd.fi.v2.fah.models.mapping.SingleLineMappingData;
import kd.fi.v2.fah.models.valueset.IValueSetMeta;
import kd.fi.v2.fah.models.valueset.SingleValueSetData;
import kd.fi.v2.fah.models.valueset.ValueSetDataCollection;
import kd.fi.v2.fah.models.valueset.ValueSetTypeCollectionMeta;
import kd.fi.v2.fah.services.IDBValueSetAndMappingService;
import kd.fi.v2.fah.util.ValueSetAndMappingutil;
import kd.fi.v2.fah.utils.ValueSetUtil;

public class DBValueSetAndMappingServiceImpl
implements IDBValueSetAndMappingService {
    private static final Log logger = LogFactory.getLog(DBValueSetAndMappingServiceImpl.class);

    @Override
    public ValueSetTypeCollectionMeta queryValueSetType(Long id) {
        ValueSetTypeCollectionMeta result = null;
        if (id == 0L) {
            return result;
        }
        return null;
    }

    @Override
    public ValueSetDataCollection queryValueSetData(Long id) {
        ValueSetDataCollection result = null;
        if (id == 0L) {
            return result;
        }
        Object queryOneData = ValueSetDao.queryOneData(new Object[]{id}, ValueSetDao.queryType.valueset);
        if (queryOneData != null) {
            result = (ValueSetDataCollection)queryOneData;
        }
        return result;
    }

    @Override
    public boolean insertValueSetType(ValueSetTypeCollectionMeta valueSetType) {
        if (valueSetType == null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean insertValueSetData(ValueSetDataCollection valueSetDate) {
        if (valueSetDate == null) {
            return false;
        }
        String buildValueSetTypeHeadSql = ValueSetAndMappingutil.buildValueSetAndMappingSql(valueSetDate, ValueSetAndMappingutil.buildSqlType.insert, ValueSetAndMappingutil.buildSqlSource.ValueSetDataCollection);
        Object[] param_head = new Object[valueSetDate.getProps().size()];
        Iterator iterator_head = valueSetDate.getProps().entrySet().iterator();
        int index_head = 0;
        while (iterator_head.hasNext()) {
            Map.Entry row = iterator_head.next();
            param_head[index_head] = ((Object[])row.getValue())[1];
            ++index_head;
        }
        String buildValueSetDataLineSql = null;
        ArrayList dataCol = valueSetDate.getDataCol();
        ArrayList<Object[]> params = new ArrayList<Object[]>(dataCol.size());
        if (dataCol.size() > 0) {
            buildValueSetDataLineSql = ValueSetAndMappingutil.buildValueSetAndMappingSql(dataCol.get(0), ValueSetAndMappingutil.buildSqlType.insert, ValueSetAndMappingutil.buildSqlSource.SingleValueSetData);
            for (SingleValueSetData svd : dataCol) {
                Object[] buildValueSetDataLineParams = svd.buildValueSetDataLineParams();
                buildValueSetDataLineParams[0] = valueSetDate.getId();
                params.add(buildValueSetDataLineParams);
            }
        }
        return ValueSetDao.insertValueSetData(buildValueSetTypeHeadSql, param_head, buildValueSetDataLineSql, params, ValueSetDao.queryType.valueset);
    }

    @Override
    public MappingDataCollection queryMappingData(Long id) {
        DynamicObject valMapType = BusinessDataServiceHelper.loadSingle((String)"fah_valmap_typenew", (String)"struc,name,number,enable,description,createtime,creator.id,checkstatus,modifier.id,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (null == valMapType) {
            return null;
        }
        DynamicObject strucData = valMapType.getDynamicObject("struc");
        Long strucid = (Long)strucData.getPkValue();
        DynamicObjectCollection fields = QueryServiceHelper.query((String)"fah_flex_struc", (String)"dseq,fieldusagetype,flexfieldnum", (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)strucid)}, (String)"fieldusagetype desc,dseq asc");
        HashSet<String> flexfieldnums = new HashSet<String>();
        LinkedList<String> inPutFields = new LinkedList<String>();
        LinkedList<String> outPutFields = new LinkedList<String>();
        for (DynamicObject field : fields) {
            String flexfieldnum = field.getString("flexfieldnum");
            flexfieldnums.add(flexfieldnum.toLowerCase());
            if (field.getInt("fieldusagetype") == 1) {
                inPutFields.add(flexfieldnum.toLowerCase());
                continue;
            }
            outPutFields.add(flexfieldnum.toLowerCase());
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT fid,feffectdate,fexpiredate,fenable,fserialnumber,fMapValueType,fstatus,fownorgid,fgroupid," + String.join((CharSequence)",", flexfieldnums), new Object[0]).append("FROM t_fah_flex_mapval ", new Object[0]).append("WHERE fmaptypeid = ? ", new Object[]{id});
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)"2FMS=8GUFGGN", (String)"fah_valmap_typenew", (String)PermissonType.EXPORT.getPermId());
        if (!permOrgRs.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgRs.getHasPermOrgs();
            if (null != hasPermOrgs && !hasPermOrgs.isEmpty()) {
                sql.appendIn(" and fownorgid", hasPermOrgs.toArray());
            } else {
                sql.append(" and 1!=1", new Object[0]);
            }
        }
        sql.append(" order by fgroupid,fserialnumber", new Object[0]);
        DataSet mapVals = DB.queryDataSet((String)"FahValMapEdit", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
        MappingDataCollection mappingData = new MappingDataCollection(id, valMapType.getString("number"), valMapType.getString("name"), Boolean.valueOf(valMapType.getBoolean("enable")), valMapType.getDate("createtime"), valMapType.getDate("modifytime"), Long.valueOf(valMapType.getLong("creator.id")), Long.valueOf(valMapType.getLong("modifier.id")), valMapType.getString("checkstatus"), valMapType.getString("description"));
        FlexFieldGrpCfg flexFieldCfg = this.getFlexFieldGrpCfgFromStruc(strucData);
        mappingData.setMeta((IValueSetMeta)flexFieldCfg);
        ArrayList<SingleLineMappingData> lineMappingDataList = new ArrayList<SingleLineMappingData>();
        for (Row mapVal : mapVals) {
            String flexfieldnum;
            int i;
            int size;
            SingleLineMappingData lineData = new SingleLineMappingData();
            int serialnumber = mapVal.getInteger("fserialnumber");
            if ("1".equals(mapVal.getString("fMapValueType"))) {
                lineData.setMapValueType(1);
                size = inPutFields.size();
                Object[] inPutValues = new Object[inPutFields.size()];
                for (i = 0; i < size; ++i) {
                    flexfieldnum = (String)inPutFields.get(i);
                    inPutValues[i] = flexfieldnum.startsWith("ftxtattr") ? mapVal.getString(flexfieldnum) : mapVal.getLong(flexfieldnum);
                }
                lineData.setValues(inPutValues);
            } else {
                lineData.setMapValueType(0);
                size = outPutFields.size();
                Object[] outPutValues = new Object[size];
                for (i = 0; i < size; ++i) {
                    flexfieldnum = (String)outPutFields.get(i);
                    outPutValues[i] = flexfieldnum.startsWith("ftxtattr") ? mapVal.getString(flexfieldnum) : mapVal.getLong(flexfieldnum);
                }
                lineData.setValues(outPutValues);
            }
            lineData.setId(mapVal.getLong("fid"));
            lineData.setEffectDate(mapVal.getDate("feffectdate"));
            lineData.setExpireDate(mapVal.getDate("fexpiredate"));
            lineData.setEnabled(mapVal.getBoolean("fenable").booleanValue());
            lineData.setSerialNumber(Integer.valueOf(serialnumber));
            lineData.setMeta((IValueSetMeta)flexFieldCfg);
            lineData.setStatus(mapVal.getString("fstatus"));
            lineData.setOwnOrgId(mapVal.getLong("fownorgid"));
            lineData.setOrgGroupId(mapVal.getLong("fgroupid"));
            lineMappingDataList.add(lineData);
        }
        mappingData.setDataCol(lineMappingDataList);
        return mappingData;
    }

    private FlexFieldGrpCfg getFlexFieldGrpCfgFromStruc(DynamicObject mapStruc) {
        if (mapStruc == null) {
            return new FlexFieldGrpCfg();
        }
        FlexFieldGrpCfg flexFieldCfg = new FlexFieldGrpCfg((Long)mapStruc.getPkValue(), mapStruc.getString("number"), mapStruc.getString("name"));
        flexFieldCfg.setOwnerEntityNum("fah_valmap_struc");
        flexFieldCfg.setOwnerTableName("t_fah_valmap_struc");
        DynamicObjectCollection mapStrucEntrys = QueryServiceHelper.query((String)"fah_flex_struc", (String)"dseq,attnum,attname,attdatatype,refentity,reftypeid,reffieldnum,flexfieldnum,fieldusagetype,description  ", (QFilter[])new QFilter[]{new QFilter("parentid", "=", mapStruc.getPkValue())}, (String)"fieldusagetype desc,dseq asc");
        for (DynamicObject mapStrucEntry : mapStrucEntrys) {
            FlexFieldCfg fieldCfg = new FlexFieldCfg((Long)mapStrucEntry.getPkValue(), mapStrucEntry.getString("attnum"), mapStrucEntry.getString("attname"), mapStrucEntry.getInt("dseq"), mapStrucEntry.getString("description"), mapStrucEntry.getString("flexfieldnum"));
            fieldCfg.setDataType(DataValueTypeEnum.getEnum((String)mapStrucEntry.getString("attdatatype")));
            fieldCfg.setFieldUsageType(mapStrucEntry.getInt("fieldusagetype"));
            fieldCfg.setRefBaseProp(mapStrucEntry.getString("refentity"));
            fieldCfg.setRefTypeId(Long.valueOf(mapStrucEntry.getLong("reftypeid")));
            fieldCfg.setRefFieldNum(mapStrucEntry.getString("reffieldnum"));
            flexFieldCfg.cache((Object)fieldCfg);
        }
        flexFieldCfg.flush();
        return flexFieldCfg;
    }

    @Override
    public FlexFieldGrpCfg queryMappingType(Long id) {
        return null;
    }

    @Override
    public Long insertMappingData(MappingDataCollection mappingData) {
        if (mappingData == null) {
            return null;
        }
        HashMap<String, Object[]> del_params_head = new HashMap<String, Object[]>(2);
        HashMap<String, List<Object[]>> del_params_line = new HashMap<String, List<Object[]>>(2);
        HashMap<String, Object[]> insert_params_head = new HashMap<String, Object[]>(2);
        HashMap<String, List<Object[]>> insert_params_line = new HashMap<String, List<Object[]>>(3);
        HashMap<String, List<Object[]>> pre_insert_params_line = new HashMap<String, List<Object[]>>(1);
        if (mappingData.isEdit()) {
            String del_head = ValueSetAndMappingutil.buildValueSetAndMappingSql(mappingData, ValueSetAndMappingutil.buildSqlType.delete, ValueSetAndMappingutil.buildSqlSource.MappingDataCollection);
            String del_multiLang = "delete from t_fah_valmap_type_l where fid = ?";
            Object[] param_del = new Object[]{mappingData.getId()};
            del_params_head.put(del_head, param_del);
            del_params_head.put(del_multiLang, param_del);
        }
        String buildValueSetAndMappingSql = ValueSetAndMappingutil.buildValueSetAndMappingSql(mappingData, ValueSetAndMappingutil.buildSqlType.insert, ValueSetAndMappingutil.buildSqlSource.MappingDataCollection);
        Iterator iterator_head = mappingData.queryProps().entrySet().iterator();
        Object[] param_head = new Object[mappingData.queryProps().size()];
        int index_head = 0;
        while (iterator_head.hasNext()) {
            Map.Entry row = iterator_head.next();
            param_head[index_head] = ((Object[])row.getValue())[1];
            ++index_head;
        }
        String sql_multiLang = "insert into t_fah_valmap_type_l(fpkid,fid,flocaleid,fname) values (?,?,?,?)";
        long genLongId = DB.genLongId((String)"t_fah_valmap_type_l");
        Object[] param_multiLang = new Object[]{genLongId, mappingData.getId(), "zh_CN", mappingData.getName()};
        insert_params_head.put(buildValueSetAndMappingSql, param_head);
        insert_params_head.put(sql_multiLang, param_multiLang);
        ArrayList<Object[]> params_del = new ArrayList<Object[]>(16);
        ArrayList<Object[]> params_insert = new ArrayList<Object[]>(16);
        ArrayList<Object[]> params_his = new ArrayList<Object[]>(16);
        ArrayList<Object[]> params_main = new ArrayList<Object[]>(16);
        ArrayList<Object[]> params_modify = new ArrayList<Object[]>(16);
        String sql_query_del = "select fid,fmaptypeid,fgroupid,fserialNumber,fchangetype,fpageid from t_fah_flex_mapval_tmp where fmaptypeid = " + mappingData.getId() + " and fpageid = '" + mappingData.getPageId() + "'";
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.services.DBValueSetAndMappingServiceImpl", (DBRoute)FAHCommonConstant.FI, (String)sql_query_del);){
            for (Object row : queryDataSet) {
                Object changetype = row.get("fchangetype");
                if ("U".equals(changetype)) {
                    params_del.add(new Object[]{row.getLong("fmaptypeid"), row.getInteger("fserialNumber"), row.getLong("fgroupid")});
                    params_his.add(new Object[]{row.getLong("fid"), row.getString("fpageid")});
                    params_insert.add(new Object[]{row.getLong("fid"), row.getString("fpageid")});
                }
                if ("A".equals(changetype)) {
                    params_insert.add(new Object[]{row.getLong("fid"), row.getString("fpageid")});
                }
                if (!"D".equals(changetype)) continue;
                params_del.add(new Object[]{row.getLong("fmaptypeid"), row.getInteger("fserialNumber"), row.getLong("fgroupid")});
                params_main.add(new Object[]{row.getLong("fid"), row.getLong("fmaptypeid"), row.getInteger("fserialNumber"), row.getLong("fgroupid")});
                params_modify.add(new Object[]{new Date(), row.getLong("fid"), row.getLong("fmaptypeid"), row.getInteger("fserialNumber"), row.getLong("fgroupid")});
            }
        }
        ArrayList<Object[]> params_change_his = new ArrayList<Object[]>(params_his.size());
        long[] genSingleLongIds = DB.genLongIds((String)"t_fah_flex_mapval_tmp", (int)params_his.size());
        int index = 0;
        for (Object[] param : params_his) {
            params_change_his.add(new Object[]{genSingleLongIds[index], param[0]});
            ++index;
        }
        String sql_move = "insert into t_fah_flex_mapval_his(fid,fmaptypeid,fserialnumber,fhashcode,fenable,feffectdate,fexpiredate,fmapvaluetype,fhasmulvalue,fstatus,ftxtattr1,ftxtattr2,ftxtattr3,ftxtattr4,ftxtattr5,ftxtattr6,ftxtattr7,ftxtattr8,ftxtattr9,ftxtattr10,fidattr1,fidattr2,fidattr3,fidattr4,fidattr5,fidattr6,fidattr7,fidattr8,fidattr9,fidattr10,ftxtattr11,ftxtattr12,ftxtattr13,ftxtattr14,ftxtattr15,fownorgid,forgtype,fgroupid,fcreatetime,fcreatorid,fmodifytime,fmodifierid) select fid,fmaptypeid,fserialnumber,fhashcode,fenable,feffectdate,fexpiredate,fmapvaluetype,fhasmulvalue,fstatus,ftxtattr1,ftxtattr2,ftxtattr3,ftxtattr4,ftxtattr5,ftxtattr6,ftxtattr7,ftxtattr8,ftxtattr9,ftxtattr10,fidattr1,fidattr2,fidattr3,fidattr4,fidattr5,fidattr6,fidattr7,fidattr8,fidattr9,fidattr10,ftxtattr11,ftxtattr12,ftxtattr13,ftxtattr14,ftxtattr15,fownorgid,forgtype,fgroupid,fcreatetime,fcreatorid,fmodifytime,fmodifierid from t_fah_flex_mapval where fid = ? and fmaptypeid = ? and fserialnumber = ? and fgroupid = ?";
        pre_insert_params_line.put(sql_move, params_main);
        String change_type = "update t_fah_flex_mapval_his set fchangetype = 'D' where fid = ? and fmaptypeid = ? and fserialnumber = ? and fgroupid = ?";
        insert_params_line.put(change_type, params_main);
        String change_modify = "update t_fah_flex_mapval_his set fmodifytime = ? where fid = ? and fmaptypeid = ? and fserialnumber = ? and fgroupid = ?";
        insert_params_line.put(change_modify, params_modify);
        String del_line = "delete from t_fah_flex_mapval where fmaptypeid = ? and fserialnumber = ? and fgroupid = ?";
        del_params_line.put(del_line, params_del);
        String change_his = "update t_fah_flex_mapval_his set fid = ? where fid = ?";
        insert_params_line.put(change_his, params_change_his);
        String insert_his = "insert into t_fah_flex_mapval_his(fid,fmaptypeid,fserialnumber,fhashcode,fenable,feffectdate,fexpiredate,fmapvaluetype,fhasmulvalue,fstatus,ftxtattr1,ftxtattr2,ftxtattr3,ftxtattr4,ftxtattr5,ftxtattr6,ftxtattr7,ftxtattr8,ftxtattr9,ftxtattr10,fidattr1,fidattr2,fidattr3,fidattr4,fidattr5,fidattr6,fidattr7,fidattr8,fidattr9,fidattr10,ftxtattr11,ftxtattr12,ftxtattr13,ftxtattr14,ftxtattr15,fownorgid,forgtype,fgroupid,fcreatetime,fcreatorid,fmodifytime,fmodifierid,fchangetype) select ftmpid,fmaptypeid,fserialnumber,fhashcode,fenable,feffectdate,fexpiredate,fmapvaluetype,fhasmulvalue,fstatus,ftxtattr1,ftxtattr2,ftxtattr3,ftxtattr4,ftxtattr5,ftxtattr6,ftxtattr7,ftxtattr8,ftxtattr9,ftxtattr10,fidattr1,fidattr2,fidattr3,fidattr4,fidattr5,fidattr6,fidattr7,fidattr8,fidattr9,fidattr10,ftxtattr11,ftxtattr12,ftxtattr13,ftxtattr14,ftxtattr15,fownorgid,forgtype,fgroupid,fcreatetime,fcreatorid,fmodifytime,fmodifierid,fchangetype from t_fah_flex_mapval_tmp where fid = ? and fpageid = ?";
        insert_params_line.put(insert_his, params_his);
        String insert_line = "insert into t_fah_flex_mapval(fid,fmaptypeid,fserialnumber,fhashcode,fenable,feffectdate,fexpiredate,fmapvaluetype,fhasmulvalue,fstatus,ftxtattr1,ftxtattr2,ftxtattr3,ftxtattr4,ftxtattr5,ftxtattr6,ftxtattr7,ftxtattr8,ftxtattr9,ftxtattr10,fidattr1,fidattr2,fidattr3,fidattr4,fidattr5,fidattr6,fidattr7,fidattr8,fidattr9,fidattr10,ftxtattr11,ftxtattr12,ftxtattr13,ftxtattr14,ftxtattr15,fownorgid,forgtype,fgroupid,fcreatetime,fcreatorid,fmodifytime,fmodifierid) select fid,fmaptypeid,fserialnumber,fhashcode,fenable,feffectdate,fexpiredate,fmapvaluetype,fhasmulvalue,fstatus,ftxtattr1,ftxtattr2,ftxtattr3,ftxtattr4,ftxtattr5,ftxtattr6,ftxtattr7,ftxtattr8,ftxtattr9,ftxtattr10,fidattr1,fidattr2,fidattr3,fidattr4,fidattr5,fidattr6,fidattr7,fidattr8,fidattr9,fidattr10,ftxtattr11,ftxtattr12,ftxtattr13,ftxtattr14,ftxtattr15,fownorgid,forgtype,fgroupid,fcreatetime,fcreatorid,fmodifytime,fmodifierid from t_fah_flex_mapval_tmp where fid = ? and fpageid = ?";
        insert_params_line.put(insert_line, params_insert);
        String clearTmpSql = "delete from t_fah_flex_mapval_tmp where fmaptypeid = " + mappingData.getId() + " and fpageid = '" + mappingData.getPageId() + "'";
        boolean insertMappingData = ValueSetDao.insertMappingData(pre_insert_params_line, del_params_head, del_params_line, insert_params_head, insert_params_line, clearTmpSql);
        if (insertMappingData) {
            return (Long)mappingData.getId();
        }
        return null;
    }

    @Override
    public boolean insertMappingType(FlexFieldGrpCfg mappingType) {
        return false;
    }

    @Override
    public boolean updateValueSetType(ValueSetTypeCollectionMeta valueSetType) {
        return false;
    }

    @Override
    public boolean updateValueSetData(ValueSetDataCollection valueSetDate) {
        return false;
    }

    @Override
    public boolean updateMappingData(MappingDataCollection mappingData) {
        return false;
    }

    @Override
    public boolean updateMappingType(FlexFieldGrpCfg mappingType) {
        return false;
    }

    public void deleteTempData(Long typeId, String orgId, Set<Integer> deleteSerialNums) {
    }

    public void insertTempMappingData(Long typeId, List<SingleLineMappingData> insertData) {
        if (typeId == null || typeId == 0L || insertData == null || insertData.size() == 0) {
            return;
        }
        HashMap<String, Object[]> del_params_head = new HashMap<String, Object[]>(2);
        HashMap<String, List<Object[]>> del_params_line = new HashMap<String, List<Object[]>>(2);
        HashMap<String, Object[]> insert_params_head = new HashMap<String, Object[]>(2);
        HashMap<String, List<Object[]>> insert_params_line = new HashMap<String, List<Object[]>>(3);
        String sql_del = "delete from t_fah_flex_mapval_tmp where fmaptypeid = ? and fgroupid = ? and fserialNumber = ? and fpageid = ?";
        ArrayList<Object[]> params_del = new ArrayList<Object[]>(insertData.size());
        for (SingleLineMappingData slm : insertData) {
            params_del.add(new Object[]{typeId, slm.getOrgGroupId(), slm.getSerialNumber(), slm.getPageId()});
        }
        del_params_line.put(sql_del, params_del);
        String sql_insert_in = "";
        String sql_insert_out = "";
        String sql_insert_del = "";
        String sqlMapStr = ValueSetAndMappingutil.buildValueSetAndMappingSql(insertData.get(0), ValueSetAndMappingutil.buildSqlType.insert, ValueSetAndMappingutil.buildSqlSource.SingleLineMappingDataTmp);
        if (sqlMapStr != null) {
            Map sqlMap = (Map)SerializationUtils.fromJsonString((String)sqlMapStr, Map.class);
            sql_insert_in = (String)sqlMap.get("in");
            sql_insert_out = (String)sqlMap.get("out");
            sql_insert_del = (String)sqlMap.get("del");
        }
        ArrayList<Object[]> params_in = new ArrayList<Object[]>(insertData.size() / 2);
        ArrayList<Object[]> params_out = new ArrayList<Object[]>(insertData.size() / 2);
        ArrayList<Object[]> params_insert_del = new ArrayList<Object[]>(insertData.size());
        long[] genSingleLongIds = DB.genLongIds((String)"t_fah_flex_mapval_tmp", (int)insertData.size());
        long[] gentempLongIds = DB.genLongIds((String)"t_fah_flex_mapval_tmp", (int)insertData.size());
        FlexFieldGrpCfg meta = (FlexFieldGrpCfg)insertData.get(0).getMeta();
        Map mappingTypeSort = ValueSetUtil.getMappingTypeSort((FlexFieldGrpCfg)meta);
        String[] output_prop = (String[])mappingTypeSort.get("output");
        String[] input_prop = (String[])mappingTypeSort.get("input");
        int index_singleLongId = 0;
        int index_tempId = 0;
        for (SingleLineMappingData data : insertData) {
            int params_size;
            int mapValueType = data.getMapValueType();
            int props_size = data.getBaseprops().size();
            String changeType = data.getChangeType();
            int n = params_size = MappingValueType.INPUT.getCode() == mapValueType ? input_prop.length + props_size : output_prop.length + props_size;
            if ("D".equals(changeType)) {
                params_size = props_size;
            }
            Object[] param = new Object[params_size + 1];
            int index = 1;
            LinkedHashMap baseprops = data.getBaseprops();
            if (data.getId() == null || data.getId() == 0L) {
                Long curr_id = genSingleLongIds[index_singleLongId];
                data.setId(curr_id);
                ++index_singleLongId;
            }
            for (Map.Entry row : baseprops.entrySet()) {
                param[index] = data.get((String)row.getKey());
                ++index;
            }
            param[0] = gentempLongIds[index_tempId];
            ++index_tempId;
            param[1] = typeId;
            if (!"D".equals(changeType)) {
                for (Object obj : data.getValues()) {
                    if (obj == null) {
                        String key;
                        String string = key = MappingValueType.INPUT.getCode() == mapValueType ? input_prop[index - props_size - 1] : output_prop[index - props_size - 1];
                        param[index] = key.toLowerCase().contains("fidattr") ? Long.valueOf(0L) : "";
                    } else {
                        param[index] = obj;
                    }
                    ++index;
                }
                if (MappingValueType.INPUT.getCode() == mapValueType) {
                    params_in.add(param);
                    continue;
                }
                params_out.add(param);
                continue;
            }
            params_insert_del.add(param);
        }
        insert_params_line.put(sql_insert_in, params_in);
        insert_params_line.put(sql_insert_out, params_out);
        insert_params_line.put(sql_insert_del, params_insert_del);
        boolean insertMappingData = ValueSetDao.insertMappingData(null, del_params_head, del_params_line, insert_params_head, insert_params_line, null);
        if (insertMappingData) {
            // empty if block
        }
    }
}

