/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.services.dto;

import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.fi.v2.fah.models.mapping.IMapInput;
import kd.fi.v2.fah.models.mapping.impl.ArrayDataValueSetImpl;
import kd.fi.v2.fah.models.mapping.impl.MapInput;
import kd.fi.v2.fah.models.valueset.IValueSetMeta;
import kd.fi.v2.fah.services.dto.AbstractMappingDataIterator;

public class MixedValueMappingDataIterator
extends AbstractMappingDataIterator<IMapInput> {
    private Long currentMappingId;
    private Row currentRow;

    public MixedValueMappingDataIterator(IValueSetMeta inputMeta, DataSet dataSet) {
        super(inputMeta, dataSet);
    }

    @Override
    public boolean hasNext() {
        return null != this.currentRow || null != this.dataSet && this.dataSet.hasNext();
    }

    @Override
    public IMapInput next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Iterator contains no elements");
        }
        MapInput dataValueSet = new MapInput();
        while (this.hasNext()) {
            Row next = this.nextRow();
            Long mappingId = next.getLong("fid");
            if (this.currentMappingId != null && !Objects.equals(this.currentMappingId, mappingId)) {
                this.currentMappingId = mappingId;
                this.currentRow = next;
                break;
            }
            this.currentRow = null;
            if (null == this.currentMappingId) {
                this.currentMappingId = mappingId;
            }
            this.addRowData((ArrayDataValueSetImpl<Set<Object>>)dataValueSet, next);
        }
        return dataValueSet;
    }

    private Row nextRow() {
        Row tmp;
        if (null != this.currentRow) {
            tmp = this.currentRow;
        } else if (this.dataSet.hasNext()) {
            tmp = this.dataSet.next();
        } else {
            throw new NoSuchElementException("no elements");
        }
        return tmp;
    }

    private void addRowData(ArrayDataValueSetImpl<Set<Object>> dataValueSet, Row row) {
        boolean dbMultiValueFlag = row.getBoolean("fhasmulvalue");
        dataValueSet.setId(row.getLong("fid"));
        dataValueSet.setSerialNumber(row.getInteger("fserialnumber"));
        dataValueSet.setEffectDate(row.getDate("feffectdate"));
        dataValueSet.setExpireDate(row.getDate("fexpiredate"));
        dataValueSet.setHasMulValue(true);
        if (dbMultiValueFlag) {
            int colIndex = row.getInteger("fcolindex");
            String fieldValueColumnName = this.inputMeta.getColumnBySeq(colIndex).getDbFieldNum().startsWith("fidattr") ? "fidattr" : "ftxtattr";
            Object fieldValue = row.get(fieldValueColumnName);
            ((Set)dataValueSet.computeIfAbsent(Integer.valueOf(colIndex), k -> new HashSet(8))).add(fieldValue);
        } else {
            dataValueSet.setValues((Object[])this.getValuesFromRow(row));
        }
    }

    private Set<Object>[] getValuesFromRow(Row row) {
        Set[] objects = new Set[this.inputMeta.columnCnt()];
        for (int columnIndex = 0; columnIndex < this.inputMeta.columnCnt(); ++columnIndex) {
            objects[columnIndex] = Collections.singleton(row.get(this.inputMeta.getColumnBySeq(columnIndex).getDbFieldNum()));
        }
        return objects;
    }
}

