/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.services.dto;

import java.util.NoSuchElementException;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.fi.v2.fah.models.valueset.IValueSetMeta;
import kd.fi.v2.fah.services.dto.AbstractMappingDataIterator;
import kd.fi.v2.fah.services.dto.MappingData;

public class MultiValueMappingDataIterator
extends AbstractMappingDataIterator<MappingData> {
    private Long currentMappingId;
    private Row currentRow;

    public MultiValueMappingDataIterator(IValueSetMeta inputMeta, DataSet dataSet) {
        super(inputMeta, dataSet);
    }

    @Override
    public boolean hasNext() {
        return null != this.currentRow || null != this.dataSet && this.dataSet.hasNext();
    }

    @Override
    public MappingData next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Iterator contains no elements");
        }
        MappingData mappingData = new MappingData(this.inputMeta.columnCnt());
        while (this.dataSet.hasNext()) {
            Row next = this.nextRow();
            Long mappingId = next.getLong("fid");
            if (this.currentMappingId != null && !Objects.equals(this.currentMappingId, mappingId)) {
                this.currentMappingId = mappingId;
                this.currentRow = next;
                break;
            }
            this.currentRow = null;
            if (null == this.currentMappingId) {
                this.currentMappingId = mappingId;
            }
            this.addRowData(mappingData, next);
        }
        return mappingData;
    }

    private void addRowData(MappingData mappingData, Row row) {
        mappingData.setMappingId(row.getLong("fid"));
        mappingData.setSerialNumber(row.getInteger("fserialnumber"));
        mappingData.setEffectDate(row.getDate("feffectdate"));
        mappingData.setExpireDate(row.getDate("fexpiredate"));
        mappingData.setStatus(row.getString("fstatus"));
        int colIndex = row.getInteger("fcolindex");
        String fieldValueColumnName = this.inputMeta.getColumnBySeq(colIndex).getDbFieldNum().startsWith("fidattr") ? "fidattr" : "ftxtattr";
        Object fieldValue = row.get(fieldValueColumnName);
        mappingData.addFieldValue(colIndex, fieldValue);
    }

    private Row nextRow() {
        Row tmp;
        if (null != this.currentRow) {
            tmp = this.currentRow;
        } else if (this.dataSet.hasNext()) {
            tmp = this.dataSet.next();
        } else {
            throw new NoSuchElementException("no elements");
        }
        return tmp;
    }
}

