/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.services.dto;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.v2.fah.dao.FahGenerateXLADataDao;
import kd.fi.v2.fah.models.xla.XLAAccountBook;

public class SingleGenXLADataSource {
    private String billEntityName;
    private Long ruleId;
    private Long acctRuleId = 0L;
    private Set<Object> srcIds = new HashSet<Object>();
    private Set<Long> eventIds = new HashSet<Long>();
    private int ruleVersion;
    private Long sysType;
    private Long sysId;
    private Set<Long> hasErrorEventIds = new HashSet<Long>();
    private Map<Long, Object[]> supData = new HashMap<Long, Object[]>();
    private Map<Long, List<Object[]>> eventLineData = new HashMap<Long, List<Object[]>>();
    private Map<Long, Collection<XLAAccountBook>> eventAcctBookCache = new HashMap<Long, Collection<XLAAccountBook>>();
    private boolean currEventRuleOrgIsHead = false;
    private final List<Object[]> hasBuildXLAHeadData = new LinkedList<Object[]>();
    private final List<Object[]> hasBuildXLALineData = new LinkedList<Object[]>();

    public SingleGenXLADataSource(String billEntityName, Long ruleId) {
        this.billEntityName = billEntityName;
        this.ruleId = ruleId;
    }

    public void initEventLineData() {
        FahGenerateXLADataDao.getEventLineData(this.eventLineData, this.eventIds);
    }

    public Set<Object> getSrcIds() {
        return this.srcIds;
    }

    public void setSrcIds(Set<Object> srcIds) {
        this.srcIds = srcIds;
    }

    public void addSrcId(Object srcId) {
        this.srcIds.add(srcId);
    }

    public Set<Long> getEventIds() {
        return this.eventIds;
    }

    public void setEventIds(Set<Long> eventIds) {
        this.eventIds = eventIds;
    }

    public void addEventId(Long eventId) {
        this.eventIds.add(eventId);
    }

    public int getRuleVersion() {
        return this.ruleVersion;
    }

    public void setRuleVersion(int ruleVersion) {
        this.ruleVersion = ruleVersion;
    }

    public Long getSysType() {
        return this.sysType;
    }

    public void setSysType(Long sysType) {
        this.sysType = sysType;
    }

    public Long getSysId() {
        return this.sysId;
    }

    public void setSysId(Long sysId) {
        this.sysId = sysId;
    }

    public String getBillEntityName() {
        return this.billEntityName;
    }

    public Long getRuleId() {
        return this.ruleId;
    }

    public Set<Long> getHasErrorEventIds() {
        return this.hasErrorEventIds;
    }

    public void setHasErrorEventIds(Set<Long> hasErrorEventIds) {
        this.hasErrorEventIds = hasErrorEventIds;
    }

    public void addHasErrorEventIds(Long hasErrorEventId) {
        this.hasErrorEventIds.add(hasErrorEventId);
    }

    public Map<Long, Object[]> getSupData() {
        return this.supData;
    }

    public void setSupData(Map<Long, Object[]> supData) {
        this.supData = supData;
    }

    public void putSupData(Long key, Object[] value) {
        this.supData.put(key, value);
    }

    public void hasBuildXLAHeadData(Long srcId, Long srcEntryId, Long accountPurposeId) {
        Object[] hbd = new Object[]{srcId, srcEntryId, accountPurposeId};
        this.hasBuildXLAHeadData.add(hbd);
    }

    public Set<Long> getEventOrgIds() {
        return this.supData.values().stream().filter(f -> f[1] != null).map(m -> Long.parseLong(m[1].toString())).collect(Collectors.toSet());
    }

    public Set<Long> getGenEventIds(Long srcId, Long srcEntryId, Long accountPurposeId) {
        boolean isDone;
        if (this.currEventRuleOrgIsHead && (isDone = this.hasBuildXLAHeadData.stream().anyMatch(f -> srcId.equals(f[0]) && accountPurposeId.equals(f[2])))) {
            return new HashSet<Long>();
        }
        isDone = this.hasBuildXLAHeadData.stream().anyMatch(f -> srcId.equals(f[0]) && srcEntryId.equals(f[1]) && accountPurposeId.equals(f[2]));
        if (isDone) {
            return new HashSet<Long>();
        }
        return this.getEventIds(srcId, srcEntryId);
    }

    public boolean isCurrEventRuleOrgIsHead() {
        return this.currEventRuleOrgIsHead;
    }

    public void setCurrEventRuleOrgIsHead(boolean currEventRuleOrgIsHead) {
        this.currEventRuleOrgIsHead = currEventRuleOrgIsHead;
    }

    public Set<Long> getEventIds(Long srcId, Long srcEntryId) {
        if (this.currEventRuleOrgIsHead) {
            return this.supData.entrySet().stream().filter(f -> srcId.equals(((Object[])f.getValue())[0])).map(Map.Entry::getKey).collect(Collectors.toSet());
        }
        return this.supData.entrySet().stream().filter(f -> srcId.equals(((Object[])f.getValue())[0]) && srcEntryId.equals(((Object[])f.getValue())[4])).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Map<Long, Collection<XLAAccountBook>> getEventAcctBookCache() {
        return this.eventAcctBookCache;
    }

    public void setEventAcctBookCache(Map<Long, Collection<XLAAccountBook>> eventAcctBookCache) {
        this.eventAcctBookCache = eventAcctBookCache;
    }

    public void putEventAcctBookCache(Long eventId, Collection<XLAAccountBook> acctBooks) {
        this.eventAcctBookCache.put(eventId, acctBooks);
    }

    public Map<Long, List<Object[]>> getEventLineData() {
        return this.eventLineData;
    }

    public List<Object[]> getEventLineData(Long eventId) {
        return this.eventLineData.get(eventId);
    }

    public void hasBuildXLALineData(Long srcId, Long srcEntryId, Long accountPurposeId, Long eventId, Long acctBookId, Long lineTypeId) {
        Object[] hbd = new Object[]{srcId, srcEntryId, accountPurposeId, eventId, acctBookId, lineTypeId};
        this.hasBuildXLALineData.add(hbd);
    }

    public Boolean checkHasBuildLine(Long srcId, Long srcEntryId, Long accountPurposeId, Long eventId, Long acctBookId, Long lineTypeId) {
        return this.hasBuildXLALineData.stream().anyMatch(a -> srcId.equals(a[0]) && srcEntryId.equals(a[1]) && accountPurposeId.equals(a[2]) && eventId.equals(a[3]) && acctBookId.equals(a[4]) && lineTypeId.equals(a[5]));
    }

    public Object[] getCurrNeedBuildLine(List<Object[]> eventLineData_currRule, Long srcId, Long srcEntryId, Long srcEnteryId_real, Long accountPurposeId, Long eventId, Long acctBookId) {
        block5: {
            Set eventSrcEntryIdCol;
            block4: {
                if (eventLineData_currRule.isEmpty()) {
                    return null;
                }
                eventSrcEntryIdCol = eventLineData_currRule.stream().map(m -> Long.parseLong(m[0].toString())).collect(Collectors.toSet());
                if (eventSrcEntryIdCol.contains(srcEntryId)) {
                    List match_eventLine = eventLineData_currRule.stream().filter(f -> srcEntryId.equals(f[0])).collect(Collectors.toList());
                    return (Object[])match_eventLine.get(0);
                }
                if (!eventSrcEntryIdCol.contains(srcId)) break block4;
                Set LineTypeIds = eventLineData_currRule.stream().filter(f -> srcId.equals(f[0])).map(m -> m[5]).collect(Collectors.toSet());
                for (Object ltId : LineTypeIds) {
                    Boolean checkHasBuildLine = this.checkHasBuildLine(srcId, srcId, accountPurposeId, eventId, acctBookId, (Long)ltId);
                    if (checkHasBuildLine.booleanValue()) continue;
                    List match_eventLine = eventLineData_currRule.stream().filter(f -> srcId.equals(f[0]) && ltId.equals(f[5])).collect(Collectors.toList());
                    return (Object[])match_eventLine.get(0);
                }
                break block5;
            }
            if (!eventSrcEntryIdCol.contains(srcEnteryId_real)) break block5;
            Set LineTypeIds = eventLineData_currRule.stream().filter(f -> srcEnteryId_real.equals(f[0])).map(m -> m[5]).collect(Collectors.toSet());
            for (Object ltId : LineTypeIds) {
                Boolean checkHasBuildLine = this.checkHasBuildLine(srcId, srcEnteryId_real, accountPurposeId, eventId, acctBookId, (Long)ltId);
                if (checkHasBuildLine.booleanValue()) continue;
                List match_eventLine = eventLineData_currRule.stream().filter(f -> srcEnteryId_real.equals(f[0]) && ltId.equals(f[5])).collect(Collectors.toList());
                return (Object[])match_eventLine.get(0);
            }
        }
        return null;
    }

    public Long getAcctRuleId() {
        return this.acctRuleId;
    }

    public void setAcctRuleId(Long acctRuleId) {
        this.acctRuleId = acctRuleId;
    }
}

