/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.services.dto;

import java.util.NoSuchElementException;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.fi.v2.fah.models.mapping.IMapInput;
import kd.fi.v2.fah.models.mapping.impl.MapInput;
import kd.fi.v2.fah.models.valueset.IValueSetMeta;
import kd.fi.v2.fah.services.dto.AbstractMappingDataIterator;

public class SingleValueMappingDataIterator
extends AbstractMappingDataIterator<IMapInput> {
    public SingleValueMappingDataIterator(IValueSetMeta inputMeta, DataSet dataSet) {
        super(inputMeta, dataSet);
    }

    @Override
    public boolean hasNext() {
        return null != this.dataSet && this.dataSet.hasNext();
    }

    @Override
    public IMapInput next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Iterator contains no elements");
        }
        Row row = this.dataSet.next();
        MapInput dataValueSet = new MapInput();
        dataValueSet.setId(row.getLong("fid"));
        dataValueSet.setSerialNumber(row.getInteger("fserialnumber"));
        dataValueSet.setEffectDate(row.getDate("feffectdate"));
        dataValueSet.setExpireDate(row.getDate("fexpiredate"));
        dataValueSet.setMeta(this.inputMeta);
        dataValueSet.setHasMulValue(false);
        dataValueSet.setStatus(row.getString("fstatus"));
        dataValueSet.setValues(this.getValuesFromRow(this.inputMeta, row));
        return dataValueSet;
    }

    private Object[] getValuesFromRow(IValueSetMeta inputMeta, Row row) {
        Object[] objects = new Object[inputMeta.columnCnt()];
        for (int columnIndex = 0; columnIndex < inputMeta.columnCnt(); ++columnIndex) {
            objects[columnIndex] = row.get(inputMeta.getColumnBySeq(columnIndex).getDbFieldNum());
        }
        return objects;
    }
}

