/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.context.request;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.fi.v2.fah.constant.enums.event.BillDataProcessErrorCategoryEnum;
import kd.fi.v2.fah.dto.autogen.FahBgTaskLogDetailDTOs;
import kd.fi.v2.fah.dto.autogen.FahFailBillsDTOs;
import kd.fi.v2.fah.log.LogLevelEnum;
import kd.fi.v2.fah.task.context.request.ProcessBillDataRootTaskContext;
import kd.fi.v2.fah.task.status.TaskStatusEnum;

public class ProcessBillRequestErrorContext
implements Serializable {
    protected transient ProcessBillDataRootTaskContext parent;
    protected int cachedErrorPageCnt;
    protected Set<Long> errorBillIds;
    protected FahFailBillsDTOs _failBillBuffer;
    protected FahBgTaskLogDetailDTOs _logBuffer;
    protected transient AtomicInteger _logSeq = new AtomicInteger(0);
    protected transient long requestId;

    public boolean addDispatchFailedBills(String billType, Collection<Long> billIds, BillDataProcessErrorCategoryEnum msgCode, String msgDetail, Long dispatchRuleId, Integer dispatchRuleVerNo) {
        if (billIds == null || billIds.isEmpty()) {
            return false;
        }
        int size = Math.max(billIds.size(), 8);
        if (this._failBillBuffer == null) {
            this._failBillBuffer = new FahFailBillsDTOs(size);
            this._logBuffer = new FahBgTaskLogDetailDTOs(size);
        }
        for (Long id : billIds) {
            this._failBillBuffer.setRequestId(this.requestId);
            this._failBillBuffer.moveToNextParamRow();
            this._failBillBuffer.setBillType(billType);
            this._failBillBuffer.setSrcBillId(id);
            this._failBillBuffer.setMsg(msgCode.getCode());
            this._failBillBuffer.setDispatchId(dispatchRuleId);
            this._failBillBuffer.setDispatchVersion(dispatchRuleVerNo);
        }
        this.addErrorLog(msgDetail);
        return true;
    }

    public void addLogDetail(String msg, LogLevelEnum logLevel, TaskStatusEnum taskStatusEnum) {
        if (this._logBuffer == null) {
            this._logBuffer = new FahBgTaskLogDetailDTOs();
        }
        this._logBuffer.moveToNextParamRow();
        this._logBuffer.setid(this.requestId);
        this._logBuffer.setSeq(this._logSeq.incrementAndGet());
        this._logBuffer.setMsg(msg.substring(0, 255));
        this._logBuffer.setMsg_tag(msg);
        this._logBuffer.setLogLevel(logLevel.getCharCode());
        this._logBuffer.setTaskStepStatus(taskStatusEnum.getCharCode());
    }

    public void addErrorLog(String msg) {
        this.addLogDetail(msg, LogLevelEnum.Error, TaskStatusEnum.FAILURE);
    }

    public long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(long requestId) {
        this.requestId = requestId;
    }

    public ProcessBillDataRootTaskContext getParent() {
        return this.parent;
    }

    public void setParent(ProcessBillDataRootTaskContext parent) {
        this.parent = parent;
    }
}

