/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.maintask;

import java.io.Serializable;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import kd.bos.logging.Log;
import kd.bos.logging.logback.LogbackFactory;
import kd.fi.v2.fah.cache.common.ITaskResultCacheManager;
import kd.fi.v2.fah.cache.common.impl.FahTaskProcessDataCacheStorage;
import kd.fi.v2.fah.task.FahDataProcessTaskFactory;
import kd.fi.v2.fah.task.common.AbstractCommonDataWorkTask;
import kd.fi.v2.fah.task.common.AbstractCommonDataWorkTaskEx;
import kd.fi.v2.fah.task.common.DummyFuture;
import kd.fi.v2.fah.task.common.FahTaskGroupCondition;
import kd.fi.v2.fah.task.common.IFahDataWorkTask;
import kd.fi.v2.fah.task.common.ITaskExceptionListener;
import kd.fi.v2.fah.task.common.ITaskStatusChangeListener;
import kd.fi.v2.fah.task.context.request.ProcessBillDataRootTaskContext;
import kd.fi.v2.fah.task.enums.FahTaskGrpTypeEnum;
import kd.fi.v2.fah.task.maintask.IParallelTaskBuilder;
import kd.fi.v2.fah.task.params.input.IProcessBillDataTaskInputParam;
import kd.fi.v2.fah.task.params.input.ProcessBillDataRootTaskInputParam;
import kd.fi.v2.fah.task.result.FahSimpleTaskResult;
import kd.fi.v2.fah.task.result.TaskBatchResultWrapper;
import kd.fi.v2.fah.utils.pipe.FahAsyncPipePoolMgr;
import kd.fi.v2.fah.utils.pipe.FahRegisteredAsyncPipeTypeEnum;
import kd.fi.v2.fah.utils.pipe.IFahIAsyncStreamDataBlock;

public class AbstractProcessBillTypeDataRootTask
extends AbstractCommonDataWorkTaskEx<ProcessBillDataRootTaskInputParam, FahSimpleTaskResult, ProcessBillDataRootTaskContext>
implements ITaskStatusChangeListener,
IParallelTaskBuilder {
    private static final Log log = LogbackFactory.getLog(AbstractProcessBillTypeDataRootTask.class);
    protected static final FahDataProcessTaskFactory factory = FahDataProcessTaskFactory.getInstance();
    protected ITaskResultCacheManager cacheService;
    protected FahAsyncPipePoolMgr pipePoolMgr;
    protected Queue<IFahIAsyncStreamDataBlock<TaskBatchResultWrapper<?>>> currentParallelGrpDataBlocks;
    protected MainTaskExceptionListener mainTaskExceptionListener = new MainTaskExceptionListener();

    public AbstractProcessBillTypeDataRootTask(ProcessBillDataRootTaskInputParam inputParam) {
        super(inputParam);
        this.rootTaskContext = new ProcessBillDataRootTaskContext(inputParam);
        this.currentParallelGrpDataBlocks = new ConcurrentLinkedQueue();
    }

    @Override
    public Class<? extends IProcessBillDataTaskInputParam> getNextTaskInputParamType(FahTaskGrpTypeEnum currentTaskGrpType) {
        return FahDataProcessTaskFactory.getTaskInputParamClassType(currentTaskGrpType);
    }

    @Override
    public <T extends IProcessBillDataTaskInputParam> T convertToNextTaskInputParam(Object srcObject, Class sourceObjectClassType, Class<T> targetTaskInputParam) {
        return null;
    }

    @Override
    public AbstractCommonDataWorkTask getNextTask(IProcessBillDataTaskInputParam taskInputParam) {
        return (AbstractCommonDataWorkTask)factory.buildTaskInstance(taskInputParam);
    }

    @Override
    public AbstractCommonDataWorkTask getExecutionTask(FahTaskGrpTypeEnum currentTaskGrpType, Object srcObject) {
        Class<? extends IProcessBillDataTaskInputParam> nextTaskInputParamType = this.getNextTaskInputParamType(currentTaskGrpType);
        IProcessBillDataTaskInputParam nextTaskInputParam = this.convertToNextTaskInputParam(srcObject, srcObject.getClass(), nextTaskInputParamType);
        return this.getNextTask(nextTaskInputParam);
    }

    protected IProcessBillDataTaskInputParam processSerialMainTaskResult(FahSimpleTaskResult mainTaskResult, MainTaskExceptionListener mainTaskExceptionListener, FahTaskGrpTypeEnum nextParallelGrpFirstTask) {
        return this.convertToNextTaskInputParam(mainTaskResult, FahSimpleTaskResult.class, this.getNextTaskInputParamType(nextParallelGrpFirstTask));
    }

    protected void tryProcessUnCompletedBatchResult(FahTaskGrpTypeEnum[] currentExecuteTaskGrp) {
        this.rootTaskContext.getProcessDataCacheContext();
    }

    protected void onExecuteTaskGrpException(FahTaskGrpTypeEnum[] currentExecuteTaskGrp, Exception ex) {
        this.rootTaskContext.getTaskGroupCondition().cancel(true);
        super.onException((Throwable)ex);
    }

    protected FahSimpleTaskResult doTaskJob() throws Exception {
        FahTaskGrpTypeEnum[][] executionTaskGrps = this.rootTaskContext.getInputParamContext().getExecuteTaskGrp();
        int totalParallelTaskGrpCnt = executionTaskGrps.length;
        FahTaskGroupCondition groupCondition = this.rootTaskContext.getTaskGroupCondition();
        FahTaskGrpTypeEnum[] currentParallelTaskGrp = null;
        Object mainTaskInputParam = this.getInputParam();
        int currentParallelGrpIndex = 0;
        try {
            while (!groupCondition.isCompleted() && currentParallelGrpIndex < totalParallelTaskGrpCnt) {
                currentParallelTaskGrp = executionTaskGrps[currentParallelGrpIndex];
                if (currentParallelTaskGrp == null || currentParallelTaskGrp.length < 1) continue;
                FahTaskGrpTypeEnum currentMainTaskType = currentParallelTaskGrp[0];
                AbstractCommonDataWorkTask currentMainTask = this.getExecutionTask(currentMainTaskType, mainTaskInputParam);
                if (currentMainTask == null) {
                    throw new IllegalArgumentException(String.format("Cannot initial task! TaskGrpType:%s, InputParam=%s", currentMainTaskType, mainTaskInputParam));
                }
                this.rootTaskContext.setCurrentParallelTaskGrps(currentParallelTaskGrp);
                this.mainTaskExceptionListener.reset();
                currentMainTask.setTaskExceptionListener(this.mainTaskExceptionListener);
                FahSimpleTaskResult mainTaskResult = (FahSimpleTaskResult)currentMainTask.call();
                FahTaskGrpTypeEnum nextMainTaskType = currentParallelGrpIndex + 1 < totalParallelTaskGrpCnt ? executionTaskGrps[currentParallelGrpIndex + 1][0] : null;
                mainTaskInputParam = this.processSerialMainTaskResult(mainTaskResult, this.mainTaskExceptionListener, nextMainTaskType);
                this.tryProcessUnCompletedBatchResult(currentParallelTaskGrp);
                this.waitTaskGrpCompleted();
            }
        }
        catch (Exception ex) {
            this.onExecuteTaskGrpException(currentParallelTaskGrp, ex);
        }
        return (FahSimpleTaskResult)this.taskResult;
    }

    public boolean onBatchCompleted(IFahDataWorkTask srcWorkTask, int batchSeqNo, Object batchResult, boolean withError) {
        if (srcWorkTask == null) {
            return true;
        }
        FahTaskGrpTypeEnum currentTaskGrpType = (FahTaskGrpTypeEnum)srcWorkTask.getTaskTypeCode();
        FahTaskGrpTypeEnum nextTaskGrpType = this.rootTaskContext.getNextTaskTypeOnCurrentParallelGrp(currentTaskGrpType);
        if (nextTaskGrpType == null) {
            return true;
        }
        IProcessBillDataTaskInputParam nextTaskInputParam = this.convertToNextTaskInputParam(batchResult, batchResult.getClass(), this.getNextTaskInputParamType(currentTaskGrpType));
        TaskBatchResultWrapper batchResultWrapper = new TaskBatchResultWrapper(nextTaskGrpType, batchSeqNo, batchResult.getClass(), batchResult);
        FahRegisteredAsyncPipeTypeEnum pipeType = FahRegisteredAsyncPipeTypeEnum.getDefaultPipeTypeByTaskGrpType((FahTaskGrpTypeEnum)nextTaskGrpType);
        if (this.pipePoolMgr.isQueueFull(pipeType, 1).booleanValue()) {
            this.rootTaskContext.getProcessDataCacheContext().put(nextTaskGrpType, (Serializable)batchResultWrapper);
        } else {
            IFahIAsyncStreamDataBlock dataBlock = this.pipePoolMgr.putToQueue(pipeType, (Object)batchResultWrapper, true);
            this.currentParallelGrpDataBlocks.add(dataBlock);
        }
        return true;
    }

    protected <BATCH extends IProcessBillDataTaskInputParam> int processBatchResult(TaskBatchResultWrapper<BATCH> srcBatchResult) {
        FahTaskProcessDataCacheStorage storage = this.rootTaskContext.getProcessDataCacheContext().getByClassType(srcBatchResult.getBatchResultClassType());
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Batch Result Cache Storage not found: %s", srcBatchResult));
        }
        int executedBatchCnt = 0;
        return executedBatchCnt;
    }

    protected <T> T convertBatchResultToTaskInputParam(Class srcBatchResultClassType, Object srcBatchResult, Class<T> executeTaskInputParam) {
        if (srcBatchResult == null) {
            return null;
        }
        if (srcBatchResultClassType == null) {
            srcBatchResultClassType = srcBatchResult.getClass();
        }
        if (srcBatchResultClassType.equals(executeTaskInputParam)) {
            return (T)srcBatchResult;
        }
        if (srcBatchResultClassType.isAssignableFrom(executeTaskInputParam)) {
            return (T)srcBatchResult;
        }
        throw new IllegalArgumentException(String.format("Not Support convert Batch Result=%s to InputParam=%s", srcBatchResultClassType, executeTaskInputParam));
    }

    protected Future executeSubTask(IProcessBillDataTaskInputParam inputParam) throws Exception {
        Object subTask = factory.buildTaskInstance(inputParam, this, this.taskGroupCondition, this.rootTaskContext);
        if (this.rootTaskContext.getTaskConfig().isEnableParallel()) {
            return null;
        }
        return new DummyFuture<Object>(subTask.call());
    }

    protected void waitTaskGrpCompleted() {
        for (IFahIAsyncStreamDataBlock iFahIAsyncStreamDataBlock : this.currentParallelGrpDataBlocks) {
            if (iFahIAsyncStreamDataBlock == null || iFahIAsyncStreamDataBlock.isDone() || iFahIAsyncStreamDataBlock.lock()) continue;
            iFahIAsyncStreamDataBlock.waitForCompleted();
        }
    }

    @Override
    public ProcessBillDataRootTaskContext getRootTaskContext() {
        return this.rootTaskContext;
    }

    @Override
    public void setRootTaskContext(ProcessBillDataRootTaskContext rootTaskContext) {
        this.rootTaskContext = rootTaskContext;
    }

    public ITaskResultCacheManager getCacheService() {
        return this.cacheService;
    }

    public void setCacheService(ITaskResultCacheManager cacheService) {
        this.cacheService = cacheService;
    }

    public boolean onException(IFahDataWorkTask srcWorkTask, int batchSeqNo, String errorMsg, Object errorDataParam, Throwable ex) {
        return false;
    }

    public void beforeTaskStart(IFahDataWorkTask srcWorkTask) {
        throw new UnsupportedOperationException();
    }

    public boolean onPartitionGrpCompleted(IFahDataWorkTask srcWorkTask) {
        return false;
    }

    public void afterTaskCompleted(IFahDataWorkTask srcWorkTask, Object taskResult, boolean withError) {
        throw new UnsupportedOperationException();
    }

    protected class MainTaskExceptionListener
    implements ITaskExceptionListener {
        private boolean hasError = false;
        private IFahDataWorkTask srcWorkTask;
        private int batchSeqNo;
        private String errorMsg;
        private Object errorDataParam;
        private Throwable ex;

        protected MainTaskExceptionListener() {
        }

        public boolean onException(IFahDataWorkTask srcWorkTask, int batchSeqNo, String errorMsg, Object errorDataParam, Throwable ex) {
            this.batchSeqNo = batchSeqNo;
            this.errorMsg = errorMsg;
            this.errorDataParam = errorDataParam;
            this.ex = ex;
            this.hasError = true;
            AbstractProcessBillTypeDataRootTask.this.rootTaskContext.getTaskGroupCondition().cancel(true);
            return false;
        }

        public void reset() {
            this.srcWorkTask = null;
            this.batchSeqNo = -1;
            this.errorMsg = null;
            this.errorDataParam = null;
            this.ex = null;
            this.hasError = false;
        }

        public boolean isHasError() {
            return this.hasError;
        }

        public IFahDataWorkTask getSrcWorkTask() {
            return this.srcWorkTask;
        }

        public int getBatchSeqNo() {
            return this.batchSeqNo;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public Object getErrorDataParam() {
            return this.errorDataParam;
        }

        public Throwable getEx() {
            return this.ex;
        }

        public void setHasError(boolean hasError) {
            this.hasError = hasError;
        }

        public void setSrcWorkTask(IFahDataWorkTask srcWorkTask) {
            this.srcWorkTask = srcWorkTask;
        }

        public void setBatchSeqNo(int batchSeqNo) {
            this.batchSeqNo = batchSeqNo;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public void setErrorDataParam(Object errorDataParam) {
            this.errorDataParam = errorDataParam;
        }

        public void setEx(Throwable ex) {
            this.ex = ex;
        }
    }
}

