/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.maintask;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.v2.fah.models.register.RegisterBillType;
import kd.fi.v2.fah.models.request.FahRequestProcessBillDataBatchDTO;
import kd.fi.v2.fah.models.request.FahRequestProcessBillDataTaskDTO;
import kd.fi.v2.fah.services.cache.RegisterBillTypeCheckService;
import kd.fi.v2.fah.task.common.FahTaskGroupCondition;
import kd.fi.v2.fah.task.common.ITaskStatusChangeListener;
import kd.fi.v2.fah.task.maintask.SubmitProcessBillDataRequestTask;
import kd.fi.v2.fah.task.params.input.SubmitProcessBillDataRequestTaskInputParam;

public class SubmitProcessMultiBillDataRequestTask
extends SubmitProcessBillDataRequestTask {
    private static final String PK_ALIAS = "id";

    public SubmitProcessMultiBillDataRequestTask(SubmitProcessBillDataRequestTaskInputParam inputParam, ITaskStatusChangeListener taskStatusChangeListener, FahTaskGroupCondition taskGroupCondition) {
        super(inputParam, taskStatusChangeListener, taskGroupCondition);
    }

    public SubmitProcessMultiBillDataRequestTask(SubmitProcessBillDataRequestTaskInputParam inputParam, ITaskStatusChangeListener taskStatusChangeListener) {
        super(inputParam, taskStatusChangeListener);
    }

    public SubmitProcessMultiBillDataRequestTask(SubmitProcessBillDataRequestTaskInputParam inputParam) {
        super(inputParam);
    }

    @Override
    protected RegisterBillTypeCheckService.RegisterBillTypeCheckResult checkValidateBillTypes() {
        return this.billTypeCheckService.checkValidateBillType(((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).getBillTypes());
    }

    protected String getQueryString(RegisterBillType billType) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billType.getBillType());
        String pkField = dataEntityType.getPrimaryKey().getName();
        String select = pkField + " " + PK_ALIAS;
        return "fid";
    }

    @Override
    protected int createRequestBatch(FahRequestProcessBillDataTaskDTO requestTaskDTO, int batchStartSeqNo, RegisterBillType billType, int batchSize, int notSplitBatchSize) {
        long requestId = requestTaskDTO.getId();
        ArrayList<Long> batchCache = new ArrayList<Long>(batchSize);
        int batchRecCnt = 0;
        int totalBatchCnt = 0;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"splitRequestBatch", (String)billType.getBillType(), (String)this.getQueryString(billType), (QFilter[])this.buildBillFilter(billType).toArray(), null);){
            while (ds.hasNext()) {
                batchCache.add(ds.next().getLong(0));
                if (++batchRecCnt <= batchSize) continue;
                FahRequestProcessBillDataBatchDTO batchDTO = this.buildRequestTaskBatchDTO(requestId, batchStartSeqNo + totalBatchCnt, billType, batchCache);
                ++totalBatchCnt;
                this.saveRequestTaskBatachDTO(batchDTO);
                batchCache.clear();
            }
        }
        return totalBatchCnt;
    }

    protected QFilter buildBillFilter(RegisterBillType validBillType) {
        QFilterBuilder builder = new QFilterBuilder();
        Date[] queryDateRange = ((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).getQueryDateRange();
        builder.add(validBillType.getRegisterFieldName(RegisterBillType.IDX_Date_Field), ">=", (Object)queryDateRange[0]);
        builder.add(validBillType.getRegisterFieldName(RegisterBillType.IDX_Date_Field), "<=", (Object)queryDateRange[1]);
        builder.addIn(validBillType.getRegisterFieldName(RegisterBillType.IDX_Org_Field), ((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).getOrgIds());
        return builder.buildSingleFilter();
    }
}

