/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.subtask;

import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.logback.LogbackFactory;
import kd.fi.v2.fah.dao.engine.reverse.ReverseBillDataTaskDaoImpl;
import kd.fi.v2.fah.task.common.AbstractCommonDataWorkTaskEx;
import kd.fi.v2.fah.task.common.FahTaskGroupCondition;
import kd.fi.v2.fah.task.common.ITaskStatusChangeListener;
import kd.fi.v2.fah.task.context.ReverseBillDataRootTaskContext;
import kd.fi.v2.fah.task.params.input.ReverseEventSubTaskInputParam;
import kd.fi.v2.fah.task.params.output.ReverseEventSubTaskOutputParam;

public class ReverseEventSubTask
extends AbstractCommonDataWorkTaskEx<ReverseEventSubTaskInputParam, ReverseEventSubTaskOutputParam, ReverseBillDataRootTaskContext> {
    private static final Log logger = LogbackFactory.getLog(ReverseEventSubTask.class);

    public ReverseEventSubTask(ReverseEventSubTaskInputParam inputParam, ITaskStatusChangeListener taskStatusChangeListener, FahTaskGroupCondition taskGroupCondition) {
        super(inputParam, taskStatusChangeListener, taskGroupCondition);
    }

    public ReverseEventSubTask(ReverseEventSubTaskInputParam inputParam, ITaskStatusChangeListener taskStatusChangeListener) {
        super(inputParam, taskStatusChangeListener);
    }

    public ReverseEventSubTask(ReverseEventSubTaskInputParam inputParam) {
        super(inputParam);
    }

    protected void initialization() {
        super.initialization();
        this.taskResult = new ReverseEventSubTaskOutputParam();
    }

    protected ReverseEventSubTaskOutputParam doTaskJob() throws Exception {
        long requestId = ((ReverseEventSubTaskInputParam)((Object)this.getInputParam())).getRequestId();
        Object[] typeAndBillIds = ReverseBillDataTaskDaoImpl.getBillTypeAndBillIds(requestId);
        if (null == typeAndBillIds || null == typeAndBillIds[0]) {
            this.getTaskGroupCondition().cancel(true);
            return (ReverseEventSubTaskOutputParam)this.taskResult;
        }
        String billType = String.valueOf(typeAndBillIds[0]);
        Set srcBillIds = (Set)typeAndBillIds[1];
        logger.info("ReverseEventSubTask billType:{}, srcBillIds:{}", (Object)billType, (Object)srcBillIds);
        Map<Long, Long>[] maps = ReverseBillDataTaskDaoImpl.saveReverseEvent(billType, srcBillIds, requestId);
        ((ReverseEventSubTaskOutputParam)this.taskResult).setMaps(maps);
        ((ReverseEventSubTaskOutputParam)this.taskResult).setBillType(billType);
        ((ReverseEventSubTaskOutputParam)this.taskResult).setIds(srcBillIds);
        return (ReverseEventSubTaskOutputParam)this.taskResult;
    }
}

