/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.subtask;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.logback.LogbackFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.v2.fah.dao.engine.reverse.ReverseBillDataTaskDaoImpl;
import kd.fi.v2.fah.task.common.AbstractCommonDataWorkTask;
import kd.fi.v2.fah.task.common.FahTaskGroupCondition;
import kd.fi.v2.fah.task.common.ITaskStatusChangeListener;
import kd.fi.v2.fah.task.params.input.ReverseWriteBackInputParam;
import kd.fi.v2.fah.task.result.FahSimpleTaskResult;

public class ReverseWriteBackSubTask
extends AbstractCommonDataWorkTask<ReverseWriteBackInputParam> {
    private static final Log logger = LogbackFactory.getLog(ReverseWriteBackSubTask.class);

    public ReverseWriteBackSubTask(ReverseWriteBackInputParam inputParam, ITaskStatusChangeListener taskStatusChangeListener, FahTaskGroupCondition taskGroupCondition) {
        super(inputParam, taskStatusChangeListener, taskGroupCondition);
    }

    public ReverseWriteBackSubTask(ReverseWriteBackInputParam inputParam, ITaskStatusChangeListener taskStatusChangeListener) {
        super(inputParam, taskStatusChangeListener);
    }

    public ReverseWriteBackSubTask(ReverseWriteBackInputParam inputParam) {
        super(inputParam);
    }

    protected FahSimpleTaskResult doTaskJob() throws Exception {
        long requestId = ((ReverseWriteBackInputParam)((Object)this.getInputParam())).getRequestId();
        ((FahSimpleTaskResult)this.taskResult).setRequestId(Long.valueOf(requestId));
        Object[] typeAndBillIds = ReverseBillDataTaskDaoImpl.getBillTypeAndBillIds(requestId);
        if (null == typeAndBillIds || null == typeAndBillIds[0]) {
            this.getTaskGroupCondition().cancel(true);
            return (FahSimpleTaskResult)this.taskResult;
        }
        String billType = String.valueOf(typeAndBillIds[0]);
        Set srcBillIds = (Set)typeAndBillIds[1];
        Map<String, Set<Long>> failBillsInfoMap = ReverseBillDataTaskDaoImpl.getFailBillsInfo(requestId);
        Set<Long> failSet = failBillsInfoMap.get(billType);
        if (CollectionUtils.isNotEmpty(failSet)) {
            logger.info("ReverseWriteBackSubTask billType:{},failSet:{},requestId:{}", new Object[]{billType, srcBillIds, requestId});
            srcBillIds.removeAll(failSet);
            ReverseBillDataTaskDaoImpl.rebackCurrTaskXla(requestId, billType, failSet);
        }
        if (CollectionUtils.isNotEmpty((Collection)srcBillIds)) {
            logger.info("ReverseWriteBackSubTask billType:{},srcBillIds:{},requestId:{}", new Object[]{billType, srcBillIds, requestId});
            ReverseBillDataTaskDaoImpl.updateTracker(requestId, billType, srcBillIds);
        }
        return (FahSimpleTaskResult)this.taskResult;
    }
}

