/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.util;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.Currency;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.util.QFBuilder;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.event.BillDataProcessErrorCategoryEnum;
import kd.fi.v2.fah.constant.enums.event.EventReverseStatusEnum;
import kd.fi.v2.fah.constant.enums.event.FahBillEvtStatusBaseDataEnum;
import kd.fi.v2.fah.constant.enums.event.FahEventGenOprEnum;
import kd.fi.v2.fah.constant.enums.event.FahEventHeadField;
import kd.fi.v2.fah.constant.enums.event.FahEventHeadStatusEnum;
import kd.fi.v2.fah.constant.enums.event.FahEventLineTmpField;
import kd.fi.v2.fah.constant.enums.event.FahEventStageEnum;
import kd.fi.v2.fah.constant.event.FahEventConstant;
import kd.fi.v2.fah.dao.BaseFlexFieldDao;
import kd.fi.v2.fah.dao.FahCheckXLADataDao;
import kd.fi.v2.fah.dao.FahXLADaoImpl;
import kd.fi.v2.fah.dao.engine.reverse.ReverseBillDataTaskDaoImpl;
import kd.fi.v2.fah.dao.event.EventTrackerDao;
import kd.fi.v2.fah.dao.event.FahNoEvtBillsDao;
import kd.fi.v2.fah.dao.event.FahRegBillDao;
import kd.fi.v2.fah.dao.event.context.BuildEvtContext;
import kd.fi.v2.fah.dao.task.FahRequestTaskDaoImpl;
import kd.fi.v2.fah.datasource.QueryDataSourceFactory;
import kd.fi.v2.fah.event.EvtHeadInfo;
import kd.fi.v2.fah.event.FahEvtTaskParam;
import kd.fi.v2.fah.getvaluehandle.IGetValueHandle;
import kd.fi.v2.fah.job.FahJobContext;
import kd.fi.v2.fah.log.FahBgTaskLogger;
import kd.fi.v2.fah.models.event.dispatch.ConditionField;
import kd.fi.v2.fah.models.event.dispatch.ValueZone;
import kd.fi.v2.fah.models.event.eventrule.EventRuleLineCfg;
import kd.fi.v2.fah.models.event.eventrule.EventRuleModelCfg;
import kd.fi.v2.fah.models.event.eventrule.FieldAliasInfo;
import kd.fi.v2.fah.sqlbuilder.IInsertSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.ISqlParamBuffer;
import kd.fi.v2.fah.sqlbuilder.impl.BaseInsertSqlBuilder;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.task.status.TaskStatusEnum;
import kd.fi.v2.fah.util.EventGenTaskUtils;
import kd.fi.v2.fah.util.FahWriteBackPluginExecutor;
import kd.fi.v2.fah.util.FahWriteBackSqlExecutor;
import kd.fi.v2.fah.utils.ICommonDataValueUtil;
import kd.fi.v2.fah.utils.StringUtils;
import kd.fi.v2.fah.utils.mutex.FahMutexRequireUtil;

public class BuildEvtDataUtil {
    private static final Log logger = LogFactory.getLog(BuildEvtDataUtil.class);

    public static DataSet getLineDataset(BuildEvtContext buildEvtContext, Iterable<FieldAliasInfo> fieldAliasInfos, String orderBy) {
        LinkedList<String> selectList = new LinkedList<String>();
        for (FieldAliasInfo fieldAliasInfo : fieldAliasInfos) {
            selectList.add(fieldAliasInfo.getQueryFieldNumber() + " " + fieldAliasInfo.getAlias());
        }
        String selector = kd.bos.dataentity.utils.StringUtils.join((Object[])selectList.toArray(), (String)",");
        return QueryDataSourceFactory.getQueryDataSource(buildEvtContext.getBillType()).queryEntryDataFromSelector(buildEvtContext.getBillIds(), buildEvtContext.getSourceEntry(), buildEvtContext.getSourceEntryIds(), selector, orderBy, -1);
    }

    public static void buildEvtHead(BuildEvtContext buildEvtContext, Row currRow, EvtHeadInfo evtHeadInfo) {
        EventRuleModelCfg ruleModelCfg = buildEvtContext.getRuleModelCfg();
        Long orgId = currRow.getLong("srcbill_orgnum");
        String billNo = currRow.getString("srcbill_num");
        Long billId = currRow.getLong("srcbill_pk");
        Long entryId = currRow.getLong(buildEvtContext.getSrcBillPkColumnName());
        if (orgId == null || orgId == 0L) {
            String orgNullMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d[\u7f16\u7801\uff1a\u201c%2$s\u201d\uff0cID\uff1a\u201c%3$d\u201d]\u5355\u636e\u4f53\u201c%4$s\u201d[entryid\uff1a\u201c%5$d\u201d]\u7684\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u521b\u5efa\u4e8b\u4ef6\u5931\u8d25\u3002", (String)"BuildEvtDataUtil_6", (String)"fi-ai-business", (Object[])new Object[0]), buildEvtContext.getBillType(), billNo, billId, ruleModelCfg.getSourceEntry(), entryId);
            buildEvtContext.getFahJobContext().getFahBgTaskLogger().addDetailEntryErr(orgNullMsg);
        }
        ISqlParamBuffer headParamBuffer = buildEvtContext.getHeadBuilder().getSqlParamBuffer();
        headParamBuffer.set(FahEventHeadField.FID.ordinal(), (Object)evtHeadInfo.getEvtHeadId());
        headParamBuffer.set(FahEventHeadField.FNUMBER.ordinal(), (Object)evtHeadInfo.getEvtNo());
        headParamBuffer.set(FahEventHeadField.FORGID.ordinal(), (Object)orgId);
        headParamBuffer.set(FahEventHeadField.FSRC_SYSTYPE.ordinal(), (Object)buildEvtContext.getSrcSysType());
        headParamBuffer.set(FahEventHeadField.FSRC_SYSID.ordinal(), (Object)buildEvtContext.getSrcSysId());
        headParamBuffer.set(FahEventHeadField.FSRC_BILLTYPE.ordinal(), (Object)buildEvtContext.getBillType());
        headParamBuffer.set(FahEventHeadField.FSRC_BILLNO.ordinal(), (Object)billNo);
        headParamBuffer.set(FahEventHeadField.FSRC_BILLID.ordinal(), (Object)billId);
        headParamBuffer.set(FahEventHeadField.FSOURCEENTRY.ordinal(), (Object)ruleModelCfg.getSourceEntry());
        headParamBuffer.set(FahEventHeadField.FSOURCEENTRYID.ordinal(), (Object)entryId);
        headParamBuffer.set(FahEventHeadField.FEVTTYPEID.ordinal(), (Object)ruleModelCfg.getEventTypeId());
        headParamBuffer.set(FahEventHeadField.FEVTCLASSID.ordinal(), (Object)ruleModelCfg.getEventClassId());
        headParamBuffer.set(FahEventHeadField.FBIZDATE.ordinal(), (Object)currRow.getDate(buildEvtContext.getBizDateAlias()));
        headParamBuffer.set(FahEventHeadField.FBOOKEDDATE.ordinal(), buildEvtContext.getBookedDateAlias() == null ? null : currRow.getDate(buildEvtContext.getBookedDateAlias()));
        headParamBuffer.set(FahEventHeadField.FRULEID.ordinal(), ruleModelCfg.getId());
        headParamBuffer.set(FahEventHeadField.FRULEVERSION.ordinal(), (Object)FahEventConstant.DEFAULT_LONG_ZERO);
        headParamBuffer.set(FahEventHeadField.FDISPATCHID.ordinal(), (Object)buildEvtContext.getDispatchId());
        headParamBuffer.set(FahEventHeadField.FDISPATCHVERSION.ordinal(), (Object)FahEventConstant.DEFAULT_LONG_ZERO);
        headParamBuffer.set(FahEventHeadField.FEVTLINECNT.ordinal(), (Object)FahEventConstant.DEFAULT_INT_ZERO);
        headParamBuffer.set(FahEventHeadField.FCREATESTAGE.ordinal(), (Object)FahEventStageEnum.CREATING_EVENT_HEAD.getStage());
        headParamBuffer.set(FahEventHeadField.FCREATESTATUS.ordinal(), (Object)FahEventHeadStatusEnum.TEMPORARY_STORAGE.getStatus());
        headParamBuffer.set(FahEventHeadField.FNEEDACCT.ordinal(), (Object)ruleModelCfg.getNeedAcct());
        headParamBuffer.set(FahEventHeadField.FBIZDATASTATUS.ordinal(), (Object)"0");
        headParamBuffer.set(FahEventHeadField.FISPREVIEW.ordinal(), (Object)buildEvtContext.getFisPreview());
        headParamBuffer.set(FahEventHeadField.FRELATEID.ordinal(), (Object)FahEventConstant.RELATEID_NONE);
        headParamBuffer.set(FahEventHeadField.FREVERSESTATUS.ordinal(), (Object)"0");
        headParamBuffer.set(FahEventHeadField.FCREATETIME.ordinal(), (Object)buildEvtContext.getCreateTime());
        headParamBuffer.set(FahEventHeadField.FMODIFYTIME.ordinal(), (Object)buildEvtContext.getCreateTime());
        headParamBuffer.set(FahEventHeadField.FCREATORID.ordinal(), (Object)RequestContext.get().getCurrUserId());
        headParamBuffer.set(FahEventHeadField.FMODIFIERID.ordinal(), (Object)RequestContext.get().getCurrUserId());
        headParamBuffer.set(FahEventHeadField.FREQUESTID.ordinal(), (Object)buildEvtContext.getRequestId());
    }

    public static boolean checkLastBillFinished(BuildEvtContext buildEvtContext) {
        return Objects.equals(buildEvtContext.getCurrRowBillId(), buildEvtContext.getLastRowBillId());
    }

    public static PairTuple<Boolean, String> buildEvtLine(BuildEvtContext buildEvtContext, Row currRow, EventRuleLineCfg lineCfg, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos, Map<Long, PairTuple<IGetValueHandle, IGetValueHandle>> getValueHandleMap) {
        Long eventLineTypeId;
        String msg = " ";
        boolean lineErr = false;
        Map<Long, Boolean> lineTypeEnableMap = buildEvtContext.getLineTypeEnableMap();
        Boolean eventLineTypeEnable = lineTypeEnableMap.get(eventLineTypeId = lineCfg.getEventLineTypeId());
        if (null == eventLineTypeEnable || !eventLineTypeEnable.booleanValue()) {
            lineErr = true;
            msg = ResManager.loadKDString((String)"\u4e8b\u4ef6\u884c\u7c7b\u578b\u53ef\u80fd\u88ab\u7981\u7528\u6216\u8005\u5220\u9664\u3002", (String)"BuildEvtDataUtil_2", (String)"fi-ai-business", (Object[])new Object[0]);
        }
        PairTuple<IGetValueHandle, IGetValueHandle> handlePairTuple = getValueHandleMap.get(lineCfg.getId());
        ISqlParamBuffer sqlParamBuffer = buildEvtContext.getLineTmpBuilder().getSqlParamBuffer();
        EvtHeadInfo evtHeadInfo = buildEvtContext.getEvtHeadInfoMap().get(buildEvtContext.getCurrRowBillId());
        sqlParamBuffer.set(FahEventLineTmpField.FID.ordinal(), (Object)evtHeadInfo.getEvtHeadId());
        sqlParamBuffer.set(FahEventLineTmpField.FSEQ.ordinal(), (Object)evtHeadInfo.nextSeq());
        sqlParamBuffer.set(FahEventLineTmpField.FLINETYPEID.ordinal(), (Object)eventLineTypeId);
        sqlParamBuffer.set(FahEventLineTmpField.FSOURCEENTRY.ordinal(), (Object)lineCfg.fetchAmountFieldEntry());
        sqlParamBuffer.set(FahEventLineTmpField.FSRCBILLENTRYID.ordinal(), (Object)currRow.getLong(lineCfg.fetchAmountPKAlias()));
        sqlParamBuffer.set(FahEventLineTmpField.FSRCLINERULEID.ordinal(), (Object)lineCfg.getId());
        Long amount = null == handlePairTuple.getKey() ? FahEventConstant.DEFAULT_LONG_ZERO : ((IGetValueHandle)handlePairTuple.getKey()).getValue(currRow, fieldAliasInfos);
        sqlParamBuffer.set(FahEventLineTmpField.FAMOUNT.ordinal(), (Object)amount);
        Long currencyId = null == handlePairTuple.getValue() ? FahEventConstant.DEFAULT_LONG_ZERO : ((IGetValueHandle)handlePairTuple.getValue()).getValue(currRow, fieldAliasInfos);
        sqlParamBuffer.set(FahEventLineTmpField.FCURRENCYID.ordinal(), (Object)currencyId);
        sqlParamBuffer.set(FahEventLineTmpField.FLINESTATUS.ordinal(), (Object)"2");
        if (amount == null) {
            lineErr = true;
            sqlParamBuffer.set(FahEventLineTmpField.FAMOUNT.ordinal(), (Object)FahEventConstant.DEFAULT_LONG_ZERO);
            msg = msg + ResManager.loadKDString((String)"\u91d1\u989d\u5b57\u6bb5\u672a\u53d6\u5230\u503c\u3002", (String)"BuildEvtDataUtil_3", (String)"fi-ai-business", (Object[])new Object[0]);
        }
        if (!BuildEvtDataUtil.checkAmountWithCurrency(amount, currencyId)) {
            lineErr = true;
            Currency currency = FahCheckXLADataDao.getCurrencyFromThreadCache(currencyId);
            msg = msg + String.format(ResManager.loadKDString((String)"\u5e01\u79cd\u7cbe\u5ea6\uff1a%1$s\uff0c\u91d1\u989d\uff08\u539f\u5e01\uff09\uff1a%2$s\uff0c\u4e0d\u6ee1\u8db3\u5e01\u79cd\u7cbe\u5ea6\u3002", (String)"BuildEvtDataUtil_7", (String)"fi-ai-business", (Object[])new Object[0]), currency.getAmtprecision(), amount);
        }
        if (lineErr) {
            sqlParamBuffer.set(FahEventLineTmpField.FLINESTATUS.ordinal(), (Object)"3");
        }
        sqlParamBuffer.set(FahEventLineTmpField.FMSG.ordinal(), (Object)msg);
        return new PairTuple((Object)lineErr, (Object)msg);
    }

    public static DataSet getHeadDataset(BuildEvtContext buildEvtContext, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos) {
        LinkedList<String> selectList = new LinkedList<String>();
        for (FieldAliasInfo fieldAliasInfo : fieldAliasInfos) {
            selectList.add(fieldAliasInfo.getQueryFieldNumber() + " " + fieldAliasInfo.getAlias());
        }
        String selector = kd.bos.dataentity.utils.StringUtils.join((Object[])selectList.toArray(), (String)",");
        return QueryDataSourceFactory.getQueryDataSource(buildEvtContext.getBillType()).queryEntryDataFromSelector(buildEvtContext.getBillIds(), buildEvtContext.getSourceEntry(), buildEvtContext.getSourceEntryIds(), selector, buildEvtContext.getRuleModelCfg().getOrderBy(), -1);
    }

    public static void initEvtHeadFields(BuildEvtContext buildEvtContext) {
        EntityType entityType;
        EventRuleModelCfg ruleModelCfg;
        String sourceEntry;
        String billType = buildEvtContext.getBillType();
        String pkName = billType.equals(sourceEntry = (ruleModelCfg = buildEvtContext.getRuleModelCfg()).getSourceEntry()) ? "srcbill_pk" : ((entityType = (EntityType)MetadataServiceHelper.getDataEntityType((String)billType).getAllEntities().get(sourceEntry)) instanceof SubEntryType ? "srcbill_subentrypk" : "srcbill_entrypk");
        buildEvtContext.setSrcBillPkColumnName(pkName);
        if (StringUtils.isNotEmpty((String)ruleModelCfg.getAcctDateNum())) {
            buildEvtContext.setBookedDateAlias("srcbill_acctdate");
        }
        if (Objects.equals(ruleModelCfg.getBizDateNum(), ruleModelCfg.getAcctDateNum())) {
            buildEvtContext.setBizDateAlias("srcbill_acctdate");
        } else {
            buildEvtContext.setBizDateAlias("srcbill_bizdate");
        }
    }

    public static void addNotFoundAmountFailRow(BuildEvtContext buildEvtContext, Long billId, EventRuleLineCfg lineCfg) {
        EvtHeadInfo evtHeadInfo = buildEvtContext.getEvtHeadInfoMap().get(billId);
        evtHeadInfo.addTotalEvtLineCnt();
        evtHeadInfo.addErrEvtLineCnt();
        ISqlParamBuffer lineTmpParamBuffer = buildEvtContext.getLineTmpBuilder().getSqlParamBuffer();
        lineTmpParamBuffer.set(FahEventLineTmpField.FID.ordinal(), (Object)evtHeadInfo.getEvtHeadId());
        lineTmpParamBuffer.set(FahEventLineTmpField.FSEQ.ordinal(), (Object)evtHeadInfo.nextSeq());
        lineTmpParamBuffer.set(FahEventLineTmpField.FLINETYPEID.ordinal(), (Object)lineCfg.getEventLineTypeId());
        lineTmpParamBuffer.set(FahEventLineTmpField.FSOURCEENTRY.ordinal(), (Object)lineCfg.fetchAmountFieldEntry());
        lineTmpParamBuffer.set(FahEventLineTmpField.FSRCBILLENTRYID.ordinal(), (Object)FahEventConstant.DEFAULT_LONG_ZERO);
        lineTmpParamBuffer.set(FahEventLineTmpField.FSRCLINERULEID.ordinal(), (Object)lineCfg.getId());
        lineTmpParamBuffer.set(FahEventLineTmpField.FAMOUNT.ordinal(), (Object)FahEventConstant.DEFAULT_LONG_ZERO);
        lineTmpParamBuffer.set(FahEventLineTmpField.FCURRENCYID.ordinal(), (Object)FahEventConstant.DEFAULT_LONG_ZERO);
        String msg = ResManager.loadKDString((String)"\u91d1\u989d\u5b57\u6bb5\u4e0d\u5b58\u5728", (String)"BuildEvtDataUtil_4", (String)"fi-ai-business", (Object[])new Object[0]);
        lineTmpParamBuffer.set(FahEventLineTmpField.FMSG.ordinal(), (Object)(lineCfg.fetchAmountNumber() + msg));
        lineTmpParamBuffer.set(FahEventLineTmpField.FLINESTATUS.ordinal(), (Object)"3");
    }

    public static BaseMutableArrayMapStorage<String, FieldAliasInfo> filterAmountFields(List<EventRuleLineCfg> lineCfgNotFoundAmountFieldList, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos) {
        if (lineCfgNotFoundAmountFieldList.size() == 0) {
            return fieldAliasInfos;
        }
        Set amountNumSet = lineCfgNotFoundAmountFieldList.stream().map(EventRuleLineCfg::fetchAmountNumber).collect(Collectors.toSet());
        BaseMutableArrayMapStorage fieldAliasInfos2 = new BaseMutableArrayMapStorage();
        for (FieldAliasInfo fieldAliasInfo : fieldAliasInfos) {
            if (amountNumSet.contains(fieldAliasInfo.getNumber())) continue;
            fieldAliasInfos2.add((Object)fieldAliasInfo);
        }
        return fieldAliasInfos2;
    }

    public static DataSet getDatasetForDispatch(String billType, String selector, String orderBy, String billPkField, Collection<Long> billIds) {
        return QueryServiceHelper.queryDataSet((String)"kd.fi.v2.fah.event.mservice.util.BuildEvtDataUtil.getDatasetForDispatch", (String)billType, (String)selector, (QFilter[])new QFilter(billPkField, "in", billIds).toArray(), (String)orderBy, (int)-1);
    }

    public static Map<Long, String> getBillNoById(String billType, Collection<Long> billIds) {
        LinkedHashMap<Long, String> billNoMap = new LinkedHashMap<Long, String>();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
        ISimpleProperty pkProperty = dataEntityType.getPrimaryKey();
        String pkPropName = pkProperty.getName();
        BillEntityType bnt = (BillEntityType)dataEntityType;
        String billNo = bnt.getBillNo();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.v2.fah.event.mservice.util.BuildEvtDataUtil.getbillNoById", (String)billType, (String)(pkPropName + "," + billNo), (QFilter[])new QFilter(pkPropName, "in", billIds).toArray(), null, (int)-1);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                billNoMap.put(row.getLong(pkPropName), row.getString(billNo));
            }
        }
        return billNoMap;
    }

    public static DataSet getBillInfoById(String billType, Collection<Long> billIds, String entryEntity, Collection<Long> sourceEntityIds) {
        StringBuilder selector = new StringBuilder();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
        ISimpleProperty pkProperty = dataEntityType.getPrimaryKey();
        String pkPropName = pkProperty.getName();
        selector.append(pkPropName);
        QFilter filter = new QFilter(pkPropName, "in", billIds);
        if (!billType.equals(entryEntity) && kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)entryEntity) && null != sourceEntityIds && !sourceEntityIds.isEmpty()) {
            EntityType entityType = (EntityType)dataEntityType.getAllEntities().get(entryEntity);
            if (entityType instanceof SubEntryType) {
                selector.append(",").append(entityType.getParent().getName()).append(".").append(entryEntity).append(".id").append(" fdetailid");
                filter.and(new QFilter(entityType.getParent().getName() + "." + entryEntity + ".id", "in", sourceEntityIds));
            } else {
                selector.append(",").append(entryEntity).append(".id").append(" fentryid");
                filter.and(new QFilter(entryEntity + ".id", "in", sourceEntityIds));
            }
        }
        BillEntityType bnt = (BillEntityType)dataEntityType;
        String billNo = bnt.getBillNo();
        selector.append(",").append(billNo);
        return QueryServiceHelper.queryDataSet((String)"kd.fi.v2.fah.event.mservice.util.BuildEvtDataUtil.getBillInfoById", (String)billType, (String)selector.toString(), (QFilter[])filter.toArray(), null, (int)-1);
    }

    public static List<Long> saveEventDataHeader(BuildEvtContext buildEvtContext) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew((String)"saveEventDataHeader");){
            BaseInsertSqlBuilder headBuilder = buildEvtContext.getHeadBuilder();
            List<Long> evtHeadIds = BuildEvtDataUtil.getEvtHeadIds(headBuilder);
            if (CollectionUtils.isEmpty(evtHeadIds)) {
                List<Long> list = Collections.emptyList();
                return list;
            }
            int partitionGrpCode = buildEvtContext.getPartitionGrpCode().incrementAndGet();
            headBuilder.setColumnValue(FahEventHeadField.FPARTITIONGRPCODE.ordinal(), (Object)partitionGrpCode);
            BaseFlexFieldDao.doInsert((IInsertSqlBuilder)headBuilder);
            buildEvtContext.clearAllSqlParamData();
            List<Long> list = evtHeadIds;
            return list;
        }
        catch (Exception e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static void saveEventDataLine(BuildEvtContext buildEvtContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<ThreeTuple<Long, Boolean, Integer>> getEvtInfoList(BuildEvtContext buildEvtContext) {
        LinkedList<ThreeTuple<Long, Boolean, Integer>> evtInfoList = new LinkedList<ThreeTuple<Long, Boolean, Integer>>();
        Map<Long, EvtHeadInfo> headInfoMap = buildEvtContext.getEvtHeadInfoMap();
        if (buildEvtContext.isFinish()) {
            headInfoMap.values().stream().filter(h -> !h.isEvtLineStatusFlushDBFlag()).forEach(headInfo -> {
                evtInfoList.add(new ThreeTuple((Object)headInfo.getEvtHeadId(), (Object)BuildEvtDataUtil.isBuildEvtLineSuccess(headInfo), (Object)headInfo.getTotalEvtLineCnt()));
                headInfo.setEvtLineStatusFlushDBFlag(true);
            });
        } else if (buildEvtContext.isSingleLineGroup()) {
            headInfoMap.values().stream().filter(h -> BuildEvtDataUtil.isBuildEvtLineComplete(buildEvtContext.getCurrRowBillId(), h)).forEach(headInfo -> {
                evtInfoList.add(new ThreeTuple((Object)headInfo.getEvtHeadId(), (Object)BuildEvtDataUtil.isBuildEvtLineSuccess(headInfo), (Object)headInfo.getTotalEvtLineCnt()));
                headInfo.setEvtLineStatusFlushDBFlag(true);
            });
        }
        return evtInfoList;
    }

    private static boolean isBuildEvtLineComplete(Long currRowBillId, EvtHeadInfo headInfo) {
        return !Objects.equals(currRowBillId, headInfo.getBillId()) && !headInfo.isEvtLineStatusFlushDBFlag() && headInfo.getTotalEvtLineCnt() > 0;
    }

    private static boolean isBuildEvtLineSuccess(EvtHeadInfo headInfo) {
        return headInfo.getErrEvtLineCnt() == 0 && headInfo.getTotalEvtLineCnt() > 0;
    }

    private static Collection<Long> batchUpdateHeadStatusWithLineCnt(List<ThreeTuple<Long, Boolean, Integer>> evtInfoList, int bigEntrySizeConfig, AtomicInteger partitionGrpCode) {
        if (CollectionUtils.isEmpty(evtInfoList)) {
            return Collections.emptyList();
        }
        String updateSql = "update t_fah_event_header set fcreatestage = ?, fcreatestatus = ?, fevtlinecnt = ?, fmodifierid = ?, fmodifytime = ? where fid = ? ";
        String updateBigEntrySql = "update t_fah_event_header set fpartitiongrpcode = ?, fmodifierid = ?, fmodifytime = ? where fid = ? ";
        LinkedList updateParamsList = new LinkedList();
        LinkedList bitEntryParamsList = new LinkedList();
        LinkedList<Long> successBigEntryEvtList = new LinkedList<Long>();
        long modifierId = RequestContext.get().getCurrUserId();
        Date modifyTime = new Date();
        evtInfoList.forEach(evtInfo -> {
            Object[] param = new Object[]{FahEventStageEnum.CREATING_EVENT_LINE.getStage(), (Boolean)evtInfo.item2 != false ? FahEventHeadStatusEnum.TEMPORARY_STORAGE.getStatus() : FahEventHeadStatusEnum.FAIL.getStatus(), evtInfo.item3, modifierId, modifyTime, evtInfo.item1};
            updateParamsList.add(param);
            if ((Integer)evtInfo.item3 > bigEntrySizeConfig) {
                Object[] bigEntryEvtParams = new Object[4];
                int partitionGrpCodeInt = partitionGrpCode.incrementAndGet();
                bigEntryEvtParams[0] = partitionGrpCodeInt;
                bigEntryEvtParams[1] = modifierId;
                bigEntryEvtParams[2] = modifyTime;
                bigEntryEvtParams[3] = evtInfo.item1;
                bitEntryParamsList.add(bigEntryEvtParams);
                if (((Boolean)evtInfo.item2).booleanValue()) {
                    successBigEntryEvtList.add((Long)evtInfo.item1);
                }
            }
        });
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)updateSql, updateParamsList);
                if (bitEntryParamsList.size() > 0) {
                    DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)updateBigEntrySql, bitEntryParamsList);
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        return successBigEntryEvtList;
    }

    private static List<Long> getEvtHeadIds(BaseInsertSqlBuilder headBuilder) {
        int[] columnPos = new int[]{FahEventHeadField.FID.ordinal()};
        Iterator iterator = headBuilder.selectSqlParamDataRows(columnPos, false);
        LinkedList<Long> evtHeadIds = new LinkedList<Long>();
        while (iterator.hasNext()) {
            Object[] next = (Object[])iterator.next();
            if (null == next[0]) continue;
            evtHeadIds.add((Long)next[0]);
        }
        return evtHeadIds;
    }

    public static void updateFahRequestTaskStatusToRunning(Long requestId) {
        FahRequestTaskDaoImpl.updateFahRequestTaskStatusToRunning(requestId);
    }

    public static void updateFahRequestTaskStatusToBizDataRunning(Long requestId) {
        FahRequestTaskDaoImpl.updateFahRequestTaskStatusToBizData(requestId, TaskStatusEnum.PROCESSING);
    }

    public static void updateFahRequestTaskStatusToBizDataEnd(Long requestId) {
        FahRequestTaskDaoImpl.updateFahRequestTaskStatusToBizData(requestId, TaskStatusEnum.COMPLETED);
    }

    public static void batchUpdateHeadStatus(Collection<Long> evtIds, FahEventStageEnum stageEnum, FahEventHeadStatusEnum statusEnum) {
        if (evtIds == null || evtIds.isEmpty()) {
            return;
        }
        String updateSql = "update t_fah_event_header set fcreatestage = ?, fcreatestatus = ? where fid = ? ";
        List params = evtIds.stream().map(id -> {
            Object[] param = new Object[]{stageEnum.getStage(), statusEnum.getStatus(), id};
            return param;
        }).collect(Collectors.toList());
        try (TXHandle h = TX.required();){
            try {
                DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)updateSql, params);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static void saveFahTaskBatch(long requestId, int taskBatchSeq, String billType, Collection<Long> billIds) {
        long taskBatchId = DB.genLongId((String)"t_fah_task_batch");
        BuildEvtDataUtil.saveFahTaskBatch(taskBatchId, requestId, taskBatchSeq, billType, billIds);
    }

    public static void saveFahTaskBatch(long taskBatchId, long requestId, int taskBatchSeq, String billType, Collection<Long> billIds) {
        if (CollectionUtils.isEmpty(billIds)) {
            return;
        }
        Object[] taskBatchParams = new Object[]{taskBatchId, requestId, taskBatchSeq, billType, null, null, billIds.size(), "", "0"};
        DB.execute((DBRoute)DBRoute.of((String)"ai"), (String)"insert into t_fah_task_batch(fid,frequestid,fseqno,fbilltype,fexcutestarttime,fexcuteendtime,freccnt,flockinstanceid,fstatus) values(?,?,?,?,?,?,?,?,?)", (Object[])taskBatchParams);
        long[] taskBatchEnIds = DB.genLongIds((String)"t_fah_task_batch_en", (int)billIds.size());
        ArrayList<Object[]> taskBatchEnParamsList = new ArrayList<Object[]>(billIds.size());
        int index = 0;
        for (Long billId : billIds) {
            Object[] taskBatchEnParams = new Object[]{taskBatchId, taskBatchEnIds[index], index++, billId};
            taskBatchEnParamsList.add(taskBatchEnParams);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"ai"), (String)"insert into t_fah_task_batch_en(fid,fentryid,fseqno,fsrcbillid) values(?,?,?,?)", taskBatchEnParamsList);
    }

    public static Iterator<PairTuple<String, Collection<Long>>> getBillIdsIterator(Map<String, Object> params, String billType, Collection<Long> billIds) {
        return new BillIdsIterator1(params, billType, billIds);
    }

    public static PairTuple<Collection<Long>, Collection<Long>> checkBillStatus(String billType, Collection<Long> billIds) {
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)billType) || CollectionUtils.isEmpty(billIds)) {
            return new PairTuple(Collections.emptySet(), Collections.emptySet());
        }
        Tuple<String, List<String>> regStatus = FahRegBillDao.queryAllowBillStatus(billType);
        QFilter statusFilter = new QFilter((String)regStatus.item1, "in", regStatus.item2);
        QFilter idFilter = new QFilter("id", "in", billIds);
        List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)billType, (QFilter[])new QFilter[]{idFilter, statusFilter}, null, (int)-1);
        HashSet passIds = new HashSet(primaryKeys);
        List notPassIds = billIds.stream().filter(id -> !passIds.contains(id)).collect(Collectors.toList());
        return new PairTuple(passIds, notPassIds);
    }

    public static PairTuple<Collection<Long>, Collection<Long>> checkBillEvtAndVchStatus(String billType, Collection<Long> billIds) {
        if (StringUtils.isEmpty((String)billType) || CollectionUtils.isEmpty(billIds)) {
            return new PairTuple(Collections.emptySet(), Collections.emptySet());
        }
        HashSet<Long> buildXlaAndGlVchFailedBillIds = new HashSet<Long>(billIds);
        LinkedList buildXlaAndGlVchSuccessBillIds = new LinkedList();
        BuildEvtDataUtil.accessBuildXlaGLVchSuccessAndBillIds(billType, billIds, id -> {
            buildXlaAndGlVchFailedBillIds.remove(id);
            buildXlaAndGlVchSuccessBillIds.add(id);
            return true;
        });
        return new PairTuple(buildXlaAndGlVchFailedBillIds, buildXlaAndGlVchSuccessBillIds);
    }

    private static int accessBuildXlaGLVchSuccessAndBillIds(String billType, Collection<Long> billIds, Function<Long, Boolean> consumerFunc) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select distinct fsrc_billid from t_fah_evt_tracker ", new Object[0]);
        sqlBuilder.append("where fsrc_billtype = ? ", new Object[]{billType});
        sqlBuilder.append("and fstatus = ? ", new Object[]{"4"});
        sqlBuilder.appendIn("and fsrc_billid ", billIds.toArray());
        sqlBuilder.append(" and freverseflag = ? ", new Object[]{EventReverseStatusEnum.DEFAULT.getCode()});
        int accessCnt = 0;
        try (DataSet dataSet = DB.queryDataSet((String)"getBuildXlaGLSuccessAndBillIds", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                ++accessCnt;
                if (consumerFunc.apply(dataSet.next().getLong(0)).booleanValue()) continue;
                break;
            }
        }
        return accessCnt;
    }

    public static PairTuple<Set<Long>, Set<Long>> lockBillIds(String billType, Collection<Long> billIds) {
        if (StringUtils.isEmpty((String)billType) || CollectionUtils.isEmpty(billIds)) {
            return new PairTuple((Object)Collections.EMPTY_SET, (Object)Collections.EMPTY_SET);
        }
        return FahMutexRequireUtil.requireMutex_For_V2((String)billType, (Set)((Set)billIds));
    }

    public static void releaseLock(Map<String, Set<Long>> lockedBillsMap) {
        if (null == lockedBillsMap || lockedBillsMap.isEmpty()) {
            return;
        }
        try (TXHandle h = TX.notSupported();){
            for (Map.Entry<String, Set<Long>> lockedBillsEntry : lockedBillsMap.entrySet()) {
                FahMutexRequireUtil.batchRelease((String)lockedBillsEntry.getKey(), lockedBillsEntry.getValue());
            }
        }
    }

    public static void saveSkipBills(long requestId, String billType, Map<BillDataProcessErrorCategoryEnum, Collection<Long>> skipBillIdsMap) {
        BuildEvtDataUtil.insertSkipBills(requestId, billType, skipBillIdsMap);
    }

    private static void insertSkipBills(long requestId, String billType, Map<BillDataProcessErrorCategoryEnum, Collection<Long>> skipBillIdsMap) {
        if (skipBillIdsMap.isEmpty()) {
            return;
        }
        List<Long> billIds = skipBillIdsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (billIds.isEmpty()) {
            return;
        }
        Map<Long, String> billNoIdMap = BuildEvtDataUtil.getBillNoById(billType, billIds);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(billIds.size());
        try (TXHandle h = TX.requiresNew((String)"updateSkipBills");){
            for (Map.Entry<BillDataProcessErrorCategoryEnum, Collection<Long>> skipBillIdsEntry : skipBillIdsMap.entrySet()) {
                BillDataProcessErrorCategoryEnum skipType = skipBillIdsEntry.getKey();
                Collection<Long> skipBillIds = skipBillIdsEntry.getValue();
                if (CollectionUtils.isEmpty(skipBillIds)) continue;
                long[] fahTaskSkipBills = DB.genLongIds((String)"t_fah_task_skip_bills", (int)skipBillIds.size());
                int index = 0;
                for (Long billId : skipBillIds) {
                    Object[] params = new Object[]{fahTaskSkipBills[index++], requestId, billType, billId, billNoIdMap.getOrDefault(billId, "-"), BuildEvtDataUtil.getMsgBySkipType(skipType), skipType.getCode()};
                    paramsList.add(params);
                }
            }
            String insertSql = "insert into t_fah_task_skip_bills (fid, frequestid, fbilltype, fsrcbillid, fsrcbillno, fmsg, fmsg_code) values (?,?,?,?,?,?,?)";
            if (paramsList.isEmpty()) {
                return;
            }
            try {
                DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)insertSql, paramsList);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private static String getMsgBySkipType(BillDataProcessErrorCategoryEnum skipType) {
        String msg;
        switch (skipType) {
            case UNMATCHED_DISPATCH_RULE: {
                msg = ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5206\u6d41\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u5206\u6d41\u89c4\u5219\u548c\u9002\u7528\u7ec4\u7ec7\u3002", (String)"BuildEvtDataUtil_5", (String)"fi-ai-business", (Object[])new Object[0]);
                break;
            }
            default: {
                msg = skipType.getDesc().loadKDString();
            }
        }
        return msg;
    }

    public static void saveFailBills(long requestId, String billType, long dispatchId, int dispatchVersion, Collection<Long> failBillIds, String msg, BillDataProcessErrorCategoryEnum msgCode) {
        if (CollectionUtils.isEmpty(failBillIds)) {
            return;
        }
        long[] fahTaskFailBills = DB.genLongIds((String)"t_fah_task_fail_bills", (int)failBillIds.size());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(failBillIds.size());
        int index = 0;
        Map<Long, String> billNoIdMap = BuildEvtDataUtil.getBillNoById(billType, failBillIds);
        for (Long billId : failBillIds) {
            Object[] params = new Object[]{fahTaskFailBills[index++], requestId, billType, billId, billNoIdMap.getOrDefault(billId, "-"), dispatchId, dispatchVersion, msg, msgCode.getCode()};
            paramsList.add(params);
        }
        BuildEvtDataUtil.insertFailBills(paramsList);
    }

    public static void saveFailBillsUnMatchEvtRule(Long requestId, String billType, long dispatchId, int dispatchVersion, Map<Long, Set<String>> unMatchAnyEvtRuleBillIds, BillDataProcessErrorCategoryEnum msgCode) {
        if (null == unMatchAnyEvtRuleBillIds || unMatchAnyEvtRuleBillIds.isEmpty()) {
            return;
        }
        long[] fahTaskFailBills = DB.genLongIds((String)"t_fah_task_fail_bills", (int)unMatchAnyEvtRuleBillIds.size());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(unMatchAnyEvtRuleBillIds.size());
        int index = 0;
        Map<Long, String> billNoIdMap = BuildEvtDataUtil.getBillNoById(billType, unMatchAnyEvtRuleBillIds.keySet());
        for (Map.Entry<Long, Set<String>> unMatchAnyEvtRuleBillIdAndMsg : unMatchAnyEvtRuleBillIds.entrySet()) {
            Long billId = unMatchAnyEvtRuleBillIdAndMsg.getKey();
            String msg = unMatchAnyEvtRuleBillIdAndMsg.getValue().toString();
            Object[] params = new Object[]{fahTaskFailBills[index++], requestId, billType, billId, billNoIdMap.getOrDefault(billId, "-"), dispatchId, dispatchVersion, msg, msgCode.getCode()};
            paramsList.add(params);
        }
        BuildEvtDataUtil.insertFailBills(paramsList);
    }

    private static void insertFailBills(List<Object[]> paramsList) {
        if (CollectionUtils.isEmpty(paramsList)) {
            return;
        }
        String insertSql = "insert into t_fah_task_fail_bills (fid, frequestid, fbilltype, fsrcbillid, fsrcbillno, fdispatchid, fdispatchversion, fmsg, fmsg_code) values(?,?,?,?,?,?,?,?,?)";
        try (TXHandle h = TX.requiresNew((String)"insertFailBills");){
            try {
                DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)insertSql, paramsList);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static void saveFailBillsByEvtIds(Long requestId, FahEvtTaskParam fahEvtTaskParam, Collection<Long> evtIds, BillDataProcessErrorCategoryEnum msgCode) {
        if (CollectionUtils.isEmpty(evtIds)) {
            return;
        }
        ArrayList<Long> billIdList = new ArrayList<Long>(8);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select distinct a.fsrc_billid from t_fah_event_header a where ", new Object[0]);
        sqlBuilder.appendIn(" a.fid", evtIds.toArray());
        sqlBuilder.append(" and a.fsrc_billtype = ?", new Object[]{fahEvtTaskParam.getBillType()});
        sqlBuilder.append(" and a.fstatus = ?", new Object[]{"4"});
        try (DataSet dataSet = DB.queryDataSet((String)"queryEvtHeadBillTypeMap", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                billIdList.add(row.getLong("fsrc_billid"));
            }
        }
        Map<Long, String> billNoIdeMap = BuildEvtDataUtil.getBillNoById(fahEvtTaskParam.getBillType(), billIdList);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(evtIds.size());
        long[] fahTaskFailBills = DB.genLongIds((String)"t_fah_task_fail_bills", (int)billIdList.size());
        int index = 0;
        for (Long billId : billIdList) {
            Object[] params = new Object[]{fahTaskFailBills[index++], requestId, fahEvtTaskParam.getBillType(), billId, billNoIdeMap.getOrDefault(billId, "-"), fahEvtTaskParam.getDispatchId(), fahEvtTaskParam.getDispatchVersion(), " ", msgCode.getCode()};
            paramsList.add(params);
        }
        BuildEvtDataUtil.insertFailBills(paramsList);
    }

    public static void deleteTmpEvtOrFailedEvt(String billType, Collection<Long> billIds, int sqlExecuteBatchSize) {
        boolean hasTmpOrFailedEvt = false;
        LinkedList<Long> evtHeadIds = new LinkedList<Long>();
        SqlBuilder selectEvtHeadSqlBuilder = new SqlBuilder();
        selectEvtHeadSqlBuilder.append("select fid from t_fah_event_header where fcreatestatus != ? ", new Object[]{FahEventHeadStatusEnum.SUCCESS.getStatus()});
        selectEvtHeadSqlBuilder.append("and fsrc_billtype = ? ", new Object[]{billType});
        selectEvtHeadSqlBuilder.appendIn("and fsrc_billid", billIds.toArray());
        selectEvtHeadSqlBuilder.append("and fstatus = ?", new Object[]{"4"});
        try (DataSet evtHeadDs = DB.queryDataSet((String)"selectEvtHeadSqlBuilder", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)selectEvtHeadSqlBuilder);){
            while (evtHeadDs.hasNext()) {
                hasTmpOrFailedEvt = true;
                Row evtHeadRow = evtHeadDs.next();
                evtHeadIds.add(evtHeadRow.getLong("fid"));
                if (evtHeadIds.size() < sqlExecuteBatchSize) continue;
                BuildEvtDataUtil.deleteByEvtHeadIds(evtHeadIds, sqlExecuteBatchSize);
                evtHeadIds.clear();
            }
            if (evtHeadIds.size() > 0) {
                BuildEvtDataUtil.deleteByEvtHeadIds(evtHeadIds, sqlExecuteBatchSize);
            }
        }
        if (hasTmpOrFailedEvt) {
            SqlBuilder deleteEvtHeadSqlBuilder = new SqlBuilder();
            deleteEvtHeadSqlBuilder.append("delete from t_fah_event_header where fcreatestatus != ? ", new Object[]{FahEventHeadStatusEnum.SUCCESS.getStatus()});
            deleteEvtHeadSqlBuilder.append("and fsrc_billtype = ? ", new Object[]{billType});
            deleteEvtHeadSqlBuilder.append("and fstatus = ? ", new Object[]{"4"});
            deleteEvtHeadSqlBuilder.appendIn("and fsrc_billid", billIds.toArray());
            DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteEvtHeadSqlBuilder);
        }
    }

    private static void deleteByEvtHeadIds(List<Long> evtHeadIds, int sqlExecuteBatchSize) {
        BuildEvtDataUtil.deleteByEvtHeadIds(evtHeadIds, sqlExecuteBatchSize, true);
        BuildEvtDataUtil.deleteByEvtHeadIds(evtHeadIds, sqlExecuteBatchSize, false);
    }

    private static void deleteByEvtHeadIds(List<Long> evtHeadIds, int sqlExecuteBatchSize, boolean isTempTable) {
        if (CollectionUtils.isEmpty(evtHeadIds)) {
            return;
        }
        String xlaHeadTable = isTempTable ? "t_fah_ae_headers_tmp" : "t_fah_ae_headers";
        String xlaLineTable = isTempTable ? "t_fah_ae_lines_tmp" : "t_fah_ae_lines";
        String evtLineTable = isTempTable ? "t_fah_event_line_tmp" : "t_fah_event_line";
        LinkedList<Long> xlaHeadIds = new LinkedList<Long>();
        boolean hasTmpOrFailedXla = false;
        SqlBuilder selectXlaHeadSqlBuilder = new SqlBuilder();
        selectXlaHeadSqlBuilder.appendIn("select fid from " + xlaHeadTable + " where fstatus = '4' and fsrceventid ", evtHeadIds.toArray());
        try (DataSet xlaHeadDs = DB.queryDataSet((String)"selectXlaHeadSqlBuilder", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)selectXlaHeadSqlBuilder);){
            while (xlaHeadDs.hasNext()) {
                hasTmpOrFailedXla = true;
                Row xlaHeadRow = xlaHeadDs.next();
                xlaHeadIds.add(xlaHeadRow.getLong("fid"));
                if (xlaHeadIds.size() < sqlExecuteBatchSize) continue;
                SqlBuilder deleteXlaLineSqlBuilder = new SqlBuilder();
                deleteXlaLineSqlBuilder.appendIn("delete from " + xlaLineTable + " where fid", xlaHeadIds.toArray());
                DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteXlaLineSqlBuilder);
                xlaHeadIds.clear();
            }
        }
        if (xlaHeadIds.size() > 0) {
            SqlBuilder deleteXlaLineSqlBuilder = new SqlBuilder();
            deleteXlaLineSqlBuilder.appendIn("delete from " + xlaLineTable + " where fid", xlaHeadIds.toArray());
            DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteXlaLineSqlBuilder);
            xlaHeadIds.clear();
        }
        if (hasTmpOrFailedXla) {
            SqlBuilder deleteXlaHeadSqlBuilder = new SqlBuilder();
            deleteXlaHeadSqlBuilder.appendIn("delete from " + xlaHeadTable + " where fstatus = '4' and fsrceventid", evtHeadIds.toArray());
            DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteXlaHeadSqlBuilder);
        }
        SqlBuilder deleteEvtLineSqlBuilder = new SqlBuilder();
        deleteEvtLineSqlBuilder.appendIn("delete from " + evtLineTable + " where fid", evtHeadIds.toArray());
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteEvtLineSqlBuilder);
    }

    public static void updateFahRequestFinal(long requestId, int totalBillCnt) {
        int totalFailedBillCnt = 0;
        SqlBuilder selectFailedBillCnt = new SqlBuilder();
        selectFailedBillCnt.append("select count(1) cnt from (", new Object[0]);
        selectFailedBillCnt.append("select a.fbilltype,a.fsrcbillid from t_fah_task_fail_bills a where a.frequestid = ? ", new Object[]{requestId});
        selectFailedBillCnt.append(" union ", new Object[0]);
        selectFailedBillCnt.append("select a.fbilltype,a.fsrcbillid from t_fah_task_skip_bills a where a.frequestid = ? ", new Object[]{requestId});
        selectFailedBillCnt.append(" ) t ", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"selectFailedBillCnt", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)selectFailedBillCnt);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                totalFailedBillCnt = row.getInteger("cnt");
            }
        }
        SqlBuilder selectTotalEvtCnt = new SqlBuilder();
        selectTotalEvtCnt.append("select count(1) cnt from t_fah_event_header ", new Object[0]);
        selectTotalEvtCnt.append(" where frequestid = ? ", new Object[]{requestId});
        selectTotalEvtCnt.append(" and fstatus = ? ", new Object[]{"4"});
        int totalEvtBillCnt = 0;
        try (DataSet dataSet = DB.queryDataSet((String)"selectTotalEvtCnt", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)selectTotalEvtCnt);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                totalEvtBillCnt = row.getInteger("cnt");
            }
        }
        int noGenEvtCnt = FahNoEvtBillsDao.queryNoGenEvtCnt(requestId);
        FahRequestTaskDaoImpl.updateFahRequestFinal(requestId, totalBillCnt, totalFailedBillCnt, totalEvtBillCnt, noGenEvtCnt);
    }

    public static Map<Long, Boolean> queryEvtHeadAccountMap(Collection<Long> evtHeadIds) {
        if (CollectionUtils.isEmpty(evtHeadIds)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Boolean> evtHeadAccountMap = new HashMap<Long, Boolean>(evtHeadIds.size());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,a.fneedacct from t_fah_event_header a ", new Object[0]);
        sqlBuilder.appendIn("where a.fid", evtHeadIds.toArray());
        sqlBuilder.append("and fstatus = ?", new Object[]{"4"});
        try (DataSet dataSet = DB.queryDataSet((String)"queryEvtHeadAccountMap", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                evtHeadAccountMap.put(row.getLong("fid"), row.getBoolean("fneedacct"));
            }
        }
        return evtHeadAccountMap;
    }

    public static String buildUnMatchConditionFieldValue(String billType, ValueZone valueZone, List<ConditionField> conditionFields, List<Object> conditionValueList) {
        String valueZoneEntity = valueZone.getEntityName();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
        EntityType entityType = (EntityType)mainEntityType.getAllEntities().get(valueZoneEntity);
        String valueZoneName = entityType.getDisplayName().getLocaleValue();
        String unMatchMsg = ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u4e8b\u4ef6\u89c4\u5219", (String)"BuildEvtDataUtil_8", (String)"fi-ai-business", (Object[])new Object[0]);
        String conditionMsg = BuildEvtDataUtil.buildConditionFieldValue(conditionFields, conditionValueList);
        return ResManager.loadKDString((String)"\u5355\u636e\u5728\u6240\u5c5e\u53d6\u503c\u533a\u57df\u201c%1$s\u201d[%2$s]%3$s\uff0c%4$s", (String)"BuildEvtDataUtil_1", (String)"fi-ai-business", (Object[])new Object[]{valueZoneName, valueZoneEntity, unMatchMsg, conditionMsg});
    }

    public static String buildNoNeedGenEvtConditionFieldValue(String billType, ValueZone valueZone, List<ConditionField> conditionFields, List<Object> conditionValueList) {
        String valueZoneEntity = valueZone.getEntityName();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
        EntityType entityType = (EntityType)mainEntityType.getAllEntities().get(valueZoneEntity);
        String valueZoneName = entityType.getDisplayName().getLocaleValue();
        String noNeedGenEvtMsg = ResManager.loadKDString((String)"\u5339\u914d\u5230\u65e0\u9700\u4ea7\u751f\u4e8b\u4ef6", (String)"BuildEvtDataUtil_9", (String)"fi-ai-business", (Object[])new Object[0]);
        String conditionMsg = BuildEvtDataUtil.buildConditionFieldValue(conditionFields, conditionValueList);
        return ResManager.loadKDString((String)"\u5355\u636e\u5728\u6240\u5c5e\u53d6\u503c\u533a\u57df\u201c%1$s\u201d[%2$s]%3$s\uff0c%4$s", (String)"BuildEvtDataUtil_1", (String)"fi-ai-business", (Object[])new Object[]{valueZoneName, valueZoneEntity, noNeedGenEvtMsg, conditionMsg});
    }

    public static String buildConditionFieldValue(List<ConditionField> conditionFields, List<Object> conditionValueList) {
        StringBuilder stringBuilder = new StringBuilder();
        if (CollectionUtils.isEmpty(conditionFields)) {
            stringBuilder.append(ResManager.loadKDString((String)"\u672a\u542f\u7528\u6761\u4ef6\u5b57\u6bb5", (String)"BuildEvtDataUtil_0", (String)"fi-ai-business", (Object[])new Object[0]));
        } else {
            for (int i = 0; i < conditionFields.size(); ++i) {
                ConditionField conditionField = conditionFields.get(i);
                String fieldName = conditionField.getFieldName();
                Object conditionFieldValue = conditionValueList.get(i);
                stringBuilder.append(fieldName).append(": ").append(conditionFieldValue);
                if (i >= conditionFields.size() - 1) continue;
                stringBuilder.append(",");
            }
        }
        return ResManager.loadKDString((String)"\u6761\u4ef6\u5b57\u6bb5\u503c\u4e3a\uff1a[%s]", (String)"BuildEvtDataUtil_10", (String)"fi-ai-business", (Object[])new Object[]{stringBuilder.toString()});
    }

    public static EvtHeadInfo genEvtHeadInfo(Long srcBillEntryId, BuildEvtContext buildEvtContext) {
        Long eventId = buildEvtContext.pollEventId();
        String eventNo = buildEvtContext.pollEventNo();
        EvtHeadInfo evtHeadInfo = new EvtHeadInfo();
        evtHeadInfo.setBillId(srcBillEntryId);
        evtHeadInfo.setEvtNo(eventNo);
        evtHeadInfo.setEvtHeadId(eventId);
        return evtHeadInfo;
    }

    public static <K, V> List<Map<K, V>> splitMap(Map<K, V> originalMap, int chunkSize) {
        if (null == originalMap || originalMap.isEmpty()) {
            return Collections.emptyList();
        }
        if (originalMap.size() <= chunkSize) {
            return Collections.singletonList(originalMap);
        }
        int batchCnt = originalMap.size() / chunkSize + originalMap.size() % chunkSize == 0 ? 0 : 1;
        ArrayList<Map<K, V>> listOfMaps = new ArrayList<Map<K, V>>(batchCnt);
        HashMap<K, V> currentMap = new HashMap<K, V>(chunkSize);
        listOfMaps.add(currentMap);
        for (Map.Entry<K, V> entry : originalMap.entrySet()) {
            if (currentMap.size() == chunkSize) {
                currentMap = new HashMap(chunkSize);
                listOfMaps.add(currentMap);
            }
            currentMap.put(entry.getKey(), entry.getValue());
        }
        return listOfMaps;
    }

    public static void writeBackBillVchStatus(long requestId, boolean isException, Map<String, Set<Long>> processingBillsMap, FahEventGenOprEnum eventGenOprEnum, FahJobContext fahJobContext) {
        boolean writeBack = Boolean.parseBoolean(SysParamConfig.get((String)"fah.evt.billVchStatus.writeBack", (String)"true"));
        logger.info(String.format("buildEventData_updateBillEventStatus start, requestId: %1$d, writeBack: %2$b", requestId, writeBack));
        if (!writeBack) {
            return;
        }
        ThreadPools.executeOnce((String)"writeBackBillEventStatus", () -> {
            try {
                if (FahEventGenOprEnum.REVERSE_GL_XLA_EVENT == eventGenOprEnum) {
                    BuildEvtDataUtil.writeBackBillVchStatusAsyncWhenReverse(requestId, isException);
                } else {
                    fahJobContext.getFahBgTaskLogger().addDetailEntry("buildEventData_writeBackBillVchStatusAsync start, requestId: " + requestId + "eventGenOprEnum:" + eventGenOprEnum);
                    BuildEvtDataUtil.writeBackBillVchStatusAsync(requestId, isException, processingBillsMap, eventGenOprEnum, fahJobContext);
                    fahJobContext.getFahBgTaskLogger().addDetailEntry("buildEventData_writeBackBillVchStatusAsync end, requestId: " + requestId + "eventGenOprEnum:" + eventGenOprEnum);
                }
            }
            catch (Exception e) {
                logger.error("buildEventData_writeBackBillVchStatus err, requestId: {}, ", (Object)requestId, (Object)e);
                if (FahEventGenOprEnum.REVERSE_GL_XLA_EVENT != eventGenOprEnum) {
                    String traceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    fahJobContext.getFahBgTaskLogger().addDetailEntryErr("buildEventData_writeBackBillVchStatus,err:" + traceMessage);
                }
            }
            finally {
                if (FahEventGenOprEnum.REVERSE_GL_XLA_EVENT != eventGenOprEnum) {
                    fahJobContext.setWriteBackTaskUsing(false);
                    fahJobContext.close();
                }
            }
        });
    }

    private static void writeBackBillVchStatusAsyncWhenReverse(long requestId, boolean isException) {
        String paramsInfo = String.format("buildEventData_writeBackBillVchStatusAsyncWhenReverse params, requestId: %d, isException: %b", requestId, isException);
        logger.info(paramsInfo);
        HashMap<String, Map<Long, FahBillEvtStatusBaseDataEnum>> writeBackBillStatusMap = new HashMap<String, Map<Long, FahBillEvtStatusBaseDataEnum>>(16);
        HashMap<String, Map<Long, FahBillEvtStatusBaseDataEnum>> writeBackBillStatusMapForDap = new HashMap<String, Map<Long, FahBillEvtStatusBaseDataEnum>>(16);
        Map postGlMap = Collections.emptyMap();
        if (isException) {
            PairTuple<Map<String, Set<Long>>, Map<String, Set<Long>>> failMapTuple = ReverseBillDataTaskDaoImpl.queryFailBillTypeAndBillIdsMap(requestId, true);
            BuildEvtDataUtil.addAllToResultMap(writeBackBillStatusMap, (Map)failMapTuple.getValue(), FahBillEvtStatusBaseDataEnum.EQUAL_CR_OR_DR);
            BuildEvtDataUtil.addAllToResultMap(writeBackBillStatusMap, (Map)failMapTuple.getKey(), FahBillEvtStatusBaseDataEnum.VOUCHER);
        } else {
            PairTuple<Map<String, Map<Long, Set<Long>>>, Map<String, Set<Long>>> successMapTuple = EventTrackerDao.querySuccessBillTypeAndBillIdsMap(requestId);
            postGlMap = (Map)successMapTuple.getKey();
            Map<String, Set<Long>> postGlBillIdsMap = postGlMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).keySet()));
            BuildEvtDataUtil.addAllToResultMap(writeBackBillStatusMap, (Map)successMapTuple.getValue(), FahBillEvtStatusBaseDataEnum.REVERSED);
            BuildEvtDataUtil.addAllToResultMap(writeBackBillStatusMap, postGlBillIdsMap, FahBillEvtStatusBaseDataEnum.CROSS);
            BuildEvtDataUtil.addAllToResultMap(writeBackBillStatusMapForDap, postGlBillIdsMap, FahBillEvtStatusBaseDataEnum.CROSS);
            PairTuple<Map<String, Set<Long>>, Map<String, Set<Long>>> failMapTuple = ReverseBillDataTaskDaoImpl.queryFailBillTypeAndBillIdsMap(requestId, false);
            BuildEvtDataUtil.addAllToResultMap(writeBackBillStatusMap, (Map)failMapTuple.getValue(), FahBillEvtStatusBaseDataEnum.EQUAL_CR_OR_DR);
            BuildEvtDataUtil.addAllToResultMap(writeBackBillStatusMap, (Map)failMapTuple.getKey(), FahBillEvtStatusBaseDataEnum.VOUCHER);
        }
        Map<Long, String> vchIdNoMap = BuildEvtDataUtil.queryGLVchNo(postGlMap);
        BuildEvtDataUtil.executeDapWriteBackPlugin(writeBackBillStatusMapForDap, postGlMap, vchIdNoMap, null);
        BuildEvtDataUtil.executeFahWriteBack(writeBackBillStatusMap, null);
    }

    private static void writeBackBillVchStatusAsync(long requestId, boolean isException, Map<String, Set<Long>> processingBillsMap, FahEventGenOprEnum eventGenOprEnum, FahJobContext fahJobContext) {
        String paramsInfo = String.format("buildEventData_writeBackBillVchStatusAsync params, requestId: %d, isException: %b, eventGenOprEnum: %s, processingBillsMap: %s", requestId, isException, eventGenOprEnum.name(), FahBgTaskLogger.logSizeOrDetail2(processingBillsMap));
        fahJobContext.getFahBgTaskLogger().addDetailEntry(paramsInfo);
        HashMap<String, Map<Long, FahBillEvtStatusBaseDataEnum>> writeBackBillStatusMap = new HashMap<String, Map<Long, FahBillEvtStatusBaseDataEnum>>(16);
        HashMap<String, Map<Long, FahBillEvtStatusBaseDataEnum>> writeBackBillStatusMapForDap = new HashMap<String, Map<Long, FahBillEvtStatusBaseDataEnum>>(16);
        Map postGlMap = Collections.emptyMap();
        if (isException) {
            BuildEvtDataUtil.addAllToResultMap(writeBackBillStatusMap, processingBillsMap, FahBillEvtStatusBaseDataEnum.FAIL);
        } else {
            Map<String, Set<Long>> noEvtMap = FahRequestTaskDaoImpl.queryNeedWriteBackNoEvtBillTypeAndBillIdsMap(requestId);
            BuildEvtDataUtil.addAllToResultMap(writeBackBillStatusMap, noEvtMap, FahBillEvtStatusBaseDataEnum.SHELF);
            if (eventGenOprEnum == FahEventGenOprEnum.CREATE_TMP_EVENT) {
                Map<String, Set<Long>> successTempMap = FahXLADaoImpl.getInstance().querySuccessTmpEvtBillTypeAndBillIdsMap(requestId);
                BuildEvtDataUtil.addAllToResultMap(writeBackBillStatusMap, successTempMap, FahBillEvtStatusBaseDataEnum.TEMPORARY);
            } else {
                PairTuple<Map<String, Map<Long, Set<Long>>>, Map<String, Set<Long>>> successMapTuple = EventTrackerDao.querySuccessBillTypeAndBillIdsMap(requestId);
                postGlMap = (Map)successMapTuple.getKey();
                Map<String, Set<Long>> postGlBillIdsMap = postGlMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).keySet()));
                BuildEvtDataUtil.addAllToResultMap(writeBackBillStatusMap, (Map)successMapTuple.getValue(), FahBillEvtStatusBaseDataEnum.EQUAL_CR_OR_DR);
                BuildEvtDataUtil.addAllToResultMap(writeBackBillStatusMap, postGlBillIdsMap, FahBillEvtStatusBaseDataEnum.VOUCHER);
                BuildEvtDataUtil.addAllToResultMap(writeBackBillStatusMapForDap, postGlBillIdsMap, FahBillEvtStatusBaseDataEnum.VOUCHER);
            }
            Map<String, Set<Long>> failMap = FahRequestTaskDaoImpl.queryFailBillTypeAndBillIdsMap(requestId);
            BuildEvtDataUtil.addAllToResultMap(writeBackBillStatusMap, failMap, FahBillEvtStatusBaseDataEnum.FAIL);
        }
        fahJobContext.getFahBgTaskLogger().addDetailEntry("buildEventData_writeBackBillVchStatusAsync postGlMap: " + FahBgTaskLogger.logSizeOrDetail2(postGlMap));
        Map<Long, String> vchIdNoMap = BuildEvtDataUtil.queryGLVchNo(postGlMap);
        fahJobContext.getFahBgTaskLogger().addDetailEntry("buildEventData_writeBackBillVchStatusAsync vchIdNoMap: " + FahBgTaskLogger.logSizeOrDetail2(vchIdNoMap));
        BuildEvtDataUtil.executeDapWriteBackPlugin(writeBackBillStatusMapForDap, postGlMap, vchIdNoMap, fahJobContext);
        fahJobContext.getFahBgTaskLogger().addDetailEntry("buildEventData_writeBackBillVchStatusAsync writeBackBillStatusMap: " + FahBgTaskLogger.logSizeOrDetail2(writeBackBillStatusMap));
        BuildEvtDataUtil.executeFahWriteBack(writeBackBillStatusMap, fahJobContext);
    }

    private static Map<Long, String> queryGLVchNo(Map<String, Map<Long, Set<Long>>> postGlMap) {
        if (postGlMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet<Long> vchIds = new HashSet<Long>(8);
        for (Map<Long, Set<Long>> billIdVchIdsMap : postGlMap.values()) {
            for (Set<Long> billIdVchIds : billIdVchIdsMap.values()) {
                vchIds.addAll(billIdVchIds);
            }
        }
        if (vchIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> vchIdNoMap = new HashMap<Long, String>(vchIds.size());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, fnumber from t_gl_voucher where ", new Object[0]);
        sqlBuilder.appendIn("fid", vchIds.toArray());
        try (DataSet dataSet = DB.queryDataSet((String)"", (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                vchIdNoMap.put(row.getLong("fid"), row.getString("fnumber"));
            }
        }
        return vchIdNoMap;
    }

    private static void executeFahWriteBack(Map<String, Map<Long, FahBillEvtStatusBaseDataEnum>> writeBackBillStatusMap, FahJobContext fahJobContext) {
        if (writeBackBillStatusMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<Long, FahBillEvtStatusBaseDataEnum>> entry : writeBackBillStatusMap.entrySet()) {
            String billType = entry.getKey();
            Map<Long, FahBillEvtStatusBaseDataEnum> billEvtStatusMap = entry.getValue();
            Map<FahBillEvtStatusBaseDataEnum, Set<Long>> billEvtStatusGroupMap = BuildEvtDataUtil.groupByStatus(billEvtStatusMap);
            FahWriteBackSqlExecutor writeBackSqlExecutor = new FahWriteBackSqlExecutor(billType);
            if (null != fahJobContext) {
                String msg = String.format("buildEventData_executeFahWriteBack billType: %s,  writeBackSqlExecutor: %s,  billEvtStatusGroupMap: %s", billType, writeBackSqlExecutor, FahBgTaskLogger.logSizeOrDetail2(billEvtStatusGroupMap));
                fahJobContext.getFahBgTaskLogger().addDetailEntry(msg);
            }
            for (Map.Entry<FahBillEvtStatusBaseDataEnum, Set<Long>> groupEntry : billEvtStatusGroupMap.entrySet()) {
                FahBillEvtStatusBaseDataEnum billEvtStatusEnum = groupEntry.getKey();
                Set<Long> billIds = groupEntry.getValue();
                writeBackSqlExecutor.execute("executeFahWriteBack", billEvtStatusEnum, billIds);
            }
        }
    }

    private static Map<FahBillEvtStatusBaseDataEnum, Set<Long>> groupByStatus(Map<Long, FahBillEvtStatusBaseDataEnum> billEvtStatusMap) {
        return billEvtStatusMap.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toSet())));
    }

    private static void executeDapWriteBackPlugin(Map<String, Map<Long, FahBillEvtStatusBaseDataEnum>> writeBackBillStatusMapForDap, Map<String, Map<Long, Set<Long>>> postGlMap, Map<Long, String> vchIdNoMap, FahJobContext fahJobContext) {
        if (writeBackBillStatusMapForDap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<Long, FahBillEvtStatusBaseDataEnum>> entry : writeBackBillStatusMapForDap.entrySet()) {
            String billType = entry.getKey();
            FahWriteBackPluginExecutor pluginExecutor = new FahWriteBackPluginExecutor(billType, postGlMap, vchIdNoMap);
            Map<Long, FahBillEvtStatusBaseDataEnum> billEvtStatusMap = entry.getValue();
            Map<FahBillEvtStatusBaseDataEnum, Set<Long>> billEvtStatusGroupMap = BuildEvtDataUtil.groupByStatus(billEvtStatusMap);
            if (null != fahJobContext) {
                String msg = String.format("buildEventData_executeDapWriteBackPlugin billType: %s, pluginExecutor: %s, billEvtStatusGroupMap: %s", billType, pluginExecutor, FahBgTaskLogger.logSizeOrDetail2(billEvtStatusGroupMap));
                fahJobContext.getFahBgTaskLogger().addDetailEntry(msg);
            }
            for (Map.Entry<FahBillEvtStatusBaseDataEnum, Set<Long>> groupEntry : billEvtStatusGroupMap.entrySet()) {
                FahBillEvtStatusBaseDataEnum billEvtStatusEnum = groupEntry.getKey();
                Set<Long> billIds = groupEntry.getValue();
                pluginExecutor.execute(billEvtStatusEnum, billIds);
            }
        }
    }

    private static void addAllToResultMap(Map<String, Map<Long, FahBillEvtStatusBaseDataEnum>> relsultMap, Map<String, Set<Long>> billTypeAndBillIdsMap, FahBillEvtStatusBaseDataEnum billEvtStatusEnum) {
        for (Map.Entry<String, Set<Long>> billTypeAndBillIdsMapEntry : billTypeAndBillIdsMap.entrySet()) {
            String billType = billTypeAndBillIdsMapEntry.getKey();
            Set<Long> billIds = billTypeAndBillIdsMapEntry.getValue();
            Map billEvtStatusMap = relsultMap.computeIfAbsent(billType, k -> new HashMap(billIds.size()));
            for (Long billId : billIds) {
                billEvtStatusMap.put(billId, billEvtStatusEnum);
            }
        }
    }

    public static void updateBillVchStatusProcessing(String billType, Collection<Long> billIds) {
        if (StringUtils.isEmpty((String)billType) || CollectionUtils.isEmpty(billIds)) {
            return;
        }
        boolean writeBack = Boolean.parseBoolean(SysParamConfig.get((String)"fah.evt.billVchStatus.writeBack", (String)"true"));
        if (!writeBack) {
            return;
        }
        FahWriteBackSqlExecutor updateSqlExecutor = new FahWriteBackSqlExecutor(billType);
        updateSqlExecutor.execute("updateBillEventStatusProcessing", FahBillEvtStatusBaseDataEnum.PROCESS, billIds);
    }

    public static boolean checkAmountWithCurrency(Object amount, Object currencyId) {
        BigDecimal amountBigDecimal;
        if (amount == null) {
            return true;
        }
        if (amount instanceof BigDecimal) {
            amountBigDecimal = (BigDecimal)amount;
        } else {
            try {
                amountBigDecimal = new BigDecimal(amount.toString());
            }
            catch (NumberFormatException e) {
                return true;
            }
        }
        if (null == currencyId || (Long)currencyId == 0L) {
            return true;
        }
        Currency currency = FahCheckXLADataDao.getCurrencyFromThreadCache((Long)currencyId);
        if (null == currency) {
            return true;
        }
        return ICommonDataValueUtil.checkNumberScale((BigDecimal)amountBigDecimal, (int)currency.getAmtprecision());
    }

    private static class BillIdsIterator1<T>
    implements Iterator<PairTuple<String, Collection<Long>>> {
        private final Long requestId;
        private final Queue<PairTuple<String, Long>> batchIds;
        private final int buildEvtBillBatchSize;

        public BillIdsIterator1(Map<String, Object> params, String billType, Collection<Long> billIds) {
            Map option = (Map)params.get("option");
            this.requestId = Long.parseLong((String)option.get("taskid"));
            this.batchIds = this.getBatchIds();
            this.buildEvtBillBatchSize = Integer.parseInt(SysParamConfig.get((String)"fah.evt.buildEvtBillBatchSize", (String)"999"));
        }

        private Queue<PairTuple<String, Long>> getBatchIds() {
            LinkedList<PairTuple<String, Long>> batchIds = new LinkedList<PairTuple<String, Long>>();
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid,fbilltype from t_fah_task_batch where frequestid = ? order by fseqno", new Object[]{this.requestId});
            try (DataSet dataSet = DB.queryDataSet((String)"BillIdsIterator1.getBatchIds", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    batchIds.offer((PairTuple<String, Long>)new PairTuple((Object)row.getString("fbilltype"), (Object)row.getLong("fid")));
                }
            }
            return batchIds;
        }

        @Override
        public boolean hasNext() {
            return !this.batchIds.isEmpty();
        }

        @Override
        public PairTuple<String, Collection<Long>> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("BillIdsIterator contains no elements");
            }
            PairTuple<String, Long> billTypeAndBatchId = this.batchIds.remove();
            return this.queryByBatchId((Long)billTypeAndBatchId.getValue(), (String)billTypeAndBatchId.getKey());
        }

        private PairTuple<String, Collection<Long>> queryByBatchId(Long batchId, String billType) {
            HashSet<Long> billIds = new HashSet<Long>(this.buildEvtBillBatchSize);
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fsrcbillid from t_fah_task_batch_en ", new Object[0]);
            sqlBuilder.append(" where fid = ? ", new Object[]{batchId});
            sqlBuilder.append("  order by fseqno", new Object[0]);
            try (DataSet dataSet = DB.queryDataSet((String)"BillIdsIterator1.getBatchIds", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    billIds.add(row.getLong("fsrcbillid"));
                }
            }
            return new PairTuple((Object)billType, billIds);
        }
    }

    public static class BillIdsIterator<T>
    implements Iterator<PairTuple<String, Collection<Long>>> {
        private static final String COLON = ":";
        private static final String CACHE_KEY_PREFIX = "BuildEventAndXLA";
        private static final String PK_ALIAS = "id";
        private final boolean isCustom;
        private final boolean idsUseCache;
        private final int buildEvtBillBatchSize;
        private Collection<String> billTypes;
        private Map<String, DataSet> billTypeDataSetCacheMap;
        private Map<String, List<String>> billTypeStatusMap;
        private Map<String, PairTuple<String, String>> dateOrgFiledByBillTypes;
        private Collection<Long> orgIds;
        private Date startDate;
        private Date endDate;
        private String billType;
        private Collection<Long> cachedIds;
        private PairTuple<String, Collection<Long>> cachedNext;
        private PairTuple<String, Collection<Long>> noCacheBatch;

        public BillIdsIterator(Map<String, Object> params, String billType, Collection<Long> billIds) {
            Map option = (Map)params.get("option");
            this.isCustom = "1".equals(option.get("iscustom"));
            this.idsUseCache = "1".equals(option.get("idsusecache"));
            this.buildEvtBillBatchSize = Integer.parseInt(SysParamConfig.get((String)"fah.evt.buildEvtBillBatchSize", (String)"999"));
            if (this.isCustom) {
                this.orgIds = JSON.parseArray((String)((String)option.get("orgs")), Long.class);
                this.billTypes = JSON.parseArray((String)((String)option.get("billtypes")), String.class);
                this.billTypeDataSetCacheMap = new HashMap<String, DataSet>(this.billTypes.size());
                this.dateOrgFiledByBillTypes = EventGenTaskUtils.getDateOrgFiledByBillTypes(this.billTypes);
                this.startDate = new Date(Long.parseLong((String)option.get("startdate")));
                this.endDate = new Date(Long.parseLong((String)option.get("enddate")));
                this.billTypeStatusMap = EventGenTaskUtils.genBillTypeStatusMap(this.billTypes);
            } else if (this.idsUseCache) {
                this.billType = billType;
                this.cachedIds = this.initCachedIds(Long.parseLong((String)option.get("taskid")));
            } else {
                this.noCacheBatch = new PairTuple((Object)billType, billIds);
            }
        }

        @Override
        public boolean hasNext() {
            this.cachedNext = this.prepareNext();
            return this.cachedNext != null;
        }

        @Override
        public PairTuple<String, Collection<Long>> next() {
            if (null == this.cachedNext) {
                throw new NoSuchElementException("BillIdsIterator contains no elements");
            }
            return this.cachedNext;
        }

        private PairTuple<String, Collection<Long>> prepareNext() {
            if (this.isCustom) {
                return this.getResultFromDB();
            }
            if (this.idsUseCache) {
                return this.getResultFromCache();
            }
            if (this.noCacheBatch != null) {
                PairTuple<String, Collection<Long>> tmp = this.noCacheBatch;
                this.noCacheBatch = null;
                return tmp;
            }
            return null;
        }

        private PairTuple<String, Collection<Long>> getResultFromCache() {
            Iterator<Long> cacheIdsIterator = this.cachedIds.iterator();
            HashSet<Long> batchBillIds = new HashSet<Long>(this.buildEvtBillBatchSize);
            while (cacheIdsIterator.hasNext()) {
                Long billId = cacheIdsIterator.next();
                cacheIdsIterator.remove();
                batchBillIds.add(billId);
                if (batchBillIds.size() < this.buildEvtBillBatchSize) continue;
                return new PairTuple((Object)this.billType, batchBillIds);
            }
            return batchBillIds.size() > 0 ? new PairTuple((Object)this.billType, batchBillIds) : null;
        }

        private PairTuple<String, Collection<Long>> getResultFromDB() {
            Iterator<String> iterator = this.billTypes.iterator();
            while (iterator.hasNext()) {
                HashSet<Long> billIds = new HashSet<Long>(this.buildEvtBillBatchSize);
                String currBillType = iterator.next();
                DataSet dataSet = this.billTypeDataSetCacheMap.computeIfAbsent(currBillType, k -> this.queryBillIdsDataSetByBillType(currBillType));
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    billIds.add(row.getLong(PK_ALIAS));
                    if (billIds.size() < this.buildEvtBillBatchSize) continue;
                    return new PairTuple((Object)currBillType, billIds);
                }
                dataSet.close();
                this.billTypeDataSetCacheMap.remove(currBillType);
                iterator.remove();
                if (!CollectionUtils.isNotEmpty(billIds)) continue;
                return new PairTuple((Object)currBillType, billIds);
            }
            return null;
        }

        private DataSet queryBillIdsDataSetByBillType(String billType) {
            PairTuple<String, String> dateOrgFieldTuple = this.dateOrgFiledByBillTypes.get(billType);
            String dateField = (String)dateOrgFieldTuple.getKey();
            String orgField = (String)dateOrgFieldTuple.getValue();
            QFBuilder qfBuilder = new QFBuilder();
            if (CollectionUtils.isNotEmpty(this.orgIds)) {
                qfBuilder.add(orgField, "in", this.orgIds);
            }
            if (this.startDate != null) {
                qfBuilder.add(dateField, ">=", (Object)this.startDate);
            }
            if (this.endDate != null) {
                qfBuilder.add(dateField, "<=", (Object)this.endDate);
            }
            if (this.billTypeStatusMap != null) {
                List<String> billStatus = this.billTypeStatusMap.get(billType);
                qfBuilder.add("billstatus", "in", billStatus);
            }
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
            String pkField = dataEntityType.getPrimaryKey().getName();
            String select = pkField + " " + PK_ALIAS;
            return QueryServiceHelper.queryDataSet((String)"queryBillIdsDataSetByBillType", (String)billType, (String)select, (QFilter[])qfBuilder.toArray(), (String)pkField);
        }

        private Collection<Long> initCachedIds(Long requestId) {
            DistributeSessionlessCache taskStatusCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ai");
            String billIdsCacheKey = BillIdsIterator.getBillIdsCacheKey(requestId);
            String[] idStringArray = taskStatusCache.getList(billIdsCacheKey);
            return Arrays.stream(idStringArray).map(Long::parseLong).collect(Collectors.toList());
        }

        public static String getBillIdsCacheKey(Long requestId) {
            RequestContext requestContext = RequestContext.get();
            return Instance.getClusterName() + COLON + requestContext.getAccountId() + COLON + CACHE_KEY_PREFIX + COLON + requestId;
        }
    }
}

