/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.dao.event.FahRegBillDao;
import kd.fi.v2.fah.dao.task.FahRequestTaskDaoImpl;
import kd.fi.v2.fah.dto.FahRegBillDTO;
import kd.fi.v2.fah.dto.FahRegBillEntryDTO;
import kd.fi.v2.fah.dto.FahRegBillInfo;
import kd.fi.v2.fah.models.register.RegisterBillType;
import kd.fi.v2.fah.models.register.RegisterBillTypeCollection;
import kd.fi.v2.fah.utils.StringUtils;

public class EventGenTaskUtils {
    public static Set<Long> queryEventPksByRequestId(Long requestId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid from t_fah_event_header where frequestid = ?", new Object[]{requestId}).append("and fstatus = ?", new Object[]{"4"});
        try (DataSet dataSet = DB.queryDataSet((String)"queryEventPksByRequestId", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            HashSet<Long> result = new HashSet<Long>(16);
            while (dataSet.hasNext()) {
                result.add(dataSet.next().getLong("fid"));
            }
            HashSet<Long> hashSet = result;
            return hashSet;
        }
    }

    public static Set<String> getRegisteredBillNums() {
        return FahRegBillDao.getRegBillNumbers();
    }

    public static Map<String, PairTuple<String, String>> getDateOrgFiledByBillTypes(Collection<String> billTypes) {
        return FahRegBillDao.batchQuerySrcDateAndSrcOrg(billTypes);
    }

    public static RegisterBillTypeCollection getRegisterDateOrgFiled() {
        List<FahRegBillDTO> fahRegBillDTOS = FahRegBillDao.queryAllEnableInfo();
        RegisterBillTypeCollection registerBillTypeCollection = new RegisterBillTypeCollection();
        fahRegBillDTOS.forEach(dto -> {
            RegisterBillType registerBillType = new RegisterBillType();
            registerBillType.setBillType(dto.getSrcBillType());
            List<FahRegBillEntryDTO> entry = dto.getEntry();
            if (entry != null && !entry.isEmpty()) {
                registerBillType.setEnabledBillStatus(entry.stream().map(FahRegBillEntryDTO::getSrcBillStatusVal).collect(Collectors.toSet()));
                registerBillType.setRegisterFieldNumbers(new String[]{dto.getSrcBillOrgField(), entry.get(0).getSrcBillDateFieldNum()});
            } else {
                registerBillType.setEnabledBillStatus(new HashSet<String>(2));
                registerBillType.setRegisterFieldNumbers(new String[]{dto.getSrcBillOrgField(), ""});
            }
            registerBillTypeCollection.addRegisterBillType(registerBillType);
        });
        return registerBillTypeCollection;
    }

    public static void updateFahRequestTask(Long requestId, String message) {
        FahRequestTaskDaoImpl.updateFahRequestTask(requestId, message, false);
    }

    public static void updateFahRequestTaskWithBizDataErr(Long requestId, String message) {
        FahRequestTaskDaoImpl.updateFahRequestTask(requestId, message, true);
    }

    public static Map<String, List<String>> genBillTypeStatusMap(Collection<String> billTypes) {
        return FahRegBillDao.getBillType2Status(billTypes);
    }

    private static List<String> generateStatusList(String srcbillstatus) {
        String[] split = srcbillstatus.split(",");
        LinkedList<String> list = new LinkedList<String>();
        for (String s : split) {
            if (!StringUtils.isNotEmpty((String)s)) continue;
            list.add(s);
        }
        return list;
    }

    public static String getBillEvtStatusFieldNum(String billType) {
        FahRegBillInfo regBillInfo = EventGenTaskUtils.getFahRegBillInfoCached(billType);
        return regBillInfo.getEvtStatusFieldNum();
    }

    public static String getWriteBackPlugin(String billType) {
        FahRegBillInfo regBillInfo = EventGenTaskUtils.getFahRegBillInfoCached(billType);
        return regBillInfo.getWriteBackPlugin();
    }

    public static FahRegBillInfo getFahRegBillInfoCached(String billType) {
        HashMap regBillInfoCache = (HashMap)ThreadCache.get((Object)"EventGenTaskUtils.getFahRegBillInfoCached", HashMap::new);
        return regBillInfoCache.computeIfAbsent(billType, EventGenTaskUtils::getFahRegBillInfo);
    }

    public static FahRegBillInfo getFahRegBillInfo(String billType) {
        List<FahRegBillDTO> fahRegBillDTOS = FahRegBillDao.batchQueryRegBillByBillType(Collections.singletonList(billType));
        if (fahRegBillDTOS.isEmpty() || fahRegBillDTOS.get(0).getEntry() == null || fahRegBillDTOS.get(0).getEntry().isEmpty()) {
            return new FahRegBillInfo("", "", "", "", "", "", "", "");
        }
        FahRegBillDTO regBillDTO = fahRegBillDTOS.get(0);
        FahRegBillEntryDTO entryDTO = regBillDTO.getEntry().get(0);
        return new FahRegBillInfo(regBillDTO.getSrcAppId(), regBillDTO.getSrcBillType(), regBillDTO.getWriteBackPlugin(), regBillDTO.getSrcBillStatusField(), regBillDTO.getSrcBillOrgField(), entryDTO.getSrcBillStatusVal(), entryDTO.getSrcBillDateFieldNum(), entryDTO.getEvtStatusFieldNum());
    }
}

