/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.dao.DaoFactory;
import kd.fi.v2.fah.dao.event.FahBizDimComDao;
import kd.fi.v2.fah.dao.event.FahEventRuleCfgDAO;
import kd.fi.v2.fah.dao.flex.MappingValueDaoImpl;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSet;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetData;
import kd.fi.v2.fah.models.event.eventrule.EvtRuleRelationDetailsDto;
import kd.fi.v2.fah.utils.StringUtils;

public class FahEventRuleUtils {
    public static String getAmountEntryNum(String groupId, DynamicExtractFieldValueSetData data) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)groupId);
        if (data != null) {
            String amountField = ((DynamicExtractFieldValueSet)data.getFieldValueSetList().get(0)).getTextValue();
            if (StringUtils.isEmpty((String)amountField)) {
                return null;
            }
            IDataEntityProperty prop = mainEntityType.findProperty(amountField.split("\\.")[0]);
            if (prop != null) {
                IDataEntityType parentProp = prop.getParent();
                if (parentProp == null || parentProp instanceof MainEntityType) {
                    return mainEntityType.getName();
                }
                return parentProp.getName();
            }
            return mainEntityType.getName();
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91d1\u989d\uff08\u539f\u5e01\uff09\u53d6\u503c\u3002", (String)"FahEventRulePlugin_6", (String)"fi-ai-formplugin", (Object[])new Object[0]));
    }

    public static FormShowParameter genCustomFormParam(Object[] selectOrg, DynamicObjectCollection entryCollection, Long dimGrpId, int formViewCode) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(entryCollection.size());
        for (DynamicObject dynamic : entryCollection) {
            Object[] objects = new Object[]{dynamic.get("sub_bizdim"), dynamic.get("sub_enable"), dynamic.get("sub_required"), dynamic.get("sub_presetvalue"), dynamic.get("sub_customvalue")};
            params.add(objects);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("fah_dim_customset");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("selectOrg", (Object)SerializationUtils.serializeToBase64((Object)selectOrg));
        parameter.setCustomParam("dimgrpid", (Object)dimGrpId);
        parameter.setCustomParam("params", (Object)SerializationUtils.serializeToBase64(params));
        parameter.setCustomParam("dimCustomStatus", (Object)formViewCode);
        parameter.setCustomParam("isFromEventRule", (Object)true);
        String[] groupData = FahEventRuleUtils.getCustomerData(dimGrpId);
        if (null != groupData) {
            parameter.setCustomParam("dimCustomSetGroupData", (Object)groupData[0]);
            parameter.setCustomParam("dimCustomSetOrgData", (Object)groupData[1]);
            parameter.setCustomParam("dimCustomSetEntryData", (Object)groupData[2]);
        }
        return parameter;
    }

    private static String[] getCustomerData(Long dimGrpId) {
        DynamicObjectCollection groupData = ((FahBizDimComDao)DaoFactory.getInstance(FahBizDimComDao.class)).queryGroupData(dimGrpId);
        if (!groupData.isEmpty()) {
            LinkedHashMap<String, List> orgGroupMap = new LinkedHashMap<String, List>();
            MappingValueDaoImpl dao = new MappingValueDaoImpl();
            LinkedList<PairTuple> groupList = new LinkedList<PairTuple>();
            LinkedList<Long> groupIds = new LinkedList<Long>();
            for (DynamicObject dynamic : groupData) {
                long groupId = dynamic.getLong("id");
                groupIds.add(groupId);
                List orglist = dao.queryOrgRecordsByTypeId(Long.valueOf(groupId));
                orgGroupMap.put(String.valueOf(groupId), orglist);
                groupList.add(new PairTuple((Object)groupId, (Object)new PairTuple((Object)dynamic.getString("number"), (Object)dynamic.getString("name"))));
            }
            DynamicObjectCollection collection = ((FahBizDimComDao)DaoFactory.getInstance(FahBizDimComDao.class)).queryEntryGroupData(dimGrpId, groupIds);
            LinkedHashMap<String, List> groupDataMap = new LinkedHashMap<String, List>();
            for (DynamicObject dynamic : collection) {
                groupDataMap.computeIfAbsent(String.valueOf(dynamic.get("fCustGrpID")), k -> new LinkedList()).add(new Object[]{dynamic.get("fBizDimTypeId"), dynamic.get("fbizdimtypenum"), dynamic.get("fIsEnabled"), dynamic.get("fIsRequired")});
            }
            return new String[]{SerializationUtils.serializeToBase64(groupList), SerializationUtils.serializeToBase64(orgGroupMap), SerializationUtils.serializeToBase64(groupDataMap)};
        }
        return null;
    }

    public static Map<Integer, LinkedHashSet<String>> getErrorMsg(DynamicObjectCollection entryEntity, boolean isEdit) {
        int entrySize = entryEntity.size();
        LinkedHashMap<Integer, LinkedHashSet<String>> messageMap = new LinkedHashMap<Integer, LinkedHashSet<String>>(entrySize);
        HashSet eventRuleIds = new HashSet(entrySize);
        entryEntity.forEach(v -> {
            long lineId = v.getLong("id");
            if (lineId != 0L) {
                eventRuleIds.add(lineId);
            }
        });
        if (isEdit && !eventRuleIds.isEmpty()) {
            DataSet rows = FahEventRuleCfgDAO.getAllDimGrpForCheck(eventRuleIds);
            Object object = null;
            try {
                for (Row row : rows) {
                    messageMap.computeIfAbsent(row.getInteger("lineseq"), v -> new LinkedHashSet()).add(String.valueOf(row.getInteger("dimgrpseq")));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (rows != null) {
                    if (object != null) {
                        try {
                            rows.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        rows.close();
                    }
                }
            }
        }
        Integer index = 1;
        for (DynamicObject obj : entryEntity) {
            DynamicObjectCollection bizDatas = obj.getDynamicObjectCollection("dimextract");
            int row = 1;
            for (DynamicObject bizdata : bizDatas) {
                long sub_presetvalue = bizdata.getLong("sub_presetvalueid");
                long sub_customvalue = bizdata.getLong("sub_customvalueid");
                if (bizdata.getBoolean("sub_enable") && sub_presetvalue == 0L && sub_customvalue == 0L) {
                    messageMap.computeIfAbsent(index, v -> new LinkedHashSet()).add(String.valueOf(row));
                } else {
                    Set rowSet = (Set)messageMap.get(index);
                    if (rowSet != null) {
                        rowSet.remove(String.valueOf(row));
                    }
                }
                ++row;
            }
            if (messageMap.get(index) == null || ((LinkedHashSet)messageMap.get(index)).isEmpty()) {
                messageMap.remove(index);
            }
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return messageMap;
    }

    public static List<EvtRuleRelationDetailsDto> getEvtRuleRelaDataList(DynamicObjectCollection relationSubEntry, Long lineTypeId) {
        ArrayList<EvtRuleRelationDetailsDto> dataList = new ArrayList<EvtRuleRelationDetailsDto>(relationSubEntry.size());
        for (DynamicObject row : relationSubEntry) {
            EvtRuleRelationDetailsDto dto = new EvtRuleRelationDetailsDto();
            dto.setSubEntryId(Long.valueOf(row.getLong("id")));
            dto.setLineType(lineTypeId);
            dto.setEventRule(Long.valueOf(row.getLong("evtrule_rel.id")));
            dto.setBillType(row.getString("billtype_rel.id"));
            dto.setRelationType(row.getString("relationtype"));
            dto.setRelationVal(row.getString("relationdetails"));
            dataList.add(dto);
        }
        return dataList;
    }
}

