/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.util.DateUtil;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.FahDataValsetEntryPropEnum;
import kd.fi.v2.fah.constant.enums.FahDataValsetPropEnum;
import kd.fi.v2.fah.constant.enums.FahValMapEntryPropEnum;
import kd.fi.v2.fah.constant.enums.FahValMapMultiValueEnum;
import kd.fi.v2.fah.constant.enums.FahValMapPropEnum;
import kd.fi.v2.fah.constant.enums.MappingValueType;
import kd.fi.v2.fah.converters.basedata.IDConvertNumberHelper;
import kd.fi.v2.fah.models.flex.FlexFieldCfg;
import kd.fi.v2.fah.models.flex.FlexFieldGrpCfg;
import kd.fi.v2.fah.models.mapping.MappingDataCollection;
import kd.fi.v2.fah.models.mapping.SingleLineMappingData;
import kd.fi.v2.fah.models.valueset.SingleValueSetData;
import kd.fi.v2.fah.models.valueset.ValueSetDataCollection;
import kd.fi.v2.fah.services.DBValueSetAndMappingServiceImpl;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.FahMappingUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FahFlexExportUtil {
    private static final Log logger = LogFactory.getLog(FahFlexExportUtil.class);
    private static final String BEFORE = "before";
    private static final String AFTER = "after";

    public static String export(Long id, String entityId, boolean withData) {
        OutputStream fos = null;
        FileInputStream fis = null;
        try {
            XSSFWorkbook workbook;
            MainEntityType valMapType = EntityMetadataCache.getDataEntityType((String)entityId);
            if ("fah_valmap_typenew".equals(entityId)) {
                workbook = FahFlexExportUtil.buildWorkBookOfMapping(entityId, id, withData);
            } else if ("fah_valueset_type".equals(entityId)) {
                workbook = FahFlexExportUtil.buildWorkBookOfValueSet(entityId, id, withData);
            } else {
                throw new IllegalArgumentException("Not support data type");
            }
            File temp = File.createTempFile(FilenameUtils.getName((String)UUID.randomUUID().toString()), ".xlsx");
            fos = Files.newOutputStream(temp.toPath(), new OpenOption[0]);
            workbook.write(fos);
            valMapType.getDisplayName().getLocaleValue();
            fis = new FileInputStream(temp);
            String fieldName = withData ? ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e.xlsx", (String)"FahFlexExportUtil_0", (String)"fi-ai-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f.xlsx", (String)"FahFlexExportUtil_1", (String)"fi-ai-business", (Object[])new Object[0]);
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(valMapType.getDisplayName().getLocaleValue() + fieldName, (InputStream)fis, 60);
            fis.close();
            String string = url;
            return string;
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    public static XSSFWorkbook buildWorkBookOfMapping(String entityId, Long id, boolean withData) {
        int i;
        XSSFWorkbook workbook = new XSSFWorkbook();
        DBValueSetAndMappingServiceImpl valueSetService = new DBValueSetAndMappingServiceImpl();
        MappingDataCollection mappingData = valueSetService.queryMappingData(id);
        FlexFieldGrpCfg meta = (FlexFieldGrpCfg)mappingData.getMeta();
        BaseMutableArrayMapStorage collections = (BaseMutableArrayMapStorage)meta.getCollections();
        XSSFSheet sheet1 = workbook.createSheet(ResManager.loadKDString((String)"\u6620\u5c04\u53d6\u503c", (String)"FahFlexExportUtil_3", (String)"fi-ai-business", (Object[])new Object[0]));
        XSSFRow noteRow = FahFlexExportUtil.getRow(sheet1, 0);
        FahFlexExportUtil.createCell(sheet1, noteRow, 0, FahFlexExportUtil.getCellStyle((Workbook)workbook, true, false)).setCellValue(ResManager.loadKDString((String)"\u7ea2\u8272\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5", (String)"FahFlexExportUtil_2", (String)"fi-ai-business", (Object[])new Object[0]));
        XSSFRow numberRow = FahFlexExportUtil.getRow(sheet1, 1);
        XSSFRow titleNumberRow = FahFlexExportUtil.getRow(sheet1, 2);
        FahValMapPropEnum[] valMapPropEnums = FahValMapPropEnum.values();
        int enumLength = valMapPropEnums.length;
        for (int i2 = 0; i2 < enumLength; ++i2) {
            FahValMapPropEnum propEnum = valMapPropEnums[i2];
            Boolean flag = propEnum.getFlag();
            FahFlexExportUtil.createCell(sheet1, numberRow, i2, FahFlexExportUtil.getCellStyle((Workbook)workbook, false, true)).setCellValue(propEnum.getNumber());
            String realityName = Boolean.TRUE.equals(flag) ? "*" + propEnum.getName() : propEnum.getName();
            FahFlexExportUtil.createCell(sheet1, titleNumberRow, i2, FahFlexExportUtil.getCellStyle((Workbook)workbook, flag, true)).setCellValue(realityName);
        }
        XSSFRow entryNumberRow = FahFlexExportUtil.getRow(sheet1, 4);
        XSSFRow entryTitleRow = FahFlexExportUtil.getRow(sheet1, 5);
        int length = 0;
        HashMap<Integer, PairTuple<String, Integer>> columIndexAndType = new HashMap<Integer, PairTuple<String, Integer>>(collections.size());
        FahValMapEntryPropEnum[] valMapEntryPropEnum = FahValMapEntryPropEnum.values();
        length = FahFlexExportUtil.createBeforeArrangeOfMapping(workbook, sheet1, entryNumberRow, entryTitleRow, valMapEntryPropEnum, length, BEFORE);
        for (FlexFieldCfg model : collections) {
            FahFlexExportUtil.createCell(sheet1, entryNumberRow, length, FahFlexExportUtil.getCellStyle((Workbook)workbook, false, true)).setCellValue(model.getNumber());
            boolean isOutPut = MappingValueType.OUTPUT.getCode() == model.getFieldUsageType();
            FahFlexExportUtil.createCell(sheet1, entryTitleRow, length, FahFlexExportUtil.getCellStyle((Workbook)workbook, isOutPut, true)).setCellValue(isOutPut ? "*" + model.getName() : model.getName());
            columIndexAndType.put(length, (PairTuple<String, Integer>)new PairTuple((Object)model.getNumber(), (Object)model.getFieldUsageType()));
            ++length;
        }
        FahFlexExportUtil.createBeforeArrangeOfMapping(workbook, sheet1, entryNumberRow, entryTitleRow, valMapEntryPropEnum, length, AFTER);
        XSSFRow headValRow = FahFlexExportUtil.getRow(sheet1, 3);
        String selectFields = StringUtils.join((Object[])Arrays.stream(FahValMapPropEnum.values()).map(FahValMapPropEnum::getNumber).toArray(), (String)",");
        DynamicObject valueMapType = QueryServiceHelper.queryOne((String)entityId, (String)selectFields, (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        for (i = 0; i < FahValMapPropEnum.values().length; ++i) {
            FahValMapPropEnum propEnum = FahValMapPropEnum.values()[i];
            FahFlexExportUtil.createCell(sheet1, headValRow, i, FahFlexExportUtil.getCellStyle((Workbook)workbook, false, false)).setCellValue(null != valueMapType ? valueMapType.getString(propEnum.getNumber()) : "");
        }
        if (withData) {
            FahFlexExportUtil.exportData(workbook, sheet1, mappingData, length, columIndexAndType);
        } else {
            XSSFSheet sheet2 = workbook.createSheet(ResManager.loadKDString((String)"\u6279\u91cf\u589e\u884c", (String)"FahFlexExportUtil_4", (String)"fi-ai-business", (Object[])new Object[0]));
            int startRow = 0;
            for (FahValMapMultiValueEnum valueEnum : FahValMapMultiValueEnum.values()) {
                int columIndex = 0;
                XSSFRow row = FahFlexExportUtil.getRow(sheet2, startRow++);
                XSSFCell cell = FahFlexExportUtil.createCell(sheet2, row, columIndex++, FahFlexExportUtil.getCellStyle((Workbook)workbook, false, true, HSSFColor.HSSFColorPredefined.YELLOW));
                if (StringUtils.isNotEmpty((CharSequence)valueEnum.getComment())) {
                    FahFlexExportUtil.addCellComment(sheet2, valueEnum.getComment(), cell, 3, 2);
                }
                cell.setCellValue(valueEnum.getName());
                if (FahValMapMultiValueEnum.COLUMN_NUMBER != valueEnum && FahValMapMultiValueEnum.COLUMN_NAME != valueEnum) continue;
                CellStyle cellStyle = FahFlexExportUtil.getCellStyle((Workbook)workbook, false, true);
                cell.setCellStyle(cellStyle);
                for (FlexFieldCfg fieldCfg : collections) {
                    if (MappingValueType.INPUT.getCode() != fieldCfg.getFieldUsageType()) continue;
                    XSSFCell fCell = FahFlexExportUtil.createCell(sheet2, row, columIndex++, cellStyle);
                    fCell.setCellValue(FahValMapMultiValueEnum.COLUMN_NUMBER == valueEnum ? fieldCfg.getNumber() : fieldCfg.getName());
                }
            }
        }
        for (i = 0; i < length; ++i) {
            FahFlexExportUtil.setColumnStyleOfText(workbook, sheet1, i);
        }
        return workbook;
    }

    private static void addCellComment(XSSFSheet sheet, String commentVal, XSSFCell cell, int colIncrement, int rowIncrement) {
        XSSFDrawing drawing = sheet.createDrawingPatriarch();
        Comment comment = drawing.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex() + colIncrement, cell.getRowIndex() + rowIncrement));
        comment.setString((RichTextString)new XSSFRichTextString(commentVal));
        cell.setCellComment(comment);
    }

    private static void exportData(XSSFWorkbook workbook, XSSFSheet sheet1, MappingDataCollection mappingData, int length, Map<Integer, PairTuple<String, Integer>> columIndexAndType) {
        int rowIndex = 6;
        XSSFRow columNumRow = FahFlexExportUtil.getRow(sheet1, 4);
        String[] columNumList = new String[length];
        LinkedHashMap<Integer, PairTuple<DataValueTypeEnum, Object>> flexColumInfoMap = new LinkedHashMap<Integer, PairTuple<DataValueTypeEnum, Object>>();
        HashMap<String, Set<Long>> basePropIdMap = new HashMap<String, Set<Long>>();
        HashMap<Long, Set<Long>> assistPropIdMap = new HashMap<Long, Set<Long>>();
        HashMap<Long, Set<Long>> asstPropIdMap = new HashMap<Long, Set<Long>>();
        HashMap<Integer, PairTuple<String, String>> checkBoxEntityAndFieldMap = new HashMap<Integer, PairTuple<String, String>>();
        FlexFieldGrpCfg meta = (FlexFieldGrpCfg)mappingData.getMeta();
        BaseMutableArrayMapStorage collections = (BaseMutableArrayMapStorage)meta.getCollections();
        for (int i = 0; i < columNumList.length; ++i) {
            String columNum;
            columNumList[i] = columNum = columNumRow.getCell(i).getStringCellValue();
            PairTuple<String, Integer> tuple = columIndexAndType.get(i);
            if (null != tuple) {
                FlexFieldCfg flexFieldCfg = (FlexFieldCfg)collections.get((Object)columNum);
                if (null == flexFieldCfg) continue;
                if (DataValueTypeEnum.BaseProp == flexFieldCfg.getDataType()) {
                    flexColumInfoMap.putIfAbsent(i, (PairTuple<DataValueTypeEnum, Object>)new PairTuple((Object)flexFieldCfg.getDataType(), (Object)flexFieldCfg.getRefEntity()));
                    continue;
                }
                if (DataValueTypeEnum.AssistProp == flexFieldCfg.getDataType()) {
                    flexColumInfoMap.putIfAbsent(i, (PairTuple<DataValueTypeEnum, Object>)new PairTuple((Object)flexFieldCfg.getDataType(), (Object)flexFieldCfg.getRefTypeId()));
                    continue;
                }
                if (DataValueTypeEnum.Kingdee_AcctAssistDim == flexFieldCfg.getDataType()) {
                    flexColumInfoMap.putIfAbsent(i, (PairTuple<DataValueTypeEnum, Object>)new PairTuple((Object)flexFieldCfg.getDataType(), (Object)flexFieldCfg.getRefTypeId()));
                    continue;
                }
                if (DataValueTypeEnum.Kingdee_BillDropDownList != flexFieldCfg.getDataType()) continue;
                checkBoxEntityAndFieldMap.putIfAbsent(i, (PairTuple<String, String>)new PairTuple((Object)flexFieldCfg.getRefEntity(), (Object)flexFieldCfg.getRefFieldNum()));
                continue;
            }
            if (!FahValMapEntryPropEnum.OWNORG.getNumber().equals(columNum)) continue;
            flexColumInfoMap.putIfAbsent(i, new PairTuple((Object)DataValueTypeEnum.BaseProp, (Object)"bos_org"));
        }
        List dataCol = mappingData.getDataCol();
        HashMap<String, Integer> rowAndIndexMap = new HashMap<String, Integer>();
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        XSSFDataFormat format = workbook.createDataFormat();
        cellStyle.setDataFormat(format.getFormat("@"));
        for (SingleLineMappingData data : dataCol) {
            String rowPk = data.getOrgGroupId() + "_" + data.getSerialNumber();
            Integer index = (Integer)rowAndIndexMap.get(rowPk);
            boolean needAdd = false;
            if (null == index) {
                index = rowIndex++;
                needAdd = true;
                rowAndIndexMap.put(rowPk, index);
            }
            XSSFRow row = FahFlexExportUtil.getRow(sheet1, index);
            int flexIndex = 0;
            for (int i = 0; i < length; ++i) {
                String columNumber = columNumList[i];
                XSSFCell cell = null;
                Object value = null;
                PairTuple<String, Integer> tuple = columIndexAndType.get(i);
                if (null == tuple) {
                    if (needAdd) {
                        cell = row.createCell(i);
                        value = data.get(columNumber);
                        if (FahValMapEntryPropEnum.OWNORG.getNumber().equals(columNumber)) {
                            basePropIdMap.computeIfAbsent("bos_org", v -> new HashSet()).add(Long.parseLong(String.valueOf(value)));
                        }
                    }
                } else if (data.getMapValueType() == ((Integer)tuple.getValue()).intValue()) {
                    cell = row.createCell(i);
                    if (null != data.getValues() && flexIndex < data.getValues().length) {
                        value = data.getValues()[flexIndex++];
                        FlexFieldCfg flexFieldCfg = (FlexFieldCfg)collections.get((Object)columNumber);
                        if (DataValueTypeEnum.BaseProp == flexFieldCfg.getDataType()) {
                            basePropIdMap.computeIfAbsent(flexFieldCfg.getRefEntity(), v -> new HashSet()).add(Long.parseLong(String.valueOf(value)));
                        } else if (DataValueTypeEnum.AssistProp == flexFieldCfg.getDataType()) {
                            assistPropIdMap.computeIfAbsent(flexFieldCfg.getRefTypeId(), v -> new HashSet()).add(Long.parseLong(String.valueOf(value)));
                        } else if (DataValueTypeEnum.Kingdee_AcctAssistDim == flexFieldCfg.getDataType()) {
                            asstPropIdMap.computeIfAbsent(flexFieldCfg.getRefTypeId(), v -> new HashSet()).add(Long.parseLong(String.valueOf(value)));
                        }
                    }
                }
                if (value instanceof Date) {
                    value = FahFlexExportUtil.getFormatDateValue(value, columNumber);
                }
                if (null == cell) continue;
                cell.setCellValue(null == value ? "" : String.valueOf(value));
                cell.setCellStyle((CellStyle)cellStyle);
            }
        }
        Map<Integer, Map<String, LocaleString>> checkBoxComboItems = FahFlexExportUtil.getCheckBoxComboItems(checkBoxEntityAndFieldMap);
        if (!flexColumInfoMap.isEmpty() || !checkBoxComboItems.isEmpty()) {
            FahFlexExportUtil.convertCellValue(sheet1, flexColumInfoMap, basePropIdMap, assistPropIdMap, asstPropIdMap, checkBoxComboItems, (CellStyle)cellStyle);
        }
    }

    private static Map<Integer, Map<String, LocaleString>> getCheckBoxComboItems(Map<Integer, PairTuple<String, String>> checkBoxEntityAndFieldMap) {
        HashMap<Integer, Map<String, LocaleString>> checkBoxComboItems = new HashMap<Integer, Map<String, LocaleString>>();
        for (Map.Entry<Integer, PairTuple<String, String>> entry : checkBoxEntityAndFieldMap.entrySet()) {
            try {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)((String)entry.getValue().getKey()));
                DynamicProperty comboProperty = entityType.getProperty((String)entry.getValue().getValue());
                if (!(comboProperty instanceof ComboProp)) continue;
                Map<String, LocaleString> valAndNameMap = ((ComboProp)comboProperty).getComboItems().stream().collect(Collectors.toMap(ValueMapItem::getValue, ValueMapItem::getName, (key1, key2) -> key2));
                checkBoxComboItems.put(entry.getKey(), valAndNameMap);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return checkBoxComboItems;
    }

    private static Object getFormatDateValue(Object dateValue, String columNum) {
        if (null != (dateValue = FahMappingUtils.dateIsEquals((Date)((Date)dateValue), (boolean)FahDataValsetEntryPropEnum.EFFECTDATE.getNumber().equals(columNum)))) {
            dateValue = DateUtil.getShort2Format().format(dateValue);
        }
        return dateValue;
    }

    /*
     * WARNING - void declaration
     */
    private static void convertCellValue(XSSFSheet sheet1, Map<Integer, PairTuple<DataValueTypeEnum, Object>> flexColumInfoMap, Map<String, Set<Long>> basePropIdMap, Map<Long, Set<Long>> assistPropIdMap, Map<Long, Set<Long>> asstPropIdMap, Map<Integer, Map<String, LocaleString>> checkBoxComboItems, CellStyle cellStyle) {
        void var11_18;
        Map numberMap;
        HashMap<String, Map> basePropNumberMap = new HashMap<String, Map>(basePropIdMap.size());
        HashMap<Object, Map> assistPropNumberMap = new HashMap<Object, Map>(assistPropIdMap.size());
        HashMap<Object, Map> asstPropNumberMap = new HashMap<Object, Map>(asstPropIdMap.size());
        for (Map.Entry<String, Set<Long>> entry : basePropIdMap.entrySet()) {
            numberMap = IDConvertNumberHelper.queryBaseDataNumbers((String)entry.getKey(), entry.getValue(), null);
            basePropNumberMap.put(entry.getKey(), numberMap);
        }
        for (Map.Entry<Object, Set<Long>> entry : assistPropIdMap.entrySet()) {
            numberMap = IDConvertNumberHelper.queryAssistantIds((Long)((Long)entry.getKey()), entry.getValue());
            assistPropNumberMap.put(entry.getKey(), numberMap);
        }
        for (Map.Entry<Object, Set<Long>> entry : asstPropIdMap.entrySet()) {
            numberMap = IDConvertNumberHelper.getAsstDimTypeByEntryId((Long)((Long)entry.getKey()), entry.getValue(), null);
            asstPropNumberMap.put(entry.getKey(), numberMap);
        }
        int rows = sheet1.getPhysicalNumberOfRows();
        int n = 6;
        while (var11_18 < rows) {
            Cell cell;
            XSSFRow flexRow = sheet1.getRow((int)var11_18);
            for (Map.Entry<Integer, PairTuple<DataValueTypeEnum, Object>> entry : flexColumInfoMap.entrySet()) {
                cell = flexRow.getCell(entry.getKey().intValue());
                PairTuple<DataValueTypeEnum, Object> tuple = entry.getValue();
                Map idAndNumber = null;
                String type = String.valueOf(tuple.getValue());
                if (DataValueTypeEnum.BaseProp == tuple.getKey()) {
                    idAndNumber = (Map)basePropNumberMap.get(type);
                } else if (DataValueTypeEnum.AssistProp == tuple.getKey()) {
                    idAndNumber = (Map)assistPropNumberMap.get(Long.valueOf(type));
                } else if (DataValueTypeEnum.Kingdee_AcctAssistDim == tuple.getKey()) {
                    idAndNumber = (Map)asstPropNumberMap.get(Long.valueOf(type));
                }
                if (null == cell || null == idAndNumber) continue;
                String newValue = (String)idAndNumber.get(Long.parseLong(cell.getStringCellValue()));
                cell.setCellValue(null != newValue ? newValue : "");
                cell.setCellStyle(cellStyle);
            }
            for (Map.Entry<Integer, Object> entry : checkBoxComboItems.entrySet()) {
                cell = flexRow.getCell(entry.getKey().intValue());
                Map numberAndNames = (Map)entry.getValue();
                LocaleString name = (LocaleString)numberAndNames.get(cell.getStringCellValue());
                cell.setCellValue(null != name ? name.getLocaleValue_zh_CN() : "");
                cell.setCellStyle(cellStyle);
            }
            ++var11_18;
        }
    }

    public static XSSFWorkbook buildWorkBookOfValueSet(String entityId, Long id, boolean withData) {
        int i;
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet1 = workbook.createSheet("Sheet1");
        DBValueSetAndMappingServiceImpl valueSetService = new DBValueSetAndMappingServiceImpl();
        ValueSetDataCollection valueSetData = valueSetService.queryValueSetData(id);
        FlexFieldGrpCfg meta = (FlexFieldGrpCfg)valueSetData.getMeta();
        BaseMutableArrayMapStorage collections = (BaseMutableArrayMapStorage)meta.getCollections();
        FahDataValsetPropEnum[] values = FahDataValsetPropEnum.values();
        int enumLength = values.length;
        FahDataValsetEntryPropEnum[] entryValues = FahDataValsetEntryPropEnum.values();
        XSSFRow noteRow = FahFlexExportUtil.getRow(sheet1, 0);
        FahFlexExportUtil.createCell(sheet1, noteRow, 0, FahFlexExportUtil.getCellStyle((Workbook)workbook, true, false)).setCellValue(ResManager.loadKDString((String)"\u7ea2\u8272\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5", (String)"FahFlexExportUtil_2", (String)"fi-ai-business", (Object[])new Object[0]));
        XSSFRow numberRow = FahFlexExportUtil.getRow(sheet1, 1);
        XSSFRow titleNumberRow = FahFlexExportUtil.getRow(sheet1, 2);
        for (int i2 = 0; i2 < enumLength; ++i2) {
            FahDataValsetPropEnum propEnum = values[i2];
            Boolean flag = propEnum.getFlag();
            FahFlexExportUtil.createCell(sheet1, numberRow, i2, FahFlexExportUtil.getCellStyle((Workbook)workbook, false, true)).setCellValue(propEnum.getNumber());
            String realityName = flag != false ? "*" + propEnum.getName() : propEnum.getName();
            FahFlexExportUtil.createCell(sheet1, titleNumberRow, i2, FahFlexExportUtil.getCellStyle((Workbook)workbook, flag, true)).setCellValue(realityName);
        }
        XSSFRow entryNumberRow = FahFlexExportUtil.getRow(sheet1, 4);
        XSSFRow entryTitleRow = FahFlexExportUtil.getRow(sheet1, 5);
        int length = 0;
        length = FahFlexExportUtil.createBeforeArrange(workbook, sheet1, entryNumberRow, entryTitleRow, entryValues, length, BEFORE);
        for (FlexFieldCfg model : collections) {
            FahFlexExportUtil.createCell(sheet1, entryNumberRow, length, FahFlexExportUtil.getCellStyle((Workbook)workbook, false, true)).setCellValue(model.getNumber());
            FahFlexExportUtil.createCell(sheet1, entryTitleRow, length, FahFlexExportUtil.getCellStyle((Workbook)workbook, false, true)).setCellValue(model.getName());
            ++length;
        }
        FahFlexExportUtil.createBeforeArrange(workbook, sheet1, entryNumberRow, entryTitleRow, entryValues, length, AFTER);
        XSSFRow headValRow = FahFlexExportUtil.getRow(sheet1, 3);
        String selectFields = StringUtils.join((Object[])Arrays.stream(FahDataValsetPropEnum.values()).map(FahDataValsetPropEnum::getNumber).toArray(), (String)",");
        DynamicObject valueSetType = QueryServiceHelper.queryOne((String)entityId, (String)selectFields, (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        for (i = 0; i < enumLength; ++i) {
            FahDataValsetPropEnum propEnum = values[i];
            FahFlexExportUtil.createCell(sheet1, headValRow, i, FahFlexExportUtil.getCellStyle((Workbook)workbook, false, false)).setCellValue(null != valueSetType ? valueSetType.getString(propEnum.getNumber()) : "");
        }
        if (withData) {
            int rowIndex = 6;
            XSSFRow columNumRow = FahFlexExportUtil.getRow(sheet1, 4);
            String[] columNumList = new String[length];
            for (int i3 = 0; i3 < columNumList.length; ++i3) {
                columNumList[i3] = columNumRow.getCell(i3).getStringCellValue();
            }
            ArrayList dataCol = valueSetData.getDataCol();
            XSSFCellStyle cellStyle = workbook.createCellStyle();
            XSSFDataFormat format = workbook.createDataFormat();
            cellStyle.setDataFormat(format.getFormat("@"));
            for (SingleValueSetData data : dataCol) {
                XSSFRow row = FahFlexExportUtil.getRow(sheet1, rowIndex++);
                int flexSeq = 0;
                for (int i4 = 0; i4 < length; ++i4) {
                    XSSFCell cell = row.createCell(i4);
                    Object value = null;
                    String columNum = columNumList[i4];
                    if (null != FahDataValsetEntryPropEnum.getEnumByNumber((String)columNum)) {
                        value = data.get(columNum);
                    } else if (null != data.getValues() && flexSeq < data.getValues().length) {
                        value = data.getValues()[flexSeq++];
                    }
                    if (value instanceof Date) {
                        value = FahFlexExportUtil.getFormatDateValue(value, columNum);
                    }
                    if (null == cell) continue;
                    cell.setCellValue(null == value ? "" : String.valueOf(value));
                    cell.setCellStyle((CellStyle)cellStyle);
                }
            }
        }
        for (i = 0; i < length; ++i) {
            FahFlexExportUtil.setColumnStyleOfText(workbook, sheet1, i);
        }
        return workbook;
    }

    private static void setColumnStyleOfText(XSSFWorkbook workbook, XSSFSheet sheet, int columnIndex) {
        XSSFCellStyle style = workbook.createCellStyle();
        XSSFDataFormat format = workbook.createDataFormat();
        style.setDataFormat(format.getFormat("@"));
        sheet.setDefaultColumnStyle(columnIndex, (CellStyle)style);
    }

    private static int createBeforeArrange(XSSFWorkbook workbook, XSSFSheet sheet, XSSFRow titleNumberRow, XSSFRow titleNameRow, FahDataValsetEntryPropEnum[] values, int length, String position) {
        int site = length;
        for (FahDataValsetEntryPropEnum propEnum : values) {
            if (!position.equals(propEnum.getPosition())) continue;
            Boolean flag = propEnum.getFlag();
            FahFlexExportUtil.createCell(sheet, titleNumberRow, site, FahFlexExportUtil.getCellStyle((Workbook)workbook, false, true)).setCellValue(propEnum.getNumber());
            String realityName = flag != false ? "*" + propEnum.getName() : propEnum.getName();
            XSSFCell cell = FahFlexExportUtil.createCell(sheet, titleNameRow, site, FahFlexExportUtil.getCellStyle((Workbook)workbook, flag, true));
            cell.setCellValue(realityName);
            if (StringUtils.isNotEmpty((CharSequence)propEnum.getComment())) {
                FahFlexExportUtil.addCellComment(sheet, propEnum.getComment(), cell, 1, 1);
            }
            ++site;
        }
        return site;
    }

    private static int createBeforeArrangeOfMapping(XSSFWorkbook workbook, XSSFSheet sheet, XSSFRow titleNumberRow, XSSFRow titleNameRow, FahValMapEntryPropEnum[] values, int length, String position) {
        int site = length;
        for (FahValMapEntryPropEnum propEnum : values) {
            if (!position.equals(propEnum.getPosition())) continue;
            Boolean flag = propEnum.getFlag();
            FahFlexExportUtil.createCell(sheet, titleNumberRow, site, FahFlexExportUtil.getCellStyle((Workbook)workbook, false, true)).setCellValue(propEnum.getNumber());
            String realityName = flag != false ? "*" + propEnum.getName() : propEnum.getName();
            XSSFCell cell = FahFlexExportUtil.createCell(sheet, titleNameRow, site, FahFlexExportUtil.getCellStyle((Workbook)workbook, flag, true));
            cell.setCellValue(realityName);
            if (StringUtils.isNotEmpty((CharSequence)propEnum.getComment())) {
                FahFlexExportUtil.addCellComment(sheet, propEnum.getComment(), cell, 1, 1);
            }
            ++site;
        }
        return site;
    }

    public static XSSFRow getRow(XSSFSheet sheet, int r) {
        XSSFRow row = sheet.getRow(r);
        if (row == null) {
            row = sheet.createRow(r);
        }
        return row;
    }

    public static XSSFCell createCell(XSSFSheet sheet, XSSFRow row, int column, CellStyle style) {
        XSSFCell cell = row.createCell(column);
        cell.setCellStyle(style);
        sheet.setColumnWidth(column, 6200);
        return cell;
    }

    public static CellStyle getCellStyle(Workbook workbook, boolean isHighLight, boolean isDefaultCell) {
        return FahFlexExportUtil.getCellStyle(workbook, isHighLight, isDefaultCell, null);
    }

    public static CellStyle getCellStyle(Workbook workbook, boolean isHighLight, boolean isDefaultCell, HSSFColor.HSSFColorPredefined groundColor) {
        CellStyle cs = workbook.createCellStyle();
        cs.setAlignment(FahFlexExportUtil.getAlignment("default"));
        if (isHighLight) {
            Font font = workbook.createFont();
            font.setColor(IndexedColors.RED.getIndex());
            cs.setFont(font);
        }
        if (isDefaultCell) {
            if (null == groundColor) {
                groundColor = HSSFColor.HSSFColorPredefined.GREY_25_PERCENT;
            }
            cs.setFillForegroundColor(groundColor.getIndex());
            cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        cs.setDataFormat(workbook.createDataFormat().getFormat("@"));
        return cs;
    }

    public static HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase());
        }
        catch (Throwable var3) {
            return HorizontalAlignment.GENERAL;
        }
    }
}

