/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.newapi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.JSONUtils;

@ApiController(value="ai", desc="\u751f\u6210\u51ed\u8bc1\u63a5\u53e3")
public class BuildVoucherServiceApiHelper
implements IBillWebApiPlugin {
    @ApiPostMapping(value="/buildVoucher")
    public CustomApiResult<String> buildVoucher(@ApiParam(value="\u5355\u636e\u7c7b\u578b", required=true, example="\"ai_dapbill\"") @ApiParam(value="\u5355\u636e\u7c7b\u578b", required=true, example="\"ai_dapbill\"") String billType, @ApiParam(value="\u5355\u636eid", required=true, example="[1212153586599869440,1196324667896387584]") @ApiParam(value="\u5355\u636eid", required=true, example="[1212153586599869440,1196324667896387584]") List<Long> billIds, @ApiParam(value="\u64cd\u4f5c\u53c2\u6570", example="{\"ignorebillstatus\":\"true\"}") @ApiParam(value="\u64cd\u4f5c\u53c2\u6570", example="{\"ignorebillstatus\":\"true\"}") HashMap<String, String> params) throws IOException {
        OperationResult opResult;
        String strData = "";
        HashMap<Object, Object> map = new HashMap();
        if (StringUtils.isBlank((CharSequence)billType)) {
            throw new KDBizException(new ErrorCode("0001", ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BuildVoucherServiceApiHelper_1", (String)"fi-ai-webapi", (Object[])new Object[0])), new Object[0]);
        }
        if (billIds.isEmpty()) {
            throw new KDBizException(new ErrorCode("0002", ResManager.loadKDString((String)"\u5355\u636eID\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BuildVoucherServiceApiHelper_2", (String)"fi-ai-webapi", (Object[])new Object[0])), new Object[0]);
        }
        Object[] objects = billIds.toArray();
        OperateOption option = OperateOption.create();
        if (!params.isEmpty()) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                option.setVariableValue(entry.getKey(), entry.getValue());
            }
        }
        if (!(opResult = OperationServiceHelper.executeOperate((String)"generatevoucher", (String)billType, (Object[])objects, (OperateOption)option)).getSuccessPkIds().isEmpty()) {
            if (opResult.getSuccessPkIds().size() < billIds.size()) {
                HashSet succIdSet = new HashSet(opResult.getSuccessPkIds());
                map = BuildVoucherServiceApiHelper.getGlVoucher(billType, billIds);
                Iterator<Long> iterator = billIds.iterator();
                while (iterator.hasNext()) {
                    if (!succIdSet.contains(iterator.next())) continue;
                    iterator.remove();
                }
                List allInfo = opResult.getAllErrorOrValidateInfo();
                if (allInfo.size() == 1) {
                    for (Long id : billIds) {
                        map.put(id, opResult.getMessage() == null ? ((IOperateInfo)allInfo.get(0)).getMessage() : opResult.getMessage());
                    }
                } else {
                    for (IOperateInfo info : allInfo) {
                        Long sourceId = (Long)info.getPkValue();
                        map.put(sourceId, opResult.getMessage() == null ? info.getMessage() : opResult.getMessage());
                    }
                }
                strData = JSONUtils.toString(map);
                return CustomApiResult.fail((String)"", (String)strData);
            }
            map = BuildVoucherServiceApiHelper.getGlVoucher(billType, billIds);
            strData = JSONUtils.toString(map);
            return CustomApiResult.success((Object)strData);
        }
        List allInfo = opResult.getAllErrorOrValidateInfo();
        if (allInfo.size() == 1) {
            for (Long id : billIds) {
                map.put(id, opResult.getMessage() == null ? ((IOperateInfo)allInfo.get(0)).getMessage() : opResult.getMessage());
            }
        } else {
            for (IOperateInfo info : allInfo) {
                Long sourceId = (Long)info.getPkValue();
                map.put(sourceId, opResult.getMessage() == null ? info.getMessage() : opResult.getMessage());
            }
        }
        strData = JSONUtils.toString(map);
        return CustomApiResult.fail((String)"", (String)strData);
    }

    private static HashMap<Long, String> getGlVoucher(String billType, List<Long> billIds) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        ArrayList<QFilter> qFilters1 = new ArrayList<QFilter>(2);
        qFilters1.add(new QFilter("sourcebill", "in", billIds));
        qFilters1.add(new QFilter("sourcebilltype", "=", (Object)billType));
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.newapi.BuildVoucherServiceApiHelper", (String)"gl_voucher", (String)"id,billno,sourcebill", (QFilter[])qFilters1.toArray(new QFilter[0]), null);){
            for (Row row : queryDataSet) {
                Long sourcebillId = row.getLong("sourcebill");
                Long glVoucherId = row.getLong("id");
                String glVoucherNo = row.getString("billno");
                map.put(sourcebillId, glVoucherId + ":" + glVoucherNo);
            }
        }
        return map;
    }
}

