/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.dap;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.ai.VoucherType;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.buildresult.IVoucher;
import kd.fi.ai.mservice.builder.buildresult.IVoucherEntry;
import kd.fi.ai.mservice.dao.BaseDataLoader;

public class DapBillnoUtil {
    private static Log logger = LogFactory.getLog(DapBillnoUtil.class);
    private static final String FIELD_GL_ORG = "org";
    private static final String FIELD_GL_BILLSTAUS = "billstatus";
    private static final String FIELD_GL_BILLNO = "billno";
    private static final String FIELD_GL_SOURCEBILL = "sourcebill";

    public static void setGLVoucherBillNo(String entity, List<IVoucher<?>> vouchers, ISingleTaskContext taskContext) {
        logger.info("\u4f1a\u8ba1\u5e73\u53f0\u5f00\u59cb\u5904\u7406\u6682\u5b58\u51ed\u8bc1\u7f16\u7801");
        HashMap<Long, IVoucher> dyVoucherMap = new HashMap<Long, IVoucher>();
        List<DynamicObject> glVouchers = DapBillnoUtil.convertToDynamicObject(entity, vouchers, taskContext, dyVoucherMap);
        if (glVouchers == null || glVouchers.isEmpty()) {
            return;
        }
        HashMap<Long, List> orgMap = new HashMap<Long, List>();
        for (DynamicObject obj : glVouchers) {
            long orgId = obj.getLong("org.id");
            orgMap.computeIfAbsent(orgId, p -> new ArrayList()).add(obj);
        }
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)entity);
        ICodeRuleService crservice = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        obj.set(FIELD_GL_BILLSTAUS, (Object)"A");
        for (Map.Entry entry : orgMap.entrySet()) {
            obj.set(FIELD_GL_ORG, entry.getKey());
            CodeRuleInfo codeRule = crservice.getCodeRule(entity, obj, String.valueOf(entry.getKey()));
            List list = (List)entry.getValue();
            if (null == codeRule) continue;
            List codeRuleEntry = codeRule.getRuleEntry();
            HashMap<String, String> bizField = new HashMap<String, String>(4);
            HashMap<String, SimpleDateFormat> dateFormat = new HashMap<String, SimpleDateFormat>(4);
            for (CodeRuleEntryInfo entryInfo : codeRuleEntry) {
                if (entryInfo.getAttributeType().equals("2")) {
                    bizField.put(entryInfo.getValueAtribute(), entryInfo.getAttributeType());
                    dateFormat.put(entryInfo.getValueAtribute(), new SimpleDateFormat(entryInfo.getFormat()));
                }
                if (!entryInfo.getAttributeType().equals("8")) continue;
                bizField.put(entryInfo.getValueAtribute(), entryInfo.getAttributeType());
            }
            DapBillnoUtil.setVoucherNumber(entity, list, dyVoucherMap, bizField, dateFormat, crservice);
        }
        logger.info("\u4f1a\u8ba1\u5e73\u53f0\u8bbe\u7f6e\u6682\u5b58\u51ed\u8bc1\u7f16\u7801\u7ed3\u675f");
    }

    public static List<DynamicObject> convertToDynamicObject(String entity, List<IVoucher<?>> vouchers, ISingleTaskContext taskContext, Map<Long, IVoucher> dyVoucherMap) {
        if (vouchers == null || vouchers.isEmpty()) {
            return null;
        }
        ArrayList<DynamicObject> ret = new ArrayList<DynamicObject>(vouchers.size());
        for (IVoucher<?> glvoucher : vouchers) {
            DynamicObject dynamicObjectVoucher = glvoucher.toDynamicObjectVoucher(taskContext, entity);
            dyVoucherMap.put(glvoucher.getSourceBillId(), glvoucher);
            ret.add(dynamicObjectVoucher);
        }
        return ret;
    }

    private static void setVoucherNumber(String entity, List<DynamicObject> dataentity, Map<Long, IVoucher> dyVoucherMap, Map<String, String> bizField, Map<String, SimpleDateFormat> dateFormat, ICodeRuleService crservice) {
        if (dataentity.isEmpty()) {
            return;
        }
        HashMap keyMap = new HashMap();
        for (DynamicObject dynamicObject : dataentity) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : bizField.entrySet()) {
                String field = entry.getKey();
                if ("2".equals(entry.getValue())) {
                    if (null == dynamicObject.getDate(field)) {
                        sb.append("-");
                        continue;
                    }
                    sb.append(dateFormat.get(field).format(dynamicObject.getDate(field))).append("-");
                    continue;
                }
                if (!bizField.get(field).equals("8")) continue;
                sb.append(dynamicObject.getString(field)).append("-");
            }
            String name = "key";
            if (sb.length() > 0) {
                name = sb.substring(0, sb.length() - 1);
            }
            if (keyMap.get(name) == null) {
                ArrayList<DynamicObject> subList = new ArrayList<DynamicObject>();
                subList.add(dynamicObject);
                keyMap.put(name, subList);
                continue;
            }
            ((List)keyMap.get(name)).add(dynamicObject);
        }
        for (Map.Entry entry : keyMap.entrySet()) {
            List subList = (List)entry.getValue();
            DynamicObject subObj = (DynamicObject)subList.get(0);
            subObj.set(FIELD_GL_BILLSTAUS, (Object)"A");
            String[] billNo = crservice.getBatchNumber(entity, subObj, subObj.getString("org.id"), subList.size());
            int i = 0;
            for (DynamicObject ext : subList) {
                ext.set(FIELD_GL_BILLNO, (Object)billNo[i]);
                IVoucher glVoucher = dyVoucherMap.get(ext.get(FIELD_GL_SOURCEBILL));
                glVoucher.setNumber(billNo[i]);
                ++i;
            }
        }
    }

    public static void SetGLVoucherBillNo(List<IVoucher<?>> vouchers, ISingleTaskContext taskContext) {
        SimpleDateFormat bf = new SimpleDateFormat("yyyy-MM-dd");
        HashMap vchGroup = new HashMap();
        for (IVoucher<?> voucher : vouchers) {
            List<IVoucher<?>> vchList;
            String key;
            if (null != voucher.getEntryRows() && !voucher.getEntryRows().isEmpty()) {
                voucher.setVdescription(((IVoucherEntry)voucher.getEntryRows().get(0)).getDescription());
            }
            if (vchGroup.containsKey(key = new StringBuffer().append(voucher.getOrgId()).append(voucher.getVchTypeId()).append(bf.format(voucher.getBookedDate())).toString())) {
                vchList = (List)vchGroup.get(key);
                vchList.add(voucher);
                continue;
            }
            vchList = new ArrayList();
            vchList.add(voucher);
            vchGroup.put(key, vchList);
        }
        for (List vchList : vchGroup.values()) {
            DapBillnoUtil.setNumber(taskContext, vchList);
        }
    }

    private static void setNumber(ISingleTaskContext taskContext, List<IVoucher<?>> vchList) {
        ORM orm = ORM.create();
        DynamicObject voucherObj = orm.newDynamicObject("ai_bizvoucher");
        IVoucher<?> voucher = vchList.get(0);
        voucherObj.set("bizdate", (Object)voucher.getBizDate());
        voucherObj.set("bookeddate", (Object)voucher.getBookedDate());
        voucherObj.set(FIELD_GL_ORG, (Object)BaseDataLoader.loadOrg((ISingleTaskContext)taskContext, (Long)voucher.getOrgId()));
        voucherObj.set("period", (Object)BaseDataLoader.loadPeriod((ISingleTaskContext)taskContext, (Long)voucher.getPeriodId()));
        voucherObj.set("sourcetype", (Object)voucher.getSourceType());
        voucherObj.set("booktype", (Object)BaseDataLoader.loadBooktype((ISingleTaskContext)taskContext, (Long)taskContext.getBookInfo().getBookTypeId()));
        DynamicObject vtp = orm.newDynamicObject("gl_vouchertype");
        VoucherType vt = BaseDataLoader.loadVchType((IBuildVchContext)taskContext.getBuildVchContext(), (Long)voucher.getVchTypeId());
        vtp.set("id", (Object)vt.getId());
        vtp.set("name", (Object)vt.getName());
        vtp.set("number", (Object)vt.getNumber());
        voucherObj.set("vouchertype", (Object)vtp);
        voucherObj.set(FIELD_GL_BILLSTAUS, (Object)"A");
        String[] numbers = CodeRuleServiceHelper.getBatchNumber((String)"ai_bizvoucher", (DynamicObject)voucherObj, (String)Long.toString(voucher.getOrgId()), (int)vchList.size());
        int i = 0;
        for (IVoucher<?> v : vchList) {
            if (numbers == null || numbers.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e8b\u4ef6\u5e93\u672a\u8bbe\u7f6e\u6216\u672a\u542f\u7528\u7f16\u7801\u89c4\u5219", (String)"DapBillnoUtil_1", (String)"fi-ai-mservice", (Object[])new Object[0]));
            }
            v.setNumber(numbers[i++]);
        }
    }

    private static List<DynamicObject> convertToDynamicObject(List<IVoucher<?>> vouchers, ISingleTaskContext taskContext, Map<Long, IVoucher> dyVoucherMap) {
        if (vouchers == null || vouchers.isEmpty()) {
            return null;
        }
        ArrayList<DynamicObject> ret = new ArrayList<DynamicObject>(vouchers.size());
        for (IVoucher<?> glvoucher : vouchers) {
            DynamicObject voucherObj = BusinessDataServiceHelper.newDynamicObject((String)"gl_voucher");
            voucherObj.set("bizdate", (Object)glvoucher.getBizDate());
            voucherObj.set("bookeddate", (Object)glvoucher.getBookedDate());
            voucherObj.set(FIELD_GL_BILLNO, (Object)glvoucher.getNumber());
            voucherObj.set(FIELD_GL_ORG, (Object)BaseDataLoader.loadOrg((ISingleTaskContext)taskContext, (Long)glvoucher.getOrgId()));
            voucherObj.set("period", (Object)BaseDataLoader.loadPeriod((ISingleTaskContext)taskContext, (Long)glvoucher.getPeriodId()));
            voucherObj.set("sourcetype", (Object)glvoucher.getSourceType());
            DynamicObject vtp = BusinessDataServiceHelper.newDynamicObject((String)"gl_vouchertype");
            VoucherType vt = BaseDataLoader.loadVchType((IBuildVchContext)taskContext.getBuildVchContext(), (Long)glvoucher.getVchTypeId());
            vtp.set("id", (Object)vt.getId());
            vtp.set("name", (Object)vt.getName());
            vtp.set("number", (Object)vt.getNumber());
            voucherObj.set("vouchertype", (Object)vtp);
            voucherObj.set(FIELD_GL_BILLSTAUS, (Object)"A");
            voucherObj.set(FIELD_GL_SOURCEBILL, (Object)glvoucher.getSourceBillId());
            dyVoucherMap.put(glvoucher.getSourceBillId(), glvoucher);
            ret.add(voucherObj);
        }
        return ret;
    }

    public static void reyGLVoucherBillNo(List<IVoucher<?>> vouchers, ISingleTaskContext taskContext) {
        logger.info("\u4e8c\u6b21\u5408\u5e76\u56de\u6536\u65ad\u53f7");
        HashMap<Long, IVoucher> dyVoucherMap = new HashMap<Long, IVoucher>();
        List<DynamicObject> glVouchers = DapBillnoUtil.convertToDynamicObject(vouchers, taskContext, dyVoucherMap);
        if (glVouchers == null || glVouchers.isEmpty()) {
            return;
        }
        ICodeRuleService crservice = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        glVouchers.stream().forEach(v -> crservice.recycleNumber("gl_voucher", v, v.getString("org_id"), v.getString(FIELD_GL_BILLNO)));
    }
}

