/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.dap;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.AcctBook;
import kd.fi.ai.AppBookConfig;
import kd.fi.ai.BizBook;
import kd.fi.ai.dap.AppBizBookConfigCache;
import kd.fi.ai.dap.DapCache;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.util.DapUtil;
import kd.fi.bd.business.service.GLAccountBookService;

public class DapBookHelper {
    private Map<String, Set<AcctBook>> bizBook2AcctBookCache;
    private Map<Long, Set<AcctBook>> acctOrgCache;
    private BilBookResult result;

    public DapBookHelper(Map<String, Set<AcctBook>> bizBook2AcctBookCache, Map<Long, Set<AcctBook>> acctOrgCache) {
        this.bizBook2AcctBookCache = bizBook2AcctBookCache;
        this.acctOrgCache = acctOrgCache;
        this.result = new BilBookResult();
    }

    public BilBookResult getSingleBillAcctBook(String billTypeKey, List<String> orgPropNames, String bookPropName, String bookTypePropName, DynamicObject bill) {
        return this.getSingleBillAcctBook(billTypeKey, orgPropNames, bookPropName, bookTypePropName, bill, 0L);
    }

    public BilBookResult getSingleBillAcctBook(String billTypeKey, List<String> orgPropNames, String bookPropName, String bookTypePropName, DynamicObject bill, long eventClassID) {
        this.result = new BilBookResult();
        for (String orgPropName : orgPropNames) {
            Long orgid = bill.getLong(orgPropName);
            this.getBookAndAddMap(billTypeKey, bookPropName, bookTypePropName, bill, orgid, orgPropName, eventClassID);
        }
        Set<AcctBook> acctBooks = this.result.getAcctBooks();
        boolean realBook = false;
        HashSet<AcctBook> fakeBook = new HashSet<AcctBook>();
        for (AcctBook ab : acctBooks) {
            if (ab.getBookID() != 0L) {
                realBook = true;
                continue;
            }
            fakeBook.add(ab);
        }
        if (realBook && fakeBook.size() > 0) {
            acctBooks.removeAll(fakeBook);
            Set<Map.Entry<String, Set<AcctBook>>> bizcache = this.bizBook2AcctBookCache.entrySet();
            for (Map.Entry<String, Set<AcctBook>> e : bizcache) {
                e.getValue().removeAll(fakeBook);
            }
        }
        return this.result;
    }

    private void getBookAndAddMap(String billTypeKey, String bookPropName, String bookTypePropName, DynamicObject bill, Long orgid, String orgField, long eventClassID) {
        if (StringUtils.isBlank((CharSequence)bookPropName)) {
            if (StringUtils.isBlank((CharSequence)bookTypePropName)) {
                this.addOrgBookTypeMap(billTypeKey, bill, orgid, 0L, 0L, orgField, eventClassID);
            } else {
                Long bookTypeID = bill.getLong(bookTypePropName);
                this.addOrgBookTypeMap(billTypeKey, bill, orgid, 0L, bookTypeID, orgField, eventClassID);
            }
        } else {
            Long bookID = bill.getLong(bookPropName);
            Long bookTypeID = 0L;
            if (StringUtils.isNotBlank((CharSequence)bookTypePropName)) {
                bookTypeID = bill.getLong(bookTypePropName);
            }
            this.addOrgBookTypeMap(billTypeKey, bill, orgid, bookID, bookTypeID, orgField, eventClassID);
        }
    }

    private void addOrgBookTypeMap(String billTypeKey, DynamicObject bill, Long orgid, Long bookid, Long bookTypeid, String orgField, long eventClassID) {
        if (orgid == null || orgid == 0L) {
            this.result.setNoOrg(true);
            return;
        }
        Set<AcctBook> bookSet = null;
        BizBook bizBook = new BizBook((orgid = Long.valueOf(this.getOrgIdForCostcenter(billTypeKey, bill, orgField, orgid, eventClassID))).longValue(), bookTypeid.longValue(), bookid.longValue(), orgField);
        if (this.bizBook2AcctBookCache.containsKey(bizBook.toString())) {
            bookSet = this.bizBook2AcctBookCache.get(bizBook.toString());
        } else {
            MainEntityType mType = EntityMetadataCache.getDataEntityType((String)billTypeKey);
            if (AppBizBookConfigCache.getInstance().isBookOnOrg(mType.getBizAppNumber())) {
                bookSet = this.getAcctBookFromBizOrg(mType.getBizAppNumber(), bizBook, billTypeKey);
            } else if (bookid != 0L || bookTypeid != 0L) {
                bookSet = this.getAcctBookFromBizBook(bizBook, billTypeKey, orgField);
            }
            if (bookid == 0L && bookTypeid == 0L && (bookSet == null || bookSet.size() == 0)) {
                bookSet = new HashSet<AcctBook>();
                if (this.acctOrgCache.containsKey(orgid)) {
                    bookSet = this.acctOrgCache.get(orgid);
                    HashSet<AcctBook> copyAcctBook = new HashSet<AcctBook>(16);
                    for (AcctBook abk : bookSet) {
                        if (abk.getBizOrgField().equals(orgField)) {
                            copyAcctBook.add(abk);
                            continue;
                        }
                        copyAcctBook.add(new AcctBook(abk.getAcctOrgID(), abk.getBookTypeID(), abk.getBookID(), abk.getBizOrgID(), orgField));
                    }
                    bookSet = copyAcctBook;
                } else {
                    bookSet = DapUtil.getAcctBookIncludeSelf((long)orgid, (String)orgField);
                    this.acctOrgCache.put(orgid, bookSet);
                }
            }
            this.bizBook2AcctBookCache.put(bizBook.toString(), bookSet);
        }
        if (bookSet == null || bookSet.size() == 0) {
            this.result.getNoBookOrgs().add(orgid);
            return;
        }
        for (AcctBook ab : bookSet) {
            this.result.getAcctBooks().add(ab);
        }
    }

    private Set<AcctBook> getAcctBookFromBizOrg(String bizAppNumber, BizBook bizBook, String billTypeKey) {
        AppInfo app = AppMetadataCache.getAppInfo((String)bizAppNumber);
        Set glBookids = GLAccountBookService.queryGlAccountBook((String)app.getId(), (Long)0L, (Long)bizBook.getAcctOrgID());
        HashSet<AcctBook> res = new HashSet<AcctBook>(16);
        DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,org,bookstype", (QFilter[])new QFilter("id", "in", (Object)glBookids).toArray());
        for (DynamicObject glb : books) {
            res.add(new AcctBook(glb.getLong("org"), glb.getLong("bookstype"), glb.getLong("id"), bizBook.getAcctOrgID(), bizBook.getBizOrgField()));
        }
        return res;
    }

    private Set<AcctBook> getAcctBookFromBizBook(BizBook bizBook, String billTypeKey, String orgField) {
        if (bizBook.getBookID() != 0L) {
            String appNumber = DapCache.getBillEntityAppNumber((String)billTypeKey);
            AppBookConfig appconfig = DapCache.appConfig.get(appNumber);
            QFilter orgFilter = new QFilter(appconfig.bookEntityOrgField, "=", (Object)bizBook.getAcctOrgID());
            QFilter idFilter = new QFilter("id", "=", (Object)bizBook.getBookID());
            boolean exist = QueryServiceHelper.exists((String)appconfig.bookEntity, (QFilter[])new QFilter[]{idFilter, orgFilter});
            if (!exist) {
                return null;
            }
            return this.queryGLBook(bizBook.getBookID(), appconfig, bizBook.getAcctOrgID(), orgField);
        }
        String appNumber = DapCache.getBillEntityAppNumber((String)billTypeKey);
        AppBookConfig appconfig = DapCache.appConfig.get(appNumber);
        QFilter orgFilter = new QFilter(appconfig.bookEntityOrgField, "=", (Object)bizBook.getAcctOrgID());
        QFilter typeFilter = new QFilter(appconfig.bookEntityTypeField, "=", (Object)bizBook.getBookTypeID());
        DynamicObject bizBookObj = BusinessDataServiceHelper.loadSingle((String)appconfig.bookEntity, (String)"id", (QFilter[])new QFilter[]{orgFilter, typeFilter});
        if (bizBookObj != null) {
            return this.queryGLBook(bizBookObj.getLong("id"), appconfig, bizBook.getAcctOrgID(), orgField);
        }
        return null;
    }

    private Set<AcctBook> queryGLBook(long bizBookID, AppBookConfig appconfig, long bizOrgID, String orgField) {
        AppInfo app = AppMetadataCache.getAppInfo((String)appconfig.appNumber);
        Set glBookids = GLAccountBookService.queryGlAccountBook((String)app.getId(), (Long)bizBookID, (Long)0L);
        DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,org,bookstype", (QFilter[])new QFilter("id", "in", (Object)glBookids).toArray());
        HashSet<AcctBook> res = new HashSet<AcctBook>(16);
        for (DynamicObject glb : books) {
            res.add(new AcctBook(glb.getLong("org"), glb.getLong("bookstype"), glb.getLong("id"), bizOrgID, orgField));
        }
        return res;
    }

    public static Set<Long> getBizBooks(String billEntityKey, long glBookID) {
        String billBookTypeField = DapCache.getBillBookTypeField((String)billEntityKey);
        String billBookField = DapCache.getBillBookField((String)billEntityKey);
        if (StringUtils.isNotBlank((CharSequence)billBookTypeField) || StringUtils.isNotBlank((CharSequence)billBookField)) {
            String appNumber = DapCache.getBillEntityAppNumber((String)billEntityKey);
            Map books = GLAccountBookService.queryAllBizAccountBook((long)glBookID);
            List c = (List)books.get(appNumber);
            if (c != null) {
                return new HashSet<Long>(c);
            }
        }
        return null;
    }

    private long getOrgIdForCostcenter(String billTypeKey, DynamicObject bill, String orgField, Long orgid, long eventClassID) {
        MainEntityType mType = EntityMetadataCache.getDataEntityType((String)billTypeKey);
        BasedataProp base = null;
        if (orgField.indexOf(".") == -1) {
            DynamicProperty property = mType.getProperty(orgField);
            if (property != null) {
                base = (BasedataProp)property;
            } else if (eventClassID != 0L && (property = (mType = (MainEntityType)ThreadCache.get((Object)("AiEventMeta" + eventClassID), () -> AiEventMetaUtil.getEntityType((Object)eventClassID))).getProperty(orgField)) != null) {
                base = (BasedataProp)property;
            }
        } else {
            if (eventClassID != 0L) {
                mType = (MainEntityType)ThreadCache.get((Object)("AiEventMeta" + eventClassID), () -> AiEventMetaUtil.getEntityType((Object)eventClassID));
            }
            String[] fields = orgField.split("\\.");
            DynamicObjectType entryType = ((EntryProp)mType.getProperty(fields[0])).getDynamicCollectionItemPropertyType();
            if (fields.length == 2) {
                base = (BasedataProp)entryType.getProperty(fields[1]);
            } else if (fields.length == 3) {
                DynamicObjectType subEntryType = ((SubEntryProp)entryType.getProperty(fields[1])).getDynamicCollectionItemPropertyType();
                base = (BasedataProp)subEntryType.getProperty(fields[2]);
            }
        }
        if (base != null && "bos_costcenter".equals(base.getBaseEntityId())) {
            DynamicObject dyo = QueryServiceHelper.queryOne((String)"bos_costcenter", (String)"accountorg", (QFilter[])new QFilter("id", "=", (Object)orgid).toArray());
            return dyo.getLong("accountorg");
        }
        return orgid;
    }

    public static class BilBookResult {
        private Set<AcctBook> acctBooks = new HashSet<AcctBook>();
        private boolean noOrg = false;
        private Set<Long> noBookOrgs = new HashSet<Long>();

        public Set<AcctBook> getAcctBooks() {
            return this.acctBooks;
        }

        public void setAcctBooks(Set<AcctBook> acctBooks) {
            this.acctBooks = acctBooks;
        }

        public boolean isNoOrg() {
            return this.noOrg;
        }

        public void setNoOrg(boolean noOrg) {
            this.noOrg = noOrg;
        }

        public Set<Long> getNoBookOrgs() {
            return this.noBookOrgs;
        }

        public void setNoBookOrgs(Set<Long> noBookOrgs) {
            this.noBookOrgs = noBookOrgs;
        }
    }
}

