/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.dap;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.ai.operation.DapOperationResultHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.builder.BuildVoucherType;
import kd.fi.ai.builder.SourceBillInfo;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.dap.DapCache;
import kd.fi.ai.mservice.builder.reporter.BuildVchReporter;
import kd.fi.ai.mservice.service.BuildVoucherServiceImpl;
import kd.fi.ai.mservice.service.helper.SelectTemplateUtil;

public class DapQueueConsumer
implements MessageConsumer {
    private static Log logger = LogFactory.getLog(DapQueueConsumer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object msg, String messageId, boolean resend, MessageAcker acker) {
        block65: {
            try {
                if (!(msg instanceof Map)) break block65;
                Map map = (Map)msg;
                List successPkIds = (List)map.get("billIds");
                if (successPkIds.isEmpty()) {
                    acker.ack(messageId);
                    return;
                }
                String billTypeKey = (String)map.get("billEntity");
                Object operateKey = map.get("operationKey");
                if (operateKey != null) {
                    QFilter billTypeFilter = new QFilter("fsourcebill", "=", (Object)billTypeKey);
                    QFilter enableFilter = new QFilter("enable", "!=", (Object)"0");
                    QFilter operFilter = new QFilter("oper", "=", operateKey);
                    QFilter billDataFilter = SelectTemplateUtil.getVchTemplateBillFilter(DapCache.getDapConfigCache((String)billTypeKey), successPkIds);
                    LinkedList<QFilter> filters = new LinkedList<QFilter>();
                    filters.add(billTypeFilter);
                    filters.add(enableFilter);
                    filters.add(operFilter);
                    filters.add(billDataFilter);
                    List vchTemplates = DapCache.getTemplateByFilters(filters);
                    if (vchTemplates == null || vchTemplates.size() != 1) {
                        return;
                    }
                    List<VCHTemplate> tps = SelectTemplateUtil.getBillValidTemplates(billTypeKey, successPkIds, vchTemplates);
                    if (tps == null || tps.size() != 1) {
                        return;
                    }
                }
                BuildVoucherServiceImpl mservice = new BuildVoucherServiceImpl();
                HashSet pkset = new HashSet();
                successPkIds.forEach(e -> pkset.add((Long)e));
                List opts = EntityMetadataCache.getDataEntityOperate((String)billTypeKey);
                boolean hasGenerateVoucherOpt = false;
                String genVoucherOptName = "generatevoucher";
                for (Map opt : opts) {
                    String optKey = (String)opt.get("type");
                    if (!optKey.equalsIgnoreCase("generatevoucher")) continue;
                    hasGenerateVoucherOpt = true;
                    genVoucherOptName = (String)opt.get("key");
                }
                String resultStr = null;
                if (hasGenerateVoucherOpt) {
                    OperateOption op = OperateOption.create();
                    op.setVariableValue("onTime", "true");
                    op.setVariableValue("onTimeOperateKey", (String)operateKey);
                    op.setVariableValue("BuildVoucherType", "1");
                    int waitSec = 1;
                    HashSet<Object> succIds = new HashSet<Object>(1);
                    HashSet toGenVchBillIds = new HashSet(pkset);
                    while (succIds.size() < toGenVchBillIds.size()) {
                        toGenVchBillIds.removeAll(succIds);
                        if (waitSec > 5) {
                            logger.info("DapQueueConsumer\u90e8\u5206\u6570\u636e\u591a\u6b21\u91cd\u8bd5\u672a\u751f\u6210\u51ed\u8bc1\uff1a" + toGenVchBillIds);
                            break;
                        }
                        try {
                            if (waitSec > 1) {
                                Thread.sleep(1000 * waitSec);
                            }
                        }
                        catch (InterruptedException e2) {
                            logger.info("context" + e2);
                        }
                        OperationResult result1 = OperationServiceHelper.executeOperate((String)genVoucherOptName, (String)billTypeKey, (Object[])toGenVchBillIds.toArray(), (OperateOption)op);
                        resultStr = !result1.isSuccess() ? result1.getMessage() : null;
                        succIds = new HashSet(result1.getSuccessPkIds());
                        Set noLockIds = result1.getAllErrorInfo().stream().filter(oe -> !oe.getMessage().contains(ResManager.loadKDString((String)"\u9501\u5b9a", (String)"DapQueueConsumer_0", (String)"fi-ai-mservice", (Object[])new Object[0]))).map(oe -> oe.getPkValue()).collect(Collectors.toSet());
                        succIds.addAll(noLockIds);
                        if (succIds.size() < toGenVchBillIds.size()) {
                            try (DataSet ds = QueryServiceHelper.queryDataSet((String)DapOperationResultHelper.class.getName(), (String)"ai_daptracker", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", toGenVchBillIds), new QFilter("billtype", "=", (Object)billTypeKey)}, null);){
                                for (Row row : ds) {
                                    succIds.add(row.getLong("sourcebillid"));
                                }
                            }
                        }
                        waitSec += 2;
                    }
                } else {
                    int waitSec = 1;
                    HashSet<Long> succids = new HashSet<Long>(1);
                    HashSet toGenVchBillIds = new HashSet(pkset);
                    while (succids.size() < toGenVchBillIds.size()) {
                        toGenVchBillIds.removeAll(succids);
                        if (waitSec > 5) {
                            logger.info("DapQueueConsumer1\u90e8\u5206\u6570\u636e\u591a\u6b21\u91cd\u8bd5\u672a\u751f\u6210\u51ed\u8bc1\uff1a" + toGenVchBillIds);
                            break;
                        }
                        try {
                            if (waitSec > 1) {
                                Thread.sleep(1000 * waitSec);
                            }
                        }
                        catch (InterruptedException e3) {
                            logger.info("context" + e3);
                        }
                        Date start = new Date();
                        Calendar date = Calendar.getInstance();
                        date.setTime(start);
                        date.set(13, date.get(13) - 1);
                        HashMap<String, String> params = new HashMap<String, String>(8);
                        params.put("BuildVoucherType", "1");
                        resultStr = mservice.onTimeBuildVoucher(billTypeKey, (String)operateKey, pkset, SerializationUtils.toJsonString(params));
                        succids.clear();
                        try (DataSet ds = QueryServiceHelper.queryDataSet((String)DapOperationResultHelper.class.getName(), (String)"ai_buildreport", (String)"id,sourcebillno,fsourcebillid,buildstate", (QFilter[])new QFilter[]{new QFilter("fsourcebillid", "in", toGenVchBillIds), new QFilter("createtime", ">=", (Object)date.getTime())}, (String)"buildstate asc,createtime desc");){
                            for (Row row : ds) {
                                String state;
                                Long billid = row.getLong("fsourcebillid");
                                if (succids.contains(billid) || !"0".equals(state = row.getString("buildstate"))) continue;
                                succids.add(billid);
                            }
                        }
                        if (succids.size() < toGenVchBillIds.size()) {
                            ds = QueryServiceHelper.queryDataSet((String)DapOperationResultHelper.class.getName(), (String)"ai_daptracker", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", toGenVchBillIds)}, null);
                            var22_33 = null;
                            try {
                                for (Row row : ds) {
                                    succids.add(row.getLong("sourcebillid"));
                                }
                            }
                            catch (Throwable throwable) {
                                var22_33 = throwable;
                                throw throwable;
                            }
                            finally {
                                if (ds != null) {
                                    if (var22_33 != null) {
                                        try {
                                            ds.close();
                                        }
                                        catch (Throwable throwable) {
                                            var22_33.addSuppressed(throwable);
                                        }
                                    } else {
                                        ds.close();
                                    }
                                }
                            }
                        }
                        waitSec += 2;
                    }
                }
                if (resultStr != null) {
                    this.reportError(billTypeKey, (Long)successPkIds.get(0), resultStr);
                }
            }
            finally {
                acker.ack(messageId);
            }
        }
    }

    private void reportError(String billTypeKey, Long billID, String msg) {
        BuildVchReporter reporter = new BuildVchReporter();
        SourceBillInfo billInfo = new SourceBillInfo();
        billInfo.setEntityNumber(billTypeKey);
        String billNumber = "";
        DynamicObject billData = BusinessDataServiceHelper.loadSingle((Object)billID, (String)billTypeKey);
        try {
            billNumber = billData.getString("billno");
        }
        catch (Exception exception) {
            // empty catch block
        }
        reporter.AddErrorReport(null, billInfo, billID, billNumber, "", VoucherCheckItem.Other, VoucherErrLevel.Error, msg, "E", BuildVoucherType.OnlyBizVoucher.getValue() + "");
        reporter.SaveReoprt("gl");
    }
}

