/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.fatvs;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;

public class SkillRunnableImpl
implements ISkillRunnable {
    public static final String KEY_NUMBER = "number";
    public static final String KEY_NAME = "name";
    public static final String KEY_VALUE = "value";
    public static final String KEY_VALUE_TYPE = "valueType";
    public static final String KEY_BIZ_VOUCHER_SOURCE_BILL_PERIOD_QUANTITY = "bizVoucherSrcBillPeriodQty";
    public static final String KEY_BIZ_VOUCHER_SOURCE_BILL_QUANTITY = "bizVoucherSrcBillQty";
    public static final String KEY_BIZ_VOUCHER_ENTRY_QUANTITY = "bizVoucherEntryQty";

    public SkillRunResult pullData(SkillRunContext runContext) {
        SkillRunResult skillResult = runContext.getSkillResult();
        String skillNum = runContext.getSkillNum();
        Date startTime = runContext.getStartTime();
        Date endTime = runContext.getEndTime();
        Map<String, Integer> qtyMap = this.getData(startTime, endTime);
        List<Map<String, String>> dataList = this.processResultData(qtyMap);
        skillResult.setData(dataList);
        skillResult.setDate(startTime);
        skillResult.setSkillNum(skillNum);
        skillResult.setFailCount(Integer.valueOf(0));
        skillResult.setTotalCount(qtyMap.get(KEY_BIZ_VOUCHER_SOURCE_BILL_PERIOD_QUANTITY));
        return skillResult;
    }

    private List<Map<String, String>> processResultData(Map<String, Integer> qtyMap) {
        Integer billQty = qtyMap.get(KEY_BIZ_VOUCHER_SOURCE_BILL_QUANTITY);
        Integer bizVoucherEntryQty = qtyMap.get(KEY_BIZ_VOUCHER_ENTRY_QUANTITY);
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>(2);
        HashMap<String, String> param1Map = new HashMap<String, String>(1);
        param1Map.put(KEY_NUMBER, "bycldjsjl");
        param1Map.put(KEY_NAME, ResManager.loadKDString((String)"\u672c\u6708\u5904\u7406\u5355\u636e\u91cf", (String)"SkillRunnableImpl_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
        param1Map.put(KEY_VALUE, String.valueOf(billQty));
        param1Map.put(KEY_VALUE_TYPE, "0");
        HashMap<String, String> param2Map = new HashMap<String, String>(1);
        param2Map.put(KEY_NUMBER, "byscywpzfls");
        param2Map.put(KEY_NAME, ResManager.loadKDString((String)"\u672c\u6708\u751f\u6210\u4e1a\u52a1\u51ed\u8bc1\u5206\u5f55\u6570", (String)"SkillRunnableImpl_1", (String)"fi-ai-mservice", (Object[])new Object[0]));
        param2Map.put(KEY_VALUE, String.valueOf(bizVoucherEntryQty));
        param2Map.put(KEY_VALUE_TYPE, "0");
        dataList.add(param1Map);
        dataList.add(param2Map);
        return dataList;
    }

    private Map<String, Integer> getData(Date startTime, Date endTime) {
        HashMap<String, Integer> qtyMap = new HashMap<String, Integer>(4);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select count(distinct a.fsourcebillid) as srcPeriodCount from t_ai_bizvoucher a inner join t_ai_bizvoucherentry b on a.fid=b.fid where a.fcreatetime >= ? and a.fcreatetime <= ?", new Object[]{startTime, endTime});
        Integer srcPeriodCount = (Integer)DB.query((DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getInt("srcPeriodCount");
            }
            return 0;
        });
        qtyMap.put(KEY_BIZ_VOUCHER_SOURCE_BILL_PERIOD_QUANTITY, srcPeriodCount);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(startTime);
        calendar.set(5, 1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date firstDay = calendar.getTime();
        ((Calendar)calendar).add(2, 1);
        ((Calendar)calendar).add(13, -1);
        Date lastDay = calendar.getTime();
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select count(distinct a.fsourcebillid) as srcCount from t_ai_bizvoucher a inner join t_ai_bizvoucherentry b on a.fid=b.fid where a.fcreatetime >= ? and a.fcreatetime <= ?", new Object[]{firstDay, lastDay});
        Integer srcCount = (Integer)DB.query((DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getInt("srcCount");
            }
            return 0;
        });
        qtyMap.put(KEY_BIZ_VOUCHER_SOURCE_BILL_QUANTITY, srcCount);
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select count(1) as entryCount from t_ai_bizvoucher a inner join t_ai_bizvoucherentry b on a.fid=b.fid where a.fcreatetime >= ? and a.fcreatetime <= ?", new Object[]{firstDay, lastDay});
        Integer entryCount = (Integer)DB.query((DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getInt("entryCount");
            }
            return 0;
        });
        qtyMap.put(KEY_BIZ_VOUCHER_ENTRY_QUANTITY, entryCount);
        return qtyMap;
    }
}

