/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder;

import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.ai.builder.BuildVchProgressInfo;
import kd.fi.ai.builder.BuildVoucherType;
import kd.fi.ai.builder.GLVoucherUnionType;
import kd.fi.ai.mservice.builder.BuildVchEngine;
import kd.fi.ai.mservice.builder.BuildVchScheme;
import kd.fi.ai.mservice.builder.BuildVchService;
import kd.fi.ai.mservice.builder.SelectedAcctBook;
import kd.fi.ai.mservice.builder.SelectedSourceBill;
import kd.fi.ai.mservice.builder.SingleTaskEngine;

public class BuildVchServiceImpl
implements BuildVchService {
    private Object lock;

    public BuildVchServiceImpl(Object lock) {
        this.lock = lock;
    }

    public BuildVchServiceImpl() {
    }

    public void BuildSingleTask(String transId, String taskId) {
        SingleTaskEngine engine = new SingleTaskEngine();
        engine.BuildSingleTask(transId, taskId, this.lock);
    }

    public String BuildVoucher(BuildVchScheme scheme) throws Exception {
        String batchCacheId;
        String transId = scheme.getTransId();
        if (StringUtils.isBlank((CharSequence)transId)) {
            transId = "";
            scheme.setTransId(transId);
        }
        if (StringUtils.isBlank((CharSequence)(batchCacheId = scheme.getBatchCacheId()))) {
            batchCacheId = UUID.randomUUID().toString();
            scheme.setBatchCacheId(batchCacheId);
        }
        BuildVchEngine engine = new BuildVchEngine();
        engine.BuildVoucher(scheme);
        return transId;
    }

    public String BuildVoucher(Map<String, Object> map) throws Exception {
        BuildVchScheme scheme = this.getBuildScheme(map);
        return this.BuildVoucher(scheme);
    }

    private BuildVchScheme getBuildScheme(Map<String, Object> map) {
        BuildVchScheme scheme = new BuildVchScheme();
        scheme.setTransId(UUID.randomUUID().toString());
        SelectedAcctBook acctBook = new SelectedAcctBook();
        acctBook.setBookId(((Long)map.get("bookId")).longValue());
        acctBook.setPeriodId(((Long)map.get("periodId")).longValue());
        acctBook.setCoverGLVoucher(false);
        String buildType = (String)map.get("buildVoucherType");
        if (String.valueOf(BuildVoucherType.OnlyBizVoucher.ordinal()).equals(buildType)) {
            acctBook.setBuildVoucherType(BuildVoucherType.OnlyBizVoucher);
        } else if (String.valueOf(BuildVoucherType.OnlyGLVoucher.ordinal()).equals(buildType)) {
            acctBook.setBuildVoucherType(BuildVoucherType.OnlyGLVoucher);
        } else {
            acctBook.setBuildVoucherType(BuildVoucherType.BizAndGLVoucher);
        }
        SelectedSourceBill sourceBill = new SelectedSourceBill();
        sourceBill.setEntityNumber((String)map.get("entityNumber"));
        long billIdString = (Long)map.get("billIds");
        sourceBill.getBillIds().add(billIdString);
        String unionType = (String)map.get("unionType");
        if (String.valueOf(GLVoucherUnionType.UnionAll.getValue()).equals(unionType)) {
            sourceBill.setUnionType(GLVoucherUnionType.UnionAll);
        } else if (String.valueOf(GLVoucherUnionType.UnionByFields.getValue()).equals(unionType)) {
            sourceBill.setUnionType(GLVoucherUnionType.UnionByFields);
        } else if (String.valueOf(GLVoucherUnionType.UnionSpanBill.getValue()).equals(unionType)) {
            sourceBill.setUnionType(GLVoucherUnionType.UnionSpanBill);
        } else {
            sourceBill.setUnionType(GLVoucherUnionType.Single);
        }
        String unionFieldKeys = (String)map.get("unionFields");
        sourceBill.setUnionFields(unionFieldKeys);
        acctBook.getSelectedSourceBills().add(sourceBill);
        scheme.getSelectedBooks().add(acctBook);
        return scheme;
    }

    public void CancelBuildVoucherProgress(String transId) {
    }

    public BuildVchProgressInfo GetBuildVoucherProgress(String transId) {
        BuildVchProgressInfo progressInfo = new BuildVchProgressInfo();
        return progressInfo;
    }
}

