/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.builder.AcctBookInfo;
import kd.fi.ai.builder.BuildVoucherType;
import kd.fi.ai.builder.GLVoucherUnionType;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.SingleTaskInfo;
import kd.fi.ai.builder.SourceBillInfo;
import kd.fi.ai.dap.MutexRequireUtil;
import kd.fi.ai.enums.ZeroAmountSysParamEnum;
import kd.fi.ai.exception.DapException;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.context.BuildVchContext;
import kd.fi.ai.mservice.builder.context.SingleTaskContext;
import kd.fi.ai.mservice.builder.helper.CacheHelper;
import kd.fi.ai.mservice.builder.helper.SourceBillHelper;
import kd.fi.ai.mservice.builder.singletaskaction.AbstractSingleTaskAction;
import kd.fi.ai.mservice.builder.singletaskaction.AddCustFieldsAction;
import kd.fi.ai.mservice.builder.singletaskaction.AddExpandFieldAction;
import kd.fi.ai.mservice.builder.singletaskaction.BuildBizVoucherAction;
import kd.fi.ai.mservice.builder.singletaskaction.BuildGLVoucherAction;
import kd.fi.ai.mservice.builder.singletaskaction.CompileTemplateAction;
import kd.fi.ai.mservice.builder.singletaskaction.CreateSetValueHelperAction;
import kd.fi.ai.mservice.builder.singletaskaction.CreateTaskPluginAction;
import kd.fi.ai.mservice.builder.singletaskaction.HandleEventBlockAction;
import kd.fi.ai.mservice.builder.singletaskaction.InitTaskVariableAction;
import kd.fi.ai.mservice.builder.singletaskaction.LoadBizVoucherByBillIdAction;
import kd.fi.ai.mservice.builder.singletaskaction.LoadBizVoucherRowsAction;
import kd.fi.ai.mservice.builder.singletaskaction.LoadSouceBillRowsAction;
import kd.fi.ai.mservice.builder.singletaskaction.MergeBookTasksLast;
import kd.fi.ai.mservice.builder.singletaskaction.MergeBookTasksResult;
import kd.fi.ai.mservice.builder.singletaskaction.PreviewVoucherAction;
import kd.fi.ai.mservice.builder.singletaskaction.ReParationDapTrackerAction;
import kd.fi.ai.mservice.builder.singletaskaction.SaveBizVoucherTaskResult;
import kd.fi.ai.mservice.builder.singletaskaction.SaveBookTasksResult;
import kd.fi.ai.mservice.builder.singletaskaction.SelectSourceEntityAction;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.util.FieldReplaceUtil;
import kd.fi.v2.fah.optimizor.FahOptimizeControlPanel;
import kd.fi.v2.fah.utils.ParamUtils;

public class SingleTaskEngine {
    private static Log log = LogFactory.getLog(SingleTaskEngine.class);

    public void BuildSingleTask(String transId, String taskId, Object lock) {
        BuildVchContext context = CacheHelper.getContext(transId);
        context.Initialize();
        ISingleTaskContext taskContext = null;
        try {
            context.getProgresser().BeginTask(taskId);
            SingleTaskInfo taskInfo = context.getProgresser().getCurrTaskInfo();
            if (taskInfo == null) {
                return;
            }
            this.fixIdDataType(taskInfo);
            taskContext = this.CreateTaskContext(context, taskInfo);
            taskContext.setLock(lock);
            SingleTaskResult taskResult = this.CreateTaskResult(taskContext);
            context.getReporter().BeginTask(taskContext);
            List<AbstractSingleTaskAction> actions = this.CreateLogicActions(taskContext, taskResult);
            if (taskContext.getShowInfo().booleanValue()) {
                log.info(ResManager.loadKDString((String)"\u6784\u5efa\u903b\u8f91\u5355\u5143\u5b8c\u6bd5\uff0c\u5f00\u59cb\u9010\u4e2a\u6267\u884c\u5355\u5143\u3002", (String)"SingleTaskEngine_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
            }
            for (AbstractSingleTaskAction action : actions) {
                action.Do();
            }
        }
        catch (Exception exp) {
            log.info("--DAP--" + ExceptionUtils.getExceptionStackTraceMessage((Exception)exp));
            if (exp instanceof DapException) {
                throw exp;
            }
            String message = exp.getMessage() != null && exp.getMessage().length() > 50 ? StringUtils.substring((String)exp.getMessage(), (int)0, (int)50) : exp.getMessage();
            DapException dexp = new DapException(message, (Throwable)exp);
            dexp.setExceptionstack((Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)exp));
            throw dexp;
        }
        finally {
            if (taskContext != null && taskContext.getReBillLockFormMutexL().size() > 0) {
                List relationshipSourcebillcol = taskContext.getTemplate().getRelationshipSourcebillcol();
                for (String v : relationshipSourcebillcol) {
                    MutexRequireUtil.batchRelease((String)v, (Set)taskContext.getReBillLockFormMutexL());
                }
            }
        }
    }

    private ISingleTaskContext CreateTaskContext(IBuildVchContext context, SingleTaskInfo taskInfo) {
        SingleTaskContext taskContext = new SingleTaskContext();
        taskContext.setTaskId(taskInfo.getTaskId());
        taskContext.setBuildVchContext(context);
        AcctBookInfo bookInfo = (AcctBookInfo)context.getBooks().get(taskInfo.getBookId());
        SourceBillInfo sourceBill = (SourceBillInfo)bookInfo.getSourceBills().get(taskInfo.getEntityNumber());
        MainEntityType srcEntityType = SourceBillHelper.getMainEntityType(taskInfo.getEntityNumber());
        VCHTemplate template = null;
        if (!StringUtils.isBlank((CharSequence)taskInfo.getTemplateId())) {
            template = (VCHTemplate)sourceBill.getVchTemplates().get(taskInfo.getTemplateId());
        }
        taskContext.setZeroAmountGenEntryParam(ZeroAmountSysParamEnum.parseByValue((String)ParamUtils.getZeroAmountParam((Long)bookInfo.getAcctOrgId())));
        taskContext.setBookInfo(bookInfo);
        taskContext.setSourceBill(sourceBill);
        if (template != null && template.getEventClassId() != 0L) {
            taskContext.setSrcEntityType(AiEventMetaUtil.getEntityType((Object)template.getEventClassId()));
        } else {
            taskContext.setSrcEntityType(srcEntityType);
        }
        taskContext.setTemplate(template);
        taskContext.getSrcBillIds().addAll(taskInfo.getSrcBillIds());
        taskContext.getHistBizVchIds().addAll(taskInfo.getHistBizVoucherIds());
        taskContext.setGroupEntryName(taskInfo.getGroupEntryName());
        taskContext.setAttachs(taskInfo.getAttachs());
        taskContext.getEntryIds().addAll(taskInfo.getEntryIds());
        taskContext.setShowInfo(bookInfo.getAcctOrgId(), 0L);
        BuildVchContext bc = (BuildVchContext)context;
        taskContext.setOpr(bc.getScheme().getOpr());
        taskContext.setBuildType(bc.getScheme().getBuildType());
        taskContext.setReOper(bc.getScheme().getReoper());
        taskContext.setcurr_succIds_cacheKey(bc.getScheme().getCurr_succIds_cacheKey());
        taskContext.setGenVoucherMemoryMergeTask(bc.getScheme().getGvMemory());
        taskContext.setEnableBizVoucher();
        taskContext.setEnableBizVoucherByOrg(bookInfo.getAcctOrgId());
        taskContext.setVoucherByAcct(bookInfo.getAcctOrgId());
        String templateEntityNumber = "";
        if (template != null) {
            DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)template.getId(), (String)"ai_vchtemplate", (String)"fsourcebill.id");
            templateEntityNumber = dyn.getString("fsourcebill.id");
            template.setSourceBill(taskInfo.getEntityNumber());
        }
        if (!taskInfo.getEntityNumber().equalsIgnoreCase(templateEntityNumber)) {
            taskContext.setTemplateEntityName(templateEntityNumber);
            Map commonAndSourceFieldcol = FieldReplaceUtil.getCommonAndSourceFieldcol((String)templateEntityNumber, (String)taskInfo.getEntityNumber());
            taskContext.setCommonAndSourceFieldcol(commonAndSourceFieldcol);
        }
        taskContext.setPreBuild(((BuildVchContext)context).getScheme().isPreBuild());
        taskContext.setBuildBizvoucherFromMidle(((BuildVchContext)context).getScheme().isBuildBizvoucherFromMidle());
        taskContext.setVchTemplatePreVoucher(((BuildVchContext)context).getScheme().isVchTemplatePreVoucher());
        taskContext.setParallelEntryJoinResultMaxSize(FahOptimizeControlPanel.getParallelEntryJoinResultMaxSize());
        if (taskContext.isPreBuild().booleanValue() && template != null) {
            template.setUnionType(GLVoucherUnionType.Single);
            template.setSubmit(true);
        }
        this.inizCustomKeyInfoData(taskContext, bc.getScheme().getBilltypeAndCustomkey());
        return taskContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inizCustomKeyInfoData(ISingleTaskContext taskContext, Map<String, Map<String, List<String>>> billtypeAndCustomkey) {
        if (billtypeAndCustomkey.isEmpty()) {
            return;
        }
        String entityNumber = taskContext.getSourceBill().getEntityNumber();
        Map<String, List<String>> ifo = billtypeAndCustomkey.get(entityNumber);
        List ids = taskContext.getSrcBillIds().stream().map(v -> Long.parseLong(v.toString())).collect(Collectors.toList());
        HashMap result = new HashMap(ids.size());
        if (taskContext.getShowInfo().booleanValue()) {
            log.info("--DAP--inizCustomKeyInfoData: --ifo:" + ifo + ";ids:" + ids);
        }
        if (ifo != null && ifo.get("bill") != null && !ifo.get("bill").isEmpty() && !ids.isEmpty()) {
            HashSet<String> params = new HashSet<String>((Collection)ifo.get("bill"));
            List<String> voucherparams = ifo.get("voucher");
            List<String> customuniquekey = ifo.get("customuniquekey");
            params.add("id");
            String join = String.join((CharSequence)",", params);
            try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.builder.SingleTaskEngine", (String)entityNumber, (String)join, (QFilter[])new QFilter("id", "in", ids).toArray(), null);){
                for (Row row : queryDataSet) {
                    Object id = row.get("id");
                    HashMap<String, Object> ps = new HashMap<String, Object>(params.size());
                    for (String param : params) {
                        ps.put(param, row.get(param));
                    }
                    ps.put("voucher", voucherparams);
                    ps.put("customuniquekey", customuniquekey);
                    result.put(entityNumber + "-" + id, ps);
                }
            }
        } else if (ifo != null && ifo.get("voucher") != null && !ifo.get("voucher").isEmpty() && !ids.isEmpty()) {
            List<String> voucherparams = ifo.get("voucher");
            List<String> customuniquekey = ifo.get("customuniquekey");
            for (Long id : ids) {
                HashMap<String, List<String>> ps = new HashMap<String, List<String>>(8);
                ps.put("voucher", voucherparams);
                ps.put("customuniquekey", customuniquekey);
                result.put(entityNumber + "-" + id, ps);
            }
        }
        taskContext.setCustomKey(result);
    }

    private SingleTaskResult CreateTaskResult(ISingleTaskContext taskContext) {
        SingleTaskResult taskResult = new SingleTaskResult();
        return taskResult;
    }

    private List<AbstractSingleTaskAction> CreateLogicActions(ISingleTaskContext taskContext, SingleTaskResult taskResult) {
        BuildVchContext context = (BuildVchContext)taskContext.getBuildVchContext();
        String pageId = context.getScheme().getPageId();
        ArrayList<AbstractSingleTaskAction> actions = new ArrayList<AbstractSingleTaskAction>(13);
        String tag = "";
        if (taskContext.getBookInfo().getBuildVoucherType() == BuildVoucherType.OnlyGLVoucher) {
            tag = "G";
            actions.add(new InitTaskVariableAction(taskContext, taskResult));
            actions.add(new CreateTaskPluginAction(taskContext, taskResult));
            actions.add(new LoadBizVoucherRowsAction(taskContext, taskResult));
            actions.add(new CompileTemplateAction(taskContext, taskResult));
            actions.add(new SelectSourceEntityAction(taskContext, taskResult));
            actions.add(new LoadSouceBillRowsAction(taskContext, taskResult));
            actions.add(new BuildGLVoucherAction(taskContext, taskResult));
            actions.add(new MergeBookTasksResult(taskContext, taskResult));
            actions.add(new ReParationDapTrackerAction(taskContext, taskResult));
            actions.add(new SaveBookTasksResult(taskContext, taskResult));
        } else if (taskContext.getBookInfo().getBuildVoucherType() == BuildVoucherType.OnlyBizVoucher) {
            tag = "O";
            actions.add(new InitTaskVariableAction(taskContext, taskResult));
            actions.add(new CreateTaskPluginAction(taskContext, taskResult));
            actions.add(new LoadBizVoucherByBillIdAction(taskContext, taskResult));
            actions.add(new AddExpandFieldAction(taskContext, taskResult));
            actions.add(new AddCustFieldsAction(taskContext, taskResult));
            actions.add(new CompileTemplateAction(taskContext, taskResult));
            actions.add(new SelectSourceEntityAction(taskContext, taskResult));
            actions.add(new LoadSouceBillRowsAction(taskContext, taskResult));
            actions.add(new CreateSetValueHelperAction(taskContext, taskResult));
            actions.add(new BuildBizVoucherAction(taskContext, taskResult));
            actions.add(new MergeBookTasksResult(taskContext, taskResult));
            actions.add(new MergeBookTasksLast(taskContext, taskResult));
            actions.add(new SaveBizVoucherTaskResult(taskContext, taskResult));
        } else if (StringUtils.isNotBlank((CharSequence)pageId)) {
            tag = "P";
            actions.add(new InitTaskVariableAction(taskContext, taskResult));
            actions.add(new CreateTaskPluginAction(taskContext, taskResult));
            actions.add(new LoadBizVoucherByBillIdAction(taskContext, taskResult));
            actions.add(new AddExpandFieldAction(taskContext, taskResult));
            actions.add(new AddCustFieldsAction(taskContext, taskResult));
            actions.add(new CompileTemplateAction(taskContext, taskResult));
            actions.add(new SelectSourceEntityAction(taskContext, taskResult));
            actions.add(new LoadSouceBillRowsAction(taskContext, taskResult));
            actions.add(new CreateSetValueHelperAction(taskContext, taskResult));
            actions.add(new BuildBizVoucherAction(taskContext, taskResult));
            actions.add(new MergeBookTasksResult(taskContext, taskResult));
            actions.add(new PreviewVoucherAction(taskContext, taskResult));
        } else {
            tag = "B";
            actions.add(new InitTaskVariableAction(taskContext, taskResult));
            actions.add(new CreateTaskPluginAction(taskContext, taskResult));
            actions.add(new LoadBizVoucherByBillIdAction(taskContext, taskResult));
            actions.add(new AddExpandFieldAction(taskContext, taskResult));
            actions.add(new AddCustFieldsAction(taskContext, taskResult));
            actions.add(new CompileTemplateAction(taskContext, taskResult));
            actions.add(new SelectSourceEntityAction(taskContext, taskResult));
            actions.add(new LoadSouceBillRowsAction(taskContext, taskResult));
            actions.add(new CreateSetValueHelperAction(taskContext, taskResult));
            actions.add(new BuildBizVoucherAction(taskContext, taskResult));
            actions.add(new MergeBookTasksResult(taskContext, taskResult));
            actions.add(new MergeBookTasksLast(taskContext, taskResult));
            actions.add(new SaveBookTasksResult(taskContext, taskResult));
            actions.add(new HandleEventBlockAction(taskContext, taskResult));
        }
        log.info("--DAP--actions:" + tag);
        return actions;
    }

    private void fixIdDataType(SingleTaskInfo taskInfo) {
        block3: {
            ISimpleProperty pkProperty;
            ArrayList oldIds;
            block2: {
                oldIds = new ArrayList();
                oldIds.addAll(taskInfo.getSrcBillIds());
                String entityId = taskInfo.getEntityNumber();
                MainEntityType mainEntityType = SourceBillHelper.getMainEntityType(entityId);
                pkProperty = mainEntityType.getPrimaryKey();
                if (!(pkProperty instanceof VarcharProp)) break block2;
                taskInfo.getSrcBillIds().clear();
                for (Object id : oldIds) {
                    taskInfo.getSrcBillIds().add(id.toString());
                }
                break block3;
            }
            if (!(pkProperty instanceof LongProp)) break block3;
            taskInfo.getSrcBillIds().clear();
            for (Object id : oldIds) {
                taskInfo.getSrcBillIds().add(Long.valueOf(id.toString()));
            }
        }
    }
}

