/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.compiler;

import java.util.HashMap;
import java.util.Map;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.compiler.AbstractCompiler;
import kd.fi.ai.mservice.builder.getvaluehandle.ConditionGetHandle;
import kd.fi.ai.mservice.builder.getvaluemode.AutoMode;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;
import kd.fi.ai.mservice.builder.helper.BuildHelper;

public class AiEventMustInputCompiler
extends AbstractCompiler {
    private Map<String, ConditionGetHandle> fieldConditionMap = new HashMap<String, ConditionGetHandle>(16);
    private Map<String, String> fieldFilterMap = new HashMap<String, String>(16);

    public AiEventMustInputCompiler(ISingleTaskContext taskContext, Map<String, String> fieldFilterMap) {
        super(taskContext);
        this.fieldFilterMap = fieldFilterMap;
    }

    @Override
    protected void DoParseFields() {
        super.DoParseFields();
        AutoMode numberMode = new AutoMode(this.taskContext, "number");
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, numberMode.getVars());
        for (Map.Entry<String, ConditionGetHandle> conditionGetHandleEntry : this.fieldConditionMap.entrySet()) {
            ConditionGetHandle conditionGetHandle = conditionGetHandleEntry.getValue();
            AutoMode mode = new AutoMode(this.taskContext, conditionGetHandleEntry.getKey());
            BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, mode.getVars());
            BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, conditionGetHandle.getVars());
        }
    }

    @Override
    protected void DoCompolier() {
        super.DoCompolier();
        for (Map.Entry<String, String> fieldFilter : this.fieldFilterMap.entrySet()) {
            String filterExpression = fieldFilter.getValue();
            this.fieldConditionMap.put(fieldFilter.getKey(), new ConditionGetHandle(this.taskContext, filterExpression, Boolean.TRUE));
        }
    }

    public Map<String, ConditionGetHandle> getFieldConditionMap() {
        return this.fieldConditionMap;
    }

    public void setFieldConditionMap(Map<String, ConditionGetHandle> fieldConditionMap) {
        this.fieldConditionMap = fieldConditionMap;
    }
}

