/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.compiler;

import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.SourceBillInfo;
import kd.fi.ai.mservice.builder.compiler.AbstractCompiler;
import kd.fi.ai.mservice.builder.getvaluehandle.SourceFieldGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.UnionKeyGetHandle;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;
import kd.fi.ai.mservice.builder.getvaluemode.SourceBillFieldMode;
import kd.fi.ai.mservice.builder.helper.BuildHelper;

public class SourceBillCompiler
extends AbstractCompiler {
    private SourceBillInfo sourceBillInfo;
    private SourceFieldGetHandle<String> pkGetHandle;
    private SourceFieldGetHandle<String> sourceBillNoGetHandle;
    private UnionKeyGetHandle unionKeyGetHandle;

    public SourceBillCompiler(ISingleTaskContext taskContext) {
        super(taskContext);
        this.sourceBillInfo = taskContext.getSourceBill();
    }

    public SourceFieldGetHandle<String> getPkGetHandle() {
        return this.pkGetHandle;
    }

    public SourceFieldGetHandle<String> getSourceBillNoGetHandle() {
        return this.sourceBillNoGetHandle;
    }

    public UnionKeyGetHandle getUnionKeyGetHandle() {
        return this.unionKeyGetHandle;
    }

    @Override
    protected void DoCompolier() {
        super.DoCompolier();
        MainEntityType mainEntityType = this.taskContext.getSrcEntityType();
        this.pkGetHandle = new SourceFieldGetHandle<String>(this.taskContext, mainEntityType.getPrimaryKey().getName(), "");
        if (this.taskContext.getTemplate().getEventClassId() != 0L) {
            this.sourceBillNoGetHandle = new SourceFieldGetHandle<String>(this.taskContext, "number", "");
        } else {
            String billNoFieldName = this.taskContext.getSrcEntityType() instanceof BillEntityType ? ((BillEntityType)this.taskContext.getSrcEntityType()).getBillNo() : "billno";
            this.sourceBillNoGetHandle = new SourceFieldGetHandle<String>(this.taskContext, billNoFieldName, "");
        }
        this.unionKeyGetHandle = new UnionKeyGetHandle(this.taskContext, this.sourceBillInfo.getUnionFields());
        String logMessage = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u5408\u5e76\u65b9\u5f0f\uff1a%s", (String)"SourceBillCompiler_0", (String)"fi-ai-mservice", (Object[])new Object[0]), this.unionKeyGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
    }

    @Override
    protected void DoParseFields() {
        String bizBookTypeField;
        super.DoParseFields();
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.pkGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.sourceBillNoGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.unionKeyGetHandle.getVars());
        MainEntityType mainEntityType = this.taskContext.getSrcEntityType();
        String bizBookField = this.taskContext.getSourceBill().getBillBookField();
        if (bizBookField != null) {
            String[] keyItems = StringUtils.split((String)bizBookField, (String)".");
            IDataEntityProperty property = mainEntityType.findProperty(keyItems[0]);
            SourceBillFieldMode bizBookVar = new SourceBillFieldMode(bizBookField, keyItems, property);
            BuildHelper.AddVarToFldList(this.selectedFields, bizBookVar);
        }
        if ((bizBookTypeField = this.taskContext.getSourceBill().getBillBookTypeField()) != null) {
            String[] keyItems = StringUtils.split((String)bizBookTypeField, (String)".");
            IDataEntityProperty property = mainEntityType.findProperty(keyItems[0]);
            SourceBillFieldMode bizBookVar = new SourceBillFieldMode(bizBookTypeField, keyItems, property);
            BuildHelper.AddVarToFldList(this.selectedFields, bizBookVar);
        }
    }
}

