/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.ai.builder.plugin.field.VchTplField;
import kd.bos.ext.fi.ai.builder.plugin.fieldenum.VchTplFieldSort;
import kd.bos.util.StringUtils;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchTplBizGroup;
import kd.fi.ai.VchTplEntry;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.mservice.builder.compiler.AbstractCompiler;
import kd.fi.ai.mservice.builder.compiler.TplEntryCompiler;
import kd.fi.ai.mservice.builder.compiler.TplGroupCompiler;
import kd.fi.ai.mservice.builder.getvaluehandle.AbstractGetValueHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.AccountGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.CheckVchTemplateFilterHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.ExplanationGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.GetValueHandleFactory;
import kd.fi.ai.mservice.builder.getvaluehandle.VchAttachmentGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.VchCashierGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.VchCreatorGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.VchExpireDateGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.VchTypeGetHandle;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;
import kd.fi.ai.mservice.builder.helper.BuildHelper;
import kd.fi.ai.util.FieldReplaceUtil;

public class TplCompiler
extends AbstractCompiler {
    private VCHTemplate vchTemplate;
    private VchTypeGetHandle vchTypeGetHandle;
    private VchExpireDateGetHandle vchDateGetHandle;
    private VchExpireDateGetHandle bizDateGetHandle;
    private ExplanationGetHandle referenceGetHandle;
    private VchAttachmentGetHandle vchAttachmentGetHandle;
    private CheckVchTemplateFilterHandle checkVchTemplateFilterHandle;
    private VchCreatorGetHandle vchCreatorGetHandle;
    private List<AccountGetHandle> accountGetHandles;
    private List<TplGroupCompiler> tplGroupCompilers = new ArrayList<TplGroupCompiler>();
    private Map<String, TplEntryCompiler> tplEntryCompilers = new HashMap<String, TplEntryCompiler>();
    private VchCashierGetHandle cashierGetHandle;
    private Map<String, AbstractGetValueHandle<?>> expandMap = new HashMap();

    public TplCompiler(ISingleTaskContext taskContext, VCHTemplate vchTemplate) {
        super(taskContext);
        this.vchTemplate = vchTemplate;
    }

    public VCHTemplate getVchTemplate() {
        return this.vchTemplate;
    }

    public VchTypeGetHandle getVchTypeGetHandle() {
        return this.vchTypeGetHandle;
    }

    public VchExpireDateGetHandle getVchDateGetHandle() {
        return this.vchDateGetHandle;
    }

    public VchExpireDateGetHandle getBizDateGetHandle() {
        return this.bizDateGetHandle;
    }

    public ExplanationGetHandle getReferenceGetHandle() {
        return this.referenceGetHandle;
    }

    public List<TplGroupCompiler> getTplGroupCompilers() {
        return this.tplGroupCompilers;
    }

    public Map<String, TplEntryCompiler> getTplEntryCompilers() {
        return this.tplEntryCompilers;
    }

    public List<AccountGetHandle> getAccountGetHandle() {
        if (this.accountGetHandles == null) {
            return new ArrayList<AccountGetHandle>();
        }
        return this.accountGetHandles;
    }

    public VchCashierGetHandle getCashierGetHandle() {
        return this.cashierGetHandle;
    }

    public boolean isCompileSuccess() {
        if (this.tplGroupCompilers.size() == 0) {
            String message = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u6a21\u677f\uff1a%1$s--%2$s \u672a\u914d\u7f6e\u4e1a\u52a1\u5206\u7ec4\u3002", (String)"TplCompiler_0", (String)"fi-ai-mservice", (Object[])new Object[0]), this.vchTemplate.getBillNo(), this.vchTemplate.getDescription());
            this.WriteErrorLog(message);
            this.addErrorReport(VoucherCheckItem.Template, message);
        }
        int failVchGroupCount = 0;
        for (TplGroupCompiler tplGroupCompiler : this.tplGroupCompilers) {
            if (tplGroupCompiler.isCompileSuccess()) continue;
            ++failVchGroupCount;
        }
        return failVchGroupCount < this.tplGroupCompilers.size();
    }

    @Override
    protected void DoParseFields() {
        super.DoParseFields();
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.vchTypeGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.vchDateGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.bizDateGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.referenceGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.checkVchTemplateFilterHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.vchAttachmentGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.cashierGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.vchCreatorGetHandle.getVars());
        if (this.getAccountGetHandle() != null) {
            for (AccountGetHandle accountGetHandle : this.getAccountGetHandle()) {
                BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, accountGetHandle.getVars());
            }
        }
        for (Map.Entry entry : this.expandMap.entrySet()) {
            BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, ((AbstractGetValueHandle)entry.getValue()).getVars());
        }
    }

    public Map<String, AbstractGetValueHandle<?>> getExpandMap() {
        return this.expandMap;
    }

    public void setExpandMap(Map<String, AbstractGetValueHandle<?>> expandMap) {
        this.expandMap = expandMap;
    }

    @Override
    protected void DoCompolier() {
        super.DoCompolier();
        this.vchTypeGetHandle = new VchTypeGetHandle(this.taskContext, this.vchTemplate.getVchTypesSet());
        String logMessage = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u7c7b\u578b\u53d6\u503c\u89c4\u5219\uff1a%s", (String)"TplCompiler_2", (String)"fi-ai-mservice", (Object[])new Object[0]), this.vchTypeGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        this.vchDateGetHandle = new VchExpireDateGetHandle(this.taskContext, this.vchTemplate.getVchDateSet2());
        logMessage = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u65e5\u671f\u53d6\u503c\u89c4\u5219\uff1a%s", (String)"TplCompiler_3", (String)"fi-ai-mservice", (Object[])new Object[0]), this.vchDateGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        this.bizDateGetHandle = new VchExpireDateGetHandle(this.taskContext, this.vchTemplate.getBizDateSet2());
        logMessage = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u53d6\u503c\u89c4\u5219\uff1a%s", (String)"TplCompiler_4", (String)"fi-ai-mservice", (Object[])new Object[0]), this.vchDateGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        this.referenceGetHandle = new ExplanationGetHandle(this.taskContext, this.vchTemplate.getReferenceSet(), null);
        logMessage = String.format(ResManager.loadKDString((String)"\u53c2\u8003\u6d88\u606f\u503c\u89c4\u5219\uff1a%s", (String)"TplCompiler_5", (String)"fi-ai-mservice", (Object[])new Object[0]), this.referenceGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        this.cashierGetHandle = new VchCashierGetHandle(this.taskContext, this.vchTemplate, 0L);
        String expression = null;
        String oriExp = null;
        if (this.vchTemplate.getFilterSet() != null && this.vchTemplate.getFilterSet() != null) {
            Map commonAndSourceFieldcol = this.taskContext.getCommonAndSourceFieldcol();
            if (!commonAndSourceFieldcol.isEmpty()) {
                VchTplExpression filterSet = FieldReplaceUtil.replaceFilterSet((VchTplExpression)this.vchTemplate.getFilterSet(), (Map)commonAndSourceFieldcol);
                this.vchTemplate.setFilterSet(filterSet);
            }
            oriExp = expression = this.vchTemplate.getFilterSet().getExpression();
            if (this.vchTemplate.getFilterSet().getFilterCondition() != null) {
                expression = this.vchTemplate.getFilterSet().buildFullFormula(this.taskContext.getSrcEntityType());
            }
        }
        this.checkVchTemplateFilterHandle = new CheckVchTemplateFilterHandle(this.taskContext, expression, oriExp);
        for (VchTplBizGroup vchTempBizGroup : this.vchTemplate.getBizGroups()) {
            TplGroupCompiler tplGroupCompiler = new TplGroupCompiler(this.taskContext, vchTempBizGroup);
            tplGroupCompiler.Compolier();
            this.tplGroupCompilers.add(tplGroupCompiler);
            for (TplEntryCompiler tplEntryCompiler : tplGroupCompiler.getTplEntryCompilers()) {
                this.tplEntryCompilers.put(tplEntryCompiler.getVchTempEntry().getId(), tplEntryCompiler);
            }
            List vchEntrys = vchTempBizGroup.getVchEntrys();
            for (VchTplEntry entry : vchEntrys) {
                String sourceType = entry.getAcctsSet().getSourcetype();
                if (!"exp".equalsIgnoreCase(sourceType)) continue;
                String exp = entry.getAcctsSet().getExp();
                String name = entry.getAcctsSet().getAcctName();
                if (!StringUtils.isNotEmpty((String)exp)) continue;
                if (this.accountGetHandles == null) {
                    this.accountGetHandles = new ArrayList<AccountGetHandle>();
                }
                this.accountGetHandles.add(new AccountGetHandle(this.taskContext, exp));
                logMessage = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u79d1\u76ee\u8868\u8fbe\u5f0f\uff1a%s", (String)"TplCompiler_6", (String)"fi-ai-mservice", (Object[])new Object[0]), name);
                this.WriteInfoLog(logMessage);
            }
        }
        this.vchAttachmentGetHandle = new VchAttachmentGetHandle(this.taskContext, this.vchTemplate.getAttachment(), 0);
        logMessage = String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u6570\u53d6\u503c\u89c4\u5219\uff1a%s", (String)"TplCompiler_7", (String)"fi-ai-mservice", (Object[])new Object[0]), this.vchAttachmentGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        this.vchCreatorGetHandle = new VchCreatorGetHandle(this.taskContext, this.vchTemplate.getCreatorSet());
        logMessage = String.format(ResManager.loadKDString((String)"\u5236\u5355\u4eba\u914d\u7f6e\uff1a%s", (String)"TplCompiler_8", (String)"fi-ai-mservice", (Object[])new Object[0]), this.vchAttachmentGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        List expandFields = this.vchTemplate.getExtVchTplField();
        for (VchTplField vchTplField : expandFields) {
            if (!VchTplFieldSort.Head.equals((Object)vchTplField.getVchTplFieldSort())) continue;
            this.expandMap.put(vchTplField.getFieldName(), GetValueHandleFactory.getGetValueHandler(this.taskContext, vchTplField));
        }
    }

    public VchAttachmentGetHandle getVchAttachmentGetHandle() {
        return this.vchAttachmentGetHandle;
    }

    public void setVchAttachmentGetHandle(VchAttachmentGetHandle vchAttachmentGetHandle) {
        this.vchAttachmentGetHandle = vchAttachmentGetHandle;
    }

    public CheckVchTemplateFilterHandle getCheckVchTemplateFilterHandle() {
        return this.checkVchTemplateFilterHandle;
    }

    public void setCheckVchTemplateFilterHandle(CheckVchTemplateFilterHandle checkVchTemplateFilterHandle) {
        this.checkVchTemplateFilterHandle = checkVchTemplateFilterHandle;
    }

    public VchCreatorGetHandle getVchCreatorGetHandle() {
        return this.vchCreatorGetHandle;
    }

    public void setVchCreatorGetHandle(VchCreatorGetHandle vchCreatorGetHandle) {
        this.vchCreatorGetHandle = vchCreatorGetHandle;
    }
}

