/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.context;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.orm.query.QFilter;
import kd.fi.ai.AccountMapType;
import kd.fi.ai.AccountView;
import kd.fi.ai.AcctBook;
import kd.fi.ai.AsstDimMapType;
import kd.fi.ai.AsstactType;
import kd.fi.ai.CashFlowItem;
import kd.fi.ai.Currency;
import kd.fi.ai.ExchangeRate;
import kd.fi.ai.Org;
import kd.fi.ai.Period;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VoucherSource;
import kd.fi.ai.VoucherType;
import kd.fi.ai.builder.AcctBookInfo;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.IBuildVchLogger;
import kd.fi.ai.builder.IBuildVchProgresser;
import kd.fi.ai.builder.IBuildVchReporter;
import kd.fi.ai.builder.SourceBillInfo;
import kd.fi.ai.mservice.builder.BuildVchScheme;
import kd.fi.ai.mservice.builder.SelectedAcctBook;
import kd.fi.ai.mservice.builder.SelectedSourceBill;
import kd.fi.ai.mservice.builder.context.ContextData;
import kd.fi.ai.mservice.builder.helper.AcctBookHelper;
import kd.fi.ai.mservice.builder.helper.SourceBillHelper;
import kd.fi.ai.mservice.builder.helper.TplHelper;
import kd.fi.ai.mservice.builder.logger.BuildVchLogger;
import kd.fi.ai.mservice.builder.progresser.BuildVchProgresser;
import kd.fi.ai.mservice.builder.reporter.BuildVchReporter;
import kd.fi.ai.mservice.dao.BaseDataLoader;
import kd.fi.ai.util.FieldReplaceUtil;
import kd.fi.v2.fah.optimizor.FahOptimizeControlPanel;

public class BuildVchContext
implements IBuildVchContext {
    private ContextData contextData = new ContextData();
    private transient IBuildVchLogger logger;
    private transient IBuildVchProgresser progresser;
    private transient IBuildVchReporter reporter;
    private transient AcctBookHelper bookHelper = new AcctBookHelper();
    private transient SourceBillHelper sourceBillHelper = new SourceBillHelper();
    private transient TplHelper tplHelper = new TplHelper();
    private transient boolean isCacheExtractVariables = FahOptimizeControlPanel.getCacheExtractVariables();
    private transient boolean isCacheParseFormula = FahOptimizeControlPanel.getCacheParseFormula();

    public ContextData getContextData() {
        return this.contextData;
    }

    public void setContextData(ContextData contextData) {
        this.contextData = contextData;
    }

    public String getTransId() {
        return this.getContextData().getTransId();
    }

    public void setTransId(String transId) {
        this.getContextData().setTransId(transId);
    }

    public IBuildVchLogger getLogger() {
        return this.logger;
    }

    public void setLogger(IBuildVchLogger logger) {
        this.logger = logger;
    }

    public IBuildVchProgresser getProgresser() {
        return this.progresser;
    }

    public void setProgresser(IBuildVchProgresser progresser) {
        this.progresser = progresser;
    }

    public IBuildVchReporter getReporter() {
        return this.reporter;
    }

    public void setReporter(IBuildVchReporter reporter) {
        this.reporter = reporter;
    }

    public Map<Long, AcctBookInfo> getBooks() {
        return this.getContextData().getBooks();
    }

    public void setBooks(Map<Long, AcctBookInfo> books) {
        this.getContextData().setBooks(books);
    }

    public BuildVchScheme getScheme() {
        return this.getContextData().getScheme();
    }

    public void setScheme(BuildVchScheme scheme) {
        this.getContextData().setScheme(scheme);
        this.getContextData().setTransId(scheme.getTransId());
    }

    public void Initialize() {
        this.logger = new BuildVchLogger(this.getTransId());
        this.progresser = new BuildVchProgresser();
        this.progresser.setTransId(this.getTransId());
        this.reporter = new BuildVchReporter();
    }

    public void ParseInputParameter() {
        HashSet<String> entityNumbers = new HashSet<String>();
        for (SelectedAcctBook selectedBook : this.getScheme().getSelectedBooks()) {
            AcctBookInfo bookInfo = this.bookHelper.LoadBookInfor(selectedBook, this);
            this.getBooks().put(selectedBook.getBookId(), bookInfo);
            for (SelectedSourceBill selectedBill : selectedBook.getSelectedSourceBills()) {
                String entityNumber = selectedBill.getEntityNumber();
                if (!entityNumbers.contains(entityNumber)) {
                    entityNumbers.add(entityNumber);
                }
                SourceBillInfo sourceBill = this.sourceBillHelper.LoadSourceBillInfor(selectedBill);
                sourceBill.setIgnorebillstatus(this.getScheme().isIgnorebillstatus());
                SourceBillInfo old = (SourceBillInfo)bookInfo.getSourceBills().get(selectedBill.getEntityNumber());
                if (old != null) {
                    sourceBill.getBillIds().addAll(old.getBillIds());
                }
                Deque tmpIDs = selectedBill.getTemplateIds();
                Map<Long, VCHTemplate> tps = this.tplHelper.loadVchTemplates(tmpIDs);
                for (Long tpid : tmpIDs) {
                    String acctOrg;
                    Map commonAndSourceFieldcol;
                    VCHTemplate vchTemplate = tps.get(tpid);
                    if (this.getScheme().isPreBuild()) {
                        Map str = vchTemplate.serializeToString();
                        vchTemplate = VCHTemplate.deserializeFromString((String)((String)str.get("json")), null);
                    }
                    if (!entityNumber.equals(vchTemplate.getSourceBill()) && (commonAndSourceFieldcol = FieldReplaceUtil.getCommonAndSourceFieldcol((String)vchTemplate.getSourceBill(), (String)entityNumber)).containsKey(acctOrg = vchTemplate.getAcctOrgSet())) {
                        vchTemplate.setAcctOrgSet((String)commonAndSourceFieldcol.get(acctOrg));
                    }
                    sourceBill.getVchTemplates().put(tpid.toString(), vchTemplate);
                }
                bookInfo.getSourceBills().put(selectedBill.getEntityNumber(), sourceBill);
            }
        }
    }

    public int GetAmountDigits(long currencyId) {
        return BaseDataLoader.loadCurrency((IBuildVchContext)this, (Long)currencyId).getAmtprecision();
    }

    public BigDecimal GetExchangeRate(long exchangeTableID, long cyFromId, long cyToId, Date date) {
        ExchangeRate rate = BaseDataLoader.loadExchangeRateEntity((IBuildVchContext)this, (long)exchangeTableID, (long)cyFromId, (long)cyToId, (Date)date);
        return rate.getRate();
    }

    public Map<Long, AsstactType> getAsstTypes() {
        return this.getContextData().getAsstTypes();
    }

    public void setAsstTypes(Map<Long, AsstactType> asstTypes) {
        this.getContextData().setAsstTypes(asstTypes);
    }

    public Map<Long, AccountView> getAccounts() {
        return this.getContextData().getAccounts();
    }

    public void setAccounts(Map<Long, AccountView> accounts) {
        this.getContextData().setAccounts(accounts);
    }

    public Map<String, AccountView> getAccountNumAndOrgCache() {
        return this.getContextData().getAccountNumAndOrgCache();
    }

    public void setAccountNumAndOrgCache(Map<String, AccountView> accountNumAndOrgCache) {
        this.getContextData().setAccountNumAndOrgCache(accountNumAndOrgCache);
    }

    public Map<Long, AccountMapType> getAccountmaptypeCache() {
        return this.getContextData().getAccountmaptypeCache();
    }

    public void setAccountmaptypeCache(Map<Long, AccountMapType> accountmaptypeCache) {
        this.getContextData().setAccountmaptypeCache(accountmaptypeCache);
    }

    public Map<String, Object> getBaseDataMappingDataCache() {
        return this.getContextData().getBaseDataMappingDataCache();
    }

    public void setBaseDataMappingDataCache(Map<String, Object> baseDataMappingDataCache) {
        this.getContextData().setBaseDataMappingDataCache(baseDataMappingDataCache);
    }

    public Map<Long, AsstDimMapType> getAsstmaptypeCache() {
        return this.getContextData().getAsstmaptypeCache();
    }

    public void setAsstmaptypeCache(Map<Long, AsstDimMapType> asstmaptypeCache) {
        this.getContextData().setAsstmaptypeCache(asstmaptypeCache);
    }

    public Map<Long, VoucherType> getVchTypeCache() {
        return this.getContextData().getVchTypeCache();
    }

    public void setVchTypeCache(Map<Long, VoucherType> vchTypeCache) {
        this.getContextData().setVchTypeCache(vchTypeCache);
    }

    public Map<String, VoucherType> getVchTypeNameOrgCache() {
        return this.getContextData().getVchTypeNameOrgCache();
    }

    public void setVchTypeNameOrgCache(Map<String, VoucherType> vchTypeNameOrgCache) {
        this.getContextData().setVchTypeNameOrgCache(vchTypeNameOrgCache);
    }

    public Map<Long, Org> getOrgCache() {
        return this.getContextData().getOrgCache();
    }

    public void setOrgCache(Map<Long, Org> orgCache) {
        this.getContextData().setOrgCache(orgCache);
    }

    public Map<Long, Period> getPeriodCache() {
        return this.getContextData().getPeriodCache();
    }

    public void setPeriodCache(Map<Long, Period> periodCache) {
        this.getContextData().setPeriodCache(periodCache);
    }

    public Map<String, Object> getAcctItemMasterIDCache() {
        return this.getContextData().getAcctItemMasterIDCache();
    }

    public void setAcctItemMasterIDCache(Map<String, Object> acctItemMasterIDCache) {
        this.getContextData().setAcctItemMasterIDCache(acctItemMasterIDCache);
    }

    public Map<String, Long> getNewAcctItemMasterIDCache() {
        return this.getContextData().getNewAcctItemMasterIDCache();
    }

    public void setNewAcctItemMasterIDCache(Map<String, Long> acctItemMasterIDCache) {
        this.getContextData().setNewAcctItemMasterIDCache(acctItemMasterIDCache);
    }

    public void setAcctFactorMasterIDCache(Map<String, Long> acctItemMasterIDCache) {
        this.getContextData().setAcctFactorMasterIDCache(acctItemMasterIDCache);
    }

    public Map<String, Long> getAcctFactorMasterIDCache() {
        return this.getContextData().getAcctFactorMasterIDCache();
    }

    public Map<String, String> getMappingTreeFactorLongNumber() {
        return this.contextData.getMappingTreeFactorLongNumber();
    }

    public void setMappingTreeFactorLongNumber(Map<String, String> mappingTreeFactorLongNumber) {
        this.contextData.setMappingTreeFactorLongNumber(mappingTreeFactorLongNumber);
    }

    public Map<String, Long> getGrpCache() {
        return this.getContextData().getGrpCache();
    }

    public void setGrpCache(Map<String, Long> grpCache) {
        this.getContextData().setGrpCache(grpCache);
    }

    public Map<String, Long> getPreCfItemCache() {
        return this.getContextData().getPreCfItemCache();
    }

    public void setPreCfItemCache(Map<String, Long> preCfItemCache) {
        this.getContextData().setPreCfItemCache(preCfItemCache);
    }

    public IBuildVchContext merge(IBuildVchContext newCtx) {
        ContextData oldData = this.getContextData();
        ContextData newData = ((BuildVchContext)newCtx).getContextData();
        oldData.getAccountmaptypeCache().putAll(newData.getAccountmaptypeCache());
        oldData.getAccountNumAndOrgCache().putAll(newData.getAccountNumAndOrgCache());
        oldData.getAccounts().putAll(newData.getAccounts());
        oldData.getAcctItemMasterIDCache().putAll(newData.getAcctItemMasterIDCache());
        oldData.getAsstmaptypeCache().putAll(newData.getAsstmaptypeCache());
        oldData.getAsstTypes().putAll(newData.getAsstTypes());
        oldData.getBaseDataMappingDataCache().putAll(newData.getBaseDataMappingDataCache());
        oldData.getGrpCache().putAll(newData.getGrpCache());
        oldData.getOrgCache().putAll(newData.getOrgCache());
        oldData.getPeriodCache().putAll(newData.getPeriodCache());
        oldData.getVchTypeCache().putAll(newData.getVchTypeCache());
        oldData.getVchTypeNameOrgCache().putAll(newData.getVchTypeNameOrgCache());
        oldData.getPreCfItemCache().putAll(newData.getPreCfItemCache());
        oldData.getAcctOrg2acctOrgCache().putAll(newData.getAcctOrg2acctOrgCache());
        oldData.getBizBook2AcctBookCache().putAll(newData.getBizBook2AcctBookCache());
        oldData.getCashflowItemNumAndOrgCache().putAll(newData.getCashflowItemNumAndOrgCache());
        oldData.getCashflowItems().putAll(newData.getCashflowItems());
        oldData.getBasedataSubs().putAll(newData.getBasedataSubs());
        oldData.getExchangeRateCache().putAll(newData.getExchangeRateCache());
        oldData.getCurrencys().putAll(newData.getCurrencys());
        oldData.getBizAsstTypes().putAll(newData.getBizAsstTypes());
        return this;
    }

    public Map<Long, Set<AcctBook>> getAcctOrg2acctOrgCache() {
        return this.getContextData().getAcctOrg2acctOrgCache();
    }

    public void setAcctOrg2acctOrgCache(Map<Long, Set<AcctBook>> acctOrg2acctOrgCache) {
        this.getContextData().setAcctOrg2acctOrgCache(acctOrg2acctOrgCache);
    }

    public Map<String, Set<AcctBook>> getBizBook2AcctBookCache() {
        return this.getContextData().getBizBook2AcctBookCache();
    }

    public void setBizBook2AcctBookCache(Map<String, Set<AcctBook>> bizBook2AcctBookCache) {
        this.getContextData().setBizBook2AcctBookCache(bizBook2AcctBookCache);
    }

    public Map<Long, CashFlowItem> getCashflowItems() {
        return this.getContextData().getCashflowItems();
    }

    public void setCashflowItems(Map<Long, CashFlowItem> cashflowItems) {
        this.getContextData().setCashflowItems(cashflowItems);
    }

    public Map<String, CashFlowItem> getCashflowItemNumAndOrgCache() {
        return this.getContextData().getCashflowItemNumAndOrgCache();
    }

    public void setCashflowItemNumAndOrgCache(Map<String, CashFlowItem> cashflowItemNumAndOrgCache) {
        this.getContextData().setCashflowItemNumAndOrgCache(cashflowItemNumAndOrgCache);
    }

    public Map<Object, List<Object>> getBasedataSubs() {
        return this.getContextData().getBasedataSubs();
    }

    public void setBasedataSubs(Map<Object, List<Object>> basedataSubs) {
        this.getContextData().setBasedataSubs(basedataSubs);
    }

    public Map<String, Object> getFunctionCache() {
        return this.getContextData().getFunctionCache();
    }

    public void setFunctionCache(Map<String, Object> functionCache) {
        this.getContextData().setFunctionCache(functionCache);
    }

    public Map<String, ExchangeRate> getExchangeRateCache() {
        return this.getContextData().getExchangeRateCache();
    }

    public void setExchangeRateCache(Map<String, ExchangeRate> exchangeRateCache) {
        this.getContextData().setExchangeRateCache(exchangeRateCache);
    }

    public Map<Long, Currency> getCurrencys() {
        return this.getContextData().getCurrencys();
    }

    public void setCurrencys(Map<Long, Currency> currencys) {
        this.getContextData().setCurrencys(currencys);
    }

    public Map<String, QFilter> getEntitysToQfilters() {
        return this.getContextData().getEntitysToQfilters();
    }

    public void setEntitysToQfilters(Map<String, QFilter> entitysToQfilters) {
        this.getContextData().setEntitysToQfilters(entitysToQfilters);
    }

    public boolean isCacheExtractVariables() {
        return this.isCacheExtractVariables;
    }

    public void setCacheExtractVariables(boolean cacheExtractVariables) {
        this.isCacheExtractVariables = cacheExtractVariables;
    }

    public boolean isCacheParseFormula() {
        return this.isCacheParseFormula;
    }

    public void setCacheParseFormula(boolean cacheParseFormula) {
        this.isCacheParseFormula = cacheParseFormula;
    }

    public void putPreCfItemCache(String k, Long v) {
        this.getContextData().putPreCfItemCache(k, v);
    }

    public Map<Long, AsstactType> getAsstBizTypes() {
        return this.getContextData().getBizAsstTypes();
    }

    public void setAsstBizTypes(Map<Long, AsstactType> bizAsstTypes) {
        this.getContextData().setBizAsstTypes(bizAsstTypes);
    }

    public Map<String, AsstactType> getAsstTypesFromString() {
        return this.getContextData().getAsstTypesFromString();
    }

    public Map<String, VoucherSource> getVoucherSource() {
        return this.getContextData().getVoucherSource();
    }

    public void setVoucherSource(Map<String, VoucherSource> voucherSourceCache) {
        this.getContextData().setVoucherSource(voucherSourceCache);
    }
}

