/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.factory;

import kd.fi.ai.VchTplEntryNewSortOption;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.VCHEntryOrder;
import kd.fi.ai.mservice.builder.factory.FirstDebitEntrySortImpl;
import kd.fi.ai.mservice.builder.factory.IVoucherEntrySort;
import kd.fi.ai.mservice.builder.factory.NewAcctNoEntrySortImpl;
import kd.fi.ai.mservice.builder.factory.NewFirstDebitEntrySortImpl;
import kd.fi.ai.mservice.builder.factory.NewOriginalOrderEntrySortImpl;
import kd.fi.ai.mservice.builder.factory.NewTemplateOrderEntrySortImpl;
import kd.fi.ai.mservice.builder.factory.OriginalOrderEntrySortImpl;
import kd.fi.ai.mservice.builder.factory.TemplateOrderEntrySortImpl;

public class EntrySortFactory {
    public static IVoucherEntrySort getEntrySort(int sortType, ISingleTaskContext taskContext) {
        if (VCHEntryOrder.FirstDebit.getValue() == sortType) {
            return new FirstDebitEntrySortImpl(taskContext);
        }
        if (VCHEntryOrder.OriginalOrder.getValue() == sortType) {
            return new OriginalOrderEntrySortImpl();
        }
        if (VCHEntryOrder.TemplateOrder.getValue() == sortType) {
            return new TemplateOrderEntrySortImpl();
        }
        return null;
    }

    public static IVoucherEntrySort getEntryNewSort(VchTplEntryNewSortOption op, ISingleTaskContext taskContext) {
        if (op.isFirstOrder1()) {
            return new NewFirstDebitEntrySortImpl(taskContext, op);
        }
        if (op.isFirstOrder2()) {
            return new NewOriginalOrderEntrySortImpl(taskContext, op);
        }
        if (op.isFirstOrder3()) {
            return new NewAcctNoEntrySortImpl(taskContext, op);
        }
        if (op.isFirstOrder4()) {
            return new NewTemplateOrderEntrySortImpl(taskContext, op);
        }
        return null;
    }
}

