/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.factory;

import java.util.Comparator;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.ai.AccountView;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.buildresult.IVoucher;
import kd.fi.ai.mservice.builder.buildresult.IVoucherEntry;
import kd.fi.ai.mservice.builder.factory.IVoucherEntrySort;
import kd.fi.ai.mservice.dao.BaseDataLoader;

public class FirstDebitEntrySortImpl
implements IVoucherEntrySort {
    public ISingleTaskContext taskContext;

    public FirstDebitEntrySortImpl(ISingleTaskContext taskContext) {
        this.taskContext = taskContext;
    }

    @Override
    public void SortVchEntryRows(IVoucher<?> voucher) {
        List entryRows = voucher.getEntryRows();
        entryRows.sort(new Comparator<IVoucherEntry>(){

            @Override
            public int compare(IVoucherEntry x, IVoucherEntry y) {
                int xDc = x.getDcDirectory();
                int yDc = y.getDcDirectory();
                if (xDc > 0 && yDc > 0) {
                    return this.compareByNumber(x, y, FirstDebitEntrySortImpl.this.taskContext);
                }
                if (xDc > 0) {
                    return -1;
                }
                if (yDc > 0) {
                    return 1;
                }
                return this.compareByNumber(x, y, FirstDebitEntrySortImpl.this.taskContext);
            }

            public int compareByNumber(IVoucherEntry x, IVoucherEntry y, ISingleTaskContext taskContext) {
                boolean flag = false;
                Long xId = x.getAccountId();
                Long yId = y.getAccountId();
                AccountView xObject = BaseDataLoader.loadAccount((IBuildVchContext)taskContext.getBuildVchContext(), (Long)xId);
                AccountView yObject = BaseDataLoader.loadAccount((IBuildVchContext)taskContext.getBuildVchContext(), (Long)yId);
                String xNo = xObject.getNumber();
                String yNo = yObject.getNumber();
                if (StringUtils.isBlank((CharSequence)xNo)) {
                    xNo = "";
                    flag = true;
                }
                if (StringUtils.isBlank((CharSequence)yNo)) {
                    yNo = "";
                    flag = true;
                }
                if (flag) {
                    return yNo.compareTo(xNo);
                }
                return xNo.compareTo(yNo);
            }
        });
    }
}

