/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.getvaluehandle;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.ai.VchTplAcccounts;
import kd.fi.ai.VchTplAccount;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.getvaluehandle.AbstractGetValueHandle;
import kd.fi.ai.mservice.builder.getvaluemode.ConditionMode;
import kd.fi.ai.mservice.builder.getvaluemode.ConstMode;
import kd.fi.ai.mservice.builder.getvaluemode.IGetValueMode;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;

public class AccountDirectoryGetHandle
extends AbstractGetValueHandle<List<Object>> {
    private VchTplAcccounts vchTplAcccounts;
    private List<Tuple<IGetValueMode<Boolean>, List<Object>>> rules = new ArrayList<Tuple<IGetValueMode<Boolean>, List<Object>>>();
    private List<IVariableMode> vars = new ArrayList<IVariableMode>();
    private List<IGetValueMode<Boolean>> modes = new ArrayList<IGetValueMode<Boolean>>(2);

    public AccountDirectoryGetHandle(ISingleTaskContext taskContext, VchTplAcccounts vchTplAcccounts) {
        super(taskContext);
        this.vchTplAcccounts = vchTplAcccounts;
        this.preCompile();
    }

    @Override
    public List<IVariableMode> getVars() {
        return this.vars;
    }

    @Override
    public void Compile() {
        StringBuilder sBuilder = new StringBuilder();
        int seq = 1;
        for (VchTplAccount item : this.vchTplAcccounts.getItems()) {
            String logMessage;
            IGetValueMode<Boolean> condition;
            String dcStr = item.getAcctName();
            if (item.getFilterSet().getFilterCondition() != null) {
                item.getFilterSet().setExpression(item.getFilterSet().buildFullFormula(this.taskContext.getSrcEntityType()));
                item.getFilterSet().setFilterCondition(null);
            }
            if (StringUtils.isBlank((CharSequence)item.getFilterSet().getExpression())) {
                condition = new ConstMode<Boolean>(true);
                logMessage = ResManager.loadKDString((String)"\u7b2c{0}\u6761\u89c4\u5219\uff0c\u65e0\u6761\u4ef6\u53d6\u79d1\u76ee{1}", (String)"AccountDirectoryGetHandle_0", (String)"fi-ai-mservice", (Object[])new Object[0]);
                logMessage = MessageFormat.format(logMessage, seq, dcStr);
                sBuilder.append(logMessage).append("; ");
            } else {
                condition = new ConditionMode(this.taskContext, item.getFilterSet().getExpression());
                logMessage = ResManager.loadKDString((String)"\u7b2c{0}\u6761\u89c4\u5219\uff0c\u53d6\u503c\u6761\u4ef6\uff1a{1}\uff0c\u6ee1\u8db3\u6761\u4ef6\u53d6\u79d1\u76ee\uff1a{2}", (String)"AccountDirectoryGetHandle_1", (String)"fi-ai-mservice", (Object[])new Object[0]);
                logMessage = MessageFormat.format(logMessage, seq, item.getFilterSet().getExpression(), dcStr);
                sBuilder.append(logMessage).append("; ");
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(item.getAccountid());
            list.add(item.getAccountNumber());
            Tuple rule = new Tuple(condition, list);
            this.rules.add((Tuple<IGetValueMode<Boolean>, List<Object>>)rule);
            this.vars.addAll(condition.getVars());
            ++seq;
        }
        this.modes = this.rules.stream().map(t -> (IGetValueMode)t.item1).collect(Collectors.toList());
        this.description = sBuilder.toString();
    }

    @Override
    public List<Object> GetVchFldValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow) {
        for (Tuple<IGetValueMode<Boolean>, List<Object>> ruleItem : this.rules) {
            if (!((Boolean)((IGetValueMode)ruleItem.item1).GetValue(fldProperties, sourceRow, extRow)).booleanValue()) continue;
            return (List)ruleItem.item2;
        }
        return new ArrayList<Object>(0);
    }

    public List<IGetValueMode<Boolean>> getConditionModes() {
        return this.modes;
    }

    private void preCompile() {
        this.Compile();
    }
}

