/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.getvaluehandle;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.AbstractVchTplItemMap;
import kd.fi.ai.AsstactType;
import kd.fi.ai.BizAssit;
import kd.fi.ai.BizAssitEntry;
import kd.fi.ai.DataType;
import kd.fi.ai.VchTplAsstDimFactorSource;
import kd.fi.ai.VchTplBizAssists;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.mservice.builder.compiler.AcctItemCompiler;
import kd.fi.ai.mservice.builder.getvaluehandle.AbstractGetValueHandle;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;
import kd.fi.ai.mservice.builder.getvaluemode.SourceBillFieldMode;
import kd.fi.ai.mservice.dao.BaseDataLoader;

public class BizAssistGetHandle
extends AbstractGetValueHandle<BizAssitEntry> {
    private List<IVariableMode> vars = new ArrayList<IVariableMode>();
    private Map<String, AcctItemCompiler> acctItemCompilers = new HashMap<String, AcctItemCompiler>();
    private String amountEntity = "";
    private VchTplBizAssists vchTplBizAssists;

    public String getAmountEntity() {
        return this.amountEntity;
    }

    public void setAmountEntity(String amountEntity) {
        this.amountEntity = amountEntity;
    }

    public Map<String, AcctItemCompiler> getAcctItemCompilers() {
        return this.acctItemCompilers;
    }

    public BizAssistGetHandle(ISingleTaskContext taskContext, VchTplBizAssists vchTplBizAssists) {
        super(taskContext);
        this.vchTplBizAssists = vchTplBizAssists;
        this.preCompile();
    }

    @Override
    public void Compile() {
        List itemList = this.vchTplBizAssists.getItemClassMaps();
        for (AbstractVchTplItemMap itemMap : itemList) {
            ArrayList<VchTplAsstDimFactorSource> assSourceList = new ArrayList<VchTplAsstDimFactorSource>();
            AcctItemCompiler itemComplier = new AcctItemCompiler(this.taskContext, itemMap, assSourceList, true);
            this.acctItemCompilers.put(itemMap.getItemClass(), itemComplier);
            itemComplier.Compolier();
            this.vars.addAll(itemComplier.getSelectedFields().values());
        }
    }

    @Override
    public List<IVariableMode> getVars() {
        return this.vars;
    }

    @Override
    public BizAssitEntry GetVchFldValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow) {
        BizAssitEntry bizAssitEntry = new BizAssitEntry();
        long billid = sourceRow.getLong("id");
        for (Map.Entry<String, AcctItemCompiler> itemEntrySet : this.acctItemCompilers.entrySet()) {
            String value;
            BizAssit bizAssit;
            block18: {
                bizAssit = new BizAssit();
                String itemKey = itemEntrySet.getKey();
                AcctItemCompiler itemComp = itemEntrySet.getValue();
                Collection<IVariableMode> vars = itemComp.getSelectedFields().values();
                boolean isNeedGetValue = this.getIsNeedGetValue(vars, this.amountEntity);
                if (!isNeedGetValue) continue;
                AsstactType asstacttype = BaseDataLoader.loadBizAsstactType((IBuildVchContext)this.taskContext.getBuildVchContext(), (Long)Long.valueOf(itemKey));
                Object acctItem = itemComp.getGetItemHandle().GetVchFldValue(fldProperties, sourceRow, extRow);
                String flexField = itemComp.getFlexName();
                bizAssit.setAsstype(flexField);
                String string = value = acctItem != null ? acctItem.toString() : "";
                if (DataType.BASEDATA.getValue().equals(asstacttype.getValueType()) || DataType.ASSISTANT.getValue().equals(asstacttype.getValueType())) {
                    if (!(acctItem instanceof Long)) {
                        this.writeReport(billid, itemKey, acctItem);
                        value = "";
                    }
                } else if (DataType.NUMERICAL.getValue().equals(asstacttype.getValueType())) {
                    int percision = asstacttype.getPercision();
                    try {
                        if (acctItem != null) {
                            if (percision >= 0) {
                                value = ((BigDecimal)acctItem).setScale(percision, 4) + "";
                                if (percision == 10 && "0E-10".equals(value)) {
                                    value = "0.0000000000";
                                }
                            } else {
                                acctItem = (BigDecimal)acctItem;
                                if ("0E-10".equals(value)) {
                                    value = "0.0000000000";
                                }
                            }
                            break block18;
                        }
                        this.writeReport(billid, itemKey, acctItem);
                        value = "";
                    }
                    catch (Throwable e) {
                        this.writeReport(billid, itemKey, acctItem);
                        value = "";
                    }
                } else if (DataType.DATE.getValue().equals(asstacttype.getValueType())) {
                    String format = "1".equals(asstacttype.getShowformat()) ? "yyyy-MM-dd" : "yyyy-MM";
                    SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                    if (acctItem instanceof Date) {
                        value = dateFormat.format(acctItem);
                    } else {
                        this.writeReport(billid, itemKey, acctItem);
                        value = "";
                    }
                } else if ("0E-10".equals(value)) {
                    value = "0";
                }
            }
            bizAssit.setAssval(value);
            bizAssitEntry.getBizAssits().add(bizAssit);
        }
        return bizAssitEntry;
    }

    private boolean getIsNeedGetValue(Collection<IVariableMode> vars, String amountEntity) {
        boolean result = true;
        Map isNeedGetValueByBizasst = this.taskContext.getIsNeedGetValueByBizasst();
        for (IVariableMode var : vars) {
            String key;
            if (!(var instanceof SourceBillFieldMode) || (result = ((Boolean)isNeedGetValueByBizasst.get(key = amountEntity + "-" + ((EntityType)((SourceBillFieldMode)var).getSourceField().getParent()).getExtendName() + "-" + ((SourceBillFieldMode)var).getFullPropName())).booleanValue())) continue;
            return result;
        }
        return result;
    }

    private void writeReport(long billid, String itemKey, Object acctItem) {
        this.taskContext.getBuildVchContext().getReporter().AddErrorReport(this.taskContext.getBookInfo(), this.taskContext.getSourceBill(), (Object)billid, "", this.taskContext.getTemplate() == null ? null : this.taskContext.getTemplate().getId(), VoucherCheckItem.AcctItem, VoucherErrLevel.Warning, () -> {
            Map assTypeNames = (Map)ThreadCache.get((Object)"asstacttype_name", () -> new HashMap(4));
            String value = assTypeNames.computeIfAbsent(itemKey, k -> BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(k), (String)"ai_asstacttype", (String)"id,name").getString("name"));
            return String.format(ResManager.loadKDString((String)"\u83b7\u53d6ID\u4e3a\u201c%1$s\u201d\u7684\u4e1a\u52a1\u7ef4\u5ea6\u201c%2$s\u201d\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6807\u51c6\u4e8b\u4ef6\u914d\u7f6e\u3002", (String)"BizAssistGetHandle_0", (String)"fi-ai-mservice", (Object[])new Object[0]), acctItem, value);
        }, this.taskContext.getBuildType(), this.taskContext.getBookInfo().getBuildVoucherType().getValue() + "");
    }

    private void preCompile() {
        this.Compile();
    }
}

